/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.adt.map.HashMap3D;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurtermin;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurvorgabe;
import de.svws_nrw.core.data.gost.klausurplanung.GostKursklausur;
import de.svws_nrw.core.data.stundenplan.StundenplanZeitraster;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.Wochentag;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.utils.DateUtils;
import de.svws_nrw.core.utils.Map2DUtils;
import de.svws_nrw.core.utils.Map3DUtils;
import de.svws_nrw.core.utils.MapUtils;
import de.svws_nrw.core.utils.gost.GostFaecherManager;
import de.svws_nrw.core.utils.klausurplanung.GostKlausurvorgabenManager;
import de.svws_nrw.core.utils.stundenplan.StundenplanManager;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GostKursklausurManager {
    @NotNull
    private GostKlausurvorgabenManager _vorgabenManager;
    @NotNull
    private static final @NotNull Comparator<@NotNull GostKlausurtermin> _compTermin = (a, b) -> {
        if (a.datum == null && b.datum != null) {
            return 1;
        }
        if (b.datum == null && a.datum != null) {
            return -1;
        }
        if (a.datum != null && b.datum != null) {
            return a.datum.compareTo(b.datum);
        }
        if (a.quartal != b.quartal) {
            return a.quartal - b.quartal;
        }
        return a.id > b.id ? 1 : -1;
    };
    @NotNull
    private final @NotNull Comparator<@NotNull GostKursklausur> _compKursklausur = (a, b) -> {
        GostFaecherManager faecherManager = this._vorgabenManager.getFaecherManager();
        if (a.kursart.compareTo(b.kursart) < 0) {
            return 1;
        }
        if (a.kursart.compareTo(b.kursart) > 0) {
            return -1;
        }
        if (faecherManager != null) {
            GostFach aFach = faecherManager.get(a.idFach);
            GostFach bFach = faecherManager.get(b.idFach);
            if (aFach != null && bFach != null) {
                if (aFach.sortierung > bFach.sortierung) {
                    return 1;
                }
                if (aFach.sortierung < bFach.sortierung) {
                    return -1;
                }
            }
        }
        if (a.halbjahr != b.halbjahr) {
            return a.halbjahr - b.halbjahr;
        }
        if (a.quartal != b.quartal) {
            return a.quartal - b.quartal;
        }
        return a.id > b.id ? 1 : -1;
    };
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostKursklausur> _kursklausur_by_id = new HashMap<Long, GostKursklausur>();
    @NotNull
    private final @NotNull List<@NotNull GostKursklausur> _kursklausurmenge = new ArrayList<GostKursklausur>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Integer, @NotNull Integer, @NotNull List<@NotNull GostKursklausur>> _kursklausurmenge_by_halbjahr_and_quartal = new HashMap2D();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostKursklausur>> _kursklausurmenge_by_idTermin = new HashMap<Long, List<GostKursklausur>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostKursklausur>> _kursklausurmenge_by_idVorgabe = new HashMap<Long, List<GostKursklausur>>();
    @NotNull
    private final @NotNull HashMap3D<@NotNull Integer, @NotNull Long, @NotNull Integer, @NotNull List<@NotNull GostKursklausur>> _kursklausurmenge_by_halbjahr_and_idTermin_and_quartal = new HashMap3D();
    @NotNull
    private final @NotNull HashMap3D<@NotNull Long, @NotNull Integer, @NotNull Integer, @NotNull GostKursklausur> _kursklausur_by_idKurs_and_halbjahr_and_quartal = new HashMap3D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Integer, @NotNull Long, @NotNull List<@NotNull GostKursklausur>> _kursklausurmenge_by_kw_and_schuelerId = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull GostKursklausur>> _kursklausurmenge_by_terminId_and_schuelerId = new HashMap2D();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostKlausurtermin> _termin_by_id = new HashMap<Long, GostKlausurtermin>();
    @NotNull
    private final @NotNull List<@NotNull GostKlausurtermin> _terminmenge = new ArrayList<GostKlausurtermin>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Integer, @NotNull Integer, @NotNull List<@NotNull GostKlausurtermin>> _terminmenge_by_halbjahr_and_quartal = new HashMap2D();
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull List<@NotNull GostKlausurtermin>> _terminmenge_by_datum = new HashMap<String, List<GostKlausurtermin>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull Long>> _schuelerIds_by_idTermin = new HashMap<Long, List<Long>>();

    public GostKursklausurManager(@NotNull GostKlausurvorgabenManager vorgabenManager, @NotNull @NotNull List<@NotNull GostKursklausur> listKlausuren, List<@NotNull GostKlausurtermin> listTermine) {
        this._vorgabenManager = vorgabenManager;
        this.initAll(listKlausuren, listTermine);
    }

    private void initAll(@NotNull @NotNull List<@NotNull GostKursklausur> listKlausuren, List<@NotNull GostKlausurtermin> listTermine) {
        this.kursklausurAddAll(listKlausuren);
        this.terminAddAll(listTermine != null ? listTermine : new ArrayList());
        this.update_all();
    }

    private void update_all() {
        this.update_kursklausurmenge();
        this.update_terminmenge();
        this.update_kursklausurmenge_by_halbjahr_and_quartal();
        this.update_kursklausurmenge_by_idTermin();
        this.update_kursklausurmenge_by_idVorgabe();
        this.update_kursklausurmenge_by_halbjahr_and_quartal_and_idTermin();
        this.update_kursklausur_by_idKurs_and_halbjahr_and_quartal();
        this.update_terminmenge_by_halbjahr_and_quartal();
        this.update_terminmenge_by_datum();
        this.update_kursklausurmenge_by_terminId_and_schuelerId();
        this.update_schuelerIds_by_idTermin();
        this.update_kursklausurmenge_by_kw_and_schuelerId();
    }

    private void update_kursklausurmenge_by_halbjahr_and_quartal() {
        this._kursklausurmenge_by_halbjahr_and_quartal.clear();
        for (GostKursklausur kk : this._kursklausurmenge) {
            Map2DUtils.getOrCreateArrayList(this._kursklausurmenge_by_halbjahr_and_quartal, kk.halbjahr, kk.quartal).add(kk);
        }
    }

    private void update_kursklausurmenge_by_idTermin() {
        this._kursklausurmenge_by_idTermin.clear();
        for (GostKursklausur kk : this._kursklausurmenge) {
            MapUtils.getOrCreateArrayList(this._kursklausurmenge_by_idTermin, kk.idTermin != null ? kk.idTermin : -1L).add(kk);
        }
    }

    private void update_kursklausurmenge_by_idVorgabe() {
        this._kursklausurmenge_by_idVorgabe.clear();
        for (GostKursklausur kk : this._kursklausurmenge) {
            MapUtils.getOrCreateArrayList(this._kursklausurmenge_by_idVorgabe, kk.idVorgabe).add(kk);
        }
    }

    private void update_kursklausurmenge_by_halbjahr_and_quartal_and_idTermin() {
        this._kursklausurmenge_by_halbjahr_and_idTermin_and_quartal.clear();
        for (GostKursklausur kk : this._kursklausurmenge) {
            Map3DUtils.getOrCreateArrayList(this._kursklausurmenge_by_halbjahr_and_idTermin_and_quartal, kk.halbjahr, kk.idTermin != null ? kk.idTermin : -1L, kk.quartal).add(kk);
        }
    }

    private void update_kursklausur_by_idKurs_and_halbjahr_and_quartal() {
        this._kursklausur_by_idKurs_and_halbjahr_and_quartal.clear();
        for (GostKursklausur kk : this._kursklausurmenge) {
            this._kursklausur_by_idKurs_and_halbjahr_and_quartal.put(kk.idKurs, kk.halbjahr, kk.quartal, kk);
        }
    }

    private void update_terminmenge_by_halbjahr_and_quartal() {
        this._terminmenge_by_halbjahr_and_quartal.clear();
        for (GostKlausurtermin t : this._terminmenge) {
            Map2DUtils.getOrCreateArrayList(this._terminmenge_by_halbjahr_and_quartal, t.halbjahr, t.quartal).add(t);
        }
    }

    private void update_terminmenge_by_datum() {
        this._terminmenge_by_datum.clear();
        for (GostKlausurtermin t : this._terminmenge) {
            MapUtils.getOrCreateArrayList(this._terminmenge_by_datum, t.datum).add(t);
        }
    }

    private void update_schuelerIds_by_idTermin() {
        this._schuelerIds_by_idTermin.clear();
        for (GostKlausurtermin t : this._terminmenge) {
            ArrayList<@NotNull Long> listSchuelerIds = new ArrayList<Long>();
            this._schuelerIds_by_idTermin.put(t.id, listSchuelerIds);
            List<@NotNull GostKursklausur> klausurenZuTermin = this._kursklausurmenge_by_idTermin.get(t.id);
            if (klausurenZuTermin == null) continue;
            for (GostKursklausur k : klausurenZuTermin) {
                listSchuelerIds.addAll(k.schuelerIds);
            }
        }
    }

    private void update_kursklausurmenge_by_kw_and_schuelerId() {
        this._kursklausurmenge_by_kw_and_schuelerId.clear();
        for (GostKlausurtermin t : this._terminmenge) {
            if (t.datum == null) continue;
            int kw = DateUtils.gibKwDesDatumsISO8601(t.datum);
            List<@NotNull GostKursklausur> klausuren = this._kursklausurmenge_by_idTermin.get(t.id);
            if (klausuren == null) continue;
            for (GostKursklausur kk : klausuren) {
                for (Long sId : kk.schuelerIds) {
                    Map2DUtils.getOrCreateArrayList(this._kursklausurmenge_by_kw_and_schuelerId, kw, sId).add(kk);
                }
            }
        }
    }

    private void update_kursklausurmenge_by_terminId_and_schuelerId() {
        this._kursklausurmenge_by_terminId_and_schuelerId.clear();
        for (GostKursklausur kk : this._kursklausurmenge) {
            for (Long sId : kk.schuelerIds) {
                Map2DUtils.getOrCreateArrayList(this._kursklausurmenge_by_terminId_and_schuelerId, kk.idTermin, sId).add(kk);
            }
        }
    }

    private void update_kursklausurmenge() {
        this._kursklausurmenge.clear();
        this._kursklausurmenge.addAll(this._kursklausur_by_id.values());
        this._kursklausurmenge.sort(this._compKursklausur);
    }

    private void kursklausurAddOhneUpdate(@NotNull GostKursklausur kursklausur) {
        GostKursklausurManager.kursklausurCheck(kursklausur);
        DeveloperNotificationException.ifMapPutOverwrites(this._kursklausur_by_id, kursklausur.id, kursklausur);
    }

    public void kursklausurAdd(@NotNull GostKursklausur kursklausur) {
        this.kursklausurAddOhneUpdate(kursklausur);
        this.update_all();
    }

    private void kursklausurAddAllOhneUpdate(@NotNull @NotNull List<@NotNull GostKursklausur> listKursklausuren) {
        for (GostKursklausur kursklausur : listKursklausuren) {
            this.kursklausurAddOhneUpdate(kursklausur);
        }
    }

    public void kursklausurAddAll(@NotNull @NotNull List<@NotNull GostKursklausur> listKursklausuren) {
        this.kursklausurAddAllOhneUpdate(listKursklausuren);
        this.update_all();
    }

    private static void kursklausurCheck(@NotNull GostKursklausur kursklausur) {
        DeveloperNotificationException.ifInvalidID("kursklausur.id", kursklausur.id);
    }

    @NotNull
    public GostKursklausur kursklausurGetByIdOrException(long idKursklausur) {
        return DeveloperNotificationException.ifMapGetIsNull(this._kursklausur_by_id, idKursklausur);
    }

    @NotNull
    public @NotNull List<@NotNull GostKursklausur> kursklausurGetMengeAsList() {
        return this._kursklausurmenge;
    }

    public void kursklausurPatchAttributes(@NotNull GostKursklausur kursklausur) {
        GostKursklausurManager.kursklausurCheck(kursklausur);
        DeveloperNotificationException.ifMapRemoveFailes(this._kursklausur_by_id, kursklausur.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._kursklausur_by_id, kursklausur.id, kursklausur);
        this.update_all();
    }

    private void kursklausurRemoveOhneUpdateById(long idKursklausur) {
        DeveloperNotificationException.ifMapRemoveFailes(this._kursklausur_by_id, idKursklausur);
    }

    public void kursklausurRemoveById(long idKursklausur) {
        this.kursklausurRemoveOhneUpdateById(idKursklausur);
        this.update_all();
    }

    public void kursklausurRemoveAll(@NotNull @NotNull List<@NotNull GostKursklausur> listKursklausuren) {
        for (GostKursklausur kursklausur : listKursklausuren) {
            this.kursklausurRemoveOhneUpdateById(kursklausur.id);
        }
        this.update_all();
    }

    private void update_terminmenge() {
        this._terminmenge.clear();
        this._terminmenge.addAll(this._termin_by_id.values());
        this._terminmenge.sort(_compTermin);
    }

    private void terminAddOhneUpdate(@NotNull GostKlausurtermin termin) {
        GostKursklausurManager.terminCheck(termin);
        DeveloperNotificationException.ifMapPutOverwrites(this._termin_by_id, termin.id, termin);
    }

    public void terminAdd(@NotNull GostKlausurtermin termin) {
        this.terminAddOhneUpdate(termin);
        this.update_all();
    }

    private void terminAddAllOhneUpdate(@NotNull @NotNull List<@NotNull GostKlausurtermin> listTermine) {
        for (GostKlausurtermin termin : listTermine) {
            this.terminAddOhneUpdate(termin);
        }
    }

    public void terminAddAll(@NotNull @NotNull List<@NotNull GostKlausurtermin> listTermine) {
        this.terminAddAllOhneUpdate(listTermine);
        this.update_all();
    }

    private static void terminCheck(@NotNull GostKlausurtermin termin) {
        DeveloperNotificationException.ifInvalidID("kursklausur.id", termin.id);
    }

    @NotNull
    public GostKlausurtermin terminGetByIdOrException(long idTermin) {
        return DeveloperNotificationException.ifMapGetIsNull(this._termin_by_id, idTermin);
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurtermin> terminGetMengeAsList() {
        return this._terminmenge;
    }

    public void terminPatchAttributes(@NotNull GostKlausurtermin termin) {
        GostKursklausurManager.terminCheck(termin);
        DeveloperNotificationException.ifMapRemoveFailes(this._termin_by_id, termin.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._termin_by_id, termin.id, termin);
        this.update_all();
    }

    private void terminRemoveOhneUpdateById(long idTermin) {
        DeveloperNotificationException.ifMapRemoveFailes(this._termin_by_id, idTermin);
        List<@NotNull GostKursklausur> klausurenZuTermin = this._kursklausurmenge_by_idTermin.get(idTermin);
        if (klausurenZuTermin != null) {
            for (GostKursklausur k : klausurenZuTermin) {
                k.idTermin = null;
            }
        }
    }

    public void terminRemoveById(long idTermin) {
        this.terminRemoveOhneUpdateById(idTermin);
        this.update_all();
    }

    public void terminRemoveAll(@NotNull @NotNull List<@NotNull GostKlausurtermin> listTermine) {
        for (GostKlausurtermin termin : listTermine) {
            this.terminRemoveOhneUpdateById(termin.id);
        }
        this.update_all();
    }

    public GostKursklausur kursklausurGetByTerminidAndKursid(long idTermin, long idKurs) {
        List<@NotNull GostKursklausur> klausuren = this.kursklausurGetMengeByTerminid(idTermin);
        for (GostKursklausur klaus : klausuren) {
            if (klaus.idKurs != idKurs) continue;
            return klaus;
        }
        return null;
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurtermin> terminGetMengeByDatum(@NotNull String datum) {
        ArrayList<@NotNull E> termine = this._terminmenge_by_datum.get(datum);
        return termine != null ? termine : new ArrayList();
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurtermin> terminGetMengeByDatumAndZeitraster(@NotNull String datum, @NotNull StundenplanZeitraster zr, @NotNull StundenplanManager manager) {
        List<@NotNull GostKlausurtermin> termine = this.terminGetMengeByDatum(datum);
        ArrayList<@NotNull GostKlausurtermin> retList = new ArrayList<GostKlausurtermin>();
        for (GostKlausurtermin termin : termine) {
            List<@NotNull StundenplanZeitraster> zrsTermin = manager.getZeitrasterByWochentagStartVerstrichen(Wochentag.fromIDorException(zr.wochentag), DeveloperNotificationException.ifNull("Startzeit des Klausurtermins", termin.startzeit), this.maxKlausurdauerGetByTerminid(termin.id));
            for (StundenplanZeitraster zrTermin : zrsTermin) {
                if (zrTermin == null || zrTermin.id != zr.id) continue;
                retList.add(termin);
            }
        }
        return retList;
    }

    @NotNull
    public @NotNull List<@NotNull GostKursklausur> kursklausurGetMengeByTerminid(Long idTermin) {
        ArrayList<@NotNull E> klausuren = this._kursklausurmenge_by_idTermin.get(idTermin != null ? idTermin : -1L);
        return klausuren != null ? klausuren : new ArrayList();
    }

    public List<@NotNull GostKursklausur> kursklausurGetMengeByHalbjahrAndQuartal(@NotNull GostHalbjahr halbjahr, int quartal) {
        return this._kursklausurmenge_by_halbjahr_and_quartal.getOrNull(halbjahr.id, quartal);
    }

    @NotNull
    public @NotNull List<@NotNull GostKursklausur> kursklausurOhneTerminGetMenge() {
        return this.kursklausurGetMengeByTerminid(-1L);
    }

    @NotNull
    public @NotNull List<@NotNull GostKursklausur> kursklausurOhneTerminGetMengeByHalbjahrAndQuartal(@NotNull GostHalbjahr halbjahr, int quartal) {
        if (quartal > 0) {
            ArrayList<@NotNull E> klausuren = this._kursklausurmenge_by_halbjahr_and_idTermin_and_quartal.getOrNull(halbjahr.id, -1L, quartal);
            return klausuren != null ? klausuren : new ArrayList();
        }
        ArrayList<@NotNull GostKursklausur> klausuren = new ArrayList<GostKursklausur>();
        for (List<GostKursklausur> kl : this._kursklausurmenge_by_halbjahr_and_idTermin_and_quartal.getNonNullValuesOfMap3AsList(halbjahr.id, -1L)) {
            klausuren.addAll(kl);
        }
        return klausuren;
    }

    @NotNull
    public @NotNull List<@NotNull Long> schueleridsGetMengeByTerminid(long idTermin) {
        ArrayList<@NotNull E> schuelerIds = this._schuelerIds_by_idTermin.get(idTermin);
        return schuelerIds != null ? schuelerIds : new ArrayList();
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurtermin> terminGetMengeByHalbjahrAndQuartal(@NotNull GostHalbjahr halbjahr, int quartal, boolean includeMultiquartal) {
        ArrayList<@NotNull GostKlausurtermin> termine = new ArrayList<GostKlausurtermin>();
        if (quartal > 0) {
            if (this._terminmenge_by_halbjahr_and_quartal.getOrNull(halbjahr.id, quartal) != null) {
                termine.addAll((Collection<GostKlausurtermin>)this._terminmenge_by_halbjahr_and_quartal.getOrNull(halbjahr.id, quartal));
            }
            if (includeMultiquartal && this._terminmenge_by_halbjahr_and_quartal.getOrNull(halbjahr.id, 0) != null) {
                termine.addAll((Collection<GostKlausurtermin>)this._terminmenge_by_halbjahr_and_quartal.getOrNull(halbjahr.id, 0));
            }
            return termine;
        }
        if (this._terminmenge_by_halbjahr_and_quartal.containsKey1(halbjahr.id)) {
            for (List<GostKlausurtermin> qTermine : this._terminmenge_by_halbjahr_and_quartal.getNonNullValuesOfKey1AsList(halbjahr.id)) {
                termine.addAll(qTermine);
            }
        }
        return termine;
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurtermin> terminMitDatumGetMenge() {
        ArrayList<@NotNull GostKlausurtermin> termineMitDatum = new ArrayList<GostKlausurtermin>();
        for (GostKlausurtermin termin : this._terminmenge) {
            if (termin.datum == null) continue;
            termineMitDatum.add(termin);
        }
        termineMitDatum.sort(_compTermin);
        return termineMitDatum;
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurtermin> terminMitDatumGetMengeByHalbjahrAndQuartal(@NotNull GostHalbjahr halbjahr, int quartal, boolean includeMultiquartal) {
        ArrayList<@NotNull GostKlausurtermin> termineMitDatum = new ArrayList<GostKlausurtermin>();
        for (GostKlausurtermin termin : this.terminGetMengeByHalbjahrAndQuartal(halbjahr, quartal, includeMultiquartal)) {
            if (termin.datum == null) continue;
            termineMitDatum.add(termin);
        }
        termineMitDatum.sort(_compTermin);
        return termineMitDatum;
    }

    public int quartalGetByTerminid(long idTermin) {
        List<@NotNull GostKursklausur> klausuren = this._kursklausurmenge_by_idTermin.get(idTermin);
        if (klausuren == null) {
            return DeveloperNotificationException.ifMapGetIsNull(this._termin_by_id, Long.valueOf((long)idTermin)).quartal;
        }
        int quartal = -1;
        for (GostKursklausur k : klausuren) {
            if (quartal == -1) {
                quartal = k.quartal;
            }
            if (quartal == k.quartal) continue;
            return -1;
        }
        return quartal;
    }

    public int schuelerklausurAnzahlGetByTerminid(long idTermin) {
        return this.schueleridsGetMengeByTerminid(idTermin).size();
    }

    public int minKursklausurstartzeitByTerminid(long idTermin) {
        int minStart = 1440;
        GostKlausurtermin termin = DeveloperNotificationException.ifMapGetIsNull(this._termin_by_id, idTermin);
        for (GostKursklausur kk : DeveloperNotificationException.ifMapGetIsNull(this._kursklausurmenge_by_idTermin, idTermin)) {
            int skStartzeit = -1;
            if (kk.startzeit != null) {
                skStartzeit = kk.startzeit;
            } else if (termin.startzeit != null) {
                skStartzeit = termin.startzeit;
            } else {
                throw new DeveloperNotificationException("Startzeit des Termins nicht definiert, Termin-ID: " + idTermin);
            }
            if (skStartzeit >= minStart) continue;
            minStart = skStartzeit;
        }
        return minStart;
    }

    public int maxKursklausurendzeitByTerminid(long idTermin) {
        int maxEnd = 0;
        GostKlausurtermin termin = DeveloperNotificationException.ifMapGetIsNull(this._termin_by_id, idTermin);
        for (GostKursklausur kk : DeveloperNotificationException.ifMapGetIsNull(this._kursklausurmenge_by_idTermin, idTermin)) {
            int endzeit;
            @NotNull GostKlausurvorgabe vorgabe = this._vorgabenManager.vorgabeGetByIdOrException(kk.idVorgabe);
            int skStartzeit = -1;
            if (kk.startzeit != null) {
                skStartzeit = kk.startzeit;
            } else if (termin.startzeit != null) {
                skStartzeit = termin.startzeit;
            } else {
                throw new DeveloperNotificationException("Startzeit des Termins nicht definiert, Termin-ID: " + idTermin);
            }
            if ((endzeit = skStartzeit + vorgabe.dauer + vorgabe.auswahlzeit) <= maxEnd) continue;
            maxEnd = endzeit;
        }
        return maxEnd;
    }

    public int maxKlausurdauerGetByTerminid(long idTermin) {
        @NotNull List<@NotNull GostKursklausur> klausuren = DeveloperNotificationException.ifMapGetIsNull(this._kursklausurmenge_by_idTermin, idTermin);
        int maxDauer = -1;
        for (GostKursklausur klausur : klausuren) {
            @NotNull GostKlausurvorgabe vorgabe = this._vorgabenManager.vorgabeGetByIdOrException(klausur.idVorgabe);
            maxDauer = vorgabe.dauer > maxDauer ? vorgabe.dauer : maxDauer;
        }
        return maxDauer;
    }

    @NotNull
    private static @NotNull Map<@NotNull GostKursklausur, @NotNull Set<@NotNull Long>> berechneKonflikte(@NotNull @NotNull List<@NotNull GostKursklausur> klausuren1, @NotNull @NotNull List<@NotNull GostKursklausur> klausuren2) {
        HashMap<@NotNull GostKursklausur, @NotNull Set<@NotNull Long>> result = new HashMap<GostKursklausur, Set<Long>>();
        ArrayList<@NotNull GostKursklausur> kursklausuren2Copy = new ArrayList<GostKursklausur>(klausuren2);
        for (GostKursklausur kk1 : klausuren1) {
            kursklausuren2Copy.remove(kk1);
            for (GostKursklausur kk2 : kursklausuren2Copy) {
                Set<@NotNull Long> konflikte = GostKursklausurManager.berechneKlausurKonflikte(kk1, kk2);
                if (konflikte.isEmpty()) continue;
                MapUtils.getOrCreateHashSet(result, kk1).addAll(konflikte);
                MapUtils.getOrCreateHashSet(result, kk2).addAll(konflikte);
            }
        }
        return result;
    }

    @NotNull
    private static @NotNull Set<@NotNull Long> berechneKlausurKonflikte(@NotNull GostKursklausur kk1, @NotNull GostKursklausur kk2) {
        HashSet<@NotNull Long> konflikte = new HashSet<Long>(kk1.schuelerIds);
        konflikte.retainAll(kk2.schuelerIds);
        return konflikte;
    }

    private static int countKonflikte(@NotNull @NotNull Map<@NotNull GostKursklausur, @NotNull Set<@NotNull Long>> konflikte) {
        @NotNull HashSet<@NotNull Long> susIds = new HashSet<Long>();
        for (Set<Long> klausurSids : konflikte.values()) {
            susIds.addAll(klausurSids);
        }
        return susIds.size();
    }

    @NotNull
    public @NotNull Map<@NotNull GostKursklausur, @NotNull Set<@NotNull Long>> konflikteMapKursklausurSchueleridsByTerminid(long idTermin) {
        List<@NotNull GostKursklausur> klausuren = this._kursklausurmenge_by_idTermin.get(idTermin);
        if (klausuren == null) {
            return new HashMap<GostKursklausur, Set<Long>>();
        }
        return GostKursklausurManager.berechneKonflikte(klausuren, klausuren);
    }

    @NotNull
    public @NotNull Map<@NotNull GostKursklausur, @NotNull Set<@NotNull Long>> konflikteNeuMapKursklausurSchueleridsByTerminidAndKursklausurid(long idTermin, long idKursklausur) {
        ArrayList<@NotNull GostKursklausur> klausuren1 = this._kursklausurmenge_by_idTermin.get(idTermin);
        ArrayList<@NotNull GostKursklausur> klausuren2 = new ArrayList<GostKursklausur>();
        klausuren2.add(DeveloperNotificationException.ifMapGetIsNull(this._kursklausur_by_id, idKursklausur));
        return GostKursklausurManager.berechneKonflikte(klausuren1 != null ? klausuren1 : new ArrayList<GostKursklausur>(), klausuren2);
    }

    public int konflikteAnzahlZuEigenemTerminGetByKursklausur(@NotNull GostKursklausur klausur) {
        @NotNull ArrayList<@NotNull GostKursklausur> klausuren1 = new ArrayList<GostKursklausur>((Collection)DeveloperNotificationException.ifMapGetIsNull(this._kursklausurmenge_by_idTermin, klausur.idTermin));
        klausuren1.remove(klausur);
        ArrayList<@NotNull GostKursklausur> klausuren2 = new ArrayList<GostKursklausur>();
        klausuren2.add(klausur);
        return GostKursklausurManager.countKonflikte(GostKursklausurManager.berechneKonflikte(klausuren1, klausuren2));
    }

    public int konflikteAnzahlZuTerminGetByTerminAndKursklausur(@NotNull GostKlausurtermin termin, @NotNull GostKursklausur klausur) {
        return GostKursklausurManager.countKonflikte(this.konflikteNeuMapKursklausurSchueleridsByTerminidAndKursklausurid(termin.id, klausur.id));
    }

    public int konflikteAnzahlGetByTerminid(long idTermin) {
        return GostKursklausurManager.countKonflikte(this.konflikteMapKursklausurSchueleridsByTerminid(idTermin));
    }

    @NotNull
    public @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostKursklausur>> klausurenProSchueleridExceedingKWThresholdByTerminAndThreshold(@NotNull GostKlausurtermin termin, int threshold) {
        return this.klausurenProSchueleridExceedingKWThresholdByTerminAndKursklausurAndThreshold(termin, null, threshold);
    }

    @NotNull
    public @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostKursklausur>> klausurenProSchueleridExceedingKWThresholdByTerminAndKursklausurAndThreshold(@NotNull GostKlausurtermin termin, GostKursklausur klausur, int threshold) {
        HashMap<@NotNull Long, @NotNull List<@NotNull GostKursklausur>> ergebnis = new HashMap<Long, List<GostKursklausur>>();
        if (termin.datum == null) {
            return ergebnis;
        }
        int kw = DateUtils.gibKwDesDatumsISO8601(termin.datum);
        Map<@NotNull Long, List<@NotNull GostKursklausur>> kursklausurmenge_by_schuelerId = this._kursklausurmenge_by_kw_and_schuelerId.getSubMapOrNull(kw);
        if (kursklausurmenge_by_schuelerId == null) {
            return ergebnis;
        }
        for (Map.Entry<Long, List<GostKursklausur>> entry : kursklausurmenge_by_schuelerId.entrySet()) {
            ArrayList<GostKursklausur> klausuren;
            List<@NotNull GostKursklausur> temp = entry.getValue();
            ArrayList<GostKursklausur> arrayList = klausuren = temp != null ? new ArrayList<GostKursklausur>(temp) : new ArrayList();
            if (klausur != null && klausur.idTermin != termin.id && klausur.schuelerIds.contains(entry.getKey())) {
                klausuren.add(klausur);
            }
            if (klausuren.size() < threshold) continue;
            ergebnis.put(entry.getKey(), klausuren);
        }
        return ergebnis;
    }

    @NotNull
    public @NotNull Map<@NotNull Long, @NotNull HashSet<@NotNull GostKursklausur>> klausurenProSchueleridExceedingKWThresholdByTerminAndDatumAndThreshold(@NotNull GostKlausurtermin termin, @NotNull String datum, int threshold, boolean thresholdOnly) {
        int kwDatum = DateUtils.gibKwDesDatumsISO8601(datum);
        return this.klausurenProSchueleridExceedingKWThresholdByKwAndTerminAndThreshold(kwDatum, termin, threshold, thresholdOnly);
    }

    @NotNull
    private @NotNull Map<@NotNull Long, @NotNull HashSet<@NotNull GostKursklausur>> klausurenProSchueleridExceedingKWThresholdByKwAndTerminAndThreshold(int kw, GostKlausurtermin termin, int threshold, boolean thresholdOnly) {
        HashMap<@NotNull Long, @NotNull HashSet<@NotNull GostKursklausur>> ergebnis = new HashMap<Long, HashSet<GostKursklausur>>();
        Map<@NotNull Long, List<@NotNull GostKursklausur>> kursklausurmenge_by_schuelerId = this._kursklausurmenge_by_kw_and_schuelerId.getSubMapOrNull(kw);
        if (kursklausurmenge_by_schuelerId == null) {
            return ergebnis;
        }
        for (Map.Entry<Long, List<GostKursklausur>> entry : kursklausurmenge_by_schuelerId.entrySet()) {
            List<GostKursklausur> klausurenInTermin;
            HashSet<GostKursklausur> klausuren;
            List<@NotNull GostKursklausur> temp = entry.getValue();
            HashSet<GostKursklausur> hashSet = klausuren = temp != null ? new HashSet<GostKursklausur>(temp) : new HashSet();
            if (termin != null && (klausurenInTermin = this._kursklausurmenge_by_terminId_and_schuelerId.getOrNull(termin.id, entry.getKey())) != null) {
                klausuren.addAll(klausurenInTermin);
            }
            if (klausuren.size() != threshold && (klausuren.size() <= threshold || thresholdOnly)) continue;
            ergebnis.put(entry.getKey(), klausuren);
        }
        return ergebnis;
    }

    @NotNull
    public @NotNull Map<@NotNull Long, @NotNull HashSet<@NotNull GostKursklausur>> klausurenProSchueleridExceedingKWThresholdByKwAndThreshold(int kw, int threshold, boolean thresholdOnly) {
        return this.klausurenProSchueleridExceedingKWThresholdByKwAndTerminAndThreshold(kw, null, threshold, thresholdOnly);
    }

    public GostKlausurtermin terminByKursklausur(@NotNull GostKursklausur klausur) {
        return this._termin_by_id.get(klausur.idTermin);
    }

    @NotNull
    public GostKlausurvorgabe vorgabeByKursklausur(@NotNull GostKursklausur klausur) {
        return this._vorgabenManager.vorgabeGetByIdOrException(klausur.idVorgabe);
    }

    public boolean istVorgabeVerwendetByVorgabe(@NotNull GostKlausurvorgabe vorgabe) {
        List<@NotNull GostKursklausur> klausuren = this._kursklausurmenge_by_idVorgabe.get(vorgabe.idVorgabe);
        return klausuren != null && !klausuren.isEmpty();
    }

    public GostKursklausur kursklausurByKursidAndHalbjahrAndQuartal(long idKurs, @NotNull GostHalbjahr halbjahr, int quartal) {
        return this._kursklausur_by_idKurs_and_halbjahr_and_quartal.getOrNull(idKurs, halbjahr.id, quartal);
    }

    public GostKursklausur kursklausurVorterminByKursklausur(@NotNull GostKursklausur klausur) {
        GostKlausurvorgabe previousVorgabe = this._vorgabenManager.getPrevious(this._vorgabenManager.vorgabeGetByIdOrException(klausur.idVorgabe));
        if (previousVorgabe == null) {
            return null;
        }
        List<@NotNull GostKursklausur> klausuren = this._kursklausurmenge_by_idVorgabe.get(previousVorgabe.idVorgabe);
        if (klausuren == null) {
            return null;
        }
        for (GostKursklausur k : klausuren) {
            if (!k.kursKurzbezeichnung.equals(klausur.kursKurzbezeichnung)) continue;
            return k;
        }
        return null;
    }

    public Integer startzeitByKursklausur(@NotNull GostKursklausur klausur) {
        GostKlausurtermin termin = this.terminByKursklausur(klausur);
        if (klausur.startzeit != null) {
            return klausur.startzeit;
        }
        return termin == null ? null : termin.startzeit;
    }

    public boolean hatAbweichendeStartzeitByKursklausur(@NotNull GostKursklausur klausur) {
        GostKlausurtermin termin = this.terminByKursklausur(klausur);
        return klausur.startzeit != null && termin != null && termin.startzeit != null && !termin.startzeit.equals(klausur.startzeit);
    }
}

