/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.data.gost.klausurplanung.GostKursklausur;
import de.svws_nrw.core.logger.Logger;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusAbstract;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy1;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy1b;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy2;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy2b;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy3;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy4;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy5;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy6;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusGreedy7;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenDynDaten;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Random;

public class KlausurblockungSchienenAlgorithmus {
    @NotNull
    private static final Random _random = new Random();
    @NotNull
    private final Logger _logger;

    public KlausurblockungSchienenAlgorithmus() {
        this._logger = new Logger();
    }

    public KlausurblockungSchienenAlgorithmus(@NotNull Logger pLogger) {
        this._logger = pLogger;
    }

    @NotNull
    public @NotNull List<@NotNull List<@NotNull Long>> berechne(@NotNull @NotNull List<@NotNull GostKursklausur> pInput, long pMaxTimeMillis) {
        long zeitEndeGesamt = System.currentTimeMillis() + pMaxTimeMillis;
        long seed = _random.nextLong();
        @NotNull Random random = new Random(seed);
        KlausurblockungSchienenDynDaten dynDaten = new KlausurblockungSchienenDynDaten(this._logger, random, pInput);
        KlausurblockungSchienenAlgorithmusAbstract[] algorithmen = new KlausurblockungSchienenAlgorithmusAbstract[]{new KlausurblockungSchienenAlgorithmusGreedy3(random, dynDaten), new KlausurblockungSchienenAlgorithmusGreedy4(random, dynDaten), new KlausurblockungSchienenAlgorithmusGreedy1(random, dynDaten), new KlausurblockungSchienenAlgorithmusGreedy1b(random, dynDaten), new KlausurblockungSchienenAlgorithmusGreedy2(random, dynDaten), new KlausurblockungSchienenAlgorithmusGreedy2b(random, dynDaten), new KlausurblockungSchienenAlgorithmusGreedy5(random, dynDaten), new KlausurblockungSchienenAlgorithmusGreedy6(random, dynDaten), new KlausurblockungSchienenAlgorithmusGreedy7(random, dynDaten)};
        dynDaten.aktion_EntferneAlles_SchienenNacheinander_KlausurenZufaellig();
        dynDaten.aktionZustand2Speichern();
        long zeitProAlgorithmus = 10L;
        do {
            for (int iAlgo = 0; iAlgo < algorithmen.length; ++iAlgo) {
                long zeitEndeRunde = System.currentTimeMillis() + zeitProAlgorithmus;
                algorithmen[iAlgo].berechne(zeitEndeRunde);
            }
        } while (System.currentTimeMillis() + (long)algorithmen.length * (zeitProAlgorithmus *= 2L) <= zeitEndeGesamt);
        dynDaten.aktionZustand2Laden();
        return dynDaten.gibErzeugeOutput();
    }
}

