/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusAbstract;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenDynDaten;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public final class KlausurblockungSchienenAlgorithmusGreedy3
extends KlausurblockungSchienenAlgorithmusAbstract {
    private int _minSchienen;
    private long _zeitEnde;
    private boolean _saved;

    public KlausurblockungSchienenAlgorithmusGreedy3(@NotNull Random pRandom, @NotNull KlausurblockungSchienenDynDaten pDynDaten) {
        super(pRandom, pDynDaten);
    }

    @NotNull
    public String toString() {
        return "Backtracking";
    }

    @Override
    public void berechne(long pZeitEnde) {
        this._minSchienen = this._dynDaten.gibAnzahlKlausuren();
        this._zeitEnde = pZeitEnde;
        this._dynDaten.aktionKlausurenAusSchienenEntfernen();
        this._saved = false;
        this.berechneRekursiv();
        this._dynDaten.aktionZustand1Laden();
        if (this._dynDaten.gibIstBesserAlsZustand2()) {
            this._dynDaten.aktionZustand2Speichern();
        }
    }

    private void berechneRekursiv() {
        int klausurNr;
        if (this._dynDaten.gibAnzahlSchienen() > this._minSchienen) {
            return;
        }
        if (this._saved && System.currentTimeMillis() > this._zeitEnde) {
            return;
        }
        int n = klausurNr = this._dynDaten.gibAnzahlSchienen() == 0 ? this._dynDaten.gibKlausurDieFreiIstMitDenMeistenFreienNachbarn() : this._dynDaten.gibKlausurDieFreiIstMitDenMeistenNachbarsfarben();
        if (klausurNr < 0) {
            if (!this._saved || this._dynDaten.gibIstBesserAlsZustand1()) {
                this._minSchienen = this._dynDaten.gibAnzahlSchienen();
                this._dynDaten.aktionZustand1Speichern();
                this._saved = true;
            }
            return;
        }
        for (int schiene = 0; schiene < this._minSchienen; ++schiene) {
            int schienenAnzahl = this._dynDaten.gibAnzahlSchienen();
            int differenz = schiene < schienenAnzahl ? 0 : schiene - schienenAnzahl + 1;
            this._dynDaten.aktionSchienenAnzahlVeraendern(differenz);
            if (this._dynDaten.aktionSetzeKlausurInSchiene(klausurNr, schiene)) {
                this.berechneRekursiv();
                this._dynDaten.aktionEntferneKlausurAusSchiene(klausurNr);
            }
            this._dynDaten.aktionSchienenAnzahlVeraendern(-differenz);
        }
    }
}

