/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.adt.collection.LinkedCollection;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenAlgorithmusAbstract;
import de.svws_nrw.core.utils.klausurplanung.KlausurblockungSchienenDynDaten;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public final class KlausurblockungSchienenAlgorithmusGreedy6
extends KlausurblockungSchienenAlgorithmusAbstract {
    public KlausurblockungSchienenAlgorithmusGreedy6(@NotNull Random pRandom, @NotNull KlausurblockungSchienenDynDaten pDynDaten) {
        super(pRandom, pDynDaten);
    }

    @NotNull
    public String toString() {
        return "Recursive Largest First (RLF)";
    }

    @Override
    public void berechne(long pZeitEnde) {
        this.berechne();
        this._dynDaten.aktionZustand1Speichern();
        while (System.currentTimeMillis() < pZeitEnde) {
            this.berechne();
            if (this._dynDaten.gibIstBesserAlsZustand1()) {
                this._dynDaten.aktionZustand1Speichern();
                continue;
            }
            this._dynDaten.aktionZustand1Laden();
        }
        if (this._dynDaten.gibIstBesserAlsZustand2()) {
            this._dynDaten.aktionZustand2Speichern();
        }
    }

    private void berechne() {
        this._dynDaten.aktionKlausurenAusSchienenEntfernen();
        @NotNull LinkedCollection<@NotNull Integer> setS = new LinkedCollection<Integer>();
        while (this._dynDaten.gibAnzahlNichtverteilterKlausuren() > 0) {
            setS.clear();
            int nr1 = this._dynDaten.gibKlausurDieFreiIstMitDenMeistenFreienNachbarn();
            int s = this._dynDaten.aktionSetzeKlausurInNeueSchiene(nr1);
            setS.addLast(nr1);
            int nr2 = this._dynDaten.gibKlausurDieFreiIstUndNichtBenachbartZurMengeAberDerenNachbarnMaximalBenachbartSind(setS);
            while (nr2 >= 0) {
                setS.addLast(nr2);
                if (!this._dynDaten.aktionSetzeKlausurInSchiene(nr2, s)) {
                    throw new DeveloperNotificationException("Fehler im Algorithmus Greedy6!");
                }
                nr2 = this._dynDaten.gibKlausurDieFreiIstUndNichtBenachbartZurMengeAberDerenNachbarnMaximalBenachbartSind(setS);
            }
        }
    }
}

