/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.adt.collection.LinkedCollection;
import de.svws_nrw.core.data.gost.klausurplanung.GostKursklausur;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class KlausurblockungSchienenDynDaten {
    private static final int SCHIENEN_MAX_ANZAHL = 1000;
    @NotNull
    private final Random _random;
    @NotNull
    private final Logger _logger;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull Integer> _mapKlausurZuNummer = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, @NotNull GostKursklausur> _mapNummerZuKlausur = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull Integer> _mapSchuelerZuNummer = new HashMap();
    private final int _klausurenAnzahl;
    @NotNull
    private final @NotNull int @NotNull [] _klausurZuSchiene;
    @NotNull
    private final @NotNull int @NotNull [] _klausurZuSchiene1;
    @NotNull
    private final @NotNull int @NotNull [] _klausurZuSchiene2;
    @NotNull
    private final @NotNull int @NotNull [] _klausurnummerZuGrad;
    @NotNull
    private final @NotNull int @NotNull [] _klausurenSortiertGrad;
    @NotNull
    private final @NotNull boolean @NotNull [] @NotNull [] _verboten;
    @NotNull
    private final @NotNull int @NotNull [] @NotNull [] _bevorzugt;
    private int _schienenAnzahl = 0;
    private int _schienenAnzahl1 = 1000;
    private int _schienenAnzahl2 = 1000;

    KlausurblockungSchienenDynDaten(@NotNull Logger pLogger, @NotNull Random pRandom, @NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        this._random = pRandom;
        this._logger = pLogger;
        this.initialisiereMapSchueler(pInput);
        this.initialisiereMapKlausuren(pInput);
        this._klausurenAnzahl = this._mapKlausurZuNummer.size();
        this._klausurZuSchiene = new int[this._klausurenAnzahl];
        this._klausurnummerZuGrad = new int[this._klausurenAnzahl];
        this._klausurenSortiertGrad = this.gibErzeugeKlausurenInReihenfolge();
        this._klausurZuSchiene1 = new int[this._klausurenAnzahl];
        this._klausurZuSchiene2 = new int[this._klausurenAnzahl];
        this._verboten = new boolean[this._klausurenAnzahl][this._klausurenAnzahl];
        this._bevorzugt = new int[this._klausurenAnzahl][this._klausurenAnzahl];
        this.initialisiereMatrixVerboten(pInput);
        this.initialisiereMatrixBevorzugt(pInput);
        this.initialisiereKnotenGrad();
        this.aktionKlausurenAusSchienenEntfernen();
    }

    private void initialisiereMapSchueler(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        @NotNull HashSet<@NotNull Long> setSchueler = new HashSet<Long>();
        for (GostKursklausur gostKursklausur : pInput) {
            for (Long schuelerID : gostKursklausur.schuelerIds) {
                if (schuelerID < 0L) {
                    throw new DeveloperNotificationException("Sch\u00fcler-ID " + schuelerID + " ist negativ!");
                }
                if (!setSchueler.add(schuelerID)) continue;
                int schuelerNummer = this._mapSchuelerZuNummer.size();
                this._mapSchuelerZuNummer.put(schuelerID, schuelerNummer);
            }
        }
    }

    private void initialisiereMapKlausuren(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        for (GostKursklausur gostKursklausur : pInput) {
            if (gostKursklausur.id < 0L) {
                throw new DeveloperNotificationException("Klausur-ID=" + gostKursklausur.id + " ist negativ!");
            }
            if (this._mapKlausurZuNummer.containsKey(gostKursklausur.id)) {
                throw new DeveloperNotificationException("Klausur-ID=" + gostKursklausur.id + " ist doppelt!");
            }
            int klausurNummer = this._mapKlausurZuNummer.size();
            this._mapKlausurZuNummer.put(gostKursklausur.id, klausurNummer);
            this._mapNummerZuKlausur.put(klausurNummer, gostKursklausur);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void initialisiereMatrixVerboten(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        @NotNull HashMap<@NotNull Long, @NotNull LinkedCollection<@NotNull Long>> mapSchuelerKlausuren = new HashMap<Long, LinkedCollection<Long>>();
        for (GostKursklausur gostKursklausur : pInput) {
            for (Long schuelerID : gostKursklausur.schuelerIds) {
                LinkedCollection<@NotNull Long> list = (LinkedCollection<Long>)mapSchuelerKlausuren.get(schuelerID);
                if (list == null) {
                    list = new LinkedCollection<Long>();
                    mapSchuelerKlausuren.put(schuelerID, list);
                }
                list.addLast(gostKursklausur.id);
            }
        }
        for (Map.Entry entry : mapSchuelerKlausuren.entrySet()) {
            @NotNull @NotNull LinkedCollection list = (LinkedCollection)entry.getValue();
            for (Long klausurID1 : list) {
                for (Long klausurID2 : list) {
                    @NotNull Integer klausurNr1 = DeveloperNotificationException.ifNull("NULL-Wert beim Mapping von klausurID1(" + klausurID1 + ")", this._mapKlausurZuNummer.get(klausurID1));
                    @NotNull Integer klausurNr2 = DeveloperNotificationException.ifNull("NULL-Wert beim Mapping von klausurID2(" + klausurID2 + ")", this._mapKlausurZuNummer.get(klausurID2));
                    this._verboten[klausurNr1.intValue()][klausurNr2.intValue()] = true;
                }
            }
        }
    }

    private void initialisiereMatrixBevorzugt(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        for (GostKursklausur gostKursklausur1 : pInput) {
            for (GostKursklausur gostKursklausur2 : pInput) {
                if (!KlausurblockungSchienenDynDaten.hatGemeinsameSchiene(gostKursklausur1.kursSchiene, gostKursklausur2.kursSchiene)) continue;
                Integer klausurNr1 = this._mapKlausurZuNummer.get(gostKursklausur1.id);
                Integer klausurNr2 = this._mapKlausurZuNummer.get(gostKursklausur2.id);
                if (klausurNr1 == null) {
                    throw new DeveloperNotificationException("NULL-Wert beim Mapping von klausurID1 --> " + gostKursklausur1.id);
                }
                if (klausurNr2 == null) {
                    throw new DeveloperNotificationException("NULL-Wert beim Mapping von klausurID2 --> " + gostKursklausur2.id);
                }
                int[] nArray = this._bevorzugt[klausurNr1];
                int n = klausurNr2;
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    private static boolean hatGemeinsameSchiene(@NotNull int[] kursSchiene1, @NotNull int[] kursSchiene2) {
        for (int schiene1 : kursSchiene1) {
            for (int schiene2 : kursSchiene2) {
                if (schiene1 != schiene2) continue;
                return true;
            }
        }
        return false;
    }

    private void initialisiereKnotenGrad() {
        for (int klausurNr1 = 0; klausurNr1 < this._klausurenAnzahl; ++klausurNr1) {
            int kanten = 0;
            for (int klausurNr2 = 0; klausurNr2 < this._klausurenAnzahl; ++klausurNr2) {
                if (!this._verboten[klausurNr1][klausurNr2]) continue;
                ++kanten;
            }
            this._klausurnummerZuGrad[klausurNr1] = kanten;
        }
        for (int i = 1; i < this._klausurenAnzahl; ++i) {
            int nummerR;
            int nummerL;
            for (int j = i; j >= 1 && this._klausurnummerZuGrad[nummerL = this._klausurenSortiertGrad[j - 1]] < this._klausurnummerZuGrad[nummerR = this._klausurenSortiertGrad[j]]; --j) {
                this._klausurenSortiertGrad[j] = nummerL;
                this._klausurenSortiertGrad[j - 1] = nummerR;
            }
        }
    }

    @NotNull
    private int[] gibErzeugeKlausurenInReihenfolge() {
        int[] temp = new int[this._klausurenAnzahl];
        for (int i = 0; i < this._klausurenAnzahl; ++i) {
            temp[i] = i;
        }
        return temp;
    }

    @NotNull
    @NotNull List<@NotNull List<@NotNull Long>> gibErzeugeOutput() {
        @NotNull ArrayList<@NotNull List<@NotNull Long>> out = new ArrayList<List<Long>>();
        for (int i = 0; i < this._schienenAnzahl; ++i) {
            out.add(new ArrayList());
        }
        for (Map.Entry<Long, Integer> e : this._mapKlausurZuNummer.entrySet()) {
            @NotNull Long klausurID = e.getKey();
            @NotNull Integer klausurNr = e.getValue();
            int schiene = this._klausurZuSchiene[klausurNr];
            DeveloperNotificationException.ifTrue("schiene(" + schiene + ") < 0", schiene < 0);
            DeveloperNotificationException.ifTrue("schiene(" + schiene + ") >= _schienenAnzahl", schiene >= this._schienenAnzahl);
            ((List)out.get(schiene)).add(klausurID);
        }
        return out;
    }

    @NotNull
    int[] gibErzeugeKlausurenInZufaelligerReihenfolge() {
        int[] temp = new int[this._klausurenAnzahl];
        for (int i = 0; i < this._klausurenAnzahl; ++i) {
            temp[i] = i;
        }
        for (int i1 = 0; i1 < this._klausurenAnzahl; ++i1) {
            int save2;
            int i2 = this._random.nextInt(this._klausurenAnzahl);
            int save1 = temp[i1];
            temp[i1] = save2 = temp[i2];
            temp[i2] = save1;
        }
        return temp;
    }

    @NotNull
    int[] gibErzeugeKlausurenInZufaelligerReihenfolgeNachBevorzugterLage() {
        int[] temp = this.gibErzeugeKlausurenInZufaelligerReihenfolge();
        block0: for (int i1 = 0; i1 < this._klausurenAnzahl; ++i1) {
            int iTausch;
            int nr1 = temp[i1];
            for (int i2 = iTausch = i1 + 1; i2 < this._klausurenAnzahl; ++i2) {
                int save2;
                int nr2 = temp[i2];
                if (this._bevorzugt[nr1][nr2] <= 0) continue;
                int save1 = temp[iTausch];
                temp[iTausch] = save2 = temp[i2];
                temp[i2] = save1;
                continue block0;
            }
        }
        return temp;
    }

    @NotNull
    int[] gibErzeugeKlausurenMitHoeheremGradZuerstEtwasPermutiert() {
        int[] temp = Arrays.copyOf(this._klausurenSortiertGrad, this._klausurenAnzahl);
        for (int i1 = 0; i1 < this._klausurenAnzahl; ++i1) {
            int save2;
            int i2 = this._random.nextInt(this._klausurenAnzahl);
            if ((i1 - i2) * (i1 - i2) > this._klausurenAnzahl) continue;
            int save1 = temp[i1];
            temp[i1] = save2 = temp[i2];
            temp[i2] = save1;
        }
        return temp;
    }

    @NotNull
    int[] gibErzeugeKlausurenMitHoeheremGradZuerst() {
        return Arrays.copyOf(this._klausurenSortiertGrad, this._klausurenAnzahl);
    }

    @NotNull
    int[] gibErzeugeSchienenInZufaelligerReihenfolge() {
        int[] temp = new int[this._schienenAnzahl];
        for (int i = 0; i < this._schienenAnzahl; ++i) {
            temp[i] = i;
        }
        for (int i1 = 0; i1 < this._schienenAnzahl; ++i1) {
            int save2;
            int i2 = this._random.nextInt(this._schienenAnzahl);
            int save1 = temp[i1];
            temp[i1] = save2 = temp[i2];
            temp[i2] = save1;
        }
        return temp;
    }

    boolean gibIstBesserAlsZustand1() {
        return this.gibVergleicheMitAktuellemZustand(this._schienenAnzahl1, this._klausurZuSchiene1);
    }

    boolean gibIstBesserAlsZustand2() {
        return this.gibVergleicheMitAktuellemZustand(this._schienenAnzahl2, this._klausurZuSchiene2);
    }

    private boolean gibVergleicheMitAktuellemZustand(int schienenAnzahlX, @NotNull @NotNull int @NotNull [] klausurZuSchieneX) {
        int bevorzugtX;
        if (this._schienenAnzahl < schienenAnzahlX) {
            return true;
        }
        if (this._schienenAnzahl > schienenAnzahlX) {
            return false;
        }
        int bevorzugt = this.gibSchienenBevorzugt(this._klausurZuSchiene);
        if (bevorzugt > (bevorzugtX = this.gibSchienenBevorzugt(klausurZuSchieneX))) {
            return true;
        }
        if (bevorzugt < bevorzugtX) {
            return false;
        }
        int[] histogramm = new int[this._schienenAnzahl];
        int[] histogrammX = new int[this._schienenAnzahl];
        for (int i = 0; i < this._klausurenAnzahl; ++i) {
            int n = this._klausurZuSchiene[i];
            histogramm[n] = histogramm[n] + 1;
            int n2 = klausurZuSchieneX[i];
            histogrammX[n2] = histogrammX[n2] + 1;
        }
        int minHisto = this._klausurenAnzahl;
        int minHistoX = this._klausurenAnzahl;
        for (int i = 0; i < this._schienenAnzahl; ++i) {
            minHisto = Math.min(minHisto, histogramm[i]);
            minHistoX = Math.min(minHistoX, histogrammX[i]);
        }
        return minHisto < minHistoX;
    }

    private int gibSchienenBevorzugt(@NotNull @NotNull int @NotNull [] pKlausurZuSchiene) {
        int summeBevorzugt = 0;
        for (int nr1 = 0; nr1 < this._klausurenAnzahl; ++nr1) {
            for (int nr2 = nr1 + 1; nr2 < this._klausurenAnzahl; ++nr2) {
                if (pKlausurZuSchiene[nr1] != pKlausurZuSchiene[nr2]) continue;
                summeBevorzugt += this._bevorzugt[nr1][nr2];
            }
        }
        return summeBevorzugt;
    }

    int gibAnzahlNichtverteilterKlausuren() {
        int summe = 0;
        for (int klausurNr = 0; klausurNr < this._klausurenAnzahl; ++klausurNr) {
            if (this._klausurZuSchiene[klausurNr] >= 0) continue;
            ++summe;
        }
        return summe;
    }

    int gibAnzahlKlausuren() {
        return this._klausurenAnzahl;
    }

    boolean gibIstKlausurUnverteilt(int klausurNr) {
        return this._klausurZuSchiene[klausurNr] < 0;
    }

    int gibErzeugeNeueSchiene() {
        ++this._schienenAnzahl;
        return this._schienenAnzahl - 1;
    }

    int gibAnzahlSchienen() {
        return this._schienenAnzahl;
    }

    int gibKlausurDieFreiIstMitDenMeistenNachbarsfarben() {
        int maxFarben = -1;
        int maxNr = -1;
        for (int klausurNr : this.gibErzeugeKlausurenInZufaelligerReihenfolge()) {
            int farben;
            if (this._klausurZuSchiene[klausurNr] >= 0 || (farben = this.gibNachbarsfarbenDerKlausur(klausurNr)) < maxFarben) continue;
            maxFarben = farben;
            maxNr = klausurNr;
        }
        return maxNr;
    }

    private int gibNachbarsfarbenDerKlausur(int klausurNr) {
        int summe = 0;
        boolean[] benutzt = new boolean[this._schienenAnzahl];
        for (int klausurNr2 = 0; klausurNr2 < this._klausurenAnzahl; ++klausurNr2) {
            int farbe = this._klausurZuSchiene[klausurNr2];
            if (farbe < 0 || !this._verboten[klausurNr][klausurNr2] || benutzt[farbe]) continue;
            benutzt[farbe] = true;
            ++summe;
        }
        return summe;
    }

    int gibKlausurDieFreiIstMitDenMeistenFreienNachbarn() {
        int maxNachbarn = -1;
        int maxNr = -1;
        for (int nr : this.gibErzeugeKlausurenInZufaelligerReihenfolge()) {
            int nachbarn;
            if (this._klausurZuSchiene[nr] >= 0 || (nachbarn = this.gibAnzahlFreierNachbarn(nr)) < maxNachbarn) continue;
            maxNachbarn = nachbarn;
            maxNr = nr;
        }
        return maxNr;
    }

    private int gibAnzahlFreierNachbarn(int nr) {
        int summe = 0;
        for (int nr2 = 0; nr2 < this._klausurenAnzahl; ++nr2) {
            if (this._klausurZuSchiene[nr2] < 0 || !this._verboten[nr][nr2]) continue;
            ++summe;
        }
        return summe;
    }

    int gibKlausurDieFreiIstUndNichtBenachbartZurMengeAberDerenNachbarnMaximalBenachbartSind(@NotNull @NotNull LinkedCollection<@NotNull Integer> setS) {
        int maxNachbarn = -1;
        int maxNr = -1;
        for (int nr2 : this.gibErzeugeKlausurenInZufaelligerReihenfolge()) {
            int nachbarn;
            if (this._klausurZuSchiene[nr2] >= 0 || this.gibIstBenachbart(nr2, setS) || (nachbarn = this.gibAnzahlFreierNachbarnVonNr2DieMitDerMengeBenachbartSind(setS, nr2)) < maxNachbarn) continue;
            maxNachbarn = nachbarn;
            maxNr = nr2;
        }
        return maxNr;
    }

    private int gibAnzahlFreierNachbarnVonNr2DieMitDerMengeBenachbartSind(@NotNull @NotNull LinkedCollection<@NotNull Integer> setS, int nr2) {
        int summe = 0;
        for (int nr3 = 0; nr3 < this._klausurenAnzahl; ++nr3) {
            if (!this._verboten[nr2][nr3] || this._klausurZuSchiene[nr3] >= 0 || !this.gibIstBenachbart(nr3, setS)) continue;
            ++summe;
        }
        return summe;
    }

    private boolean gibIstBenachbart(int nr3, @NotNull @NotNull LinkedCollection<@NotNull Integer> setS) {
        for (Integer nr4 : setS) {
            if (!this._verboten[nr3][nr4]) continue;
            return true;
        }
        return false;
    }

    void aktionZustand1Speichern() {
        this._schienenAnzahl1 = this._schienenAnzahl;
        System.arraycopy(this._klausurZuSchiene, 0, this._klausurZuSchiene1, 0, this._klausurenAnzahl);
    }

    void aktionZustand1Laden() {
        this.aktionKlausurenAusSchienenEntfernen();
        this._schienenAnzahl = this._schienenAnzahl1;
        System.arraycopy(this._klausurZuSchiene1, 0, this._klausurZuSchiene, 0, this._klausurenAnzahl);
    }

    void aktionZustand2Speichern() {
        this._schienenAnzahl2 = this._schienenAnzahl;
        System.arraycopy(this._klausurZuSchiene, 0, this._klausurZuSchiene2, 0, this._klausurenAnzahl);
        this._logger.logLn("BESSER, bevorzugtSumme = " + this.gibSchienenBevorzugt(this._klausurZuSchiene));
    }

    void aktionZustand2Laden() {
        this.aktionKlausurenAusSchienenEntfernen();
        this._schienenAnzahl = this._schienenAnzahl2;
        System.arraycopy(this._klausurZuSchiene2, 0, this._klausurZuSchiene, 0, this._klausurenAnzahl);
    }

    void aktionKlausurenAusSchienenEntfernen() {
        for (int i = 0; i < this._klausurenAnzahl; ++i) {
            this._klausurZuSchiene[i] = -1;
        }
        this._schienenAnzahl = 0;
    }

    boolean aktionSetzeKlausurInSchiene(int nr, int s) {
        if (s < 0) {
            throw new DeveloperNotificationException("aktionSetzeKlausurInSchiene(" + nr + ", " + s + ") --> Schiene zu klein!");
        }
        if (s >= this._schienenAnzahl) {
            throw new DeveloperNotificationException("aktionSetzeKlausurInSchiene(" + nr + ", " + s + ") --> Schiene zu gro\u00df!");
        }
        for (int nr2 = 0; nr2 < this._klausurenAnzahl; ++nr2) {
            if (this._klausurZuSchiene[nr2] != s || !this._verboten[nr][nr2]) continue;
            return false;
        }
        this._klausurZuSchiene[nr] = s;
        return true;
    }

    void aktionEntferneKlausurAusSchiene(int klausurNr) {
        if (this._klausurZuSchiene[klausurNr] < 0) {
            throw new DeveloperNotificationException("aktionEntferneKlausurAusSchiene(" + klausurNr + ") --> Die Klausur hatte gar keine Schiene!");
        }
        this._klausurZuSchiene[klausurNr] = -1;
    }

    int aktionSetzeKlausurInNeueSchiene(int klausurNr) {
        int schiene = this._schienenAnzahl;
        if (this._klausurZuSchiene[klausurNr] >= 0) {
            throw new DeveloperNotificationException("aktionSetzeKlausurInNeueSchiene(" + klausurNr + ") --> Die Klausur ist bereits in einer Schiene!");
        }
        this._klausurZuSchiene[klausurNr] = this._schienenAnzahl++;
        return schiene;
    }

    void aktionSchienenAnzahlVeraendern(int pDifferenz) {
        this._schienenAnzahl += pDifferenz;
    }

    void aktionSetzeKlausurInZufaelligeSchieneOderErzeugeNeue(int klausurNr) {
        for (int schienenNr : this.gibErzeugeSchienenInZufaelligerReihenfolge()) {
            if (!this.aktionSetzeKlausurInSchiene(klausurNr, schienenNr)) continue;
            return;
        }
        this.aktionSetzeKlausurInNeueSchiene(klausurNr);
    }

    void aktionSetzeNichtverteilteKlausurenZufaellig() {
        for (int nr : this.gibErzeugeKlausurenInZufaelligerReihenfolge()) {
            if (this._klausurZuSchiene[nr] != -1) continue;
            this.aktionSetzeKlausurInZufaelligeSchieneOderErzeugeNeue(nr);
        }
    }

    void aktionZerstoereEinigeSchienenUndVerteileNeu() {
        while (this._schienenAnzahl > 0) {
            int s = this._random.nextInt(this._schienenAnzahl);
            for (int nr = 0; nr < this._klausurenAnzahl; ++nr) {
                if (this._klausurZuSchiene[nr] == s) {
                    this._klausurZuSchiene[nr] = -1;
                }
                if (this._klausurZuSchiene[nr] != this._schienenAnzahl - 1) continue;
                this._klausurZuSchiene[nr] = s;
            }
            --this._schienenAnzahl;
            if (!this._random.nextBoolean()) continue;
            break;
        }
        this.aktionSetzeNichtverteilteKlausurenZufaellig();
    }

    void debug(@NotNull String header) {
        this._logger.logLn("");
        this._logger.logLn(header);
        for (int s = 0; s < this._schienenAnzahl; ++s) {
            this._logger.log("    Schiene " + (s + 1) + ": ");
            for (int nr = 0; nr < this._klausurenAnzahl; ++nr) {
                if (this._klausurZuSchiene[nr] != s) continue;
                GostKursklausur gostKlausur = this._mapNummerZuKlausur.get(nr);
                if (gostKlausur == null) {
                    throw new DeveloperNotificationException("Mapping _mapNummerZuKlausur.get(" + nr + ") ist NULL!");
                }
                this._logger.log(" " + (nr + 1) + "/" + Arrays.toString(gostKlausur.kursSchiene));
            }
            this._logger.logLn("");
        }
        for (int nr = 0; nr < this._klausurenAnzahl; ++nr) {
            DeveloperNotificationException.ifTrue("Klausur " + (nr + 1) + " --> ohne Schiene!", this._klausurZuSchiene[nr] < 0);
        }
    }

    void aktion_EntferneAlles_KlausurenZufaellig_SchienenZufaellig() {
        this.aktionKlausurenAusSchienenEntfernen();
        for (int nr : this.gibErzeugeKlausurenInZufaelligerReihenfolge()) {
            this.aktionSetzeKlausurInZufaelligeSchieneOderErzeugeNeue(nr);
        }
    }

    void aktion_EntferneAlles_SchienenNacheinander_KlausurenZufaellig() {
        this.aktionKlausurenAusSchienenEntfernen();
        while (this.gibAnzahlNichtverteilterKlausuren() > 0) {
            int schienenNr = this.gibErzeugeNeueSchiene();
            for (int klausurNr : this.gibErzeugeKlausurenInZufaelligerReihenfolge()) {
                if (!this.gibIstKlausurUnverteilt(klausurNr)) continue;
                this.aktionSetzeKlausurInSchiene(klausurNr, schienenNr);
            }
        }
    }

    void aktion_EntferneAlles_KlausurenHoherGradZuerst_SchienenZufaellig() {
        this.aktionKlausurenAusSchienenEntfernen();
        for (int klausurNr : this.gibErzeugeKlausurenMitHoeheremGradZuerstEtwasPermutiert()) {
            this.aktionSetzeKlausurInZufaelligeSchieneOderErzeugeNeue(klausurNr);
        }
    }

    void aktion_EntferneAlles_SchienenNacheinande_KlausurenHoherGradZuerst() {
        this.aktionKlausurenAusSchienenEntfernen();
        while (this.gibAnzahlNichtverteilterKlausuren() > 0) {
            int schienenNr = this.gibErzeugeNeueSchiene();
            for (int klausurNr : this.gibErzeugeKlausurenMitHoeheremGradZuerstEtwasPermutiert()) {
                if (!this.gibIstKlausurUnverteilt(klausurNr)) continue;
                this.aktionSetzeKlausurInSchiene(klausurNr, schienenNr);
            }
        }
    }

    void aktion_EntferneAlles_KlausurenMitDenMeistenNachbarsfarben_SchienenZufaellig() {
        this.aktionKlausurenAusSchienenEntfernen();
        int klausurNr = this.gibKlausurDieFreiIstMitDenMeistenNachbarsfarben();
        while (klausurNr >= 0) {
            this.aktionSetzeKlausurInZufaelligeSchieneOderErzeugeNeue(klausurNr);
            klausurNr = this.gibKlausurDieFreiIstMitDenMeistenNachbarsfarben();
        }
    }

    void aktion_EntferneAlles_TermineNacheinander_KlausurenBevorzugterLage() {
        this.aktionKlausurenAusSchienenEntfernen();
        while (this.gibAnzahlNichtverteilterKlausuren() > 0) {
            int schienenNr = this.gibErzeugeNeueSchiene();
            for (int klausurNr : this.gibErzeugeKlausurenInZufaelligerReihenfolgeNachBevorzugterLage()) {
                if (!this.gibIstKlausurUnverteilt(klausurNr)) continue;
                this.aktionSetzeKlausurInSchiene(klausurNr, schienenNr);
            }
        }
    }
}

