/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurterminblockungDaten;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurterminblockungErgebnis;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurterminblockungKonfiguration;
import de.svws_nrw.core.data.gost.klausurplanung.GostKursklausur;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.logger.Logger;
import de.svws_nrw.core.types.gost.klausurplanung.KlausurterminblockungModusKursarten;
import de.svws_nrw.core.types.gost.klausurplanung.KlausurterminblockungModusQuartale;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungAlgorithmusAbstract;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungAlgorithmusGreedy1;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungAlgorithmusGreedy1b;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungAlgorithmusGreedy2;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungAlgorithmusGreedy2b;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungAlgorithmusGreedy3;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungDynDaten;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class KlausurterminblockungAlgorithmus {
    @NotNull
    private static final Random _random = new Random();
    @NotNull
    private static final @NotNull Comparator<@NotNull GostKursklausur> _compGostKursklausur = (a, b) -> {
        if (a.halbjahr < b.halbjahr) {
            return -1;
        }
        if (a.halbjahr > b.halbjahr) {
            return 1;
        }
        if (a.quartal < b.quartal) {
            return -1;
        }
        if (a.quartal > b.quartal) {
            return 1;
        }
        return 0;
    };
    @NotNull
    private final Logger _logger;

    public KlausurterminblockungAlgorithmus() {
        this._logger = new Logger();
    }

    public KlausurterminblockungAlgorithmus(@NotNull Logger pLogger) {
        this._logger = pLogger;
    }

    @NotNull
    public GostKlausurterminblockungErgebnis apply(@NotNull GostKlausurterminblockungDaten daten) {
        @NotNull GostKlausurterminblockungErgebnis out = new GostKlausurterminblockungErgebnis();
        this.berechneRekursivQuartalsModus(daten.klausuren, daten.konfiguration, out);
        return out;
    }

    private void berechneRekursivQuartalsModus(@NotNull @NotNull List<@NotNull GostKursklausur> input, @NotNull GostKlausurterminblockungKonfiguration config, @NotNull GostKlausurterminblockungErgebnis out) {
        if (input.isEmpty()) {
            return;
        }
        if (config.modusQuartale == KlausurterminblockungModusQuartale.ZUSAMMEN.id) {
            this.berechneRekursivLkGkModus(input, config, out);
            return;
        }
        input.sort(_compGostKursklausur);
        @NotNull ArrayList<@NotNull GostKursklausur> temp = new ArrayList<GostKursklausur>();
        for (GostKursklausur klausur : input) {
            if (temp.isEmpty()) {
                temp.add(klausur);
                continue;
            }
            if (_compGostKursklausur.compare(klausur, (GostKursklausur)temp.get(0)) == 0) {
                temp.add(klausur);
                continue;
            }
            this.berechneRekursivLkGkModus(temp, config, out);
            temp.clear();
            temp.add(klausur);
        }
        if (!temp.isEmpty()) {
            this.berechneRekursivLkGkModus(temp, config, out);
            temp.clear();
        }
    }

    private void berechneRekursivLkGkModus(@NotNull @NotNull List<@NotNull GostKursklausur> input, @NotNull GostKlausurterminblockungKonfiguration config, @NotNull GostKlausurterminblockungErgebnis out) {
        @NotNull KlausurterminblockungModusKursarten modus = KlausurterminblockungModusKursarten.getOrException(config.modusKursarten);
        switch (modus) {
            case BEIDE: {
                this.berechne_helper(input, config, out);
                break;
            }
            case NUR_LK: {
                this.berechne_helper(KlausurterminblockungAlgorithmus.filter(input, true), config, out);
                break;
            }
            case NUR_GK: {
                this.berechne_helper(KlausurterminblockungAlgorithmus.filter(input, false), config, out);
                break;
            }
            case GETRENNT: {
                this.berechne_helper(KlausurterminblockungAlgorithmus.filter(input, true), config, out);
                this.berechne_helper(KlausurterminblockungAlgorithmus.filter(input, false), config, out);
                break;
            }
            default: {
                throw new DeveloperNotificationException("Der LK-GK-Modus ist unbekannt!");
            }
        }
    }

    @NotNull
    private static @NotNull List<@NotNull GostKursklausur> filter(@NotNull @NotNull List<@NotNull GostKursklausur> input, boolean istLK) {
        @NotNull ArrayList<@NotNull GostKursklausur> temp = new ArrayList<GostKursklausur>();
        for (GostKursklausur gostKursklausur : input) {
            if (gostKursklausur.kursart.equals("LK") != istLK) continue;
            temp.add(gostKursklausur);
        }
        return temp;
    }

    private void berechne_helper(@NotNull @NotNull List<@NotNull GostKursklausur> input, @NotNull GostKlausurterminblockungKonfiguration config, @NotNull GostKlausurterminblockungErgebnis out) {
        this._logger.log("KlausurterminblockungAlgorithmus");
        this._logger.modifyIndent(4);
        long zeitEndeGesamt = System.currentTimeMillis() + config.maxTimeMillis;
        long seed = _random.nextLong();
        @NotNull Random random = new Random(seed);
        KlausurterminblockungDynDaten dynDaten = new KlausurterminblockungDynDaten(this._logger, random, input, config);
        KlausurterminblockungAlgorithmusAbstract[] algorithmen = new KlausurterminblockungAlgorithmusAbstract[]{new KlausurterminblockungAlgorithmusGreedy1(random, dynDaten), new KlausurterminblockungAlgorithmusGreedy1b(random, dynDaten), new KlausurterminblockungAlgorithmusGreedy2(random, dynDaten), new KlausurterminblockungAlgorithmusGreedy2b(random, dynDaten), new KlausurterminblockungAlgorithmusGreedy3(random, dynDaten)};
        dynDaten.aktion_Clear_TermineNacheinander_GruppeZufaellig();
        dynDaten.aktionZustand2Speichern();
        long zeitProAlgorithmus = 10L;
        do {
            this._logger.log("zeitProAlgorithmus --> " + zeitProAlgorithmus);
            for (int iAlgo = 0; iAlgo < algorithmen.length; ++iAlgo) {
                long zeitEndeRunde = System.currentTimeMillis() + zeitProAlgorithmus;
                algorithmen[iAlgo].berechne(zeitEndeRunde);
                this._logger.log(algorithmen[iAlgo].toString() + " --> " + dynDaten.gibTerminAnzahl());
            }
        } while (System.currentTimeMillis() + (long)algorithmen.length * (zeitProAlgorithmus *= 2L) <= zeitEndeGesamt);
        dynDaten.aktionZustand2Laden();
        out.termine.addAll(dynDaten.gibErzeugeOutput().termine);
        this._logger.modifyIndent(-4);
    }
}

