/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungAlgorithmusAbstract;
import de.svws_nrw.core.utils.klausurplanung.KlausurterminblockungDynDaten;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Random;

public final class KlausurterminblockungAlgorithmusGreedy3
extends KlausurterminblockungAlgorithmusAbstract {
    private int _minTermine;
    private long _zeitEnde;

    public KlausurterminblockungAlgorithmusGreedy3(@NotNull Random pRandom, @NotNull KlausurterminblockungDynDaten pDynDaten) {
        super(pRandom, pDynDaten);
    }

    @NotNull
    public String toString() {
        return "Termine nacheinander, Klausurgruppen mit Backtracking";
    }

    @Override
    public void berechne(long pZeitEnde) {
        this._zeitEnde = pZeitEnde;
        this._dynDaten.aktion_Clear_TermineNacheinander_GruppeNachGrad();
        this._minTermine = this._dynDaten.gibKlausurgruppenAnzahl();
        this._dynDaten.aktionZustand1Speichern();
        this._dynDaten.aktionClear();
        this.berechneRekursiv();
        this._dynDaten.aktionZustand1Laden();
        if (this._dynDaten.gibIstBesserAlsZustand2()) {
            this._dynDaten.aktionZustand2Speichern();
        }
    }

    private void berechneRekursiv() {
        int terminNr;
        if (this._dynDaten.gibTerminAnzahl() > this._minTermine) {
            return;
        }
        if (System.currentTimeMillis() > this._zeitEnde) {
            return;
        }
        if (!this._dynDaten.gibExistierenNichtverteilteKlausuren()) {
            if (this._dynDaten.gibIstBesserAlsZustand1()) {
                this._minTermine = this._dynDaten.gibTerminAnzahl();
                this._dynDaten.aktionZustand1Speichern();
            }
            return;
        }
        @NotNull ArrayList<@NotNull Integer> gruppe = this._dynDaten.gibKlausurgruppeMitMinimalenTerminmoeglichkeiten();
        for (terminNr = 0; terminNr < this._dynDaten.gibTerminAnzahl(); ++terminNr) {
            if (!this._dynDaten.aktionSetzeKlausurgruppeInTermin(gruppe, terminNr)) continue;
            this.berechneRekursiv();
            this._dynDaten.aktionEntferneKlausurgruppeAusTermin(gruppe, terminNr);
        }
        terminNr = this._dynDaten.gibErzeugeNeuenTermin();
        if (!this._dynDaten.aktionSetzeKlausurgruppeInTermin(gruppe, terminNr)) {
            throw new DeveloperNotificationException("Ein Setzen muss hier m\u00f6glich sein!");
        }
        this.berechneRekursiv();
        this._dynDaten.aktionEntferneKlausurgruppeAusTermin(gruppe, terminNr);
        this._dynDaten.entferneLetztenTermin();
    }
}

