/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.adt.collection.LinkedCollection;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurterminblockungErgebnis;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurterminblockungErgebnisTermin;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurterminblockungKonfiguration;
import de.svws_nrw.core.data.gost.klausurplanung.GostKursklausur;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.exceptions.UserNotificationException;
import de.svws_nrw.core.logger.Logger;
import de.svws_nrw.core.types.gost.klausurplanung.KlausurterminblockungAlgorithmen;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class KlausurterminblockungDynDaten {
    private static final int MAX_TERMINE = 1000;
    @NotNull
    private final Logger _logger;
    @NotNull
    private final Random _random;
    private int _terminAnzahl = 0;
    private int _terminAnzahl1 = 1000;
    private int _terminAnzahl2 = 1000;
    @NotNull
    private final @NotNull int @NotNull [] _klausurZuTermin;
    @NotNull
    private final @NotNull int @NotNull [] _klausurZuTermin1;
    @NotNull
    private final @NotNull int @NotNull [] _klausurZuTermin2;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull Integer> _mapKlausurZuNummer = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, @NotNull GostKursklausur> _mapNummerZuKlausur = new HashMap();
    private final int _klausurenAnzahl;
    @NotNull
    private final @NotNull boolean @NotNull [] @NotNull [] _verboten;
    @NotNull
    private final @NotNull ArrayList<@NotNull ArrayList<@NotNull Integer>> _klausurGruppen = new ArrayList();
    @NotNull
    private final @NotNull ArrayList<@NotNull ArrayList<@NotNull Integer>> _klausurGruppenGrad = new ArrayList();

    public KlausurterminblockungDynDaten(@NotNull Logger pLogger, @NotNull Random pRandom, @NotNull @NotNull List<@NotNull GostKursklausur> pInput, @NotNull GostKlausurterminblockungKonfiguration pConfig) {
        this._logger = pLogger;
        this._random = pRandom;
        this.initialisiereMapKlausuren(pInput);
        this._klausurenAnzahl = this._mapKlausurZuNummer.size();
        this._klausurZuTermin = new int[this._klausurenAnzahl];
        this._klausurZuTermin1 = new int[this._klausurenAnzahl];
        this._klausurZuTermin2 = new int[this._klausurenAnzahl];
        this._verboten = new boolean[this._klausurenAnzahl][this._klausurenAnzahl];
        this.initialisiereMatrixVerboten(pInput);
        this.initialisiereKlausurgruppen(pInput, pConfig);
        this.checkKlausurgruppenOrException();
        this.initialisiereKlausurgruppenGrad();
        this.aktionClear();
    }

    private void checkKlausurgruppenOrException() {
        for (ArrayList<Integer> gruppe : this._klausurGruppen) {
            for (int nr1 : gruppe) {
                for (int nr2 : gruppe) {
                    if (!this._verboten[nr1][nr2]) continue;
                    throw new UserNotificationException("Die aktuelle Konfiguration f\u00fchrt zu einer Klausurgruppe, in der mindestens ein S. doppelt ist!");
                }
            }
        }
    }

    @NotNull
    private Integer gibKlausurNrOrException(@NotNull GostKursklausur pGostKursklausur) {
        return DeveloperNotificationException.ifNull("Kein Mapping zu gostKursklausur.id(" + pGostKursklausur.id + ")", this._mapKlausurZuNummer.get(pGostKursklausur.id));
    }

    private void initialisiereKlausurgruppenNormal(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        for (GostKursklausur gostKursklausur : pInput) {
            @NotNull Integer klausurNr = this.gibKlausurNrOrException(gostKursklausur);
            @NotNull ArrayList<@NotNull Integer> gruppe = new ArrayList<Integer>();
            gruppe.add(klausurNr);
            this._klausurGruppen.add(gruppe);
        }
    }

    private void initialisiereKlausurgruppenFaecherweise(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        @NotNull HashMap<@NotNull Long, @NotNull ArrayList<@NotNull Integer>> mapFachZuKlausurGruppe = new HashMap<Long, ArrayList<Integer>>();
        for (GostKursklausur gostKursklausur : pInput) {
            ArrayList<Integer> gruppe;
            @NotNull Integer klausurNr = this.gibKlausurNrOrException(gostKursklausur);
            long fachID = gostKursklausur.idFach;
            if (fachID < 0L) {
                gruppe = new ArrayList<Integer>();
                gruppe.add(klausurNr);
                this._klausurGruppen.add(gruppe);
                continue;
            }
            gruppe = (ArrayList<Integer>)mapFachZuKlausurGruppe.get(fachID);
            if (gruppe == null) {
                gruppe = new ArrayList<Integer>();
                mapFachZuKlausurGruppe.put(fachID, gruppe);
                this._klausurGruppen.add(gruppe);
            }
            gruppe.add(klausurNr);
        }
    }

    private void initialisiereKlausurgruppenSchienenweise(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        @NotNull HashMap<@NotNull Long, @NotNull ArrayList<@NotNull Integer>> mapSchieneZuKlausurGruppe = new HashMap<Long, ArrayList<Integer>>();
        for (GostKursklausur gostKursklausur : pInput) {
            ArrayList<Integer> gruppe;
            long schienenID;
            @NotNull Integer klausurNr = this.gibKlausurNrOrException(gostKursklausur);
            long l = schienenID = gostKursklausur.kursSchiene.length < 1 ? -1L : (long)gostKursklausur.kursSchiene[0];
            if (schienenID < 0L) {
                gruppe = new ArrayList<Integer>();
                gruppe.add(klausurNr);
                this._klausurGruppen.add(gruppe);
                continue;
            }
            gruppe = (ArrayList<Integer>)mapSchieneZuKlausurGruppe.get(schienenID);
            if (gruppe == null) {
                gruppe = new ArrayList<Integer>();
                mapSchieneZuKlausurGruppe.put(schienenID, gruppe);
                this._klausurGruppen.add(gruppe);
            }
            gruppe.add(klausurNr);
        }
    }

    private void initialisiereKlausurgruppen(@NotNull @NotNull List<@NotNull GostKursklausur> pInput, @NotNull GostKlausurterminblockungKonfiguration pConfig) {
        @NotNull KlausurterminblockungAlgorithmen algo = KlausurterminblockungAlgorithmen.getOrException(pConfig.algorithmus);
        switch (algo) {
            case NORMAL: {
                this.initialisiereKlausurgruppenNormal(pInput);
                break;
            }
            case FAECHERWEISE: {
                this.initialisiereKlausurgruppenFaecherweise(pInput);
                break;
            }
            case SCHIENENWEISE: {
                this.initialisiereKlausurgruppenSchienenweise(pInput);
            }
        }
    }

    private void initialisiereKlausurgruppenGrad() {
        this._klausurGruppenGrad.addAll(this._klausurGruppen);
        block0: for (int i = 1; i < this._klausurGruppenGrad.size(); ++i) {
            for (int j = i; j >= 1; --j) {
                @NotNull ArrayList<@NotNull Integer> gruppeR = this._klausurGruppenGrad.get(j);
                @NotNull ArrayList<@NotNull Integer> gruppeL = this._klausurGruppenGrad.get(j - 1);
                int gradR = this.gibKnotengrad(gruppeR);
                int gradL = this.gibKnotengrad(gruppeL);
                if (gradL >= gradR) continue block0;
                this._klausurGruppenGrad.set(j, gruppeL);
                this._klausurGruppenGrad.set(j - 1, gruppeR);
            }
        }
    }

    private int gibKnotengrad(@NotNull @NotNull ArrayList<@NotNull Integer> pGruppe) {
        int grad = 0;
        for (ArrayList<Integer> gruppe : this._klausurGruppen) {
            if (!this.gibIstVerboten(pGruppe, gruppe)) continue;
            ++grad;
        }
        return grad;
    }

    private boolean gibIstVerboten(@NotNull @NotNull ArrayList<@NotNull Integer> pGruppe1, @NotNull @NotNull ArrayList<@NotNull Integer> pGruppe2) {
        for (int klausurNr1 : pGruppe1) {
            for (int klausurNr2 : pGruppe2) {
                if (!this._verboten[klausurNr1][klausurNr2]) continue;
                return true;
            }
        }
        return false;
    }

    private void initialisiereMapKlausuren(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        for (GostKursklausur gostKursklausur : pInput) {
            if (gostKursklausur.id < 0L) {
                throw new DeveloperNotificationException("Klausur-ID=" + gostKursklausur.id + " ist negativ!");
            }
            if (this._mapKlausurZuNummer.containsKey(gostKursklausur.id)) {
                throw new DeveloperNotificationException("Klausur-ID=" + gostKursklausur.id + " ist doppelt!");
            }
            int klausurNummer = this._mapKlausurZuNummer.size();
            this._mapKlausurZuNummer.put(gostKursklausur.id, klausurNummer);
            this._mapNummerZuKlausur.put(klausurNummer, gostKursklausur);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void initialisiereMatrixVerboten(@NotNull @NotNull List<@NotNull GostKursklausur> pInput) {
        @NotNull HashMap<@NotNull Long, @NotNull LinkedCollection<@NotNull E>> mapSchuelerKlausuren = new HashMap();
        for (GostKursklausur gostKursklausur : pInput) {
            for (Long schuelerID : gostKursklausur.schuelerIds) {
                Integer klausurNr;
                LinkedCollection<@NotNull Integer> list = (LinkedCollection<Integer>)mapSchuelerKlausuren.get(schuelerID);
                if (list == null) {
                    list = new LinkedCollection<Integer>();
                    mapSchuelerKlausuren.put(schuelerID, list);
                }
                if ((klausurNr = this._mapKlausurZuNummer.get(gostKursklausur.id)) == null) {
                    throw new DeveloperNotificationException("Kein Mapping zu gostKursklausur.id = " + gostKursklausur.id);
                }
                list.addLast(klausurNr);
            }
        }
        for (Map.Entry entry : mapSchuelerKlausuren.entrySet()) {
            @NotNull @NotNull LinkedCollection list = (LinkedCollection)entry.getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int klausurNr1 = (Integer)iterator.next();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    int klausurNr2 = (Integer)iterator2.next();
                    if (klausurNr1 == klausurNr2) continue;
                    this._verboten[klausurNr1][klausurNr2] = true;
                }
            }
        }
    }

    int gibTerminAnzahl() {
        return this._terminAnzahl;
    }

    int gibKlausurgruppenAnzahl() {
        return this._klausurGruppen.size();
    }

    boolean gibExistierenNichtverteilteKlausuren() {
        for (int klausurNr = 0; klausurNr < this._klausurenAnzahl; ++klausurNr) {
            if (this._klausurZuTermin[klausurNr] >= 0) continue;
            return true;
        }
        return false;
    }

    int gibErzeugeNeuenTermin() {
        ++this._terminAnzahl;
        return this._terminAnzahl - 1;
    }

    void entferneLetztenTermin() {
        --this._terminAnzahl;
    }

    @NotNull
    private int[] gibTermineInZufaelligerReihenfolge() {
        int[] temp = new int[this._terminAnzahl];
        for (int i = 0; i < this._terminAnzahl; ++i) {
            temp[i] = i;
        }
        for (int i1 = 0; i1 < this._terminAnzahl; ++i1) {
            int save2;
            int i2 = this._random.nextInt(this._terminAnzahl);
            int save1 = temp[i1];
            temp[i1] = save2 = temp[i2];
            temp[i2] = save1;
        }
        return temp;
    }

    @NotNull
    private @NotNull ArrayList<@NotNull ArrayList<@NotNull Integer>> gibKlausurgruppenInZufaelligerReihenfolge() {
        @NotNull ArrayList<@NotNull ArrayList<@NotNull Integer>> temp = new ArrayList<ArrayList<Integer>>();
        temp.addAll(this._klausurGruppen);
        for (int i1 = 0; i1 < temp.size(); ++i1) {
            int i2 = this._random.nextInt(temp.size());
            @NotNull ArrayList<@NotNull Integer> save1 = temp.get(i1);
            @NotNull ArrayList<@NotNull Integer> save2 = temp.get(i2);
            temp.set(i1, save2);
            temp.set(i2, save1);
        }
        return temp;
    }

    @NotNull.List(value={@NotNull, @NotNull})
    @NotNull.List(value={@NotNull, @NotNull}) ArrayList<@NotNull ArrayList<@NotNull Integer>> gibKlausurgruppenMitHoeheremGradZuerstEtwasPermutiert() {
        @NotNull ArrayList<@NotNull ArrayList<@NotNull Integer>> temp = new ArrayList<ArrayList<Integer>>();
        temp.addAll(this._klausurGruppenGrad);
        int size = temp.size();
        for (int i1 = 0; i1 < size; ++i1) {
            int i2 = this._random.nextInt(size);
            if ((i1 - i2) * (i1 - i2) >= size) continue;
            @NotNull ArrayList<@NotNull Integer> save1 = temp.get(i1);
            @NotNull ArrayList<@NotNull Integer> save2 = temp.get(i2);
            temp.set(i1, save2);
            temp.set(i2, save1);
        }
        return temp;
    }

    @NotNull
    @NotNull ArrayList<@NotNull Integer> gibKlausurgruppeMitMinimalenTerminmoeglichkeiten() {
        int min = this._klausurenAnzahl;
        ArrayList<@NotNull Integer> gruppeMin = null;
        for (ArrayList<Integer> gruppe : this.gibKlausurgruppenMitHoeheremGradZuerstEtwasPermutiert()) {
            int terminmoeglichekeiten;
            if (!this.gibIstKlausurgruppeUnverteilt(gruppe) || (terminmoeglichekeiten = this.gibTerminmoeglichkeiten(gruppe)) >= min) continue;
            min = terminmoeglichekeiten;
            gruppeMin = gruppe;
        }
        if (gruppeMin == null) {
            throw new DeveloperNotificationException("Das darf nicht passieren!");
        }
        return gruppeMin;
    }

    private int gibTerminmoeglichkeiten(@NotNull @NotNull ArrayList<@NotNull Integer> gruppe) {
        int summe = 0;
        for (int terminNr = 0; terminNr < this._terminAnzahl; ++terminNr) {
            if (!this.aktionSetzeKlausurgruppeInTermin(gruppe, terminNr)) continue;
            ++summe;
            this.aktionEntferneKlausurgruppeAusTermin(gruppe, terminNr);
        }
        return summe;
    }

    private boolean gibVergleicheMitAktuellemZustand(int terminAnzahlX, @NotNull @NotNull int @NotNull [] klausurZuTerminX) {
        if (this._terminAnzahl < terminAnzahlX) {
            return true;
        }
        if (this._terminAnzahl > terminAnzahlX) {
            return false;
        }
        int[] histogramm = new int[this._terminAnzahl];
        int[] histogrammX = new int[this._terminAnzahl];
        for (int i = 0; i < this._klausurenAnzahl; ++i) {
            int n = this._klausurZuTermin[i];
            histogramm[n] = histogramm[n] + 1;
            int n2 = klausurZuTerminX[i];
            histogrammX[n2] = histogrammX[n2] + 1;
        }
        int minHisto = this._klausurenAnzahl;
        int minHistoX = this._klausurenAnzahl;
        for (int i = 0; i < this._terminAnzahl; ++i) {
            minHisto = Math.min(minHisto, histogramm[i]);
            minHistoX = Math.min(minHistoX, histogrammX[i]);
        }
        return minHisto < minHistoX;
    }

    private boolean gibIstKlausurgruppeUnverteilt(@NotNull @NotNull ArrayList<@NotNull Integer> pGruppe) {
        for (int klausurNr : pGruppe) {
            if (this._klausurZuTermin[klausurNr] < 0) continue;
            return false;
        }
        return true;
    }

    boolean aktionSetzeKlausurgruppeInTermin(@NotNull @NotNull ArrayList<@NotNull Integer> pGruppe, int pTermin) {
        if (pTermin < 0) {
            throw new DeveloperNotificationException("aktionSetzeKlausurGruppeInTermin(" + String.valueOf(pGruppe) + ", " + pTermin + ") --> Termin zu klein!");
        }
        if (pTermin >= this._terminAnzahl) {
            throw new DeveloperNotificationException("aktionSetzeKlausurGruppeInTermin(" + String.valueOf(pGruppe) + ", " + pTermin + ") --> Termin zu gro\u00df!");
        }
        for (int nr2 = 0; nr2 < this._klausurenAnzahl; ++nr2) {
            if (this._klausurZuTermin[nr2] != pTermin) continue;
            for (int nr : pGruppe) {
                if (!this._verboten[nr][nr2]) continue;
                return false;
            }
        }
        for (int nr : pGruppe) {
            this._klausurZuTermin[nr] = pTermin;
        }
        return true;
    }

    void aktionEntferneKlausurgruppeAusTermin(@NotNull @NotNull ArrayList<@NotNull Integer> pGruppe, int pTermin) {
        if (pTermin < 0) {
            throw new DeveloperNotificationException("aktionEntferneKlausurgruppeAusTermin(" + String.valueOf(pGruppe) + ", " + pTermin + ") --> Termin zu klein!");
        }
        if (pTermin >= this._terminAnzahl) {
            throw new DeveloperNotificationException("aktionEntferneKlausurgruppeAusTermin(" + String.valueOf(pGruppe) + ", " + pTermin + ") --> Termin zu gro\u00df!");
        }
        for (int nr : pGruppe) {
            if (this._klausurZuTermin[nr] != pTermin) {
                throw new DeveloperNotificationException("aktionEntferneKlausurgruppeAusTermin: Die Gruppe war gar nicht im Termin " + pTermin + "!");
            }
            this._klausurZuTermin[nr] = -1;
        }
    }

    void aktionSetzeKlausurgruppeInNeuenTermin(@NotNull @NotNull ArrayList<@NotNull Integer> pGruppe) {
        for (int klausurNr : pGruppe) {
            if (this._klausurZuTermin[klausurNr] < 0) continue;
            throw new DeveloperNotificationException("aktionSetzeKlausurGruppeInNeuenTermin(" + klausurNr + ") --> Die Klausur ist bereits einem Termin zugeordnet!");
        }
        for (int klausurNr : pGruppe) {
            this._klausurZuTermin[klausurNr] = this._terminAnzahl;
        }
        ++this._terminAnzahl;
    }

    private void aktionSetzeKlausurgruppeInZufallsterminOderErzeugeNeuenTermin(@NotNull @NotNull ArrayList<@NotNull Integer> pGruppe) {
        for (int terminNr : this.gibTermineInZufaelligerReihenfolge()) {
            if (!this.aktionSetzeKlausurgruppeInTermin(pGruppe, terminNr)) continue;
            return;
        }
        this.aktionSetzeKlausurgruppeInNeuenTermin(pGruppe);
    }

    boolean gibIstBesserAlsZustand1() {
        return this.gibVergleicheMitAktuellemZustand(this._terminAnzahl1, this._klausurZuTermin1);
    }

    boolean gibIstBesserAlsZustand2() {
        return this.gibVergleicheMitAktuellemZustand(this._terminAnzahl2, this._klausurZuTermin2);
    }

    @NotNull
    GostKlausurterminblockungErgebnis gibErzeugeOutput() {
        @NotNull GostKlausurterminblockungErgebnis out = new GostKlausurterminblockungErgebnis();
        for (int i = 0; i < this._terminAnzahl; ++i) {
            out.termine.add(new GostKlausurterminblockungErgebnisTermin());
        }
        for (Map.Entry<Long, Integer> e : this._mapKlausurZuNummer.entrySet()) {
            @NotNull Long klausurID = e.getKey();
            @NotNull Integer klausurNr = e.getValue();
            int terminNr = this._klausurZuTermin[klausurNr];
            DeveloperNotificationException.ifTrue("terminNr(" + terminNr + ") < 0", terminNr < 0);
            DeveloperNotificationException.ifTrue("terminNr(" + terminNr + ") >= _terminAnzahl", terminNr >= this._terminAnzahl);
            out.termine.get((int)terminNr).kursklausuren.add(klausurID);
        }
        return out;
    }

    void aktionClear() {
        for (int i = 0; i < this._klausurenAnzahl; ++i) {
            this._klausurZuTermin[i] = -1;
        }
        this._terminAnzahl = 0;
    }

    void aktionZustand1Speichern() {
        this._terminAnzahl1 = this._terminAnzahl;
        System.arraycopy(this._klausurZuTermin, 0, this._klausurZuTermin1, 0, this._klausurenAnzahl);
    }

    void aktionZustand1Laden() {
        this.aktionClear();
        this._terminAnzahl = this._terminAnzahl1;
        System.arraycopy(this._klausurZuTermin1, 0, this._klausurZuTermin, 0, this._klausurenAnzahl);
    }

    void aktionZustand2Speichern() {
        this._terminAnzahl2 = this._terminAnzahl;
        System.arraycopy(this._klausurZuTermin, 0, this._klausurZuTermin2, 0, this._klausurenAnzahl);
        this._logger.logLn("BESSER");
    }

    void aktionZustand2Laden() {
        this.aktionClear();
        this._terminAnzahl = this._terminAnzahl2;
        System.arraycopy(this._klausurZuTermin2, 0, this._klausurZuTermin, 0, this._klausurenAnzahl);
    }

    void aktion_Clear_KlausurgruppenZufaellig_TermineZufaellig() {
        this.aktionClear();
        for (ArrayList<Integer> gruppe : this.gibKlausurgruppenInZufaelligerReihenfolge()) {
            this.aktionSetzeKlausurgruppeInZufallsterminOderErzeugeNeuenTermin(gruppe);
        }
    }

    void aktion_Clear_TermineNacheinander_GruppeZufaellig() {
        this.aktionClear();
        while (this.gibExistierenNichtverteilteKlausuren()) {
            int terminNr = this.gibErzeugeNeuenTermin();
            for (ArrayList<Integer> gruppe : this.gibKlausurgruppenInZufaelligerReihenfolge()) {
                if (!this.gibIstKlausurgruppeUnverteilt(gruppe)) continue;
                this.aktionSetzeKlausurgruppeInTermin(gruppe, terminNr);
            }
        }
    }

    void aktion_Clear_GruppeHoeherGradZuerst_TermineZufaellig() {
        this.aktionClear();
        for (ArrayList<Integer> gruppe : this.gibKlausurgruppenMitHoeheremGradZuerstEtwasPermutiert()) {
            this.aktionSetzeKlausurgruppeInZufallsterminOderErzeugeNeuenTermin(gruppe);
        }
    }

    public void aktion_Clear_TermineNacheinander_GruppeNachGrad() {
        this.aktionClear();
        while (this.gibExistierenNichtverteilteKlausuren()) {
            int terminNr = this.gibErzeugeNeuenTermin();
            for (ArrayList<Integer> gruppe : this.gibKlausurgruppenMitHoeheremGradZuerstEtwasPermutiert()) {
                if (!this.gibIstKlausurgruppeUnverteilt(gruppe)) continue;
                this.aktionSetzeKlausurgruppeInTermin(gruppe, terminNr);
            }
        }
    }

    void debug(@NotNull String header) {
        this._logger.modifyIndent(4);
        this._logger.logLn(header);
        for (int s = 0; s < this._terminAnzahl; ++s) {
            this._logger.log("    Schiene " + (s + 1) + ": ");
            for (int nr = 0; nr < this._klausurenAnzahl; ++nr) {
                if (this._klausurZuTermin[nr] != s) continue;
                @NotNull GostKursklausur gostKlausur = DeveloperNotificationException.ifNull("Mapping _mapNummerZuKlausur.get(" + nr + ") ist NULL!", this._mapNummerZuKlausur.get(nr));
                this._logger.log(" " + gostKlausur.kursKurzbezeichnung + "/" + Arrays.toString(gostKlausur.kursSchiene));
            }
            this._logger.logLn("");
        }
        for (int nr = 0; nr < this._klausurenAnzahl; ++nr) {
            DeveloperNotificationException.ifTrue("Klausur " + (nr + 1) + " --> ohne Schiene!", this._klausurZuTermin[nr] < 0);
        }
        this._logger.modifyIndent(-4);
    }
}

