/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.lehrer;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.lehrer.LehrerListeEintrag;
import de.svws_nrw.core.data.lehrer.LehrerPersonalabschnittsdaten;
import de.svws_nrw.core.data.lehrer.LehrerPersonaldaten;
import de.svws_nrw.core.data.lehrer.LehrerStammdaten;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.PersonalTyp;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.utils.AttributMitAuswahl;
import de.svws_nrw.core.utils.AuswahlManager;
import de.svws_nrw.core.utils.lehrer.LehrerUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class LehrerListeManager
extends AuswahlManager<Long, LehrerListeEintrag, LehrerStammdaten> {
    @NotNull
    private static final @NotNull Function<@NotNull LehrerListeEintrag, @NotNull Long> _lehrerToId = k -> k.id;
    @NotNull
    private static final @NotNull Function<@NotNull LehrerStammdaten, @NotNull Long> _lehrerDatenToId = k -> k.id;
    @NotNull
    private final @NotNull HashMap2D<@NotNull Boolean, @NotNull Long, @NotNull LehrerListeEintrag> _mapKlasseIstSichtbar = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Boolean, @NotNull Long, @NotNull LehrerListeEintrag> _mapLehrerIstStatistikrelevant = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull PersonalTyp, @NotNull Long, @NotNull LehrerListeEintrag> _mapKlasseHatPersonaltyp = new HashMap2D();
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Integer, @NotNull PersonalTyp> personaltypen;
    @NotNull
    private static final @NotNull Function<@NotNull PersonalTyp, @NotNull Integer> _personaltypToId = pt -> pt.id;
    @NotNull
    private static final @NotNull Comparator<@NotNull PersonalTyp> _comparatorPersonaltypen = (a, b) -> a.ordinal() - b.ordinal();
    private boolean _filterNurSichtbar = true;
    private boolean _filterNurStatistikrelevant = true;
    private LehrerPersonaldaten _personaldaten = null;
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull LehrerPersonalabschnittsdaten> _mapAbschnittsdatenById = new HashMap<Long, LehrerPersonalabschnittsdaten>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull LehrerPersonalabschnittsdaten> _mapAbschnittsdatenBySchuljahresabschnittsId = new HashMap<Long, LehrerPersonalabschnittsdaten>();

    public LehrerListeManager(Schulform schulform, @NotNull @NotNull List<@NotNull LehrerListeEintrag> lehrer) {
        super(schulform, lehrer, LehrerUtils.comparator, _lehrerToId, _lehrerDatenToId, Arrays.asList(new Pair<String, Boolean>("nachname", true), new Pair<String, Boolean>("vorname", true), new Pair<String, Boolean>("kuerzel", true)));
        this.personaltypen = new AttributMitAuswahl<Integer, PersonalTyp>(Arrays.asList(PersonalTyp.values()), _personaltypToId, _comparatorPersonaltypen, this._eventHandlerFilterChanged);
        this.initLehrer();
    }

    private void initLehrer() {
        for (LehrerListeEintrag l : this.liste.list()) {
            this._mapKlasseIstSichtbar.put(l.istSichtbar, l.id, l);
            this._mapLehrerIstStatistikrelevant.put(l.istRelevantFuerStatistik, l.id, l);
            PersonalTyp personalTyp = PersonalTyp.fromBezeichnung(l.personTyp);
            if (personalTyp == null) continue;
            this._mapKlasseHatPersonaltyp.put(personalTyp, l.id, l);
        }
    }

    @Override
    protected boolean onSetDaten(@NotNull LehrerListeEintrag eintrag, @NotNull LehrerStammdaten daten) {
        if (this._personaldaten != null && this._personaldaten.id != eintrag.id) {
            this.clearPersonalDaten();
        }
        boolean updateEintrag = false;
        if (!daten.kuerzel.equals(eintrag.kuerzel)) {
            eintrag.kuerzel = daten.kuerzel;
            updateEintrag = true;
        }
        if (!daten.nachname.equals(eintrag.nachname)) {
            eintrag.nachname = daten.nachname;
            updateEintrag = true;
        }
        if (!daten.vorname.equals(eintrag.vorname)) {
            eintrag.vorname = daten.vorname;
            updateEintrag = true;
        }
        return updateEintrag;
    }

    public PersonalTyp datenGetPersonalTyp() {
        if (this._daten == null || ((LehrerStammdaten)this._daten).personalTyp == null) {
            return null;
        }
        return PersonalTyp.fromBezeichnung(((LehrerStammdaten)this._daten).personalTyp);
    }

    public boolean filterNurSichtbar() {
        return this._filterNurSichtbar;
    }

    public void setFilterNurSichtbar(boolean value) {
        this._filterNurSichtbar = value;
        this._eventHandlerFilterChanged.run();
    }

    public boolean filterNurStatistikRelevant() {
        return this._filterNurStatistikrelevant;
    }

    public void setFilterNurStatistikRelevant(boolean value) {
        this._filterNurStatistikrelevant = value;
        this._eventHandlerFilterChanged.run();
    }

    protected int compare(@NotNull LehrerListeEintrag a, @NotNull LehrerListeEintrag b) {
        for (Pair criteria : this._order) {
            String field = (String)criteria.a;
            boolean asc = criteria.b == null || (Boolean)criteria.b != false;
            int cmp = 0;
            if ("kuerzel".equals(field)) {
                cmp = a.kuerzel.compareTo(b.kuerzel);
            } else if ("nachname".equals(field)) {
                cmp = a.nachname.compareTo(b.nachname);
            } else if ("vorname".equals(field)) {
                cmp = a.vorname.compareTo(b.vorname);
            } else {
                throw new DeveloperNotificationException("Fehler bei der Sortierung. Das Sortierkriterium wird vom Manager nicht unterst\u00fctzt.");
            }
            if (cmp == 0) continue;
            return asc ? cmp : -cmp;
        }
        return Long.compare(a.id, b.id);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    protected @NotNull List<@NotNull LehrerListeEintrag> onFilter() {
        @NotNull ArrayList<@NotNull LehrerListeEintrag> tmpList = new ArrayList<LehrerListeEintrag>();
        for (LehrerListeEintrag eintrag : this.liste.list()) {
            PersonalTyp personalTyp;
            if (this._filterNurSichtbar && !eintrag.istSichtbar || this._filterNurStatistikrelevant && !eintrag.istRelevantFuerStatistik || this.personaltypen.auswahlExists() && (eintrag.personTyp == null || eintrag.personTyp.isEmpty() || (personalTyp = PersonalTyp.fromBezeichnung(eintrag.personTyp)) == null || !this.personaltypen.auswahlHas(personalTyp))) continue;
            tmpList.add(eintrag);
        }
        @NotNull @NotNull Comparator comparator = (a, b) -> this.compare((LehrerListeEintrag)a, (LehrerListeEintrag)b);
        tmpList.sort(comparator);
        return tmpList;
    }

    private void clearPersonalDaten() {
        this._personaldaten = null;
        this._mapAbschnittsdatenById.clear();
        this._mapAbschnittsdatenBySchuljahresabschnittsId.clear();
    }

    public boolean hasPersonalDaten() {
        return this._personaldaten != null;
    }

    @NotNull
    public LehrerPersonaldaten personalDaten() {
        if (this._personaldaten == null) {
            throw new DeveloperNotificationException("Es exitsieren derzeit keine Personal-Daten");
        }
        return this._personaldaten;
    }

    public void setPersonalDaten(LehrerPersonaldaten personaldaten) throws DeveloperNotificationException {
        if (personaldaten == null) {
            this.clearPersonalDaten();
            return;
        }
        this.liste.getOrException(personaldaten.id);
        boolean neueLehrerId = this._personaldaten == null || this._personaldaten.id != personaldaten.id;
        this._personaldaten = personaldaten;
        if (neueLehrerId) {
            this._mapAbschnittsdatenById.clear();
            this._mapAbschnittsdatenBySchuljahresabschnittsId.clear();
            for (LehrerPersonalabschnittsdaten abschnittsdaten : personaldaten.abschnittsdaten) {
                this._mapAbschnittsdatenById.put(abschnittsdaten.id, abschnittsdaten);
                this._mapAbschnittsdatenBySchuljahresabschnittsId.put(abschnittsdaten.idSchuljahresabschnitt, abschnittsdaten);
            }
        }
    }

    public LehrerPersonalabschnittsdaten getAbschnittById(long id) {
        return this._mapAbschnittsdatenById.get(id);
    }

    public LehrerPersonalabschnittsdaten getAbschnittBySchuljahresabschnittsId(long id) {
        return this._mapAbschnittsdatenBySchuljahresabschnittsId.get(id);
    }
}

