/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.schueler;

import de.svws_nrw.core.data.fach.FaecherListeEintrag;
import de.svws_nrw.core.data.jahrgang.JahrgangsListeEintrag;
import de.svws_nrw.core.data.klassen.KlassenListeEintrag;
import de.svws_nrw.core.data.kurse.KursListeEintrag;
import de.svws_nrw.core.data.lehrer.LehrerListeEintrag;
import de.svws_nrw.core.data.schueler.SchuelerLeistungsdaten;
import de.svws_nrw.core.data.schueler.SchuelerLernabschnittsdaten;
import de.svws_nrw.core.data.schueler.SchuelerListeEintrag;
import de.svws_nrw.core.data.schule.FoerderschwerpunktEintrag;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.Note;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import de.svws_nrw.core.utils.jahrgang.JahrgangsUtils;
import de.svws_nrw.core.utils.klassen.KlassenUtils;
import de.svws_nrw.core.utils.kurse.KursUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchuelerLernabschnittManager {
    @NotNull
    private final SchuelerListeEintrag _schueler;
    @NotNull
    private final SchuelerLernabschnittsdaten _lernabschnittsdaten;
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull SchuelerLeistungsdaten> _mapLeistungById = new HashMap<Long, SchuelerLeistungsdaten>();
    @NotNull
    private final @NotNull List<@NotNull FaecherListeEintrag> _faecher = new ArrayList<FaecherListeEintrag>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull FaecherListeEintrag> _mapFachByID = new HashMap<Long, FaecherListeEintrag>();
    @NotNull
    private final @NotNull List<@NotNull FoerderschwerpunktEintrag> _foerderschwerpunkte = new ArrayList<FoerderschwerpunktEintrag>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull FoerderschwerpunktEintrag> _mapFoerderschwerpunktByID = new HashMap<Long, FoerderschwerpunktEintrag>();
    @NotNull
    private final @NotNull List<@NotNull JahrgangsListeEintrag> _jahrgaenge = new ArrayList<JahrgangsListeEintrag>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull JahrgangsListeEintrag> _mapJahrgangByID = new HashMap<Long, JahrgangsListeEintrag>();
    @NotNull
    private final @NotNull List<@NotNull KlassenListeEintrag> _klassen = new ArrayList<KlassenListeEintrag>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull KlassenListeEintrag> _mapKlasseByID = new HashMap<Long, KlassenListeEintrag>();
    @NotNull
    private final @NotNull List<@NotNull KursListeEintrag> _kurse = new ArrayList<KursListeEintrag>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull KursListeEintrag> _mapKursByID = new HashMap<Long, KursListeEintrag>();
    @NotNull
    private final @NotNull List<@NotNull LehrerListeEintrag> _lehrer = new ArrayList<LehrerListeEintrag>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull LehrerListeEintrag> _mapLehrerByID = new HashMap<Long, LehrerListeEintrag>();
    @NotNull
    private static final @NotNull Comparator<@NotNull FaecherListeEintrag> _compFach = (a, b) -> {
        int cmp = a.sortierung - b.sortierung;
        if (cmp != 0) {
            return cmp;
        }
        if (a.kuerzel == null || b.kuerzel == null) {
            throw new DeveloperNotificationException("Fachk\u00fcrzel d\u00fcrfen nicht null sein");
        }
        cmp = a.kuerzel.compareTo(b.kuerzel);
        return cmp == 0 ? Long.compare(a.id, b.id) : cmp;
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull FoerderschwerpunktEintrag> _compFoerderschwerpunkte = (a, b) -> {
        if (a.text == null) {
            return -1;
        }
        if (b.text == null) {
            return 1;
        }
        return a.text.compareTo(b.text);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull LehrerListeEintrag> _compLehrer = (a, b) -> {
        int cmp = a.sortierung - b.sortierung;
        if (cmp != 0) {
            return cmp;
        }
        cmp = a.nachname.compareTo(b.nachname);
        if (cmp != 0) {
            return cmp;
        }
        cmp = a.vorname.compareTo(b.vorname);
        return cmp == 0 ? Long.compare(a.id, b.id) : cmp;
    };
    @NotNull
    private final @NotNull Comparator<@NotNull SchuelerLeistungsdaten> _compLeistungenByFach = (a, b) -> {
        @NotNull FaecherListeEintrag aFach = DeveloperNotificationException.ifMapGetIsNull(this._mapFachByID, a.fachID);
        @NotNull FaecherListeEintrag bFach = DeveloperNotificationException.ifMapGetIsNull(this._mapFachByID, b.fachID);
        return _compFach.compare(aFach, bFach);
    };

    public SchuelerLernabschnittManager(@NotNull SchuelerListeEintrag schueler, @NotNull SchuelerLernabschnittsdaten lernabschnittsdaten, @NotNull @NotNull List<@NotNull FaecherListeEintrag> faecher, @NotNull @NotNull List<@NotNull FoerderschwerpunktEintrag> foerderschwerpunkte, @NotNull @NotNull List<@NotNull JahrgangsListeEintrag> jahrgaenge, @NotNull @NotNull List<@NotNull KlassenListeEintrag> klassen, @NotNull @NotNull List<@NotNull KursListeEintrag> kurse, @NotNull @NotNull List<@NotNull LehrerListeEintrag> lehrer) {
        this._schueler = schueler;
        this._lernabschnittsdaten = lernabschnittsdaten;
        this.initLeistungsdaten(lernabschnittsdaten.leistungsdaten);
        this.initFaecher(faecher);
        this.initFoerderschwerpunkte(foerderschwerpunkte);
        this.initJahrgaenge(jahrgaenge);
        this.initKlassen(klassen);
        this.initKurse(kurse);
        this.initLehrer(lehrer);
    }

    private void initLeistungsdaten(@NotNull @NotNull List<@NotNull SchuelerLeistungsdaten> leistungsdaten) {
        for (SchuelerLeistungsdaten leistung : leistungsdaten) {
            this.leistungAdd(leistung);
        }
    }

    private void initFaecher(@NotNull @NotNull List<@NotNull FaecherListeEintrag> faecher) {
        this._faecher.clear();
        this._faecher.addAll(faecher);
        this._faecher.sort(_compFach);
        this._mapFachByID.clear();
        for (FaecherListeEintrag f : faecher) {
            this._mapFachByID.put(f.id, f);
        }
    }

    private void initFoerderschwerpunkte(@NotNull @NotNull List<@NotNull FoerderschwerpunktEintrag> foerderschwerpunkte) {
        this._foerderschwerpunkte.clear();
        this._foerderschwerpunkte.addAll(foerderschwerpunkte);
        this._foerderschwerpunkte.sort(_compFoerderschwerpunkte);
        this._mapFoerderschwerpunktByID.clear();
        for (FoerderschwerpunktEintrag f : foerderschwerpunkte) {
            this._mapFoerderschwerpunktByID.put(f.id, f);
        }
    }

    private void initJahrgaenge(@NotNull @NotNull List<@NotNull JahrgangsListeEintrag> jahrgaenge) {
        this._jahrgaenge.clear();
        this._jahrgaenge.addAll(jahrgaenge);
        this._jahrgaenge.sort(JahrgangsUtils.comparator);
        this._mapJahrgangByID.clear();
        for (JahrgangsListeEintrag j : jahrgaenge) {
            this._mapJahrgangByID.put(j.id, j);
        }
    }

    private void initKlassen(@NotNull @NotNull List<@NotNull KlassenListeEintrag> klassen) {
        this._klassen.clear();
        this._klassen.addAll(klassen);
        this._klassen.sort(KlassenUtils.comparator);
        this._mapKlasseByID.clear();
        for (KlassenListeEintrag k : klassen) {
            this._mapKlasseByID.put(k.id, k);
        }
    }

    private void initKurse(@NotNull @NotNull List<@NotNull KursListeEintrag> kurse) {
        this._kurse.clear();
        this._kurse.addAll(kurse);
        this._kurse.sort(KursUtils.comparator);
        this._mapKursByID.clear();
        for (KursListeEintrag k : kurse) {
            this._mapKursByID.put(k.id, k);
        }
    }

    private void initLehrer(@NotNull @NotNull List<@NotNull LehrerListeEintrag> lehrer) {
        this._lehrer.clear();
        this._lehrer.addAll(lehrer);
        this._lehrer.sort(_compLehrer);
        this._mapLehrerByID.clear();
        for (LehrerListeEintrag l : lehrer) {
            this._mapLehrerByID.put(l.id, l);
        }
    }

    @NotNull
    public SchuelerLernabschnittsdaten lernabschnittGet() {
        return this._lernabschnittsdaten;
    }

    public void leistungAdd(@NotNull SchuelerLeistungsdaten leistungsdaten) {
        this._mapLeistungById.put(leistungsdaten.id, leistungsdaten);
    }

    @NotNull
    public SchuelerLeistungsdaten leistungGetByIdOrException(long idLeistung) {
        return DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
    }

    @NotNull
    public @NotNull List<@NotNull SchuelerLeistungsdaten> leistungGetMengeAsListSortedByFach() {
        @NotNull ArrayList<@NotNull SchuelerLeistungsdaten> result = new ArrayList<SchuelerLeistungsdaten>();
        result.addAll(this._lernabschnittsdaten.leistungsdaten);
        result.sort(this._compLeistungenByFach);
        return result;
    }

    public boolean leistungHatKurs(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        return this._mapKursByID.get(leistung.kursID) != null;
    }

    public boolean leistungHatLehrer(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        return this._mapLehrerByID.get(leistung.lehrerID) != null;
    }

    @NotNull
    public FaecherListeEintrag fachGetByIdOrException(long id) {
        return DeveloperNotificationException.ifMapGetIsNull(this._mapFachByID, id);
    }

    @NotNull
    public FaecherListeEintrag fachGetByLeistungIdOrException(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        return DeveloperNotificationException.ifMapGetIsNull(this._mapFachByID, leistung.fachID);
    }

    @NotNull
    public String fachFarbeGetByLeistungsIdOrException(long idLeistung) {
        @NotNull FaecherListeEintrag fach = this.fachGetByLeistungIdOrException(idLeistung);
        return ZulaessigesFach.getByKuerzelASD(fach.kuerzel).getHMTLFarbeRGB();
    }

    @NotNull
    public @NotNull List<@NotNull FaecherListeEintrag> fachGetMenge() {
        return this._faecher;
    }

    @NotNull
    public FoerderschwerpunktEintrag foerderschwerpunktGetByIdOrException(long id) {
        return DeveloperNotificationException.ifMapGetIsNull(this._mapFoerderschwerpunktByID, id);
    }

    @NotNull
    public @NotNull List<@NotNull FoerderschwerpunktEintrag> foerderschwerpunktGetMenge() {
        return this._foerderschwerpunkte;
    }

    @NotNull
    public JahrgangsListeEintrag jahrgangGetByIdOrException(long id) {
        return DeveloperNotificationException.ifMapGetIsNull(this._mapJahrgangByID, id);
    }

    @NotNull
    public @NotNull List<@NotNull JahrgangsListeEintrag> jahrgangGetMenge() {
        return this._jahrgaenge;
    }

    @NotNull
    public KlassenListeEintrag klasseGetByIdOrException(long id) {
        return DeveloperNotificationException.ifMapGetIsNull(this._mapKlasseByID, id);
    }

    @NotNull
    public @NotNull List<@NotNull KlassenListeEintrag> klasseGetMenge() {
        return this._klassen;
    }

    @NotNull
    public KursListeEintrag kursGetByIdOrException(long id) {
        return DeveloperNotificationException.ifMapGetIsNull(this._mapKursByID, id);
    }

    public KursListeEintrag kursGetByLeistungIdOrNull(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        return this._mapKursByID.get(leistung.kursID);
    }

    @NotNull
    public KursListeEintrag kursGetByLeistungIdOrException(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        return DeveloperNotificationException.ifMapGetIsNull(this._mapKursByID, leistung.kursID);
    }

    @NotNull
    public @NotNull List<@NotNull KursListeEintrag> kursGetMenge() {
        return this._kurse;
    }

    @NotNull
    public @NotNull List<@NotNull KursListeEintrag> kursGetMengeFilteredByLeistung(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        @NotNull ArrayList<@NotNull KursListeEintrag> result = new ArrayList<KursListeEintrag>();
        for (KursListeEintrag k : this._kurse) {
            if (k.idFach != leistung.fachID || !k.idJahrgaenge.isEmpty() && !k.idJahrgaenge.contains(this._schueler.idJahrgang)) continue;
            result.add(k);
        }
        return result;
    }

    @NotNull
    public LehrerListeEintrag lehrerGetByIdOrException(long id) {
        return DeveloperNotificationException.ifMapGetIsNull(this._mapLehrerByID, id);
    }

    public LehrerListeEintrag lehrerGetByLeistungIdOrNull(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        return this._mapLehrerByID.get(leistung.lehrerID);
    }

    @NotNull
    public LehrerListeEintrag lehrerGetByLeistungIdOrException(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        return DeveloperNotificationException.ifMapGetIsNull(this._mapLehrerByID, leistung.lehrerID);
    }

    @NotNull
    public @NotNull List<@NotNull LehrerListeEintrag> lehrerGetMenge() {
        return this._lehrer;
    }

    @NotNull
    public Note noteGetByLeistungIdOrException(long idLeistung) {
        @NotNull SchuelerLeistungsdaten leistung = DeveloperNotificationException.ifMapGetIsNull(this._mapLeistungById, idLeistung);
        return Note.fromKuerzel(leistung.note);
    }

    @NotNull
    public SchuelerListeEintrag schuelerGet() {
        return this._schueler;
    }
}

