/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.schueler;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.gost.GostJahrgang;
import de.svws_nrw.core.data.jahrgang.JahrgangsListeEintrag;
import de.svws_nrw.core.data.klassen.KlassenListeEintrag;
import de.svws_nrw.core.data.kurse.KursListeEintrag;
import de.svws_nrw.core.data.schueler.SchuelerListeEintrag;
import de.svws_nrw.core.data.schueler.SchuelerStammdaten;
import de.svws_nrw.core.data.schule.Schuljahresabschnitt;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.SchuelerStatus;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import de.svws_nrw.core.utils.AttributMitAuswahl;
import de.svws_nrw.core.utils.AuswahlManager;
import de.svws_nrw.core.utils.gost.GostAbiturjahrUtils;
import de.svws_nrw.core.utils.jahrgang.JahrgangsUtils;
import de.svws_nrw.core.utils.klassen.KlassenUtils;
import de.svws_nrw.core.utils.kurse.KursUtils;
import de.svws_nrw.core.utils.schueler.SchuelerUtils;
import de.svws_nrw.core.utils.schule.SchuljahresabschnittsUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class SchuelerListeManager
extends AuswahlManager<Long, SchuelerListeEintrag, SchuelerStammdaten> {
    @NotNull
    private static final @NotNull Function<@NotNull SchuelerListeEintrag, @NotNull Long> _schuelerToId = s -> s.id;
    @NotNull
    private static final @NotNull Function<@NotNull SchuelerStammdaten, @NotNull Long> _stammdatenToId = s -> s.id;
    @NotNull
    private final @NotNull HashMap2D<@NotNull Integer, @NotNull Long, @NotNull SchuelerListeEintrag> _mapSchuelerMitStatus = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull SchuelerListeEintrag> _mapSchuelerInJahrgang = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull SchuelerListeEintrag> _mapSchuelerInKlasse = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull SchuelerListeEintrag> _mapSchuelerInKurs = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull SchuelerListeEintrag> _mapSchuelerInSchuljahresabschnitt = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Integer, @NotNull Long, @NotNull SchuelerListeEintrag> _mapSchuelerInAbiturjahrgang = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull String, @NotNull Long, @NotNull SchuelerListeEintrag> _mapSchuelerInSchulgliederung = new HashMap2D();
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Long, @NotNull JahrgangsListeEintrag> jahrgaenge;
    @NotNull
    private static final @NotNull Function<@NotNull JahrgangsListeEintrag, @NotNull Long> _jahrgangToId = jg -> jg.id;
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Long, @NotNull KlassenListeEintrag> klassen;
    @NotNull
    private static final @NotNull Function<@NotNull KlassenListeEintrag, @NotNull Long> _klasseToId = k -> k.id;
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Long, @NotNull KursListeEintrag> kurse;
    @NotNull
    private static final @NotNull Function<@NotNull KursListeEintrag, @NotNull Long> _kursToId = k -> k.id;
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Long, @NotNull Schuljahresabschnitt> schuljahresabschnitte;
    @NotNull
    private static final @NotNull Function<@NotNull Schuljahresabschnitt, @NotNull Long> _schuljahresabschnittToId = sja -> sja.id;
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Integer, @NotNull GostJahrgang> abiturjahrgaenge;
    @NotNull
    private static final @NotNull Function<@NotNull GostJahrgang, @NotNull Integer> _abiturjahrgangToId = a -> a.abiturjahr;
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull String, @NotNull Schulgliederung> schulgliederungen;
    @NotNull
    private static final @NotNull Function<@NotNull Schulgliederung, @NotNull String> _schulgliederungToId = sg -> sg.daten.kuerzel;
    @NotNull
    private static final @NotNull Comparator<@NotNull Schulgliederung> _comparatorSchulgliederung = (a, b) -> a.ordinal() - b.ordinal();
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Integer, @NotNull SchuelerStatus> schuelerstatus;
    @NotNull
    private static final @NotNull Function<@NotNull SchuelerStatus, @NotNull Integer> _schuelerstatusToId = s -> s.id;
    @NotNull
    private static final @NotNull Comparator<@NotNull SchuelerStatus> _comparatorSchuelerStatus = (a, b) -> a.ordinal() - b.ordinal();

    public SchuelerListeManager(Schulform schulform, @NotNull @NotNull List<@NotNull SchuelerListeEintrag> schueler, @NotNull @NotNull List<@NotNull JahrgangsListeEintrag> jahrgaenge, @NotNull @NotNull List<@NotNull KlassenListeEintrag> klassen, @NotNull @NotNull List<@NotNull KursListeEintrag> kurse, @NotNull @NotNull List<@NotNull Schuljahresabschnitt> schuljahresabschnitte, @NotNull @NotNull List<@NotNull GostJahrgang> abiturjahrgaenge) {
        super(schulform, schueler, SchuelerUtils.comparator, _schuelerToId, _stammdatenToId, Arrays.asList(new Pair<String, Boolean>("klassen", true), new Pair<String, Boolean>("nachname", true), new Pair<String, Boolean>("vorname", true)));
        this.jahrgaenge = new AttributMitAuswahl<Long, JahrgangsListeEintrag>(jahrgaenge, _jahrgangToId, JahrgangsUtils.comparator, this._eventHandlerFilterChanged);
        this.klassen = new AttributMitAuswahl<Long, KlassenListeEintrag>(klassen, _klasseToId, KlassenUtils.comparator, this._eventHandlerFilterChanged);
        this.kurse = new AttributMitAuswahl<Long, KursListeEintrag>(kurse, _kursToId, KursUtils.comparator, this._eventHandlerFilterChanged);
        this.schuljahresabschnitte = new AttributMitAuswahl<Long, Schuljahresabschnitt>(schuljahresabschnitte, _schuljahresabschnittToId, SchuljahresabschnittsUtils.comparator, this._eventHandlerFilterChanged);
        this.abiturjahrgaenge = new AttributMitAuswahl<Integer, GostJahrgang>(abiturjahrgaenge, _abiturjahrgangToId, GostAbiturjahrUtils.comparator, this._eventHandlerFilterChanged);
        @NotNull List<@NotNull Schulgliederung> gliederungen = schulform == null ? Arrays.asList(Schulgliederung.values()) : Schulgliederung.get(schulform);
        this.schulgliederungen = new AttributMitAuswahl<String, Schulgliederung>(gliederungen, _schulgliederungToId, _comparatorSchulgliederung, this._eventHandlerFilterChanged);
        this.schuelerstatus = new AttributMitAuswahl<Integer, SchuelerStatus>(Arrays.asList(SchuelerStatus.values()), _schuelerstatusToId, _comparatorSchuelerStatus, this._eventHandlerFilterChanged);
        this.initSchueler();
    }

    private void initSchueler() {
        for (SchuelerListeEintrag s : this.liste.list()) {
            this._mapSchuelerMitStatus.put(s.status, s.id, s);
            if (s.idJahrgang >= 0L) {
                this._mapSchuelerInJahrgang.put(s.idJahrgang, s.id, s);
            }
            if (s.idKlasse >= 0L) {
                this._mapSchuelerInKlasse.put(s.idKlasse, s.id, s);
            }
            for (long idKurs : s.kurse) {
                this._mapSchuelerInKurs.put(idKurs, s.id, s);
            }
            if (s.idSchuljahresabschnitt >= 0L) {
                this._mapSchuelerInSchuljahresabschnitt.put(s.idSchuljahresabschnitt, s.id, s);
            }
            if (s.abiturjahrgang != null) {
                this._mapSchuelerInAbiturjahrgang.put(s.abiturjahrgang, s.id, s);
            }
            if (s.schulgliederung.isBlank()) continue;
            this._mapSchuelerInSchulgliederung.put(s.schulgliederung, s.id, s);
        }
    }

    @Override
    protected boolean onSetDaten(@NotNull SchuelerListeEintrag eintrag, @NotNull SchuelerStammdaten daten) {
        boolean updateEintrag = false;
        if (!daten.vorname.equals(eintrag.vorname)) {
            eintrag.vorname = daten.vorname;
            updateEintrag = true;
        }
        if (!daten.nachname.equals(eintrag.nachname)) {
            eintrag.nachname = daten.nachname;
            updateEintrag = true;
        }
        return updateEintrag;
    }

    public void updateKlassenID(Long idKlasse) throws DeveloperNotificationException {
        if (this._daten == null) {
            throw new DeveloperNotificationException("F\u00fcr das Setzen der Klassen-ID %d muss ein Sch\u00fcler ausgew\u00e4hlt sein.".formatted(idKlasse));
        }
        if (idKlasse != null && idKlasse >= 0L && !this.klassen.has(idKlasse)) {
            throw new DeveloperNotificationException("Die Klassen-ID %d muss zu dem aktuell ausgew\u00e4hlten Schuljahresabschnitt passen.".formatted(idKlasse));
        }
        @NotNull SchuelerListeEintrag eintrag = (SchuelerListeEintrag)this.liste.getOrException(((SchuelerStammdaten)this._daten).id);
        eintrag.idKlasse = idKlasse == null || idKlasse < 0L ? -1L : idKlasse;
        this.orderSet(this.orderGet());
    }

    private int compare(@NotNull SchuelerListeEintrag a, @NotNull SchuelerListeEintrag b) {
        for (Pair criteria : this._order) {
            String field = (String)criteria.a;
            boolean asc = criteria.b == null || (Boolean)criteria.b != false;
            int cmp = 0;
            if ("klassen".equals(field)) {
                KlassenListeEintrag aKlasse = this.klassen.get(a.idKlasse);
                KlassenListeEintrag bKlasse = this.klassen.get(b.idKlasse);
                cmp = aKlasse == null && bKlasse == null ? 0 : (aKlasse == null ? -1 : (bKlasse == null ? 1 : KlassenUtils.comparator.compare(aKlasse, bKlasse)));
            } else if ("nachname".equals(field)) {
                cmp = a.nachname.compareTo(b.nachname);
            } else if ("vorname".equals(field)) {
                cmp = a.vorname.compareTo(b.vorname);
            } else {
                throw new DeveloperNotificationException("Fehler bei der Sortierung. Das Sortierkriterium wird vom Manager nicht unterst\u00fctzt.");
            }
            if (cmp == 0) continue;
            return asc ? cmp : -cmp;
        }
        return Long.compare(a.id, b.id);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    protected @NotNull List<@NotNull SchuelerListeEintrag> onFilter() {
        @NotNull ArrayList<@NotNull SchuelerListeEintrag> tmpList = new ArrayList<SchuelerListeEintrag>();
        for (SchuelerListeEintrag eintrag : this.liste.list()) {
            if (this.jahrgaenge.auswahlExists() && (eintrag.idJahrgang < 0L || !this.jahrgaenge.auswahlHasKey(eintrag.idJahrgang)) || this.klassen.auswahlExists() && (eintrag.idKlasse < 0L || !this.klassen.auswahlHasKey(eintrag.idKlasse))) continue;
            if (this.kurse.auswahlExists()) {
                boolean hatEinenKurs = false;
                for (long idKurs : eintrag.kurse) {
                    if (!this.kurse.auswahlHasKey(idKurs)) continue;
                    hatEinenKurs = true;
                }
                if (!hatEinenKurs) continue;
            }
            if (this.schulgliederungen.auswahlExists() && (eintrag.schulgliederung.isBlank() || !this.schulgliederungen.auswahlHasKey(eintrag.schulgliederung)) || this.schuelerstatus.auswahlExists() && !this.schuelerstatus.auswahlHasKey(eintrag.status)) continue;
            tmpList.add(eintrag);
        }
        @NotNull @NotNull Comparator comparator = (a, b) -> this.compare((SchuelerListeEintrag)a, (SchuelerListeEintrag)b);
        tmpList.sort(comparator);
        return tmpList;
    }
}

