/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.schueler;

import de.svws_nrw.core.data.schueler.Sprachbelegung;
import de.svws_nrw.core.data.schueler.Sprachendaten;
import de.svws_nrw.core.data.schueler.Sprachpruefung;
import de.svws_nrw.core.types.fach.Sprachpruefungniveau;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class SprachendatenUtils {
    private SprachendatenUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static boolean hatSprachbelegung(Sprachendaten sprachendaten, String sprache) {
        if (sprachendaten == null || sprachendaten.belegungen == null || sprache == null || "".equals(sprache)) {
            return false;
        }
        return SprachendatenUtils.getSprachbelegung(sprachendaten, sprache) != null;
    }

    public static boolean hatSprachbelegungInSekI(Sprachendaten sprachendaten, String sprache) {
        if (sprachendaten == null || sprachendaten.belegungen == null || sprache == null || "".equals(sprache)) {
            return false;
        }
        Sprachbelegung belegung = SprachendatenUtils.getSprachbelegung(sprachendaten, sprache);
        if (belegung != null && SprachendatenUtils.getJahrgangNumerisch(belegung.belegungVonJahrgang) > 0) {
            return SprachendatenUtils.getJahrgangNumerisch(belegung.belegungVonJahrgang) <= 10;
        }
        return false;
    }

    public static boolean hatSprachbelegungMitMin2JahrenDauerEndeSekI(Sprachendaten sprachendaten, String sprache) {
        return SprachendatenUtils.hatSprachbelegungMitMinNJahrenEndeSekI(sprachendaten, sprache, 2);
    }

    public static boolean hatSprachbelegungMitMin4JahrenDauerEndeSekI(Sprachendaten sprachendaten, String sprache) {
        return SprachendatenUtils.hatSprachbelegungMitMinNJahrenEndeSekI(sprachendaten, sprache, 4);
    }

    public static Sprachbelegung getSprachbelegung(Sprachendaten sprachendaten, String sprache) {
        if (sprachendaten == null || sprachendaten.belegungen == null || sprache == null || "".equals(sprache)) {
            return null;
        }
        @NotNull List<@NotNull Sprachbelegung> belegungen = sprachendaten.belegungen;
        for (Sprachbelegung belegung : belegungen) {
            if (!sprache.equals(belegung.sprache)) continue;
            return belegung;
        }
        return null;
    }

    public static boolean istFortfuehrbareSpracheInGOSt(Sprachendaten sprachendaten, String sprache) {
        if (sprachendaten == null || sprache == null || "".equals(sprache)) {
            return false;
        }
        if (SprachendatenUtils.hatSprachbelegungMitMin2JahrenDauerEndeSekI(sprachendaten, sprache)) {
            return true;
        }
        @NotNull List<@NotNull Sprachpruefung> pruefungen = sprachendaten.pruefungen;
        if (pruefungen != null) {
            for (Sprachpruefung pruefung : pruefungen) {
                if (!sprache.equals(pruefung.sprache) && !sprache.equals(pruefung.ersetzteSprache)) continue;
                if (pruefung.istHSUPruefung && pruefung.note != null && pruefung.note <= 4 && (pruefung.anspruchsniveauId == Sprachpruefungniveau.EESA.daten.id || pruefung.anspruchsniveauId == Sprachpruefungniveau.MSA.daten.id)) {
                    return true;
                }
                if (!SprachendatenUtils.istFeststellungspruefungEESAMSABestanden(pruefung)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean istNeueinsetzbareSpracheInGOSt(Sprachendaten sprachendaten, String sprache) {
        if (sprachendaten == null || sprache == null || "".equals(sprache)) {
            return false;
        }
        if (SprachendatenUtils.hatSprachbelegungMitMin2JahrenDauerEndeSekI(sprachendaten, sprache)) {
            return false;
        }
        @NotNull List<@NotNull Sprachpruefung> pruefungen = sprachendaten.pruefungen;
        if (pruefungen != null) {
            for (Sprachpruefung pruefung : pruefungen) {
                if (!sprache.equals(pruefung.sprache) && !sprache.equals(pruefung.ersetzteSprache) || !SprachendatenUtils.istFeststellungspruefungEESAMSABestanden(pruefung)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static @NotNull List<@NotNull String> getFortfuehrbareSprachenInGOSt(Sprachendaten sprachendaten) {
        @NotNull ArrayList<@NotNull String> sprachen = new ArrayList<String>();
        if (sprachendaten != null) {
            List<Sprachpruefung> pruefungen;
            @NotNull List<@NotNull Sprachbelegung> belegungen = sprachendaten.belegungen;
            if (belegungen != null && !belegungen.isEmpty()) {
                for (Sprachbelegung belegung : belegungen) {
                    if (!SprachendatenUtils.istFortfuehrbareSpracheInGOSt(sprachendaten, belegung.sprache)) continue;
                    sprachen.add(belegung.sprache);
                }
            }
            if ((pruefungen = sprachendaten.pruefungen) != null && !pruefungen.isEmpty()) {
                for (Sprachpruefung pruefung : pruefungen) {
                    if (!SprachendatenUtils.istFortfuehrbareSpracheInGOSt(sprachendaten, pruefung.sprache)) continue;
                    sprachen.add(pruefung.sprache);
                }
            }
        }
        return sprachen;
    }

    public static boolean hatEineSpracheAb5bis7MitMin4JahrenDauerEndeSekI(Sprachendaten sprachendaten) {
        if (sprachendaten == null) {
            return false;
        }
        int anzahlSprachen = SprachendatenUtils.getSprachlegungenNachBeginnUndDauerEndeSekI(sprachendaten, "05", "07", 4).size();
        if (anzahlSprachen >= 1) {
            return true;
        }
        @NotNull List<@NotNull Sprachpruefung> pruefungen = sprachendaten.pruefungen;
        if (pruefungen != null) {
            for (Sprachpruefung pruefung : pruefungen) {
                if (!SprachendatenUtils.kannFeststellungspruefungErsteSpracheErsetzen(pruefung) && !SprachendatenUtils.kannFeststellungspruefungZweiteSpracheErsetzen(pruefung)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hatZweiSprachenAb5Bis7MitMin4JahrenDauerEndeSekI(Sprachendaten sprachendaten) {
        List<Sprachpruefung> pruefungen;
        if (sprachendaten == null) {
            return false;
        }
        @NotNull List<@NotNull Sprachbelegung> belegungen = SprachendatenUtils.getSprachlegungenNachBeginnUndDauerEndeSekI(sprachendaten, "05", "07", 4);
        int anzahlSprachen = belegungen.size();
        if (anzahlSprachen >= 2) {
            return true;
        }
        if (anzahlSprachen == 1 && (pruefungen = sprachendaten.pruefungen) != null) {
            for (Sprachpruefung pruefung : pruefungen) {
                if (!SprachendatenUtils.kannFeststellungspruefungErsteSpracheErsetzen(pruefung) && !SprachendatenUtils.kannFeststellungspruefungZweiteSpracheErsetzen(pruefung) || belegungen.get((int)0).sprache.equals(pruefung.sprache)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hatEineSpracheAb8MitMin2JahrenDauerEndeSekI(Sprachendaten sprachendaten) {
        if (sprachendaten == null) {
            return false;
        }
        int anzahlSprachen = SprachendatenUtils.getSprachlegungenNachBeginnUndDauerEndeSekI(sprachendaten, "08", "10", 2).size();
        return anzahlSprachen >= 1;
    }

    public static String getEineSpracheAb8MitMin2JahrenDauerEndeSekI(Sprachendaten sprachendaten) {
        List<Sprachbelegung> sprachbelegungen;
        if (sprachendaten == null) {
            return null;
        }
        @NotNull List<@NotNull Sprachbelegung> belegungen = sprachendaten.belegungen;
        if (belegungen != null && !(sprachbelegungen = SprachendatenUtils.getSprachlegungenNachBeginnUndDauerEndeSekI(sprachendaten, "08", "10", 2)).isEmpty()) {
            return sprachbelegungen.get((int)0).sprache;
        }
        return null;
    }

    public static boolean hatSprachfeststellungspruefungAufEFNiveau(Sprachendaten sprachendaten) {
        if (sprachendaten == null) {
            return false;
        }
        @NotNull List<@NotNull Sprachpruefung> pruefungen = sprachendaten.pruefungen;
        if (pruefungen != null) {
            for (Sprachpruefung pruefungS1 : pruefungen) {
                if (!SprachendatenUtils.kannFeststellungspruefungErsteSpracheErsetzen(pruefungS1) && !SprachendatenUtils.kannFeststellungspruefungZweiteSpracheErsetzen(pruefungS1)) continue;
                for (Sprachpruefung pruefungEF : pruefungen) {
                    if (!pruefungEF.istFeststellungspruefung || !pruefungEF.sprache.equals(pruefungS1.sprache) || !pruefungEF.kannErstePflichtfremdspracheErsetzen && !pruefungEF.kannZweitePflichtfremdspracheErsetzen && !pruefungEF.kannWahlpflichtfremdspracheErsetzen || pruefungEF.anspruchsniveauId != Sprachpruefungniveau.EF.daten.id || pruefungEF.note == null || pruefungEF.note > 4) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getErsteSpracheInSekI(Sprachendaten sprachendaten) {
        List<Sprachbelegung> sprachbelegungen;
        List<Sprachbelegung> belegungen;
        if (sprachendaten == null) {
            return null;
        }
        @NotNull List<@NotNull Sprachpruefung> pruefungen = sprachendaten.pruefungen;
        if (pruefungen != null) {
            for (Sprachpruefung pruefung : pruefungen) {
                if (!SprachendatenUtils.kannFeststellungspruefungErsteSpracheErsetzen(pruefung)) continue;
                return pruefung.sprache;
            }
        }
        if ((belegungen = sprachendaten.belegungen) != null && !(sprachbelegungen = SprachendatenUtils.getSprachlegungenNachBeginnUndDauerEndeSekI(sprachendaten, "05", "10", 0)).isEmpty()) {
            return sprachbelegungen.get((int)0).sprache;
        }
        return null;
    }

    public static String getZweiteSpracheInSekI(Sprachendaten sprachendaten) {
        if (sprachendaten == null) {
            return null;
        }
        String pruefungErsteSprache = "";
        String pruefungZweiteSprache = "";
        @NotNull List<@NotNull Sprachpruefung> pruefungen = sprachendaten.pruefungen;
        if (pruefungen != null) {
            for (Sprachpruefung pruefung : pruefungen) {
                if (SprachendatenUtils.kannFeststellungspruefungErsteSpracheErsetzen(pruefung)) {
                    pruefungErsteSprache = pruefung.sprache;
                }
                if (!SprachendatenUtils.kannFeststellungspruefungZweiteSpracheErsetzen(pruefung)) continue;
                pruefungZweiteSprache = pruefung.sprache;
            }
        }
        if (!"".equals(pruefungZweiteSprache)) {
            return pruefungZweiteSprache;
        }
        @NotNull List<@NotNull Sprachbelegung> belegungen = sprachendaten.belegungen;
        if (belegungen != null) {
            @NotNull List<@NotNull Sprachbelegung> sprachbelegungen = SprachendatenUtils.getSprachlegungenNachBeginnUndDauerEndeSekI(sprachendaten, "05", "10", 0);
            if (!"".equals(pruefungErsteSprache)) {
                for (Sprachbelegung sprachbelegung : sprachbelegungen) {
                    if (sprachbelegung.sprache.equals(pruefungErsteSprache)) continue;
                    return sprachbelegung.sprache;
                }
            } else if (sprachbelegungen.size() > 1) {
                return sprachbelegungen.get((int)1).sprache;
            }
        }
        return null;
    }

    private static boolean hatSprachbelegungMitMinNJahrenEndeSekI(Sprachendaten sprachendaten, String sprache, int n) {
        if (sprachendaten == null || sprachendaten.belegungen == null || sprache == null || "".equals(sprache)) {
            return false;
        }
        Sprachbelegung belegung = SprachendatenUtils.getSprachbelegung(sprachendaten, sprache);
        if (belegung == null) {
            return false;
        }
        if (belegung.belegungBisJahrgang != null && (SprachendatenUtils.getJahrgangNumerisch(belegung.belegungBisJahrgang) <= 8 || (SprachendatenUtils.getJahrgangNumerisch(belegung.belegungBisJahrgang) == 9 || SprachendatenUtils.getJahrgangNumerisch(belegung.belegungBisJahrgang) == 10) && belegung.belegungBisAbschnitt != null && belegung.belegungBisAbschnitt == 1)) {
            return false;
        }
        if (belegung.belegungVonJahrgang != null) {
            int belegtVonJahrgangNumerisch = SprachendatenUtils.getJahrgangNumerisch(belegung.belegungVonJahrgang);
            int belegtBisJahrgangNumerisch = SprachendatenUtils.getJahrgangNumerisch(belegung.belegungBisJahrgang);
            int letzterJahrgangSekI = 10;
            if (0 < belegtVonJahrgangNumerisch && belegtVonJahrgangNumerisch <= 10) {
                if (belegtBisJahrgangNumerisch == 0 || belegtBisJahrgangNumerisch > letzterJahrgangSekI) {
                    belegtBisJahrgangNumerisch = letzterJahrgangSekI;
                }
                return belegtBisJahrgangNumerisch - belegtVonJahrgangNumerisch + 1 >= n;
            }
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static @NotNull List<@NotNull Sprachbelegung> getSprachlegungenNachBeginnUndDauerEndeSekI(Sprachendaten sprachendaten, String belegungsbeginnStart, String belegungsbeginnEnde, Integer mindestBelegdauer) {
        @NotNull ArrayList<@NotNull Sprachbelegung> resultBelegungen = new ArrayList<Sprachbelegung>();
        if (sprachendaten == null || sprachendaten.belegungen == null || belegungsbeginnStart == null || "".equals(belegungsbeginnStart) || belegungsbeginnEnde == null || "".equals(belegungsbeginnEnde) || mindestBelegdauer == null || mindestBelegdauer < 0) {
            return resultBelegungen;
        }
        @NotNull List<@NotNull Sprachbelegung> alleBelegungen = sprachendaten.belegungen;
        for (Sprachbelegung belegung : alleBelegungen) {
            if (belegung.sprache == null || belegung.belegungVonJahrgang == null || belegung.belegungBisJahrgang != null && (SprachendatenUtils.getJahrgangNumerisch(belegung.belegungBisJahrgang) <= 8 || (SprachendatenUtils.getJahrgangNumerisch(belegung.belegungBisJahrgang) == 9 || SprachendatenUtils.getJahrgangNumerisch(belegung.belegungBisJahrgang) == 10) && belegung.belegungBisAbschnitt != null && belegung.belegungBisAbschnitt == 1)) continue;
            int belegtVonJahrgangNumerisch = SprachendatenUtils.getJahrgangNumerisch(belegung.belegungVonJahrgang);
            int belegtBisJahrgangNumerisch = SprachendatenUtils.getJahrgangNumerisch(belegung.belegungBisJahrgang);
            int letzterJahrgangSekI = 10;
            if (belegtBisJahrgangNumerisch == 0 || belegtBisJahrgangNumerisch > letzterJahrgangSekI) {
                belegtBisJahrgangNumerisch = letzterJahrgangSekI;
            }
            if (belegtBisJahrgangNumerisch - belegtVonJahrgangNumerisch + 1 < mindestBelegdauer || belegtVonJahrgangNumerisch <= 0 || SprachendatenUtils.getJahrgangNumerisch(belegungsbeginnStart) > belegtVonJahrgangNumerisch || belegtVonJahrgangNumerisch > SprachendatenUtils.getJahrgangNumerisch(belegungsbeginnEnde)) continue;
            resultBelegungen.add(belegung);
        }
        if (!resultBelegungen.isEmpty()) {
            @NotNull Comparator comparator = (a, b) -> Integer.compare(SprachendatenUtils.getJahrgangNumerisch(a.belegungVonJahrgang), SprachendatenUtils.getJahrgangNumerisch(b.belegungVonJahrgang));
            resultBelegungen.sort(comparator);
        }
        return resultBelegungen;
    }

    private static boolean kannFeststellungspruefungErsteSpracheErsetzen(Sprachpruefung pruefung) {
        return pruefung != null && pruefung.istFeststellungspruefung && pruefung.note != null && pruefung.note <= 4 && pruefung.kannErstePflichtfremdspracheErsetzen && (pruefung.anspruchsniveauId == Sprachpruefungniveau.EESA.daten.id || pruefung.anspruchsniveauId == Sprachpruefungniveau.MSA.daten.id);
    }

    private static boolean kannFeststellungspruefungZweiteSpracheErsetzen(Sprachpruefung pruefung) {
        return !(pruefung == null || !pruefung.istFeststellungspruefung || pruefung.note == null || pruefung.note > 4 || !pruefung.kannZweitePflichtfremdspracheErsetzen && !pruefung.kannWahlpflichtfremdspracheErsetzen || pruefung.anspruchsniveauId != Sprachpruefungniveau.EESA.daten.id && pruefung.anspruchsniveauId != Sprachpruefungniveau.MSA.daten.id);
    }

    private static boolean istFeststellungspruefungEESAMSABestanden(Sprachpruefung pruefung) {
        return pruefung != null && pruefung.istFeststellungspruefung && pruefung.note != null && pruefung.note <= 4 && (pruefung.kannBelegungAlsFortgefuehrteSpracheErlauben && pruefung.anspruchsniveauId == Sprachpruefungniveau.MSA.daten.id || (pruefung.kannErstePflichtfremdspracheErsetzen || pruefung.kannZweitePflichtfremdspracheErsetzen || pruefung.kannWahlpflichtfremdspracheErsetzen) && (pruefung.anspruchsniveauId == Sprachpruefungniveau.EESA.daten.id || pruefung.anspruchsniveauId == Sprachpruefungniveau.MSA.daten.id));
    }

    private static int getJahrgangNumerisch(String kuerzelJg) {
        if (kuerzelJg == null || "".equals(kuerzelJg)) {
            return 0;
        }
        switch (kuerzelJg) {
            case "EF": {
                return 11;
            }
            case "Q1": {
                return 12;
            }
            case "Q2": {
                return 13;
            }
        }
        try {
            return Integer.parseInt(kuerzelJg);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

