/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.schule;

import de.svws_nrw.core.data.schule.AbgangsartKatalog;
import de.svws_nrw.core.data.schule.AbgangsartKatalogDaten;
import de.svws_nrw.core.data.schule.AbgangsartKatalogEintrag;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import de.svws_nrw.core.types.schule.SchulabschlussBerufsbildend;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AbgangsartenManager {
    @NotNull
    private final AbgangsartKatalog _katalogAllgemein;
    @NotNull
    private final AbgangsartKatalog _katalogBeruf;
    private final long _version;
    @NotNull
    private final @NotNull ArrayList<@NotNull AbgangsartKatalogEintrag> _alle = new ArrayList();
    @NotNull
    private final @NotNull HashMap<@NotNull String, @NotNull AbgangsartKatalogEintrag> _mapByKuerzel = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull AbgangsartKatalogEintrag> _mapByID = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull AbgangsartKatalogDaten> _mapDatenByID = new HashMap();

    public AbgangsartenManager(@NotNull AbgangsartKatalog katalogAllgemein, @NotNull AbgangsartKatalog katalogBeruf) {
        this._katalogAllgemein = katalogAllgemein;
        this._katalogBeruf = katalogBeruf;
        this._version = katalogAllgemein.version + katalogBeruf.version;
        this._alle.addAll(katalogAllgemein.eintraege);
        this._alle.addAll(katalogBeruf.eintraege);
        for (AbgangsartKatalogEintrag eintrag : this._alle) {
            this._mapByKuerzel.put(eintrag.kuerzel, eintrag);
            for (AbgangsartKatalogDaten daten : eintrag.historie) {
                AbgangsartKatalogEintrag alt = this._mapByID.put(daten.id, eintrag);
                if (alt != null) {
                    throw new DeveloperNotificationException("Fehlerhafter Katalog: Doppelte ID '" + daten.id + "' bei den Abgangsarten '" + eintrag.kuerzel + "' und '" + alt.kuerzel + "'");
                }
                this._mapDatenByID.put(daten.id, daten);
            }
        }
    }

    public long getVersion() {
        return this._version;
    }

    public AbgangsartKatalogEintrag get(@NotNull String kuerzel) {
        return this._mapByKuerzel.get(kuerzel);
    }

    public List<AbgangsartKatalogEintrag> getAll() {
        return this._alle;
    }

    public AbgangsartKatalogDaten getDaten(@NotNull String kuerzel, int schuljahr) {
        AbgangsartKatalogEintrag eintrag = this._mapByKuerzel.get(kuerzel);
        if (eintrag == null) {
            return null;
        }
        for (AbgangsartKatalogDaten daten : eintrag.historie) {
            if (daten.gueltigVon != null && daten.gueltigVon > schuljahr || daten.gueltigBis != null && daten.gueltigBis < schuljahr) continue;
            return daten;
        }
        return null;
    }

    public AbgangsartKatalogDaten getDaten(long id) {
        return this._mapDatenByID.get(id);
    }

    public String getKuerzel(long id) {
        AbgangsartKatalogEintrag eintrag = this._mapByID.get(id);
        return eintrag == null ? null : eintrag.kuerzel;
    }

    @NotNull
    public AbgangsartKatalog getKatalogAllgemeinbildend() {
        return this._katalogAllgemein;
    }

    @NotNull
    public AbgangsartKatalog getKatalogBerufsbildend() {
        return this._katalogBeruf;
    }

    public static SchulabschlussAllgemeinbildend getAbschlussAllgemeinbildend(@NotNull AbgangsartKatalogEintrag abschlussart) {
        if (abschlussart.kuerzel.length() < 0 || abschlussart.kuerzel.length() > 2) {
            throw new DeveloperNotificationException("Fehlerhafter Katalog-Eintrag: Das K\u00fcrzel einer Abgangsart muss entweder ein- oder zweistelig sein.");
        }
        @NotNull String kuerzelAbschluss = abschlussart.kuerzel.length() == 1 ? abschlussart.kuerzel : abschlussart.kuerzel.substring(1, 2);
        return SchulabschlussAllgemeinbildend.getByKuerzelStatistik(kuerzelAbschluss);
    }

    public static SchulabschlussBerufsbildend getAbschlussBerufsbildend(@NotNull AbgangsartKatalogEintrag abschlussart) {
        if (abschlussart.kuerzel.length() < 0 || abschlussart.kuerzel.length() > 2) {
            throw new DeveloperNotificationException("Fehlerhafter Katalog-Eintrag: Das K\u00fcrzel einer Abgangsart muss entweder ein- oder zweistelig sein.");
        }
        if (abschlussart.kuerzel.length() == 1) {
            return null;
        }
        return SchulabschlussBerufsbildend.getByKuerzelStatistik(abschlussart.kuerzel.substring(0, 1));
    }
}

