/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.schule;

import de.svws_nrw.core.adt.map.HashMap3D;
import de.svws_nrw.core.data.bk.BKBildungsplan;
import de.svws_nrw.core.data.bk.BKBildungsplanKatalog;
import de.svws_nrw.core.data.bk.BKBildungsplanKatalogEintrag;
import de.svws_nrw.core.data.bk.BKFBFach;
import de.svws_nrw.core.data.bk.BKFachklassenSchluessel;
import de.svws_nrw.core.data.bk.BKLernfeld;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.exceptions.UserNotificationException;
import de.svws_nrw.core.types.schule.Schulgliederung;
import de.svws_nrw.core.utils.Map3DUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BerufskollegBildungsplanManager {
    @NotNull
    private final BKBildungsplanKatalog _katalog;
    private final long _version;
    @NotNull
    private final @NotNull ArrayList<@NotNull BKBildungsplan> _values = new ArrayList();
    @NotNull
    private final @NotNull HashMap<@NotNull String, @NotNull BKFBFach> _mapFachByKuerzel = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull BKBildungsplan> _mapByID = new HashMap();
    @NotNull
    private final @NotNull HashMap3D<@NotNull Integer, @NotNull String, @NotNull Long, @NotNull List<@NotNull BKBildungsplan>> _mapBildungsplanByFachklasse = new HashMap3D();
    @NotNull
    private final @NotNull HashMap3D<@NotNull Integer, @NotNull String, @NotNull String, @NotNull HashSet<@NotNull BKFBFach>> _mapFachByFachklasse = new HashMap3D();

    public BerufskollegBildungsplanManager(@NotNull BKBildungsplanKatalog katalog) {
        this._katalog = katalog;
        this._version = katalog.version;
        for (BKBildungsplanKatalogEintrag eintrag : katalog.lehrplaene) {
            this._values.addAll(eintrag.historie);
            for (BKBildungsplan bildungsplan : eintrag.historie) {
                if (bildungsplan.fachklasse.index != eintrag.index || bildungsplan.fachklasse.schluessel != eintrag.schluessel) {
                    throw new DeveloperNotificationException("Fehlerhafter Katalog: Fachklasse in Historie mit ID '" + bildungsplan.id + "' ungleich Fachklasse des Bildungsplans");
                }
                BKBildungsplan alt = this._mapByID.put(bildungsplan.id, bildungsplan);
                if (alt != null) {
                    throw new DeveloperNotificationException("Fehlerhafter Katalog: Doppelte ID '" + bildungsplan.id);
                }
                Map3DUtils.getOrCreateArrayList(this._mapBildungsplanByFachklasse, eintrag.index, eintrag.schluessel, bildungsplan.id).add(bildungsplan);
                for (BKFBFach fach : bildungsplan.fbFaecher) {
                    this._mapFachByKuerzel.put(fach.kuerzel, fach);
                    Map3DUtils.getOrCreateHashSet(this._mapFachByFachklasse, eintrag.index, eintrag.schluessel, fach.kuerzel).add(fach);
                }
            }
        }
    }

    public long getVersion() {
        return this._version;
    }

    public BKBildungsplan[] values() {
        return this._values.toArray(new BKBildungsplan[0]);
    }

    public BKBildungsplan[] getLehrplaeneBySchuljahr(int schuljahr) {
        @NotNull ArrayList<@NotNull BKBildungsplan> lehrplaene = new ArrayList<BKBildungsplan>();
        for (BKBildungsplan bildungsplan : this._values) {
            if (bildungsplan.gueltigVon != null && bildungsplan.gueltigVon > schuljahr || bildungsplan.gueltigBis != null && bildungsplan.gueltigBis < schuljahr) continue;
            lehrplaene.add(bildungsplan);
        }
        return lehrplaene.toArray(new BKBildungsplan[0]);
    }

    public BKBildungsplan[] getLehrplaeneByIndexSchuljahr(@NotNull Integer index, int schuljahr) {
        @NotNull ArrayList<@NotNull BKBildungsplan> lehrplaene = new ArrayList<BKBildungsplan>();
        @NotNull List<@NotNull List<@NotNull BKBildungsplan>> lehrplaeneOfIndex = this._mapBildungsplanByFachklasse.getNonNullValuesOfMap2AsList(index);
        for (List<BKBildungsplan> list : lehrplaeneOfIndex) {
            for (BKBildungsplan bildungsplan : list) {
                if (bildungsplan.gueltigVon != null && bildungsplan.gueltigVon > schuljahr || bildungsplan.gueltigBis != null && bildungsplan.gueltigBis < schuljahr) continue;
                lehrplaene.add(bildungsplan);
            }
        }
        return lehrplaene.toArray(new BKBildungsplan[0]);
    }

    public BKBildungsplan[] getLehrplaeneBySchulgliederungSchuljahr(@NotNull Schulgliederung gliederung, int schuljahr) {
        if (gliederung.daten.bkIndex == null) {
            throw new IllegalArgumentException("Die Schulgliederung " + gliederung.daten.kuerzel + " hat keinen Schulgliederungs-Index.");
        }
        return this.getLehrplaeneByIndexSchuljahr(gliederung.daten.bkIndex, schuljahr);
    }

    public BKBildungsplan[] getLehrplaeneByIndexSchuljahrAll(@NotNull Integer index, int schuljahr) {
        @NotNull ArrayList<@NotNull BKBildungsplan> lehrplaene = new ArrayList<BKBildungsplan>();
        @NotNull List<@NotNull List<@NotNull BKBildungsplan>> lehrplaeneOfIndex = this._mapBildungsplanByFachklasse.getNonNullValuesOfMap2AsList(index);
        for (List<BKBildungsplan> list : lehrplaeneOfIndex) {
            for (BKBildungsplan bildungsplan : list) {
                if (bildungsplan.gueltigVon != null && bildungsplan.gueltigVon > schuljahr || bildungsplan.gueltigBis != null && bildungsplan.gueltigBis + bildungsplan.dauer / 2 + 1 < schuljahr) continue;
                lehrplaene.add(bildungsplan);
            }
        }
        return lehrplaene.toArray(new BKBildungsplan[0]);
    }

    public BKBildungsplan[] getLehrplaeneBySchulgliederungSchuljahrAll(@NotNull Schulgliederung gliederung, int schuljahr) {
        if (gliederung.daten.bkIndex == null) {
            throw new IllegalArgumentException("Die Schulgliederung " + gliederung.daten.kuerzel + " hat keinen Schulgliederungs-Index.");
        }
        return this.getLehrplaeneByIndexSchuljahrAll(gliederung.daten.bkIndex, schuljahr);
    }

    public BKBildungsplan getBildungsplanById(long id) {
        return this._mapByID.get(id);
    }

    public BKBildungsplan getBildungsplanByFachklassenschluesselSchuljahr(@NotNull BKFachklassenSchluessel schluessel, int schuljahr) {
        return this.getBildungsplanByIndexFachklasseSchuljahr(schluessel.index, schluessel.schluessel, schuljahr);
    }

    public BKBildungsplan getBildungsplanByIndexFachklasseSchuljahr(@NotNull Integer index, @NotNull String schluessel, int schuljahr) {
        Map<@NotNull Long, @NotNull List<@NotNull BKBildungsplan>> mapById = this._mapBildungsplanByFachklasse.getMap3OrNull(index, schluessel);
        if (mapById == null) {
            return null;
        }
        for (List<BKBildungsplan> lehrplaene : mapById.values()) {
            for (BKBildungsplan bildungsplan : lehrplaene) {
                if (bildungsplan.gueltigVon != null && bildungsplan.gueltigVon > schuljahr || bildungsplan.gueltigBis != null && bildungsplan.gueltigBis < schuljahr) continue;
                return bildungsplan;
            }
        }
        return null;
    }

    public BKBildungsplan getBildungsplanByFachklassenschluesselSchuljahrJahrgang(@NotNull BKFachklassenSchluessel schluessel, int schuljahr, int jahrgang) {
        return this.getBildungsplanByIndexFachklasseSchuljahrJahrgang(schluessel.index, schluessel.schluessel, schuljahr, jahrgang);
    }

    public BKBildungsplan getBildungsplanByIndexFachklasseSchuljahrJahrgang(@NotNull Integer index, @NotNull String schluessel, int schuljahr, int jahrgang) {
        BKBildungsplan bildungsplan = this.getBildungsplanByIndexFachklasseSchuljahr(index, schluessel, schuljahr - jahrgang);
        if (bildungsplan == null) {
            return null;
        }
        if ((bildungsplan.dauer + 1) / 2 < jahrgang) {
            throw new UserNotificationException("Fehlerhafter Jahrgang: Der Jahrgang " + jahrgang + " ist zu gro\u00df f\u00fcr den Bildungsgang mit einer Dauer von " + bildungsplan.dauer + " Monaten!");
        }
        return bildungsplan;
    }

    public BKFBFach[] getFaecherByFachklassenschuesselSchuljahr() {
        return this._mapFachByKuerzel.values().toArray(new BKFBFach[0]);
    }

    public BKFBFach getFachByKuerzel(@NotNull String kuerzel) {
        return this._mapFachByKuerzel.get(kuerzel);
    }

    public BKFBFach[] getFaecherByFachklassenschuesselSchuljahr(@NotNull BKFachklassenSchluessel schluessel, int schuljahr) {
        return this.getFaecherByIndexFachklasseSchuljahr(schluessel.index, schluessel.schluessel, schuljahr);
    }

    public BKFBFach[] getFaecherByIndexFachklasseSchuljahr(@NotNull Integer index, @NotNull String schluessel, int schuljahr) {
        Map<@NotNull Long, @NotNull List<@NotNull BKBildungsplan>> mapById = this._mapBildungsplanByFachklasse.getMap3OrNull(index, schluessel);
        if (mapById == null) {
            return null;
        }
        for (List<BKBildungsplan> lehrplaene : mapById.values()) {
            for (BKBildungsplan bildungsplan : lehrplaene) {
                if (bildungsplan.gueltigVon != null && bildungsplan.gueltigVon > schuljahr || bildungsplan.gueltigBis != null && bildungsplan.gueltigBis < schuljahr) continue;
                return bildungsplan.fbFaecher.toArray(new BKFBFach[0]);
            }
        }
        return null;
    }

    public BKFBFach[] getFaecherByFachklassenschluesselSchuljahrJahrgang(@NotNull BKFachklassenSchluessel schluessel, int schuljahr, int jahrgang) {
        return this.getFaecherByIndexFachklasseSchuljahrJahrgang(schluessel.index, schluessel.schluessel, schuljahr, jahrgang);
    }

    public BKFBFach[] getFaecherByIndexFachklasseSchuljahrJahrgang(@NotNull Integer index, @NotNull String schluessel, int schuljahr, int jahrgang) {
        BKBildungsplan bildungsplan = this.getBildungsplanByIndexFachklasseSchuljahrJahrgang(index, schluessel, schuljahr, jahrgang);
        if (bildungsplan == null) {
            return null;
        }
        return bildungsplan.fbFaecher.toArray(new BKFBFach[0]);
    }

    public BKLernfeld[] getLernfelderByFachklassenschluesselSchuljahr(@NotNull BKFachklassenSchluessel schluessel, int schuljahr) {
        return this.getLernfelderByIndexFachklasseSchuljahr(schluessel.index, schluessel.schluessel, schuljahr);
    }

    public BKLernfeld[] getLernfelderByIndexFachklasseSchuljahr(@NotNull Integer index, @NotNull String schluessel, int schuljahr) {
        Map<@NotNull Long, @NotNull List<@NotNull BKBildungsplan>> mapById = this._mapBildungsplanByFachklasse.getMap3OrNull(index, schluessel);
        if (mapById == null) {
            return null;
        }
        for (List<BKBildungsplan> lehrplaene : mapById.values()) {
            for (BKBildungsplan bildungsplan : lehrplaene) {
                if (bildungsplan.gueltigVon != null && bildungsplan.gueltigVon > schuljahr || bildungsplan.gueltigBis != null && bildungsplan.gueltigBis < schuljahr) continue;
                return bildungsplan.lernfelder.toArray(new BKLernfeld[0]);
            }
        }
        return null;
    }

    public BKLernfeld[] getLernfelderByFachklassenschluesselSchuljahrJahrgang(@NotNull BKFachklassenSchluessel schluessel, int schuljahr, int jahrgang) {
        return this.getLernfelderByIndexFachklasseSchuljahrJahrgang(schluessel.index, schluessel.schluessel, schuljahr, jahrgang);
    }

    public BKLernfeld[] getLernfelderByIndexFachklasseSchuljahrJahrgang(@NotNull Integer index, @NotNull String schluessel, int schuljahr, int jahrgang) {
        BKBildungsplan bildungsplan = this.getBildungsplanByIndexFachklasseSchuljahrJahrgang(index, schluessel, schuljahr, jahrgang);
        if (bildungsplan == null) {
            return null;
        }
        return bildungsplan.lernfelder.toArray(new BKLernfeld[0]);
    }

    @NotNull
    public BKBildungsplanKatalog getKatalog() {
        return this._katalog;
    }
}

