/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.schule;

import de.svws_nrw.core.data.schule.BerufskollegFachklassenKatalog;
import de.svws_nrw.core.data.schule.BerufskollegFachklassenKatalogDaten;
import de.svws_nrw.core.data.schule.BerufskollegFachklassenKatalogEintrag;
import de.svws_nrw.core.data.schule.BerufskollegFachklassenKatalogIndex;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.schule.Schulgliederung;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;

public class BerufskollegFachklassenManager {
    @NotNull
    private final BerufskollegFachklassenKatalog _katalog;
    private final long _version;
    @NotNull
    private final @NotNull ArrayList<@NotNull BerufskollegFachklassenKatalogEintrag> _values = new ArrayList();
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, @NotNull BerufskollegFachklassenKatalogIndex> _mapByIndex = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull BerufskollegFachklassenKatalogEintrag, @NotNull Integer> _mapIndexByEintrag = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull String, @NotNull BerufskollegFachklassenKatalogEintrag> _mapByKuerzel = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull BerufskollegFachklassenKatalogEintrag> _mapByID = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull BerufskollegFachklassenKatalogDaten> _mapDatenByID = new HashMap();

    public BerufskollegFachklassenManager(@NotNull BerufskollegFachklassenKatalog katalog) {
        this._katalog = katalog;
        this._version = katalog.version;
        for (BerufskollegFachklassenKatalogIndex katIndex : katalog.indizes) {
            this._values.addAll(katIndex.fachklassen);
            this._mapByIndex.put(katIndex.index, katIndex);
            for (BerufskollegFachklassenKatalogEintrag eintrag : katIndex.fachklassen) {
                this._mapIndexByEintrag.put(eintrag, katIndex.index);
                String kuerzel = katIndex.index + "-" + eintrag.schluessel + "-" + eintrag.schluessel2;
                this._mapByKuerzel.put(kuerzel, eintrag);
                for (BerufskollegFachklassenKatalogDaten daten : eintrag.historie) {
                    BerufskollegFachklassenKatalogEintrag alt = this._mapByID.put(daten.id, eintrag);
                    if (alt != null) {
                        throw new DeveloperNotificationException("Fehlerhafter Katalog: Doppelte ID '" + daten.id + "' bei der Fachklasse '" + kuerzel + "'");
                    }
                    this._mapDatenByID.put(daten.id, daten);
                }
            }
        }
    }

    public long getVersion() {
        return this._version;
    }

    public long getVersion(int index) {
        BerufskollegFachklassenKatalogIndex katIndex = this._mapByIndex.get(index);
        if (katIndex == null) {
            throw new IllegalArgumentException("Ung\u00fcltiger Fachklassen-Index.");
        }
        return katIndex.version;
    }

    public long getVersion(Schulgliederung gliederung) {
        if (gliederung.daten.bkIndex == null) {
            throw new IllegalArgumentException("Die Schulgliederung " + gliederung.daten.kuerzel + " hat keinen Fachklassen-Index.");
        }
        BerufskollegFachklassenKatalogIndex katIndex = this._mapByIndex.get(gliederung.daten.bkIndex);
        if (katIndex == null) {
            throw new IllegalArgumentException("Keine Fachklassen f\u00fcr den Fachklassen-Index " + gliederung.daten.bkIndex + " der Schulgliederung " + gliederung.daten.kuerzel + " bekannt.");
        }
        return katIndex.version;
    }

    public BerufskollegFachklassenKatalogEintrag get(@NotNull String kuerzel) {
        return this._mapByKuerzel.get(kuerzel);
    }

    public BerufskollegFachklassenKatalogEintrag[] values() {
        return this._values.toArray(new BerufskollegFachklassenKatalogEintrag[0]);
    }

    public BerufskollegFachklassenKatalogDaten getDaten(@NotNull String kuerzel, int schuljahr) {
        BerufskollegFachklassenKatalogEintrag eintrag = this._mapByKuerzel.get(kuerzel);
        if (eintrag == null) {
            return null;
        }
        for (BerufskollegFachklassenKatalogDaten daten : eintrag.historie) {
            if (daten.gueltigVon != null && daten.gueltigVon > schuljahr || daten.gueltigBis != null && daten.gueltigBis < schuljahr) continue;
            return daten;
        }
        return null;
    }

    public BerufskollegFachklassenKatalogDaten getDaten(long id) {
        return this._mapDatenByID.get(id);
    }

    public String getKuerzel(long id) {
        BerufskollegFachklassenKatalogEintrag eintrag = this._mapByID.get(id);
        Integer index = this._mapIndexByEintrag.get(eintrag);
        return eintrag == null || index == null ? null : index + "-" + eintrag.schluessel + "-" + eintrag.schluessel2;
    }

    @NotNull
    public BerufskollegFachklassenKatalogIndex getTeilKatalog(int index) {
        BerufskollegFachklassenKatalogIndex katIndex = this._mapByIndex.get(index);
        if (katIndex == null) {
            throw new IllegalArgumentException("Ung\u00fcltiger Fachklassen-Index.");
        }
        return katIndex;
    }

    @NotNull
    public BerufskollegFachklassenKatalogIndex getTeilKatalog(Schulgliederung gliederung) {
        if (gliederung.daten.bkIndex == null) {
            throw new IllegalArgumentException("Die Schulgliederung " + gliederung.daten.kuerzel + " hat keinen Fachklassen-Index.");
        }
        BerufskollegFachklassenKatalogIndex katIndex = this._mapByIndex.get(gliederung.daten.bkIndex);
        if (katIndex == null) {
            throw new IllegalArgumentException("Keine Fachklassen f\u00fcr den Fachklassen-Index " + gliederung.daten.bkIndex + " der Schulgliederung " + gliederung.daten.kuerzel + " bekannt.");
        }
        return katIndex;
    }

    @NotNull
    public BerufskollegFachklassenKatalog getKatalog() {
        return this._katalog;
    }
}

