/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.schule;

import de.svws_nrw.core.data.schule.Schuljahresabschnitt;
import jakarta.validation.constraints.NotNull;

public class SchuljahresAbschnittsManager {
    @NotNull
    private final Schuljahresabschnitt abschnitt;
    private final int anzahlAbschnitte;

    public SchuljahresAbschnittsManager(@NotNull Schuljahresabschnitt schuljahresabschnitt, int anzahlAbschnitte) {
        this.abschnitt = schuljahresabschnitt;
        this.anzahlAbschnitte = anzahlAbschnitte;
    }

    @NotNull
    public String getSchuljahresAbschnittAsString() {
        return SchuljahresAbschnittsManager.createSchuljahresAbschnittString(this.abschnitt, this.anzahlAbschnitte);
    }

    @NotNull
    public static String createSchuljahresAbschnittString(@NotNull Schuljahresabschnitt abschnitt, int anzahlAbschnitte) {
        if (anzahlAbschnitte <= 1) {
            return "" + abschnitt.schuljahr;
        }
        if (anzahlAbschnitte > 1 && anzahlAbschnitte < 5) {
            return SchuljahresAbschnittsManager.createRepresentationForAnzahlAbschnitte(anzahlAbschnitte) + abschnitt.abschnitt + " " + abschnitt.schuljahr;
        }
        return abschnitt.abschnitt + "/" + anzahlAbschnitte + " " + abschnitt.schuljahr;
    }

    @NotNull
    public String getRepresentationForAnzahlAbschnitte() {
        return SchuljahresAbschnittsManager.createRepresentationForAnzahlAbschnitte(this.anzahlAbschnitte);
    }

    @NotNull
    public static String createRepresentationForAnzahlAbschnitte(int anzahlAbschnitte) {
        if (anzahlAbschnitte == 2) {
            return "S";
        }
        if (anzahlAbschnitte == 3) {
            return "T";
        }
        if (anzahlAbschnitte == 4) {
            return "Q";
        }
        return "";
    }
}

