/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.stundenplan;

import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.adt.set.AVLSet;
import de.svws_nrw.core.data.stundenplan.Stundenplan;
import de.svws_nrw.core.data.stundenplan.StundenplanAufsichtsbereich;
import de.svws_nrw.core.data.stundenplan.StundenplanFach;
import de.svws_nrw.core.data.stundenplan.StundenplanJahrgang;
import de.svws_nrw.core.data.stundenplan.StundenplanKalenderwochenzuordnung;
import de.svws_nrw.core.data.stundenplan.StundenplanKlasse;
import de.svws_nrw.core.data.stundenplan.StundenplanKlassenunterricht;
import de.svws_nrw.core.data.stundenplan.StundenplanKomplett;
import de.svws_nrw.core.data.stundenplan.StundenplanKurs;
import de.svws_nrw.core.data.stundenplan.StundenplanLehrer;
import de.svws_nrw.core.data.stundenplan.StundenplanPausenaufsicht;
import de.svws_nrw.core.data.stundenplan.StundenplanPausenzeit;
import de.svws_nrw.core.data.stundenplan.StundenplanRaum;
import de.svws_nrw.core.data.stundenplan.StundenplanSchiene;
import de.svws_nrw.core.data.stundenplan.StundenplanSchueler;
import de.svws_nrw.core.data.stundenplan.StundenplanUnterricht;
import de.svws_nrw.core.data.stundenplan.StundenplanUnterrichtsverteilung;
import de.svws_nrw.core.data.stundenplan.StundenplanZeitraster;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.Wochentag;
import de.svws_nrw.core.utils.BlockungsUtils;
import de.svws_nrw.core.utils.CollectionUtils;
import de.svws_nrw.core.utils.DateUtils;
import de.svws_nrw.core.utils.ListUtils;
import de.svws_nrw.core.utils.Map2DUtils;
import de.svws_nrw.core.utils.MapUtils;
import de.svws_nrw.core.utils.StringUtils;
import jakarta.validation.constraints.NotNull;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class StundenplanManager {
    public static final int FAKTOR_WOCHENSTUNDEN_ZU_MINUTEN = 45;
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanAufsichtsbereich> _compAufsichtsbereich = (a, b) -> {
        int result = a.kuerzel.compareTo(b.kuerzel);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanFach> _compFach = (a, b) -> {
        if (a.sortierung < b.sortierung) {
            return -1;
        }
        if (a.sortierung > b.sortierung) {
            return 1;
        }
        int result = a.kuerzel.compareTo(b.kuerzel);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanJahrgang> _compJahrgang = (a, b) -> {
        int result = a.kuerzel.compareTo(b.kuerzel);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanKalenderwochenzuordnung> _compKWZ = (a, b) -> {
        if (a.jahr < b.jahr) {
            return -1;
        }
        if (a.jahr > b.jahr) {
            return 1;
        }
        if (a.kw < b.kw) {
            return -1;
        }
        if (a.kw > b.kw) {
            return 1;
        }
        if (a.wochentyp < b.wochentyp) {
            return -1;
        }
        if (a.wochentyp > b.wochentyp) {
            return 1;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanKlasse> _compKlasse = (a, b) -> {
        int result = a.kuerzel.compareTo(b.kuerzel);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private final @NotNull Comparator<@NotNull StundenplanKlassenunterricht> _compKlassenunterricht;
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanKurs> _compKurs = (a, b) -> {
        if (a.sortierung < b.sortierung) {
            return -1;
        }
        if (a.sortierung > b.sortierung) {
            return 1;
        }
        int result = a.bezeichnung.compareTo(b.bezeichnung);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanLehrer> _compLehrer = (a, b) -> {
        int result = a.kuerzel.compareTo(b.kuerzel);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanPausenaufsicht> _compPausenaufsicht = (a, b) -> Long.compare(a.id, b.id);
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanPausenzeit> _compPausenzeit = (a, b) -> {
        int beginnB;
        if (a.wochentag < b.wochentag) {
            return -1;
        }
        if (a.wochentag > b.wochentag) {
            return 1;
        }
        int beginnA = a.beginn == null ? -1 : a.beginn;
        int n = beginnB = b.beginn == null ? -1 : b.beginn;
        if (beginnA < beginnB) {
            return -1;
        }
        if (beginnA > beginnB) {
            return 1;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanRaum> _compRaum = (a, b) -> {
        int result = a.kuerzel.compareTo(b.kuerzel);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanSchiene> _compSchiene = (a, b) -> {
        if (a.idJahrgang < b.idJahrgang) {
            return -1;
        }
        if (a.idJahrgang > b.idJahrgang) {
            return 1;
        }
        if (a.nummer < b.nummer) {
            return -1;
        }
        if (a.nummer > b.nummer) {
            return 1;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanSchueler> _compSchueler = (a, b) -> {
        if (a.idKlasse < b.idKlasse) {
            return -1;
        }
        if (a.idKlasse > b.idKlasse) {
            return 1;
        }
        int cmpNachname = a.nachname.compareTo(b.nachname);
        if (cmpNachname != 0) {
            return cmpNachname;
        }
        int cmpVorname = a.vorname.compareTo(b.vorname);
        if (cmpVorname != 0) {
            return cmpVorname;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private final @NotNull Comparator<@NotNull StundenplanUnterricht> _compUnterricht;
    @NotNull
    private static final @NotNull Comparator<@NotNull StundenplanZeitraster> _compZeitraster = (a, b) -> {
        if (a.wochentag < b.wochentag) {
            return -1;
        }
        if (a.wochentag > b.wochentag) {
            return 1;
        }
        if (a.unterrichtstunde < b.unterrichtstunde) {
            return -1;
        }
        if (a.unterrichtstunde > b.unterrichtstunde) {
            return 1;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanAufsichtsbereich> _aufsichtsbereich_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanAufsichtsbereich> _aufsichtsbereichmenge_sortiert = new ArrayList<StundenplanAufsichtsbereich>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanFach> _fach_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanFach> _fachmenge_sortiert = new ArrayList<StundenplanFach>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanJahrgang> _jahrgang_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanJahrgang> _jahrgangmenge_sortiert = new ArrayList<StundenplanJahrgang>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanJahrgang>> _jahrgangmenge_by_idKurs = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanJahrgang>> _jahrgangmenge_by_idKlasse = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanKalenderwochenzuordnung> _kwz_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanKalenderwochenzuordnung> _kwzmenge_sortiert = new ArrayList<StundenplanKalenderwochenzuordnung>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Integer, @NotNull Integer, @NotNull StundenplanKalenderwochenzuordnung> _kwz_by_jahr_and_kw = new HashMap2D();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanKlasse> _klasse_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanKlasse> _klassenmenge_sortiert = new ArrayList<StundenplanKlasse>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlasse>> _klassenmenge_by_idKurs = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlasse>> _klassenmenge_by_idJahrgang = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlasse>> _klassenmenge_by_idSchueler = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlasse>> _klassenmenge_by_idPausenzeit = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlasse>> _klassenmenge_by_idUnterricht = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull StundenplanKlassenunterricht> _klassenunterricht_by_idKlasse_and_idFach = new HashMap2D();
    @NotNull
    private final @NotNull List<@NotNull StundenplanKlassenunterricht> _klassenunterrichtmenge = new ArrayList<StundenplanKlassenunterricht>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlassenunterricht>> _klassenunterrichtmenge_by_idKlasse = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanKlassenunterricht>> _klassenunterrichtmenge_by_idKlasse_and_idSchiene = new HashMap2D();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlassenunterricht>> _klassenunterrichtmenge_by_idSchueler = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlassenunterricht>> _klassenunterrichtmenge_by_idLehrer = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKlassenunterricht>> _klassenunterrichtmenge_by_idSchiene = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanKurs> _kurs_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanKurs> _kursmenge = new ArrayList<StundenplanKurs>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKurs>> _kursmenge_by_idSchueler = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKurs>> _kursmenge_by_idSchiene = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKurs>> _kursmenge_by_idLehrer = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKurs>> _kursmenge_by_idKlasse = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanKurs>> _kursmenge_by_idKlasse_and_idSchiene = new HashMap2D();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanKurs>> _kursmenge_by_idJahrgang = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanLehrer> _lehrer_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanLehrer> _lehrermenge_sortiert = new ArrayList<StundenplanLehrer>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanLehrer>> _lehrermenge_by_idUnterricht = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanPausenaufsicht> _pausenaufsicht_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanPausenaufsicht> _pausenaufsichtmenge = new ArrayList<StundenplanPausenaufsicht>();
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, @NotNull List<@NotNull StundenplanPausenaufsicht>> _pausenaufsichtmenge_by_wochentag = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanPausenaufsicht>> _pausenaufsichtmenge_by_idPausenzeit = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanPausenaufsicht>> _pausenaufsichtmenge_by_idLehrer = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanPausenaufsicht>> _pausenaufsichtmenge_by_idAufsichtsbereich = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanPausenaufsicht>> _pausenaufsichtmenge_by_idKlasse_and_idPausenzeit = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanPausenaufsicht>> _pausenaufsichtmenge_by_idLehrer_and_idPausenzeit = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanPausenaufsicht>> _pausenaufsichtmenge_by_idSchueler_and_idPausenzeit = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanPausenaufsicht>> _pausenaufsichtmenge_by_idJahrgang_and_idPausenzeit = new HashMap2D();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanPausenzeit> _pausenzeit_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanPausenzeit> _pausenzeitmenge = new ArrayList<StundenplanPausenzeit>();
    @NotNull
    private final @NotNull List<@NotNull StundenplanPausenzeit> _pausenzeitmengeOhneLeere_sortiert = new ArrayList<StundenplanPausenzeit>();
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_wochentag = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_idKlasse = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_idSchueler = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_idLehrer = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_idJahrgang = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_idKlasse_and_wochentag = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_idLehrer_and_wochentag = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_idSchueler_and_wochentag = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull StundenplanPausenzeit>> _pausenzeitmenge_by_idJahrgang_and_wochentag = new HashMap2D();
    private Integer _pausenzeitMinutenMin = null;
    private Integer _pausenzeitMinutenMax = null;
    private Integer _pausenzeitMinutenMinOhneLeere = null;
    private Integer _pausenzeitMinutenMaxOhneLeere = null;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanRaum> _raum_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanRaum> _raummenge_sortiert = new ArrayList<StundenplanRaum>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanSchiene> _schiene_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanSchiene> _schienenmenge = new ArrayList<StundenplanSchiene>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanSchiene>> _schienenmenge_by_idJahrgang = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanSchiene>> _schienenmenge_by_idUnterricht = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanSchiene>> _schienenmenge_by_idKlasse = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanSchueler> _schueler_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanSchueler> _schuelermenge = new ArrayList<StundenplanSchueler>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanSchueler>> _schuelermenge_by_idKlasse = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanSchueler>> _schuelermenge_by_idKurs = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanUnterricht> _unterricht_by_id = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull StundenplanUnterricht> _unterrichtmenge = new ArrayList<StundenplanUnterricht>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idKlasse = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idRaum = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idLehrer = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idSchueler = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idSchiene = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idKurs = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idZeitraster = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idJahrgang = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idUnterricht = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idKlasse_and_idZeitraster = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idRaum_and_idZeitraster = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idSchueler_and_idZeitraster = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idLehrer_and_idZeitraster = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idJahrgang_and_idZeitraster = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idKlasse_and_idFach = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull StundenplanUnterricht>> _unterrichtmenge_by_idZeitraster_and_wochentyp = new HashMap2D();
    private boolean _unterrichtHatMultiWochen = false;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull StundenplanZeitraster> _zeitraster_by_id = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Integer, @NotNull Integer, @NotNull StundenplanZeitraster> _zeitraster_by_wochentag_and_stunde = new HashMap2D();
    @NotNull
    private final @NotNull List<@NotNull StundenplanZeitraster> _zeitrastermenge = new ArrayList<StundenplanZeitraster>();
    @NotNull
    private final @NotNull List<@NotNull StundenplanZeitraster> _zeitrastermengeOhneLeere_sortiert = new ArrayList<StundenplanZeitraster>();
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, @NotNull List<@NotNull StundenplanZeitraster>> _zeitrastermenge_by_wochentag = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, @NotNull List<@NotNull StundenplanZeitraster>> _zeitrastermenge_by_stunde = new HashMap();
    private Integer _zeitrasterMinutenMin = null;
    private Integer _zeitrasterMinutenMax = null;
    private Integer _zeitrasterMinutenMinOhneLeere = null;
    private Integer _zeitrasterMinutenMaxOhneLeere = null;
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, Integer> _zeitrasterMinutenMinByStunde = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Integer, Integer> _zeitrasterMinutenMaxByStunde = new HashMap();
    private int _zeitrasterWochentagMin;
    private int _zeitrasterWochentagMax;
    @NotNull
    private @NotNull Wochentag @NotNull [] _zeitrasterWochentageAlsEnumRange;
    private int _zeitrasterStundeMin;
    private int _zeitrasterStundeMax;
    @NotNull
    private @NotNull int @NotNull [] _zeitrasterStundenRange;
    private int _zeitrasterStundeMinOhneLeere;
    private int _zeitrasterStundeMaxOhneLeere;
    @NotNull
    private @NotNull int @NotNull [] _zeitrasterStundenRangeOhneLeere;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull Double> _wertWochenminuten_by_idKurs;
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull Double> _wertWochenminuten_by_idKlasse_und_idFach;
    private final long _stundenplanID;
    private final int _stundenplanWochenTypModell;
    private final long _stundenplanSchuljahresAbschnittID;
    @NotNull
    private final String _stundenplanGueltigAb;
    @NotNull
    private final String _stundenplanGueltigBis;
    @NotNull
    private final String _stundenplanBezeichnung;

    public StundenplanManager(@NotNull Stundenplan daten, @NotNull @NotNull List<@NotNull StundenplanUnterricht> unterrichte, @NotNull @NotNull List<@NotNull StundenplanPausenaufsicht> pausenaufsichten, StundenplanUnterrichtsverteilung unterrichtsverteilung) {
        this._zeitrasterWochentagMin = Wochentag.MONTAG.id;
        this._zeitrasterWochentagMax = Wochentag.MONTAG.id;
        this._zeitrasterWochentageAlsEnumRange = new Wochentag[]{Wochentag.MONTAG};
        this._zeitrasterStundeMin = 1;
        this._zeitrasterStundeMax = 1;
        this._zeitrasterStundenRange = new int[]{1};
        this._zeitrasterStundeMinOhneLeere = 1;
        this._zeitrasterStundeMaxOhneLeere = 1;
        this._zeitrasterStundenRangeOhneLeere = new int[]{1};
        this._wertWochenminuten_by_idKurs = new HashMap();
        this._wertWochenminuten_by_idKlasse_und_idFach = new HashMap2D();
        this._compKlassenunterricht = this.klassenunterrichtCreateComparator();
        this._compUnterricht = this.unterrichtCreateComparator();
        this._stundenplanID = daten.id;
        this._stundenplanWochenTypModell = daten.wochenTypModell;
        this._stundenplanSchuljahresAbschnittID = daten.idSchuljahresabschnitt;
        this._stundenplanGueltigAb = daten.gueltigAb;
        this._stundenplanGueltigBis = StundenplanManager.init_gueltig_bis(daten.gueltigAb, daten.gueltigBis);
        this._stundenplanBezeichnung = daten.bezeichnungStundenplan;
        StundenplanUnterrichtsverteilung uv = unterrichtsverteilung;
        if (uv == null) {
            uv = new StundenplanUnterrichtsverteilung();
            uv.id = this._stundenplanID;
        }
        DeveloperNotificationException.ifTrue("Stundenplan.id != StundenplanUnterrichtsverteilung.id", daten.id != uv.id);
        this.initAll(daten.kalenderwochenZuordnung, uv.faecher, daten.jahrgaenge, daten.zeitraster, daten.raeume, daten.pausenzeiten, daten.aufsichtsbereiche, uv.lehrer, uv.schueler, daten.schienen, uv.klassen, uv.klassenunterricht, pausenaufsichten, uv.kurse, unterrichte);
    }

    public StundenplanManager(@NotNull StundenplanKomplett stundenplanKomplett) {
        this._zeitrasterWochentagMin = Wochentag.MONTAG.id;
        this._zeitrasterWochentagMax = Wochentag.MONTAG.id;
        this._zeitrasterWochentageAlsEnumRange = new Wochentag[]{Wochentag.MONTAG};
        this._zeitrasterStundeMin = 1;
        this._zeitrasterStundeMax = 1;
        this._zeitrasterStundenRange = new int[]{1};
        this._zeitrasterStundeMinOhneLeere = 1;
        this._zeitrasterStundeMaxOhneLeere = 1;
        this._zeitrasterStundenRangeOhneLeere = new int[]{1};
        this._wertWochenminuten_by_idKurs = new HashMap();
        this._wertWochenminuten_by_idKlasse_und_idFach = new HashMap2D();
        this._compKlassenunterricht = this.klassenunterrichtCreateComparator();
        this._compUnterricht = this.unterrichtCreateComparator();
        this._stundenplanID = stundenplanKomplett.daten.id;
        this._stundenplanWochenTypModell = stundenplanKomplett.daten.wochenTypModell;
        this._stundenplanSchuljahresAbschnittID = stundenplanKomplett.daten.idSchuljahresabschnitt;
        this._stundenplanGueltigAb = stundenplanKomplett.daten.gueltigAb;
        this._stundenplanGueltigBis = StundenplanManager.init_gueltig_bis(stundenplanKomplett.daten.gueltigAb, stundenplanKomplett.daten.gueltigBis);
        this._stundenplanBezeichnung = stundenplanKomplett.daten.bezeichnungStundenplan;
        DeveloperNotificationException.ifTrue("Stundenplan.id != StundenplanUnterrichtsverteilung.id", stundenplanKomplett.daten.id != stundenplanKomplett.unterrichtsverteilung.id);
        this.initAll(stundenplanKomplett.daten.kalenderwochenZuordnung, stundenplanKomplett.unterrichtsverteilung.faecher, stundenplanKomplett.daten.jahrgaenge, stundenplanKomplett.daten.zeitraster, stundenplanKomplett.daten.raeume, stundenplanKomplett.daten.pausenzeiten, stundenplanKomplett.daten.aufsichtsbereiche, stundenplanKomplett.unterrichtsverteilung.lehrer, stundenplanKomplett.unterrichtsverteilung.schueler, stundenplanKomplett.daten.schienen, stundenplanKomplett.unterrichtsverteilung.klassen, stundenplanKomplett.unterrichtsverteilung.klassenunterricht, stundenplanKomplett.pausenaufsichten, stundenplanKomplett.unterrichtsverteilung.kurse, stundenplanKomplett.unterrichte);
    }

    @NotNull
    private static String init_gueltig_bis(@NotNull String gueltigAb, String gueltigBis) {
        @NotNull int[] infoVon = DateUtils.extractFromDateISO8601(gueltigAb);
        if (gueltigBis != null) {
            try {
                DateUtils.extractFromDateISO8601(gueltigBis);
                return gueltigBis;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int jahrAb = infoVon[0];
        int monatAb = infoVon[1];
        return (monatAb <= 7 ? jahrAb : jahrAb + 1) + "-07-31";
    }

    private void initAll(@NotNull @NotNull List<@NotNull StundenplanKalenderwochenzuordnung> listKWZ, @NotNull @NotNull List<@NotNull StundenplanFach> listFach, @NotNull @NotNull List<@NotNull StundenplanJahrgang> listJahrgang, @NotNull @NotNull List<@NotNull StundenplanZeitraster> listZeitraster, @NotNull @NotNull List<@NotNull StundenplanRaum> listRaum, @NotNull @NotNull List<@NotNull StundenplanPausenzeit> listPausenzeit, @NotNull @NotNull List<@NotNull StundenplanAufsichtsbereich> listAufsichtsbereich, @NotNull @NotNull List<@NotNull StundenplanLehrer> listLehrer, @NotNull @NotNull List<@NotNull StundenplanSchueler> listSchueler, @NotNull @NotNull List<@NotNull StundenplanSchiene> listSchiene, @NotNull @NotNull List<@NotNull StundenplanKlasse> listKlasse, @NotNull @NotNull List<@NotNull StundenplanKlassenunterricht> listKlassenunterricht, @NotNull @NotNull List<@NotNull StundenplanPausenaufsicht> listPausenaufsicht, @NotNull @NotNull List<@NotNull StundenplanKurs> listKurs, @NotNull @NotNull List<@NotNull StundenplanUnterricht> listUnterricht) {
        DeveloperNotificationException.ifTrue("stundenplanWochenTypModell < 0", this._stundenplanWochenTypModell < 0);
        DeveloperNotificationException.ifTrue("stundenplanWochenTypModell == 1", this._stundenplanWochenTypModell == 1);
        this.kalenderwochenzuordnungAddAllOhneUpdate(listKWZ);
        this.fachAddAllOhneUpdate(listFach);
        this.jahrgangAddAllOhneUpdate(listJahrgang);
        this.zeitrasterAddAllOhneUpdate(listZeitraster);
        this.raumAddAllOhneUpdate(listRaum);
        this.pausenzeitAddAllOhneUpdate(listPausenzeit);
        this.aufsichtsbereichAddAllOhneUpdate(listAufsichtsbereich);
        this.lehrerAddAllOhneUpdate(listLehrer);
        this.schuelerAddAllOhneUpdate(listSchueler);
        this.klasseAddAllOhneUpdate(listKlasse);
        this.schieneAddAllOhneUpdate(listSchiene);
        this.klassenunterrichtAddAllOhneUpdate(listKlassenunterricht);
        this.pausenaufsichtAddAllOhneUpdate(listPausenaufsicht);
        this.kursAddAllOhneUpdate(listKurs);
        this.unterrichtAddAllOhneUpdate(listUnterricht);
        this.update_all();
    }

    private void update_all() {
        this.update_kwzmenge_update_kwz_by_jahr_and_kw();
        this.update_aufsichtsbereichmenge();
        this.update_fachmenge();
        this.update_jahrgangmenge();
        this.update_klassenmenge();
        this.update_klassenunterrichtmenge();
        this.update_kursmenge();
        this.update_lehrermenge();
        this.update_pausenaufsichtmenge();
        this.update_raummenge();
        this.update_schienenmenge();
        this.update_schuelermenge();
        this.update_pausenzeitmenge();
        this.update_unterrichtmenge();
        this.update_zeitrastermenge();
        this.update_pausenaufsichtmenge_by_idPausenzeit();
        this.update_pausenzeitmengeOhnePausenaufsicht();
        this.update_unterrichtmenge_by_idZeitraster();
        this.update_zeitrastermengeOhneLeereUnterrichtmenge();
        this.update_klassenmenge_by_idJahrgang();
        this.update_jahrgangmenge_by_idKlasse();
        this.update_klassenunterrichtmenge_by_idKlasse();
        this.update_klassenunterrichtmenge_by_idSchueler();
        this.update_klassenunterrichtmenge_by_idLehrer();
        this.update_klassenunterrichtmenge_by_idSchiene();
        this.update_kursmenge_by_idSchueler();
        this.update_kursmenge_by_idLehrer();
        this.update_kursmenge_by_idSchiene();
        this.update_schuelermenge_by_idKurs();
        this.update_kursmenge_by_idJahrgang();
        this.update_jahrgangmenge_by_idKurs();
        this.update_pausenaufsichtmenge_by_wochentag();
        this.update_pausenaufsichtmenge_by_idLehrer();
        this.update_pausenaufsichtmenge_by_idLehrer_and_idPausenzeit();
        this.update_pausenaufsichtmenge_by_idAufsichtsbereich();
        this.update_pausenzeitmenge_by_idLehrer();
        this.update_pausenzeitmenge_by_wochentag();
        this.update_klassenmenge_by_idPausenzeit();
        this.update_schienenmenge_by_idJahrgang();
        this.update_schuelermenge_by_idKlasse();
        this.update_klassenmenge_by_idSchueler();
        this.update_lehrermenge_by_idUnterricht();
        this.update_schienenmenge_by_idUnterricht();
        this.update_unterrichtmenge_by_idSchiene();
        this.update_unterrichtmenge_by_idKurs();
        this.update_unterrichtmenge_by_idKlasse_and_idFach();
        this.update_unterrichtmenge_by_idZeitraster_and_wochentyp();
        this.update_unterrichtmenge_by_idLehrer();
        this.update_unterrichtmenge_by_idLehrer_and_idZeitraster();
        this.update_unterrichtmenge_by_idRaum();
        this.update_unterrichtmenge_by_idRaum_and_idZeitraster();
        this.update_zeitraster_by_wochentag_and_stunde();
        this.update_zeitrastermenge_by_wochentag();
        this.update_zeitrastermenge_by_stunde();
        this.update_kursmenge_by_idKlasse();
        this.update_klassenmenge_by_idKurs();
        this.update_pausenzeitmenge_by_idLehrer_and_wochentag();
        this.update_pausenzeitmenge_by_idKlasse();
        this.update_pausenzeitmenge_by_idJahrgang();
        this.update_pausenzeitmenge_by_idSchueler();
        this.update_pausenaufsichtmenge_by_idKlasse_and_idPausenzeit();
        this.update_pausenaufsichtmenge_by_idJahrgang_and_idPausenzeit();
        this.update_pausenaufsichtmenge_by_idSchueler_and_idPausenzeit();
        this.update_unterrichtmenge_by_idJahrgang();
        this.update_unterrichtmenge_by_idSchueler();
        this.update_klassenunterrichtmenge_by_idKlasse_and_idSchiene();
        this.update_wertWochenminuten_by_idKurs();
        this.update_wertWochenminuten_by_idKlasse_und_idFach();
        this.update_unterrichtmenge_by_idUnterricht();
        this.update_pausenzeitmenge_by_idKlasse_and_wochentag();
        this.update_pausenzeitmenge_by_idJahrgang_and_wochentag();
        this.update_pausenzeitmenge_by_idSchueler_and_wochentag();
        this.update_unterrichtmenge_by_idKlasse();
        this.update_unterrichtmenge_by_idKlasse_and_idZeitraster();
        this.update_klassenmenge_by_idUnterricht();
        this.update_unterrichtmenge_by_idJahrgang_and_idZeitraster();
        this.update_unterrichtmenge_by_idSchueler_and_idZeitraster();
        this.update_schienenmenge_by_idKlasse();
        this.update_kursmenge_by_idKlasse_and_idSchiene();
    }

    private void update_unterrichtmenge_by_idUnterricht() {
        this._unterrichtmenge_by_idUnterricht.clear();
        for (List<StundenplanUnterricht> menge : this._unterrichtmenge_by_idKurs.values()) {
            for (StundenplanUnterricht u : menge) {
                DeveloperNotificationException.ifMapPutOverwrites(this._unterrichtmenge_by_idUnterricht, u.id, menge);
            }
        }
        for (List<StundenplanUnterricht> menge : this._unterrichtmenge_by_idKlasse_and_idFach.getNonNullValuesAsList()) {
            for (StundenplanUnterricht u : menge) {
                DeveloperNotificationException.ifMapPutOverwrites(this._unterrichtmenge_by_idUnterricht, u.id, menge);
            }
        }
    }

    private void update_wertWochenminuten_by_idKlasse_und_idFach() {
        this._wertWochenminuten_by_idKlasse_und_idFach.clear();
        double faktor = this._stundenplanWochenTypModell == 0 ? 1.0 : (double)this._stundenplanWochenTypModell;
        for (StundenplanKlasse klasse : this._klassenmenge_sortiert) {
            for (StundenplanFach fach : this._fachmenge_sortiert) {
                double summe_minuten = 0.0;
                for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idKlasse_and_idFach, klasse.id, fach.id)) {
                    @NotNull StundenplanZeitraster z = DeveloperNotificationException.ifMapGetIsNull(this._zeitraster_by_id, u.idZeitraster);
                    @NotNull Integer ende = DeveloperNotificationException.ifNull("z.stundenende", z.stundenende);
                    @NotNull Integer beginn = DeveloperNotificationException.ifNull("z.stundenbeginn", z.stundenbeginn);
                    int minuten = ende - beginn;
                    summe_minuten += u.wochentyp == 0 ? (double)minuten * faktor : (double)minuten;
                }
                double wochenminuten = summe_minuten / faktor;
                this._wertWochenminuten_by_idKlasse_und_idFach.put(klasse.id, fach.id, wochenminuten);
            }
        }
    }

    private void update_wertWochenminuten_by_idKurs() {
        this._wertWochenminuten_by_idKurs.clear();
        double faktor = this._stundenplanWochenTypModell == 0 ? 1.0 : (double)this._stundenplanWochenTypModell;
        for (StundenplanKurs kurs : this._kursmenge) {
            double summe_minuten = 0.0;
            for (StundenplanUnterricht u : MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idKurs, kurs.id)) {
                @NotNull StundenplanZeitraster z = DeveloperNotificationException.ifMapGetIsNull(this._zeitraster_by_id, u.idZeitraster);
                @NotNull Integer ende = DeveloperNotificationException.ifNull("z.stundenende", z.stundenende);
                @NotNull Integer beginn = DeveloperNotificationException.ifNull("z.stundenbeginn", z.stundenbeginn);
                int minuten = ende - beginn;
                summe_minuten += u.wochentyp == 0 ? (double)minuten * faktor : (double)minuten;
            }
            double wochenminuten = summe_minuten / faktor;
            this._wertWochenminuten_by_idKurs.put(kurs.id, wochenminuten);
        }
    }

    private void update_schienenmenge_by_idKlasse() {
        this._schienenmenge_by_idKlasse.clear();
        for (StundenplanKlasse klasse : this._klassenmenge_sortiert) {
            @NotNull HashSet<@NotNull Long> schienenIDs = new HashSet<Long>();
            for (StundenplanKurs kurs : MapUtils.getOrCreateArrayList(this._kursmenge_by_idKlasse, klasse.id)) {
                schienenIDs.addAll(kurs.schienen);
            }
            for (StundenplanKlassenunterricht klassenunterricht : MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idKlasse, klasse.id)) {
                schienenIDs.addAll(klassenunterricht.schienen);
            }
            for (Long idSchiene : schienenIDs) {
                @NotNull StundenplanSchiene schiene = DeveloperNotificationException.ifMapGetIsNull(this._schiene_by_id, idSchiene);
                MapUtils.addToList(this._schienenmenge_by_idKlasse, klasse.id, schiene);
            }
            MapUtils.getOrCreateArrayList(this._schienenmenge_by_idKlasse, klasse.id).sort(_compSchiene);
        }
    }

    private void update_kursmenge_by_idKlasse_and_idSchiene() {
        this._kursmenge_by_idKlasse_and_idSchiene.clear();
        for (Long idKlasse : this._kursmenge_by_idKlasse.keySet()) {
            for (StundenplanKurs kurs : MapUtils.getOrCreateArrayList(this._kursmenge_by_idKlasse, idKlasse)) {
                if (kurs.schienen.isEmpty()) {
                    Map2DUtils.addToList(this._kursmenge_by_idKlasse_and_idSchiene, idKlasse, -1L, kurs);
                    continue;
                }
                for (Long idSchiene : kurs.schienen) {
                    Map2DUtils.addToList(this._kursmenge_by_idKlasse_and_idSchiene, idKlasse, idSchiene, kurs);
                }
            }
        }
        for (Long idKlasse : this._kursmenge_by_idKlasse_and_idSchiene.getKeySet()) {
            for (Long idSchiene : this._kursmenge_by_idKlasse_and_idSchiene.getKeySetOf(idKlasse)) {
                this._kursmenge_by_idKlasse_and_idSchiene.getNonNullOrException(idKlasse, idSchiene).sort(_compKurs);
            }
        }
    }

    private void update_klassenunterrichtmenge_by_idKlasse_and_idSchiene() {
        this._klassenunterrichtmenge_by_idKlasse_and_idSchiene.clear();
        for (Long idKlasse : this._klassenunterrichtmenge_by_idKlasse.keySet()) {
            for (StundenplanKlassenunterricht klassenunterricht : MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idKlasse, idKlasse)) {
                if (klassenunterricht.schienen.isEmpty()) {
                    Map2DUtils.addToList(this._klassenunterrichtmenge_by_idKlasse_and_idSchiene, idKlasse, -1L, klassenunterricht);
                    continue;
                }
                for (Long idSchiene : klassenunterricht.schienen) {
                    Map2DUtils.addToList(this._klassenunterrichtmenge_by_idKlasse_and_idSchiene, idKlasse, idSchiene, klassenunterricht);
                }
            }
        }
        for (Long idKlasse : this._klassenunterrichtmenge_by_idKlasse_and_idSchiene.getKeySet()) {
            for (Long idSchiene : this._klassenunterrichtmenge_by_idKlasse_and_idSchiene.getKeySetOf(idKlasse)) {
                this._klassenunterrichtmenge_by_idKlasse_and_idSchiene.getNonNullOrException(idKlasse, idSchiene).sort(this._compKlassenunterricht);
            }
        }
    }

    private void update_schienenmenge_by_idUnterricht() {
        this._schienenmenge_by_idUnterricht.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            for (Long idSchiene : u.schienen) {
                @NotNull StundenplanSchiene schiene = DeveloperNotificationException.ifMapGetIsNull(this._schiene_by_id, idSchiene);
                MapUtils.addToList(this._schienenmenge_by_idUnterricht, u.id, schiene);
            }
            MapUtils.getOrCreateArrayList(this._schienenmenge_by_idUnterricht, u.id).sort(_compSchiene);
        }
    }

    private void update_klassenmenge_by_idPausenzeit() {
        this._klassenmenge_by_idPausenzeit.clear();
        for (StundenplanPausenzeit pausenzeit : this._pausenzeitmenge) {
            if (pausenzeit.klassen.isEmpty()) {
                MapUtils.getOrCreateArrayList(this._klassenmenge_by_idPausenzeit, pausenzeit.id).addAll(this._klassenmenge_sortiert);
                continue;
            }
            for (Long idKlasse : pausenzeit.klassen) {
                @NotNull StundenplanKlasse klasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, idKlasse);
                MapUtils.addToList(this._klassenmenge_by_idPausenzeit, pausenzeit.id, klasse);
            }
            MapUtils.getOrCreateArrayList(this._klassenmenge_by_idPausenzeit, pausenzeit.id).sort(_compKlasse);
        }
    }

    private void update_jahrgangmenge_by_idKlasse() {
        this._jahrgangmenge_by_idKlasse.clear();
        for (StundenplanKlasse klasse : this._klassenmenge_sortiert) {
            for (Long idJahrgang : klasse.jahrgaenge) {
                @NotNull StundenplanJahrgang jahrgang = DeveloperNotificationException.ifMapGetIsNull(this._jahrgang_by_id, idJahrgang);
                MapUtils.addToList(this._jahrgangmenge_by_idKlasse, klasse.id, jahrgang);
            }
        }
    }

    private void update_jahrgangmenge_by_idKurs() {
        this._jahrgangmenge_by_idKurs.clear();
        for (StundenplanKurs kurs : this._kursmenge) {
            for (Long idJahrgang : kurs.jahrgaenge) {
                @NotNull StundenplanJahrgang jahrgang = DeveloperNotificationException.ifMapGetIsNull(this._jahrgang_by_id, idJahrgang);
                MapUtils.addToList(this._jahrgangmenge_by_idKurs, kurs.id, jahrgang);
            }
            MapUtils.getOrCreateArrayList(this._jahrgangmenge_by_idKurs, kurs.id).sort(_compJahrgang);
        }
    }

    private void update_klassenunterrichtmenge_by_idSchiene() {
        this._klassenunterrichtmenge_by_idSchiene.clear();
        for (StundenplanKlassenunterricht klassenunterricht : this._klassenunterrichtmenge) {
            for (Long idSchiene : klassenunterricht.schienen) {
                MapUtils.addToList(this._klassenunterrichtmenge_by_idSchiene, idSchiene, klassenunterricht);
            }
        }
    }

    private void update_kursmenge_by_idSchiene() {
        this._kursmenge_by_idSchiene.clear();
        for (StundenplanKurs kurs : this._kursmenge) {
            for (Long idSchiene : kurs.schienen) {
                MapUtils.addToList(this._kursmenge_by_idSchiene, idSchiene, kurs);
            }
        }
    }

    private void update_pausenaufsichtmenge_by_idAufsichtsbereich() {
        this._pausenaufsichtmenge_by_idAufsichtsbereich.clear();
        for (StundenplanPausenaufsicht aufsicht : this._pausenaufsichtmenge) {
            for (Long idAufsichtsbereich : aufsicht.bereiche) {
                MapUtils.addToList(this._pausenaufsichtmenge_by_idAufsichtsbereich, idAufsichtsbereich, aufsicht);
            }
        }
    }

    private void update_pausenaufsichtmenge() {
        this._pausenaufsichtmenge.clear();
        this._pausenaufsichtmenge.addAll(this._pausenaufsicht_by_id.values());
        this._pausenaufsichtmenge.sort(_compPausenaufsicht);
    }

    private void update_pausenaufsichtmenge_by_wochentag() {
        this._pausenaufsichtmenge_by_wochentag.clear();
        for (StundenplanPausenaufsicht aufsicht : this._pausenaufsichtmenge) {
            @NotNull StundenplanPausenzeit zeit = DeveloperNotificationException.ifMapGetIsNull(this._pausenzeit_by_id, aufsicht.idPausenzeit);
            MapUtils.addToList(this._pausenaufsichtmenge_by_wochentag, zeit.wochentag, aufsicht);
        }
    }

    private void update_pausenaufsichtmenge_by_idPausenzeit() {
        this._pausenaufsichtmenge_by_idPausenzeit.clear();
        for (StundenplanPausenaufsicht aufsicht : this._pausenaufsichtmenge) {
            MapUtils.addToList(this._pausenaufsichtmenge_by_idPausenzeit, aufsicht.idPausenzeit, aufsicht);
        }
    }

    private void update_pausenaufsichtmenge_by_idJahrgang_and_idPausenzeit() {
        this._pausenaufsichtmenge_by_idJahrgang_and_idPausenzeit.clear();
        for (StundenplanPausenaufsicht aufsicht : this._pausenaufsichtmenge) {
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idPausenzeit, aufsicht.idPausenzeit)) {
                for (StundenplanJahrgang jahrgang : MapUtils.getOrCreateArrayList(this._jahrgangmenge_by_idKlasse, klasse.id)) {
                    Map2DUtils.addToListIfNotExists(this._pausenaufsichtmenge_by_idJahrgang_and_idPausenzeit, jahrgang.id, aufsicht.idPausenzeit, aufsicht);
                }
            }
        }
    }

    private void update_pausenaufsichtmenge_by_idSchueler_and_idPausenzeit() {
        this._pausenaufsichtmenge_by_idSchueler_and_idPausenzeit.clear();
        for (StundenplanPausenaufsicht aufsicht : this._pausenaufsichtmenge) {
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idPausenzeit, aufsicht.idPausenzeit)) {
                for (StundenplanSchueler schueler : MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKlasse, klasse.id)) {
                    Map2DUtils.addToList(this._pausenaufsichtmenge_by_idSchueler_and_idPausenzeit, schueler.id, aufsicht.idPausenzeit, aufsicht);
                }
            }
        }
    }

    private void update_pausenaufsichtmenge_by_idKlasse_and_idPausenzeit() {
        this._pausenaufsichtmenge_by_idKlasse_and_idPausenzeit.clear();
        for (StundenplanPausenaufsicht aufsicht : this._pausenaufsichtmenge) {
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idPausenzeit, aufsicht.idPausenzeit)) {
                Map2DUtils.addToList(this._pausenaufsichtmenge_by_idKlasse_and_idPausenzeit, klasse.id, aufsicht.idPausenzeit, aufsicht);
            }
        }
    }

    private void update_pausenaufsichtmenge_by_idLehrer() {
        this._pausenaufsichtmenge_by_idLehrer.clear();
        for (StundenplanPausenaufsicht aufsicht : this._pausenaufsichtmenge) {
            if (aufsicht.idLehrer < 0L) continue;
            MapUtils.addToList(this._pausenaufsichtmenge_by_idLehrer, aufsicht.idLehrer, aufsicht);
        }
    }

    private void update_pausenaufsichtmenge_by_idLehrer_and_idPausenzeit() {
        this._pausenaufsichtmenge_by_idLehrer_and_idPausenzeit.clear();
        for (StundenplanPausenaufsicht aufsicht : this._pausenaufsichtmenge) {
            if (aufsicht.idLehrer < 0L) continue;
            Map2DUtils.addToList(this._pausenaufsichtmenge_by_idLehrer_and_idPausenzeit, aufsicht.idLehrer, aufsicht.idPausenzeit, aufsicht);
        }
    }

    private void update_klassenmenge_by_idSchueler() {
        this._klassenmenge_by_idSchueler.clear();
        for (StundenplanSchueler schueler : this._schuelermenge) {
            if (schueler.idKlasse < 0L) continue;
            @NotNull StundenplanKlasse klasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, schueler.idKlasse);
            MapUtils.addToList(this._klassenmenge_by_idSchueler, schueler.id, klasse);
        }
    }

    private void update_klassenmenge_by_idJahrgang() {
        this._klassenmenge_by_idJahrgang.clear();
        for (StundenplanKlasse klasse : this._klassenmenge_sortiert) {
            for (Long idJahrgang : klasse.jahrgaenge) {
                MapUtils.addToList(this._klassenmenge_by_idJahrgang, idJahrgang, klasse);
            }
        }
    }

    private void update_kursmenge_by_idJahrgang() {
        this._kursmenge_by_idJahrgang.clear();
        for (StundenplanKurs kurs : this._kursmenge) {
            for (Long idJahrgang : kurs.jahrgaenge) {
                MapUtils.addToList(this._kursmenge_by_idJahrgang, idJahrgang, kurs);
            }
        }
    }

    private void update_schienenmenge_by_idJahrgang() {
        this._schienenmenge_by_idJahrgang.clear();
        for (StundenplanSchiene schiene : this._schienenmenge) {
            MapUtils.addToList(this._schienenmenge_by_idJahrgang, schiene.idJahrgang, schiene);
        }
    }

    private void update_pausenzeitmenge() {
        this._pausenzeitmenge.clear();
        this._pausenzeitmenge.addAll(this._pausenzeit_by_id.values());
        this._pausenzeitmenge.sort(_compPausenzeit);
        this._pausenzeitMinutenMin = null;
        this._pausenzeitMinutenMax = null;
        for (StundenplanPausenzeit p : this._pausenzeitmenge) {
            this._pausenzeitMinutenMin = BlockungsUtils.minII(this._pausenzeitMinutenMin, p.beginn);
            this._pausenzeitMinutenMax = BlockungsUtils.maxII(this._pausenzeitMinutenMax, p.ende);
        }
    }

    private void update_pausenzeitmengeOhnePausenaufsicht() {
        this._pausenzeitmengeOhneLeere_sortiert.clear();
        for (StundenplanPausenzeit zeit : this._pausenzeitmenge) {
            if (MapUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idPausenzeit, zeit.id).isEmpty()) continue;
            this._pausenzeitmengeOhneLeere_sortiert.add(zeit);
        }
        this._pausenzeitMinutenMinOhneLeere = null;
        this._pausenzeitMinutenMaxOhneLeere = null;
        for (StundenplanPausenzeit zeit : this._pausenzeitmengeOhneLeere_sortiert) {
            this._pausenzeitMinutenMinOhneLeere = BlockungsUtils.minII(this._pausenzeitMinutenMinOhneLeere, zeit.beginn);
            this._pausenzeitMinutenMaxOhneLeere = BlockungsUtils.maxII(this._pausenzeitMinutenMaxOhneLeere, zeit.ende);
        }
    }

    private void update_pausenzeitmenge_by_wochentag() {
        this._pausenzeitmenge_by_wochentag.clear();
        for (StundenplanPausenzeit zeit : this._pausenzeitmenge) {
            MapUtils.addToList(this._pausenzeitmenge_by_wochentag, zeit.wochentag, zeit);
        }
    }

    private void update_pausenzeitmenge_by_idSchueler() {
        this._pausenzeitmenge_by_idSchueler.clear();
        for (StundenplanPausenzeit pausenzeit : this._pausenzeitmenge) {
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idPausenzeit, pausenzeit.id)) {
                for (StundenplanSchueler schueler : MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKlasse, klasse.id)) {
                    MapUtils.addToList(this._pausenzeitmenge_by_idSchueler, schueler.id, pausenzeit);
                }
            }
        }
    }

    private void update_pausenzeitmenge_by_idSchueler_and_wochentag() {
        this._pausenzeitmenge_by_idSchueler_and_wochentag.clear();
        for (Long idSchueler : this._pausenzeitmenge_by_idSchueler.keySet()) {
            for (StundenplanPausenzeit zeit : MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idSchueler, idSchueler)) {
                Map2DUtils.addToList(this._pausenzeitmenge_by_idSchueler_and_wochentag, idSchueler, zeit.wochentag, zeit);
            }
        }
    }

    private void update_pausenzeitmenge_by_idKlasse() {
        this._pausenzeitmenge_by_idKlasse.clear();
        for (StundenplanPausenzeit pausenzeit : this._pausenzeitmenge) {
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idPausenzeit, pausenzeit.id)) {
                MapUtils.addToList(this._pausenzeitmenge_by_idKlasse, klasse.id, pausenzeit);
            }
        }
    }

    private void update_pausenzeitmenge_by_idKlasse_and_wochentag() {
        this._pausenzeitmenge_by_idKlasse_and_wochentag.clear();
        for (Long idKlasse : this._pausenzeitmenge_by_idKlasse.keySet()) {
            for (StundenplanPausenzeit pausenzeit : MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idKlasse, idKlasse)) {
                Map2DUtils.addToList(this._pausenzeitmenge_by_idKlasse_and_wochentag, idKlasse, pausenzeit.wochentag, pausenzeit);
            }
        }
    }

    private void update_pausenzeitmenge_by_idLehrer() {
        this._pausenzeitmenge_by_idLehrer.clear();
        for (StundenplanPausenaufsicht pausenaufsicht : this._pausenaufsichtmenge) {
            if (pausenaufsicht.idLehrer < 0L) continue;
            @NotNull StundenplanPausenzeit pausenzeit = DeveloperNotificationException.ifMapGetIsNull(this._pausenzeit_by_id, pausenaufsicht.idPausenzeit);
            MapUtils.addToList(this._pausenzeitmenge_by_idLehrer, pausenaufsicht.idLehrer, pausenzeit);
        }
    }

    private void update_pausenzeitmenge_by_idLehrer_and_wochentag() {
        this._pausenzeitmenge_by_idLehrer_and_wochentag.clear();
        for (Long idLehrer : this._pausenzeitmenge_by_idLehrer.keySet()) {
            for (StundenplanPausenzeit pausenzeit : MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idLehrer, idLehrer)) {
                Map2DUtils.addToList(this._pausenzeitmenge_by_idLehrer_and_wochentag, idLehrer, pausenzeit.wochentag, pausenzeit);
            }
        }
    }

    private void update_pausenzeitmenge_by_idJahrgang_and_wochentag() {
        this._pausenzeitmenge_by_idJahrgang_and_wochentag.clear();
        for (Long idJahrgang : this._pausenzeitmenge_by_idJahrgang.keySet()) {
            for (StundenplanPausenzeit pausenzeit : MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idJahrgang, idJahrgang)) {
                Map2DUtils.addToList(this._pausenzeitmenge_by_idJahrgang_and_wochentag, idJahrgang, pausenzeit.wochentag, pausenzeit);
            }
        }
    }

    private void update_pausenzeitmenge_by_idJahrgang() {
        this._pausenzeitmenge_by_idJahrgang.clear();
        for (StundenplanPausenzeit pausenzeit : this._pausenzeitmenge) {
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idPausenzeit, pausenzeit.id)) {
                for (Long idJahrgang : klasse.jahrgaenge) {
                    MapUtils.addToListIfNotExists(this._pausenzeitmenge_by_idJahrgang, idJahrgang, pausenzeit);
                }
            }
        }
    }

    private void update_klassenmenge_by_idKurs() {
        this._klassenmenge_by_idKurs.clear();
        for (StundenplanKurs kurs : this._kursmenge) {
            for (StundenplanSchueler schueler : MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKurs, kurs.id)) {
                if (schueler.idKlasse < 0L) continue;
                @NotNull StundenplanKlasse klasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, schueler.idKlasse);
                MapUtils.addToListIfNotExists(this._klassenmenge_by_idKurs, kurs.id, klasse);
            }
            MapUtils.getOrCreateArrayList(this._klassenmenge_by_idKurs, kurs.id).sort(_compKlasse);
        }
    }

    private void update_aufsichtsbereichmenge() {
        this._aufsichtsbereichmenge_sortiert.clear();
        this._aufsichtsbereichmenge_sortiert.addAll(this._aufsichtsbereich_by_id.values());
        this._aufsichtsbereichmenge_sortiert.sort(_compAufsichtsbereich);
    }

    private void update_fachmenge() {
        this._fachmenge_sortiert.clear();
        this._fachmenge_sortiert.addAll(this._fach_by_id.values());
        this._fachmenge_sortiert.sort(_compFach);
    }

    private void update_jahrgangmenge() {
        this._jahrgangmenge_sortiert.clear();
        this._jahrgangmenge_sortiert.addAll(this._jahrgang_by_id.values());
        this._jahrgangmenge_sortiert.sort(_compJahrgang);
    }

    private void update_kwzmenge_update_kwz_by_jahr_and_kw() {
        this._kwzmenge_sortiert.clear();
        this._kwzmenge_sortiert.addAll(this._kwz_by_id.values());
        this._kwz_by_jahr_and_kw.clear();
        for (StundenplanKalenderwochenzuordnung kwz : this._kwzmenge_sortiert) {
            DeveloperNotificationException.ifMap2DPutOverwrites(this._kwz_by_jahr_and_kw, kwz.jahr, kwz.kw, kwz);
        }
        @NotNull int[] infoVon = DateUtils.extractFromDateISO8601(this._stundenplanGueltigAb);
        @NotNull int[] infoBis = DateUtils.extractFromDateISO8601(this._stundenplanGueltigBis);
        int jahrVon = infoVon[6];
        int jahrBis = infoBis[6];
        int kwVon = infoVon[5];
        int kwBis = infoBis[5];
        DeveloperNotificationException.ifTrue("Das Start-Datum '" + this._stundenplanGueltigAb + "' ist gr\u00f6\u00dfer als das End-Datum '" + this._stundenplanGueltigBis + "'!", jahrVon > jahrBis || jahrVon == jahrBis && kwVon > kwBis);
        for (int jahr = jahrVon; jahr <= jahrBis; ++jahr) {
            int von = jahr == jahrVon ? kwVon : 1;
            int bis = jahr == jahrBis ? kwBis : DateUtils.gibKalenderwochenOfJahr(jahr);
            for (int kw = von; kw <= bis; ++kw) {
                if (this._kwz_by_jahr_and_kw.contains(jahr, kw)) continue;
                @NotNull StundenplanKalenderwochenzuordnung kwz = new StundenplanKalenderwochenzuordnung();
                kwz.id = -1L;
                kwz.jahr = jahr;
                kwz.kw = kw;
                kwz.wochentyp = this.kalenderwochenzuordnungGetWochentypOrDefault(jahr, kw);
                DeveloperNotificationException.ifMap2DPutOverwrites(this._kwz_by_jahr_and_kw, kwz.jahr, kwz.kw, kwz);
                this._kwzmenge_sortiert.add(kwz);
            }
        }
        this._kwzmenge_sortiert.sort(_compKWZ);
    }

    private void update_klassenmenge() {
        this._klassenmenge_sortiert.clear();
        this._klassenmenge_sortiert.addAll(this._klasse_by_id.values());
        this._klassenmenge_sortiert.sort(_compKlasse);
    }

    private void update_klassenunterrichtmenge() {
        this._klassenunterrichtmenge.clear();
        this._klassenunterrichtmenge.addAll(this._klassenunterricht_by_idKlasse_and_idFach.getNonNullValuesAsList());
        this._klassenunterrichtmenge.sort(this._compKlassenunterricht);
    }

    private void update_klassenunterrichtmenge_by_idKlasse() {
        this._klassenunterrichtmenge_by_idKlasse.clear();
        for (StundenplanKlassenunterricht klassenunterricht : this._klassenunterrichtmenge) {
            MapUtils.addToList(this._klassenunterrichtmenge_by_idKlasse, klassenunterricht.idKlasse, klassenunterricht);
        }
    }

    private void update_klassenunterrichtmenge_by_idSchueler() {
        this._klassenunterrichtmenge_by_idSchueler.clear();
        for (StundenplanKlassenunterricht klassenunterricht : this._klassenunterrichtmenge) {
            for (Long idSchueler : klassenunterricht.schueler) {
                MapUtils.addToList(this._klassenunterrichtmenge_by_idSchueler, idSchueler, klassenunterricht);
            }
        }
    }

    private void update_klassenunterrichtmenge_by_idLehrer() {
        this._klassenunterrichtmenge_by_idLehrer.clear();
        for (StundenplanKlassenunterricht klassenunterricht : this._klassenunterrichtmenge) {
            for (Long idLehrer : klassenunterricht.lehrer) {
                MapUtils.addToList(this._klassenunterrichtmenge_by_idLehrer, idLehrer, klassenunterricht);
            }
        }
    }

    private void update_kursmenge() {
        this._kursmenge.clear();
        this._kursmenge.addAll(this._kurs_by_id.values());
        this._kursmenge.sort(_compKurs);
    }

    private void update_kursmenge_by_idSchueler() {
        this._kursmenge_by_idSchueler.clear();
        for (StundenplanKurs kurs : this._kursmenge) {
            for (Long idSchueler : kurs.schueler) {
                MapUtils.addToList(this._kursmenge_by_idSchueler, idSchueler, kurs);
            }
        }
    }

    private void update_kursmenge_by_idLehrer() {
        this._kursmenge_by_idLehrer.clear();
        for (StundenplanKurs kurs : this._kursmenge) {
            for (Long idLehrer : kurs.lehrer) {
                MapUtils.addToList(this._kursmenge_by_idLehrer, idLehrer, kurs);
            }
        }
    }

    private void update_kursmenge_by_idKlasse() {
        this._kursmenge_by_idKlasse.clear();
        for (StundenplanKurs kurs : this._kursmenge) {
            for (StundenplanSchueler schueler : MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKurs, kurs.id)) {
                if (schueler.idKlasse < 0L) continue;
                MapUtils.addToListIfNotExists(this._kursmenge_by_idKlasse, schueler.idKlasse, kurs);
            }
        }
    }

    private void update_lehrermenge() {
        this._lehrermenge_sortiert.clear();
        this._lehrermenge_sortiert.addAll(this._lehrer_by_id.values());
        this._lehrermenge_sortiert.sort(_compLehrer);
    }

    private void update_lehrermenge_by_idUnterricht() {
        this._lehrermenge_by_idUnterricht.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            for (Long idLehrer : u.lehrer) {
                @NotNull StundenplanLehrer lehrer = DeveloperNotificationException.ifMapGetIsNull(this._lehrer_by_id, idLehrer);
                MapUtils.addToList(this._lehrermenge_by_idUnterricht, u.id, lehrer);
            }
            MapUtils.getOrCreateArrayList(this._lehrermenge_by_idUnterricht, u.id).sort(_compLehrer);
        }
    }

    private void update_raummenge() {
        this._raummenge_sortiert.clear();
        this._raummenge_sortiert.addAll(this._raum_by_id.values());
        this._raummenge_sortiert.sort(_compRaum);
    }

    private void update_schienenmenge() {
        this._schienenmenge.clear();
        this._schienenmenge.addAll(this._schiene_by_id.values());
        this._schienenmenge.sort(_compSchiene);
    }

    private void update_schuelermenge() {
        this._schuelermenge.clear();
        this._schuelermenge.addAll(this._schueler_by_id.values());
        this._schuelermenge.sort(_compSchueler);
    }

    private void update_schuelermenge_by_idKlasse() {
        this._schuelermenge_by_idKlasse.clear();
        for (StundenplanSchueler schueler : this._schuelermenge) {
            if (schueler.idKlasse < 0L) continue;
            MapUtils.addToList(this._schuelermenge_by_idKlasse, schueler.idKlasse, schueler);
        }
    }

    private void update_schuelermenge_by_idKurs() {
        this._schuelermenge_by_idKurs.clear();
        for (StundenplanKurs kurs : this._kursmenge) {
            for (Long idSchueler : kurs.schueler) {
                @NotNull StundenplanSchueler schueler = DeveloperNotificationException.ifMapGetIsNull(this._schueler_by_id, idSchueler);
                MapUtils.addToList(this._schuelermenge_by_idKurs, kurs.id, schueler);
            }
            MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKurs, kurs.id).sort(_compSchueler);
        }
    }

    private void update_unterrichtmenge() {
        this._unterrichtmenge.clear();
        this._unterrichtmenge.addAll(this._unterricht_by_id.values());
        this._unterrichtmenge.sort(this._compUnterricht);
        this._unterrichtHatMultiWochen = false;
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            if (u.wochentyp <= 0) continue;
            this._unterrichtHatMultiWochen = true;
            break;
        }
    }

    private void update_unterrichtmenge_by_idLehrer() {
        this._unterrichtmenge_by_idLehrer.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            for (Long idLehrer : u.lehrer) {
                MapUtils.addToList(this._unterrichtmenge_by_idLehrer, idLehrer, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idLehrer_and_idZeitraster() {
        this._unterrichtmenge_by_idLehrer_and_idZeitraster.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            for (Long idLehrer : u.lehrer) {
                Map2DUtils.addToList(this._unterrichtmenge_by_idLehrer_and_idZeitraster, idLehrer, u.idZeitraster, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idKlasse() {
        this._unterrichtmenge_by_idKlasse.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            if (u.idKurs == null) {
                for (Long idKlasse : u.klassen) {
                    MapUtils.addToList(this._unterrichtmenge_by_idKlasse, idKlasse, u);
                }
                continue;
            }
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idKurs, u.idKurs)) {
                MapUtils.addToList(this._unterrichtmenge_by_idKlasse, klasse.id, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idKlasse_and_idZeitraster() {
        this._unterrichtmenge_by_idKlasse_and_idZeitraster.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            if (u.idKurs == null) {
                for (Long idKlasse : u.klassen) {
                    Map2DUtils.addToList(this._unterrichtmenge_by_idKlasse_and_idZeitraster, idKlasse, u.idZeitraster, u);
                }
                continue;
            }
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idKurs, u.idKurs)) {
                Map2DUtils.addToList(this._unterrichtmenge_by_idKlasse_and_idZeitraster, klasse.id, u.idZeitraster, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idSchueler_and_idZeitraster() {
        this._unterrichtmenge_by_idSchueler_and_idZeitraster.clear();
        for (Long idSchueler : this._unterrichtmenge_by_idSchueler.keySet()) {
            for (StundenplanUnterricht u : MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idSchueler, idSchueler)) {
                Map2DUtils.addToList(this._unterrichtmenge_by_idSchueler_and_idZeitraster, idSchueler, u.idZeitraster, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idKurs() {
        this._unterrichtmenge_by_idKurs.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            if (u.idKurs == null) continue;
            MapUtils.addToList(this._unterrichtmenge_by_idKurs, u.idKurs, u);
        }
    }

    private void update_unterrichtmenge_by_idKlasse_and_idFach() {
        this._unterrichtmenge_by_idKlasse_and_idFach.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            if (u.idKurs != null) continue;
            for (Long idKlasse : u.klassen) {
                Map2DUtils.addToList(this._unterrichtmenge_by_idKlasse_and_idFach, idKlasse, u.idFach, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idZeitraster() {
        this._unterrichtmenge_by_idZeitraster.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            MapUtils.addToList(this._unterrichtmenge_by_idZeitraster, u.idZeitraster, u);
        }
    }

    private void update_unterrichtmenge_by_idZeitraster_and_wochentyp() {
        this._unterrichtmenge_by_idZeitraster_and_wochentyp.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            Map2DUtils.addToList(this._unterrichtmenge_by_idZeitraster_and_wochentyp, u.idZeitraster, u.wochentyp, u);
        }
    }

    private void update_unterrichtmenge_by_idRaum() {
        this._unterrichtmenge_by_idRaum.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            for (Long idRaum : u.raeume) {
                MapUtils.addToList(this._unterrichtmenge_by_idRaum, idRaum, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idRaum_and_idZeitraster() {
        this._unterrichtmenge_by_idRaum_and_idZeitraster.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            for (Long idRaum : u.raeume) {
                Map2DUtils.addToList(this._unterrichtmenge_by_idRaum_and_idZeitraster, idRaum, u.idZeitraster, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idSchueler() {
        this._unterrichtmenge_by_idSchueler.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            if (u.idKurs == null) {
                for (Long idKlasse : u.klassen) {
                    for (StundenplanSchueler s : MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKlasse, idKlasse)) {
                        MapUtils.addToList(this._unterrichtmenge_by_idSchueler, s.id, u);
                    }
                }
                continue;
            }
            for (StundenplanSchueler s : MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKurs, u.idKurs)) {
                MapUtils.addToList(this._unterrichtmenge_by_idSchueler, s.id, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idJahrgang() {
        this._unterrichtmenge_by_idJahrgang.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            if (u.idKurs == null) {
                for (Long idKlasse : u.klassen) {
                    for (StundenplanJahrgang jahrgang : MapUtils.getOrCreateArrayList(this._jahrgangmenge_by_idKlasse, idKlasse)) {
                        MapUtils.addToListIfNotExists(this._unterrichtmenge_by_idJahrgang, jahrgang.id, u);
                    }
                }
                continue;
            }
            for (StundenplanJahrgang jahrgang : MapUtils.getOrCreateArrayList(this._jahrgangmenge_by_idKurs, u.idKurs)) {
                MapUtils.addToList(this._unterrichtmenge_by_idJahrgang, jahrgang.id, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idJahrgang_and_idZeitraster() {
        this._unterrichtmenge_by_idJahrgang_and_idZeitraster.clear();
        for (Long idJahrgang : this._unterrichtmenge_by_idJahrgang.keySet()) {
            for (StundenplanUnterricht u : MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idJahrgang, idJahrgang)) {
                Map2DUtils.addToList(this._unterrichtmenge_by_idJahrgang_and_idZeitraster, idJahrgang, u.idZeitraster, u);
            }
        }
    }

    private void update_unterrichtmenge_by_idSchiene() {
        this._unterrichtmenge_by_idSchiene.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            for (Long idSchiene : u.schienen) {
                MapUtils.addToList(this._unterrichtmenge_by_idSchiene, idSchiene, u);
            }
        }
    }

    private void update_zeitraster_by_wochentag_and_stunde() {
        this._zeitraster_by_wochentag_and_stunde.clear();
        for (StundenplanZeitraster zeit : this._zeitrastermenge) {
            DeveloperNotificationException.ifMap2DPutOverwrites(this._zeitraster_by_wochentag_and_stunde, zeit.wochentag, zeit.unterrichtstunde, zeit);
        }
    }

    private void update_zeitrastermenge() {
        int i;
        this._zeitrastermenge.clear();
        this._zeitrastermenge.addAll(this._zeitraster_by_id.values());
        this._zeitrastermenge.sort(_compZeitraster);
        this._zeitrasterMinutenMinByStunde.clear();
        this._zeitrasterMinutenMaxByStunde.clear();
        this._zeitrasterMinutenMin = null;
        this._zeitrasterMinutenMax = null;
        this._zeitrasterWochentagMin = Wochentag.SONNTAG.id + 1;
        this._zeitrasterWochentagMax = Wochentag.MONTAG.id - 1;
        this._zeitrasterStundeMin = 999;
        this._zeitrasterStundeMax = -999;
        for (StundenplanZeitraster z : this._zeitrastermenge) {
            this._zeitrasterMinutenMin = BlockungsUtils.minII(this._zeitrasterMinutenMin, z.stundenbeginn);
            this._zeitrasterMinutenMax = BlockungsUtils.maxII(this._zeitrasterMinutenMax, z.stundenende);
            this._zeitrasterWochentagMin = BlockungsUtils.minVI(this._zeitrasterWochentagMin, z.wochentag);
            this._zeitrasterWochentagMax = BlockungsUtils.maxVI(this._zeitrasterWochentagMax, z.wochentag);
            this._zeitrasterStundeMin = BlockungsUtils.minVI(this._zeitrasterStundeMin, z.unterrichtstunde);
            this._zeitrasterStundeMax = BlockungsUtils.maxVI(this._zeitrasterStundeMax, z.unterrichtstunde);
            this._zeitrasterMinutenMinByStunde.put(z.unterrichtstunde, BlockungsUtils.minII(this._zeitrasterMinutenMinByStunde.get(z.unterrichtstunde), z.stundenbeginn));
            this._zeitrasterMinutenMaxByStunde.put(z.unterrichtstunde, BlockungsUtils.maxII(this._zeitrasterMinutenMaxByStunde.get(z.unterrichtstunde), z.stundenende));
        }
        this._zeitrasterWochentagMin = this._zeitrasterWochentagMin == Wochentag.SONNTAG.id + 1 ? Wochentag.MONTAG.id : this._zeitrasterWochentagMin;
        this._zeitrasterWochentagMax = this._zeitrasterWochentagMax == Wochentag.MONTAG.id - 1 ? Wochentag.MONTAG.id : this._zeitrasterWochentagMax;
        this._zeitrasterStundeMin = this._zeitrasterStundeMin == 999 ? 1 : this._zeitrasterStundeMin;
        this._zeitrasterStundeMax = this._zeitrasterStundeMax == -999 ? 1 : this._zeitrasterStundeMax;
        this._zeitrasterWochentageAlsEnumRange = new Wochentag[this._zeitrasterWochentagMax - this._zeitrasterWochentagMin + 1];
        for (i = 0; i < this._zeitrasterWochentageAlsEnumRange.length; ++i) {
            this._zeitrasterWochentageAlsEnumRange[i] = Wochentag.fromIDorException(this._zeitrasterWochentagMin + i);
        }
        this._zeitrasterStundenRange = new int[this._zeitrasterStundeMax - this._zeitrasterStundeMin + 1];
        for (i = 0; i < this._zeitrasterStundenRange.length; ++i) {
            this._zeitrasterStundenRange[i] = this._zeitrasterStundeMin + i;
        }
    }

    private void update_zeitrastermengeOhneLeereUnterrichtmenge() {
        this._zeitrastermengeOhneLeere_sortiert.clear();
        for (StundenplanZeitraster z : this._zeitrastermenge) {
            if (MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idZeitraster, z.id).isEmpty()) continue;
            this._zeitrastermengeOhneLeere_sortiert.add(z);
        }
        this._zeitrasterMinutenMinOhneLeere = null;
        this._zeitrasterMinutenMaxOhneLeere = null;
        this._zeitrasterStundeMinOhneLeere = 999;
        this._zeitrasterStundeMaxOhneLeere = -999;
        for (StundenplanZeitraster z : this._zeitrastermengeOhneLeere_sortiert) {
            this._zeitrasterMinutenMinOhneLeere = BlockungsUtils.minII(this._zeitrasterMinutenMinOhneLeere, z.stundenbeginn);
            this._zeitrasterMinutenMaxOhneLeere = BlockungsUtils.maxII(this._zeitrasterMinutenMaxOhneLeere, z.stundenende);
            this._zeitrasterStundeMinOhneLeere = BlockungsUtils.minVI(this._zeitrasterStundeMinOhneLeere, z.unterrichtstunde);
            this._zeitrasterStundeMaxOhneLeere = BlockungsUtils.maxVI(this._zeitrasterStundeMaxOhneLeere, z.unterrichtstunde);
        }
        this._zeitrasterStundeMinOhneLeere = this._zeitrasterStundeMinOhneLeere == 999 ? 1 : this._zeitrasterStundeMinOhneLeere;
        this._zeitrasterStundeMaxOhneLeere = this._zeitrasterStundeMaxOhneLeere == -999 ? 1 : this._zeitrasterStundeMaxOhneLeere;
        this._zeitrasterStundenRangeOhneLeere = new int[this._zeitrasterStundeMaxOhneLeere - this._zeitrasterStundeMinOhneLeere + 1];
        for (int i = 0; i < this._zeitrasterStundenRangeOhneLeere.length; ++i) {
            this._zeitrasterStundenRangeOhneLeere[i] = this._zeitrasterStundeMinOhneLeere + i;
        }
    }

    private void update_zeitrastermenge_by_wochentag() {
        this._zeitrastermenge_by_wochentag.clear();
        for (StundenplanZeitraster zeit : this._zeitrastermenge) {
            MapUtils.addToList(this._zeitrastermenge_by_wochentag, zeit.wochentag, zeit);
        }
    }

    private void update_zeitrastermenge_by_stunde() {
        this._zeitrastermenge_by_stunde.clear();
        for (StundenplanZeitraster zeit : this._zeitrastermenge) {
            MapUtils.addToList(this._zeitrastermenge_by_stunde, zeit.unterrichtstunde, zeit);
        }
    }

    private void update_klassenmenge_by_idUnterricht() {
        this._klassenmenge_by_idUnterricht.clear();
        for (StundenplanUnterricht u : this._unterrichtmenge) {
            if (u.idKurs == null) {
                for (Long idKlasse : u.klassen) {
                    @NotNull StundenplanKlasse klasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, idKlasse);
                    MapUtils.addToListIfNotExists(this._klassenmenge_by_idUnterricht, u.id, klasse);
                }
                continue;
            }
            for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idKurs, u.idKurs)) {
                MapUtils.addToListIfNotExists(this._klassenmenge_by_idUnterricht, u.id, klasse);
            }
        }
    }

    private void aufsichtsbereichAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanAufsichtsbereich> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanAufsichtsbereich aufsichtsbereich : list) {
            StundenplanManager.aufsichtsbereichCheckAttributes(aufsichtsbereich);
            DeveloperNotificationException.ifTrue("aufsichtsbereichAddAllOhneUpdate: ID=" + aufsichtsbereich.id + " existiert bereits!", this._aufsichtsbereich_by_id.containsKey(aufsichtsbereich.id));
            DeveloperNotificationException.ifTrue("aufsichtsbereichAddAllOhneUpdate: ID=" + aufsichtsbereich.id + " doppelt in der Liste!", !setOfIDs.add(aufsichtsbereich.id));
        }
        for (StundenplanAufsichtsbereich aufsichtsbereich : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._aufsichtsbereich_by_id, aufsichtsbereich.id, aufsichtsbereich);
        }
    }

    public void aufsichtsbereichAdd(@NotNull StundenplanAufsichtsbereich aufsichtsbereich) {
        this.aufsichtsbereichAddAll(ListUtils.create1(aufsichtsbereich));
    }

    public void aufsichtsbereichAddAll(@NotNull @NotNull List<@NotNull StundenplanAufsichtsbereich> listAufsichtsbereich) {
        this.aufsichtsbereichAddAllOhneUpdate(listAufsichtsbereich);
        this.update_all();
    }

    private static void aufsichtsbereichCheckAttributes(@NotNull StundenplanAufsichtsbereich aufsichtsbereich) {
        DeveloperNotificationException.ifInvalidID("aufsicht.id", aufsichtsbereich.id);
        DeveloperNotificationException.ifStringIsBlank("aufsicht.kuerzel", aufsichtsbereich.kuerzel);
    }

    @NotNull
    public StundenplanAufsichtsbereich aufsichtsbereichGetByIdOrException(long idAufsichtsbereich) {
        return DeveloperNotificationException.ifMapGetIsNull(this._aufsichtsbereich_by_id, idAufsichtsbereich);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanAufsichtsbereich> aufsichtsbereichGetMengeAsList() {
        return this._aufsichtsbereichmenge_sortiert;
    }

    public void aufsichtsbereichPatchAttributes(@NotNull StundenplanAufsichtsbereich aufsichtsbereich) {
        StundenplanManager.aufsichtsbereichCheckAttributes(aufsichtsbereich);
        DeveloperNotificationException.ifMapRemoveFailes(this._aufsichtsbereich_by_id, aufsichtsbereich.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._aufsichtsbereich_by_id, aufsichtsbereich.id, aufsichtsbereich);
        this.update_all();
    }

    private void aufsichtsbereichRemoveOhneUpdateById(long idAufsichtsbereich) {
        for (StundenplanPausenaufsicht aufsicht : MapUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idAufsichtsbereich, idAufsichtsbereich)) {
            aufsicht.bereiche.remove(idAufsichtsbereich);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._aufsichtsbereich_by_id, idAufsichtsbereich);
    }

    public void aufsichtsbereichRemoveById(long idAufsichtsbereich) {
        this.aufsichtsbereichRemoveOhneUpdateById(idAufsichtsbereich);
        this.update_all();
    }

    public void aufsichtsbereichRemoveAll(@NotNull @NotNull List<@NotNull StundenplanAufsichtsbereich> listAufsichtsbereich) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanAufsichtsbereich aufsichtsbereich : listAufsichtsbereich) {
            if (!this._aufsichtsbereich_by_id.containsKey(aufsichtsbereich.id)) {
                throw new DeveloperNotificationException("aufsichtsbereichRemoveAll: Aufsichtsbereich-ID existiert nicht!");
            }
            if (setOfIDs.add(aufsichtsbereich.id)) continue;
            throw new DeveloperNotificationException("aufsichtsbereichRemoveAll: Doppelte Aufsichtsbereich-ID in der Liste!");
        }
        for (StundenplanAufsichtsbereich aufsichtsbereich : listAufsichtsbereich) {
            this.aufsichtsbereichRemoveOhneUpdateById(aufsichtsbereich.id);
        }
        this.update_all();
    }

    @NotNull
    public String datumGetByKwzAndZeitraster(@NotNull StundenplanKalenderwochenzuordnung kwz, @NotNull StundenplanZeitraster zeit) {
        return DateUtils.gibDatumDesWochentagsOfJahrAndKalenderwoche(kwz.jahr, kwz.kw, zeit.wochentag);
    }

    @NotNull
    public String datumGetByKwzAndWochentag(@NotNull StundenplanKalenderwochenzuordnung kwz, @NotNull Wochentag wochentag) {
        return DateUtils.gibDatumDesWochentagsOfJahrAndKalenderwoche(kwz.jahr, kwz.kw, wochentag.id);
    }

    private void fachAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanFach> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanFach fach : list) {
            StundenplanManager.fachCheckAttributes(fach);
            DeveloperNotificationException.ifTrue("fachAddAllOhneUpdate: ID=" + fach.id + " existiert bereits!", this._fach_by_id.containsKey(fach.id));
            DeveloperNotificationException.ifTrue("fachAddAllOhneUpdate: ID=" + fach.id + " doppelt in der Liste!", !setOfIDs.add(fach.id));
        }
        for (StundenplanFach fach : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._fach_by_id, fach.id, fach);
        }
    }

    public void fachAdd(@NotNull StundenplanFach fach) {
        this.fachAddAll(ListUtils.create1(fach));
    }

    public void fachAddAll(@NotNull @NotNull List<@NotNull StundenplanFach> listFach) {
        this.fachAddAllOhneUpdate(listFach);
        this.update_all();
    }

    private static void fachCheckAttributes(@NotNull StundenplanFach fach) {
        DeveloperNotificationException.ifInvalidID("fach.id", fach.id);
        DeveloperNotificationException.ifStringIsBlank("fach.kuerzel", fach.kuerzel);
    }

    @NotNull
    public StundenplanFach fachGetByIdOrException(long idFach) {
        return DeveloperNotificationException.ifMapGetIsNull(this._fach_by_id, idFach);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanFach> fachGetMengeAsList() {
        return this._fachmenge_sortiert;
    }

    private void jahrgangAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanJahrgang> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanJahrgang jahrgang : list) {
            StundenplanManager.jahrgangCheckAttributes(jahrgang);
            DeveloperNotificationException.ifTrue("jahrgangAddAllOhneUpdate: ID=" + jahrgang.id + " existiert bereits!", this._jahrgang_by_id.containsKey(jahrgang.id));
            DeveloperNotificationException.ifTrue("jahrgangAddAllOhneUpdate: ID=" + jahrgang.id + " doppelt in der Liste!", !setOfIDs.add(jahrgang.id));
        }
        for (StundenplanJahrgang jahrgang : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._jahrgang_by_id, jahrgang.id, jahrgang);
        }
    }

    public void jahrgangAdd(@NotNull StundenplanJahrgang jahrgang) {
        this.jahrgangAddAll(ListUtils.create1(jahrgang));
    }

    public void jahrgangAddAll(@NotNull @NotNull List<@NotNull StundenplanJahrgang> listJahrgang) {
        this.jahrgangAddAllOhneUpdate(listJahrgang);
        this.update_all();
    }

    private static void jahrgangCheckAttributes(@NotNull StundenplanJahrgang jahrgang) {
        DeveloperNotificationException.ifInvalidID("jahrgang.id", jahrgang.id);
        DeveloperNotificationException.ifStringIsBlank("jahrgang.kuerzel", jahrgang.kuerzel);
    }

    @NotNull
    public StundenplanJahrgang jahrgangGetByIdOrException(long idJahrgang) {
        return DeveloperNotificationException.ifMapGetIsNull(this._jahrgang_by_id, idJahrgang);
    }

    private StundenplanJahrgang jahrgangGetMinimumByKlassenIDs(@NotNull @NotNull List<@NotNull Long> klassen) {
        StundenplanJahrgang min = null;
        for (Long idKlasse : klassen) {
            @NotNull StundenplanKlasse klasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, idKlasse);
            for (Long idJahrgang : klasse.jahrgaenge) {
                @NotNull StundenplanJahrgang jahrgang = DeveloperNotificationException.ifMapGetIsNull(this._jahrgang_by_id, idJahrgang);
                if (min != null && _compJahrgang.compare(jahrgang, min) >= 0) continue;
                min = jahrgang;
            }
        }
        return min;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanJahrgang> jahrgangGetMengeAsList() {
        return this._jahrgangmenge_sortiert;
    }

    public void jahrgangPatchAttributes(@NotNull StundenplanJahrgang jahrgang) {
        StundenplanManager.jahrgangCheckAttributes(jahrgang);
        DeveloperNotificationException.ifMapRemoveFailes(this._jahrgang_by_id, jahrgang.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._jahrgang_by_id, jahrgang.id, jahrgang);
        this.update_all();
    }

    private void jahrgangRemoveOhneUpdateById(long idJahrgang) {
        for (StundenplanSchiene schiene : MapUtils.getOrCreateArrayList(this._schienenmenge_by_idJahrgang, idJahrgang)) {
            this.schieneRemoveOhneUpdateById(schiene.id);
        }
        for (StundenplanKurs kurs : MapUtils.getOrCreateArrayList(this._kursmenge_by_idJahrgang, idJahrgang)) {
            kurs.jahrgaenge.remove(idJahrgang);
        }
        for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idJahrgang, idJahrgang)) {
            klasse.jahrgaenge.remove(idJahrgang);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._jahrgang_by_id, idJahrgang);
    }

    public void jahrgangRemoveById(long idJahrgang) {
        this.jahrgangRemoveOhneUpdateById(idJahrgang);
        this.update_all();
    }

    public void jahrgangRemoveAll(@NotNull @NotNull List<@NotNull StundenplanJahrgang> listJahrgang) {
        for (StundenplanJahrgang jahrgang : listJahrgang) {
            this.jahrgangRemoveOhneUpdateById(jahrgang.id);
        }
        this.update_all();
    }

    private void kalenderwochenzuordnungAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanKalenderwochenzuordnung> list) {
        @NotNull HashSet<@NotNull CallSite> setOfIDs = new HashSet<CallSite>();
        for (StundenplanKalenderwochenzuordnung kwz : list) {
            this.kalenderwochenzuordnungCheck(kwz, true);
            DeveloperNotificationException.ifTrue("kalenderwochenzuordnungAddAllOhneUpdate: JAHR=" + kwz.jahr + ", KW=" + kwz.kw + " existiert bereits!", this._kwz_by_jahr_and_kw.contains(kwz.jahr, kwz.kw));
            DeveloperNotificationException.ifTrue("kalenderwochenzuordnungAddAllOhneUpdate: JAHR=" + kwz.jahr + ", KW=" + kwz.kw + " doppelt in der Liste!", !setOfIDs.add((CallSite)((Object)(kwz.jahr + ";" + kwz.kw))));
        }
        for (StundenplanKalenderwochenzuordnung kwz : list) {
            DeveloperNotificationException.ifMap2DPutOverwrites(this._kwz_by_jahr_and_kw, kwz.jahr, kwz.kw, kwz);
        }
    }

    public void kalenderwochenzuordnungAdd(@NotNull StundenplanKalenderwochenzuordnung kwz) {
        this.kalenderwochenzuordnungAddAll(ListUtils.create1(kwz));
    }

    public void kalenderwochenzuordnungAddAll(@NotNull @NotNull List<@NotNull StundenplanKalenderwochenzuordnung> listKWZ) {
        this.kalenderwochenzuordnungAddAllOhneUpdate(listKWZ);
        this.update_all();
    }

    private void kalenderwochenzuordnungCheck(@NotNull StundenplanKalenderwochenzuordnung kwz, boolean checkID) {
        if (checkID) {
            DeveloperNotificationException.ifInvalidID("kwz.id", kwz.id);
        }
        DeveloperNotificationException.ifTrue("(kwz.jahr < DateUtils.MIN_GUELTIGES_JAHR) || (kwz.jahr > DateUtils.MAX_GUELTIGES_JAHR)", kwz.jahr < 1900 || kwz.jahr > 2900);
        DeveloperNotificationException.ifTrue("(kwz.kw < 1) || (kwz.kw > DateUtils.gibKalenderwochenOfJahr(kwz.jahr))", kwz.kw < 1 || kwz.kw > DateUtils.gibKalenderwochenOfJahr(kwz.jahr));
        DeveloperNotificationException.ifTrue("kwz.wochentyp > stundenplanWochenTypModell", kwz.wochentyp > this._stundenplanWochenTypModell);
        DeveloperNotificationException.ifTrue("kwz.wochentyp <=0", kwz.wochentyp <= 0);
    }

    @NotNull
    public StundenplanKalenderwochenzuordnung kalenderwochenzuordnungGetByIdOrException(long idKWZ) {
        return DeveloperNotificationException.ifMapGetIsNull(this._kwz_by_id, idKWZ);
    }

    @NotNull
    public StundenplanKalenderwochenzuordnung kalenderwochenzuordnungGetByJahrAndKWOrException(int jahr, int kalenderwoche) {
        return DeveloperNotificationException.ifMap2DGetIsNull(this._kwz_by_jahr_and_kw, jahr, kalenderwoche);
    }

    @NotNull
    public StundenplanKalenderwochenzuordnung kalenderwochenzuordnungGetByDatum(@NotNull String datumISO8601) {
        int[] e = DateUtils.extractFromDateISO8601(datumISO8601);
        int kwJahr = e[6];
        int kw = e[5];
        StundenplanKalenderwochenzuordnung kwz = this._kwz_by_jahr_and_kw.getOrNull(kwJahr, kw);
        if (kwz != null) {
            return kwz;
        }
        @NotNull StundenplanKalenderwochenzuordnung kwzFirst = DeveloperNotificationException.ifListGetFirstFailes("_kwz_by_jahr_and_kw", this._kwzmenge_sortiert);
        if (kwJahr < kwzFirst.jahr || kwJahr == kwzFirst.jahr && kw < kwzFirst.kw) {
            return kwzFirst;
        }
        return DeveloperNotificationException.ifListGetLastFailes("_kwz_by_jahr_and_kw", this._kwzmenge_sortiert);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKalenderwochenzuordnung> kalenderwochenzuordnungGetMengeAsList() {
        return this._kwzmenge_sortiert;
    }

    public StundenplanKalenderwochenzuordnung kalenderwochenzuordnungGetNextOrNull(@NotNull StundenplanKalenderwochenzuordnung kwz) {
        this.kalenderwochenzuordnungCheck(kwz, false);
        int max = DateUtils.gibKalenderwochenOfJahr(kwz.jahr);
        return kwz.kw < max ? this._kwz_by_jahr_and_kw.getOrNull(kwz.jahr, kwz.kw + 1) : this._kwz_by_jahr_and_kw.getOrNull(kwz.jahr + 1, 1);
    }

    public StundenplanKalenderwochenzuordnung kalenderwochenzuordnungGetPrevOrNull(@NotNull StundenplanKalenderwochenzuordnung kwz) {
        this.kalenderwochenzuordnungCheck(kwz, false);
        int max = DateUtils.gibKalenderwochenOfJahr(kwz.jahr - 1);
        return kwz.kw > 1 ? this._kwz_by_jahr_and_kw.getOrNull(kwz.jahr, kwz.kw - 1) : this._kwz_by_jahr_and_kw.getOrNull(kwz.jahr - 1, max);
    }

    @NotNull
    public String kalenderwochenzuordnungGetWocheAsString(@NotNull StundenplanKalenderwochenzuordnung kwz) {
        @NotNull String sMo = DateUtils.gibDatumDesMontagsOfJahrAndKalenderwoche(kwz.jahr, kwz.kw);
        @NotNull String sSo = DateUtils.gibDatumDesSonntagsOfJahrAndKalenderwoche(kwz.jahr, kwz.kw);
        @NotNull String sMoGer = DateUtils.gibDatumGermanFormat(sMo);
        @NotNull String sSoGer = DateUtils.gibDatumGermanFormat(sSo);
        @NotNull String sJahrKW = "KW " + kwz.kw;
        return sJahrKW + " (" + sMoGer + "\u2013" + sSoGer + ")";
    }

    public int kalenderwochenzuordnungGetWochentypOrDefault(int jahr, int kalenderwoche) {
        DeveloperNotificationException.ifSmaller("jahr", jahr, 1900L);
        DeveloperNotificationException.ifGreater("jahr", jahr, 2900L);
        DeveloperNotificationException.ifSmaller("kalenderwoche", kalenderwoche, 1L);
        DeveloperNotificationException.ifGreater("kalenderwoche", kalenderwoche, DateUtils.gibKalenderwochenOfJahr(jahr));
        if (this._stundenplanWochenTypModell == 0) {
            return 0;
        }
        StundenplanKalenderwochenzuordnung z = this._kwz_by_jahr_and_kw.getOrNull(jahr, kalenderwoche);
        if (z != null) {
            return z.wochentyp;
        }
        int wochentyp = kalenderwoche % this._stundenplanWochenTypModell;
        return wochentyp == 0 ? this._stundenplanWochenTypModell : wochentyp;
    }

    public boolean kalenderwochenzuordnungGetWochentypUsesMapping(int jahr, int kalenderwoche) {
        DeveloperNotificationException.ifSmaller("jahr", jahr, 1900L);
        DeveloperNotificationException.ifGreater("jahr", jahr, 2900L);
        DeveloperNotificationException.ifSmaller("kalenderwoche", kalenderwoche, 1L);
        DeveloperNotificationException.ifGreater("kalenderwoche", kalenderwoche, DateUtils.gibKalenderwochenOfJahr(jahr));
        StundenplanKalenderwochenzuordnung z = this._kwz_by_jahr_and_kw.getOrNull(jahr, kalenderwoche);
        if (z == null) {
            return false;
        }
        return this._stundenplanWochenTypModell >= 2 && z.id >= 0L;
    }

    public void kalenderwochenzuordnungPatchAttributes(@NotNull StundenplanKalenderwochenzuordnung kwz) {
        this.kalenderwochenzuordnungCheck(kwz, true);
        DeveloperNotificationException.ifMapRemoveFailes(this._kwz_by_id, kwz.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._kwz_by_id, kwz.id, kwz);
        this.update_all();
    }

    private void kalenderwochenzuordnungRemoveOhneUpdateById(long idKWZ) {
        DeveloperNotificationException.ifMapRemoveFailes(this._kwz_by_id, idKWZ);
    }

    public void kalenderwochenzuordnungRemoveById(long idKWZ) {
        this.kalenderwochenzuordnungRemoveOhneUpdateById(idKWZ);
        this.update_all();
    }

    public void kalenderwochenzuordnungRemoveAll(@NotNull @NotNull List<@NotNull StundenplanKalenderwochenzuordnung> listKWZ) {
        for (StundenplanKalenderwochenzuordnung kwz : listKWZ) {
            this.kalenderwochenzuordnungRemoveOhneUpdateById(kwz.id);
        }
        this.update_all();
    }

    private void klasseAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanKlasse> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanKlasse klasse : list) {
            this.klasseCheckAttributes(klasse);
            DeveloperNotificationException.ifTrue("klasseAddAllOhneUpdate: ID=" + klasse.id + " existiert bereits!", this._klasse_by_id.containsKey(klasse.id));
            DeveloperNotificationException.ifTrue("klasseAddAllOhneUpdate: ID=" + klasse.id + " doppelt in der Liste!", !setOfIDs.add(klasse.id));
        }
        for (StundenplanKlasse klasse : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._klasse_by_id, klasse.id, klasse);
        }
    }

    public void klasseAdd(@NotNull StundenplanKlasse klasse) {
        this.klasseAddAll(ListUtils.create1(klasse));
    }

    public void klasseAddAll(@NotNull @NotNull List<@NotNull StundenplanKlasse> listKlasse) {
        this.klasseAddAllOhneUpdate(listKlasse);
        this.update_all();
    }

    private void klasseCheckAttributes(@NotNull StundenplanKlasse klasse) {
        DeveloperNotificationException.ifInvalidID("klasse.id", klasse.id);
        DeveloperNotificationException.ifStringIsBlank("klasse.kuerzel", klasse.kuerzel);
        for (Long idJahrgang : klasse.jahrgaenge) {
            DeveloperNotificationException.ifMapNotContains("_jahrgang_by_id", this._jahrgang_by_id, idJahrgang);
        }
        for (Long idSchueler : klasse.schueler) {
            DeveloperNotificationException.ifMapNotContains("_schueler_by_id", this._schueler_by_id, idSchueler);
        }
    }

    private int klasseCompareByKlassenIDs(@NotNull @NotNull List<@NotNull Long> a, @NotNull @NotNull List<@NotNull Long> b) {
        if (a.size() < b.size()) {
            return -1;
        }
        if (a.size() > b.size()) {
            return 1;
        }
        for (int i = 0; i < a.size(); ++i) {
            StundenplanKlasse bKlasse;
            @NotNull Long aIdKlasse = ListUtils.getNonNullElementAtOrException(a, i);
            @NotNull Long bIdKlasse = ListUtils.getNonNullElementAtOrException(b, i);
            @NotNull StundenplanKlasse aKlasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, aIdKlasse);
            int cmpKlasse = _compKlasse.compare(aKlasse, bKlasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, bIdKlasse));
            if (cmpKlasse == 0) continue;
            return cmpKlasse;
        }
        return 0;
    }

    @NotNull
    public StundenplanKlasse klasseGetByIdOrException(long idKlasse) {
        return DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, idKlasse);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKlasse> klasseGetMengeAsList() {
        return this._klassenmenge_sortiert;
    }

    public void klassePatchAttributes(@NotNull StundenplanKlasse klasse) {
        this.klasseCheckAttributes(klasse);
        DeveloperNotificationException.ifMapRemoveFailes(this._klasse_by_id, klasse.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._klasse_by_id, klasse.id, klasse);
        this.update_all();
    }

    private void klasseRemoveOhneUpdateById(long idKlasse) {
        for (StundenplanKlassenunterricht u : MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idKlasse, idKlasse)) {
            this.klassenunterrichtRemoveOhneUpdateById(u.idKlasse, u.idFach);
        }
        for (StundenplanPausenzeit zeit : MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idKlasse, idKlasse)) {
            zeit.klassen.remove(idKlasse);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._klasse_by_id, idKlasse);
    }

    public void klasseRemoveById(long idKlasse) {
        this.klasseRemoveOhneUpdateById(idKlasse);
        this.update_all();
    }

    public void klasseRemoveAll(@NotNull @NotNull List<@NotNull StundenplanKlasse> listKlasse) {
        for (StundenplanKlasse klasse : listKlasse) {
            this.klasseRemoveOhneUpdateById(klasse.id);
        }
        this.update_all();
    }

    private void klassenunterrichtAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanKlassenunterricht> list) {
        @NotNull HashSet<@NotNull CallSite> setOfIDs = new HashSet<CallSite>();
        for (StundenplanKlassenunterricht klassenunterricht : list) {
            this.klassenunterrichtCheckAttributes(klassenunterricht);
            DeveloperNotificationException.ifTrue("klassenunterrichtAddAllOhneUpdate: KLASSE=" + klassenunterricht.idKlasse + ", FACH=" + klassenunterricht.idFach + " existiert bereits!", this._klassenunterricht_by_idKlasse_and_idFach.contains(klassenunterricht.idKlasse, klassenunterricht.idFach));
            DeveloperNotificationException.ifTrue("klassenunterrichtAddAllOhneUpdate: ID=" + klassenunterricht.idKlasse + ", FACH=" + klassenunterricht.idFach + " doppelt in der Liste!", !setOfIDs.add((CallSite)((Object)(klassenunterricht.idKlasse + ";" + klassenunterricht.idFach))));
        }
        for (StundenplanKlassenunterricht klassenunterricht : list) {
            DeveloperNotificationException.ifMap2DPutOverwrites(this._klassenunterricht_by_idKlasse_and_idFach, klassenunterricht.idKlasse, klassenunterricht.idFach, klassenunterricht);
        }
    }

    public void klassenunterrichtAdd(@NotNull StundenplanKlassenunterricht klassenunterricht) {
        this.klassenunterrichtAddAll(ListUtils.create1(klassenunterricht));
    }

    public void klassenunterrichtAddAll(@NotNull @NotNull List<@NotNull StundenplanKlassenunterricht> listKlassenunterricht) {
        this.klassenunterrichtAddAllOhneUpdate(listKlassenunterricht);
        this.update_all();
    }

    private void klassenunterrichtCheckAttributes(@NotNull StundenplanKlassenunterricht klassenunterricht) {
        DeveloperNotificationException.ifMapNotContains("_klasse_by_id", this._klasse_by_id, klassenunterricht.idKlasse);
        DeveloperNotificationException.ifMapNotContains("_fach_by_id", this._fach_by_id, klassenunterricht.idFach);
        for (Long idSchiene : klassenunterricht.schienen) {
            DeveloperNotificationException.ifMapNotContains("_schiene_by_id", this._schiene_by_id, idSchiene);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull StundenplanKlassenunterricht> klassenunterrichtCreateComparator() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            StundenplanFach bFach;
            StundenplanKlasse bKlasse;
            @NotNull StundenplanKlasse aKlasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, a.idKlasse);
            int cmpKlasse = _compKlasse.compare(aKlasse, bKlasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, b.idKlasse));
            if (cmpKlasse != 0) {
                return cmpKlasse;
            }
            @NotNull StundenplanFach aFach = DeveloperNotificationException.ifMapGetIsNull(this._fach_by_id, a.idFach);
            int cmpFach = _compFach.compare(aFach, bFach = DeveloperNotificationException.ifMapGetIsNull(this._fach_by_id, b.idFach));
            if (cmpFach != 0) {
                return cmpFach;
            }
            int cmpLehrer = this.lehrerCompareByLehrerIDs(a.lehrer, b.lehrer);
            if (cmpLehrer != 0) {
                return cmpLehrer;
            }
            if (a.wochenstunden < b.wochenstunden) {
                return -1;
            }
            if (a.wochenstunden > b.wochenstunden) {
                return 1;
            }
            return a.bezeichnung.compareTo(b.bezeichnung);
        };
        return comp;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKlassenunterricht> klassenunterrichtGetMengeAsList() {
        return this._klassenunterrichtmenge;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKlassenunterricht> klassenunterrichtGetMengeByKlasseIdAsList(long idKlasse) {
        return MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idKlasse, idKlasse);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKlassenunterricht> klassenunterrichtGetMengeByKlasseIdAndSchieneId(long idKlasse, long idSchiene) {
        return Map2DUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idKlasse_and_idSchiene, idKlasse, idSchiene);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKlassenunterricht> klassenunterrichtGetMengeByLehrerIdAsList(long idLehrer) {
        return MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idLehrer, idLehrer);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKlassenunterricht> klassenunterrichtGetMengeBySchuelerIdAsList(long idSchueler) {
        return MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idSchueler, idSchueler);
    }

    public int klassenunterrichtGetWochenminutenSOLL(long idKlasse, long idFach) {
        return DeveloperNotificationException.ifMap2DGetIsNull(this._klassenunterricht_by_idKlasse_and_idFach, Long.valueOf((long)idKlasse), Long.valueOf((long)idFach)).wochenstunden * 45;
    }

    public double klassenunterrichtGetWochenminutenIST(long idKlasse, long idFach) {
        double wochenminuten = DeveloperNotificationException.ifMap2DGetIsNull(this._wertWochenminuten_by_idKlasse_und_idFach, idKlasse, idFach);
        return StundenplanManager.gerundetAufZweiNachkommastellen(wochenminuten);
    }

    public double klassenunterrichtGetWochenminutenREST(long idKlasse, long idFach) {
        return (double)this.klassenunterrichtGetWochenminutenSOLL(idKlasse, idFach) - this.klassenunterrichtGetWochenminutenIST(idKlasse, idFach);
    }

    public int klassenunterrichtGetWochenstundenSOLL(long idKlasse, long idFach) {
        return DeveloperNotificationException.ifMap2DGetIsNull(this._klassenunterricht_by_idKlasse_and_idFach, Long.valueOf((long)idKlasse), Long.valueOf((long)idFach)).wochenstunden;
    }

    public double klassenunterrichtGetWochenstundenIST(long idKlasse, long idFach) {
        double wochenminuten = DeveloperNotificationException.ifMap2DGetIsNull(this._wertWochenminuten_by_idKlasse_und_idFach, idKlasse, idFach);
        return StundenplanManager.gerundetAufZweiNachkommastellen(wochenminuten / 45.0);
    }

    public double klassenunterrichtGetWochenstundenREST(long idKlasse, long idFach) {
        return (double)this.klassenunterrichtGetWochenstundenSOLL(idKlasse, idFach) - this.klassenunterrichtGetWochenstundenIST(idKlasse, idFach);
    }

    private void klassenunterrichtRemoveOhneUpdateById(long idKlasse, long idFach) {
        for (StundenplanUnterricht u : DeveloperNotificationException.ifMap2DGetIsNull(this._unterrichtmenge_by_idKlasse_and_idFach, idKlasse, idFach)) {
            this.unterrichtRemoveByIdOhneUpdate(u.id);
        }
        DeveloperNotificationException.ifMap2DRemoveFailes(this._klassenunterricht_by_idKlasse_and_idFach, idKlasse, idFach);
    }

    public void klassenunterrichtRemoveById(long idKlasse, long idFach) {
        this.klassenunterrichtRemoveOhneUpdateById(idKlasse, idFach);
        this.update_all();
    }

    public void klassenunterrichtRemoveAll(@NotNull @NotNull List<@NotNull StundenplanKlassenunterricht> listKlassenunterricht) {
        for (StundenplanKlassenunterricht klassenunterricht : listKlassenunterricht) {
            this.klassenunterrichtRemoveOhneUpdateById(klassenunterricht.idKlasse, klassenunterricht.idFach);
        }
        this.update_all();
    }

    private static double gerundetAufZweiNachkommastellen(double d) {
        if (d >= 0.0) {
            return (double)Math.round(d * 100.0) / 100.0;
        }
        return (double)(-Math.round(-d * 100.0)) / 100.0;
    }

    private void kursAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanKurs> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanKurs kurs : list) {
            this.kursCheckAttributes(kurs);
            DeveloperNotificationException.ifTrue("kursAddAllOhneUpdate: ID=" + kurs.id + " existiert bereits!", this._kurs_by_id.containsKey(kurs.id));
            DeveloperNotificationException.ifTrue("kursAddAllOhneUpdate: ID=" + kurs.id + " doppelt in der Liste!", !setOfIDs.add(kurs.id));
        }
        for (StundenplanKurs kurs : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._kurs_by_id, kurs.id, kurs);
        }
    }

    public void kursAdd(@NotNull StundenplanKurs kurs) {
        this.kursAddAll(ListUtils.create1(kurs));
    }

    public void kursAddAll(@NotNull @NotNull List<@NotNull StundenplanKurs> listKurs) {
        this.kursAddAllOhneUpdate(listKurs);
        this.update_all();
    }

    private void kursCheckAttributes(@NotNull StundenplanKurs kurs) {
        DeveloperNotificationException.ifInvalidID("kurs.id", kurs.id);
        DeveloperNotificationException.ifStringIsBlank("kurs.bezeichnung", kurs.bezeichnung);
        DeveloperNotificationException.ifSmaller("kurs.wochenstunden", kurs.wochenstunden, 0L);
        for (Long idSchieneDesKurses : kurs.schienen) {
            DeveloperNotificationException.ifMapNotContains("_schiene_by_id", this._schiene_by_id, idSchieneDesKurses);
        }
        for (Long idJahrgangDesKurses : kurs.jahrgaenge) {
            DeveloperNotificationException.ifMapNotContains("_jahrgang_by_id", this._jahrgang_by_id, idJahrgangDesKurses);
        }
        for (Long idSchuelerDesKurses : kurs.schueler) {
            DeveloperNotificationException.ifMapNotContains("_schueler_by_id", this._schueler_by_id, idSchuelerDesKurses);
        }
        for (Long idLehrerDesKurses : kurs.lehrer) {
            DeveloperNotificationException.ifMapNotContains("_lehrer_by_id", this._lehrer_by_id, idLehrerDesKurses);
        }
    }

    @NotNull
    public StundenplanKurs kursGetByIdOrException(long idKurs) {
        return DeveloperNotificationException.ifMapGetIsNull(this._kurs_by_id, idKurs);
    }

    public boolean kursGetHatUnterrichtAm(long idKurs, int wochentyp, @NotNull Wochentag wochentag, int unterrichtstunde) {
        for (StundenplanUnterricht u : this.unterrichtGetMengeByKursIdAndWochentyp(idKurs, wochentyp)) {
            @NotNull StundenplanZeitraster z = this.zeitrasterGetByIdOrException(u.idZeitraster);
            if (z.wochentag != wochentag.id || z.unterrichtstunde != unterrichtstunde) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKurs> kursGetMengeAsList() {
        return this._kursmenge;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKurs> kursGetMengeByKlasseIdAsList(long idKlasse) {
        return MapUtils.getOrCreateArrayList(this._kursmenge_by_idKlasse, idKlasse);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKurs> kursGetMengeByLehrerIdAsList(long idLehrer) {
        return MapUtils.getOrCreateArrayList(this._kursmenge_by_idLehrer, idLehrer);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKurs> kursGetMengeBySchuelerIdAsList(long idSchueler) {
        return MapUtils.getOrCreateArrayList(this._kursmenge_by_idSchueler, idSchueler);
    }

    @NotNull
    public @NotNull List<@NotNull Long> kursGetMengeGefiltertByWochentypAndWochentagAndStunde(@NotNull @NotNull List<@NotNull Long> idsKurs, int wochentyp, @NotNull Wochentag wochentag, int unterrichtstunde) {
        return CollectionUtils.toFilteredArrayList(idsKurs, idKurs -> this.kursGetHatUnterrichtAm((long)idKurs, wochentyp, wochentag, unterrichtstunde));
    }

    @NotNull
    public @NotNull List<@NotNull Long> kursGetMengeGefiltertByDatumAndStunde(@NotNull @NotNull List<@NotNull Long> idsKurs, @NotNull String datumISO8601, int unterrichtstunde) {
        int[] e = DateUtils.extractFromDateISO8601(datumISO8601);
        int wochentyp = this.kalenderwochenzuordnungGetWochentypOrDefault(e[6], e[5]);
        @NotNull Wochentag wochentag = Wochentag.fromIDorException(e[3]);
        return this.kursGetMengeGefiltertByWochentypAndWochentagAndStunde(idsKurs, wochentyp, wochentag, unterrichtstunde);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanKurs> kursGetMengeByKlasseIdAndSchieneId(long idKlasse, long idSchiene) {
        return Map2DUtils.getOrCreateArrayList(this._kursmenge_by_idKlasse_and_idSchiene, idKlasse, idSchiene);
    }

    public int kursGetWochenminutenSOLL(long idKurs) {
        return DeveloperNotificationException.ifMapGetIsNull(this._kurs_by_id, Long.valueOf((long)idKurs)).wochenstunden * 45;
    }

    public double kursGetWochenminutenIST(long idKurs) {
        double wochenminuten = DeveloperNotificationException.ifMapGetIsNull(this._wertWochenminuten_by_idKurs, idKurs);
        return StundenplanManager.gerundetAufZweiNachkommastellen(wochenminuten);
    }

    public double kursGetWochenminutenREST(long idKurs) {
        return (double)this.kursGetWochenminutenSOLL(idKurs) - this.kursGetWochenminutenIST(idKurs);
    }

    public int kursGetWochenstundenSOLL(long idKurs) {
        return DeveloperNotificationException.ifMapGetIsNull(this._kurs_by_id, Long.valueOf((long)idKurs)).wochenstunden;
    }

    public double kursGetWochenstundenIST(long idKurs) {
        double wochenminuten = DeveloperNotificationException.ifMapGetIsNull(this._wertWochenminuten_by_idKurs, idKurs);
        return StundenplanManager.gerundetAufZweiNachkommastellen(wochenminuten / 45.0);
    }

    public double kursGetWochenstundenREST(long idKurs) {
        return (double)this.kursGetWochenstundenSOLL(idKurs) - this.kursGetWochenstundenIST(idKurs);
    }

    public void kursPatchAttributtes(@NotNull StundenplanKurs kurs) {
        this.kursCheckAttributes(kurs);
        DeveloperNotificationException.ifMapRemoveFailes(this._kurs_by_id, kurs.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._kurs_by_id, kurs.id, kurs);
        this.update_all();
    }

    private void kursRemoveOhneUpdateById(long idKurs) {
        for (StundenplanUnterricht u : MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idKurs, idKurs)) {
            this.unterrichtRemoveByIdOhneUpdate(u.id);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._kurs_by_id, idKurs);
    }

    public void kursRemoveById(long idKurs) {
        this.kursRemoveOhneUpdateById(idKurs);
        this.update_all();
    }

    public void kursRemoveAll(@NotNull @NotNull List<@NotNull StundenplanKurs> listKurs) {
        for (StundenplanKurs kurs : listKurs) {
            this.kursRemoveOhneUpdateById(kurs.id);
        }
        this.update_all();
    }

    private void lehrerAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanLehrer> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanLehrer lehrer : list) {
            this.lehrerCheckAttributes(lehrer);
            DeveloperNotificationException.ifTrue("lehrerAddAllOhneUpdate: ID=" + lehrer.id + " existiert bereits!", this._lehrer_by_id.containsKey(lehrer.id));
            DeveloperNotificationException.ifTrue("lehrerAddAllOhneUpdate: ID=" + lehrer.id + " doppelt in der Liste!", !setOfIDs.add(lehrer.id));
        }
        for (StundenplanLehrer lehrer : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._lehrer_by_id, lehrer.id, lehrer);
        }
    }

    public void lehrerAdd(@NotNull StundenplanLehrer lehrer) {
        this.lehrerAddAll(ListUtils.create1(lehrer));
    }

    public void lehrerAddAll(@NotNull @NotNull List<@NotNull StundenplanLehrer> listLehrer) {
        this.lehrerAddAllOhneUpdate(listLehrer);
        this.update_all();
    }

    private void lehrerCheckAttributes(@NotNull StundenplanLehrer lehrer) {
        DeveloperNotificationException.ifInvalidID("lehrer.id", lehrer.id);
        DeveloperNotificationException.ifStringIsBlank("lehrer.kuerzel", lehrer.kuerzel);
        DeveloperNotificationException.ifStringIsBlank("lehrer.nachname", lehrer.nachname);
        DeveloperNotificationException.ifStringIsBlank("lehrer.vorname", lehrer.vorname);
        for (Long idFachDesLehrers : lehrer.faecher) {
            DeveloperNotificationException.ifMapNotContains("_fach_by_id", this._fach_by_id, idFachDesLehrers);
        }
    }

    private int lehrerCompareByLehrerIDs(@NotNull @NotNull List<@NotNull Long> a, @NotNull @NotNull List<@NotNull Long> b) {
        if (a.size() < b.size()) {
            return -1;
        }
        if (a.size() > b.size()) {
            return 1;
        }
        for (int i = 0; i < a.size(); ++i) {
            StundenplanLehrer bLehrer;
            @NotNull Long aIdLehrer = ListUtils.getNonNullElementAtOrException(a, i);
            @NotNull Long bIdLehrer = ListUtils.getNonNullElementAtOrException(b, i);
            @NotNull StundenplanLehrer aLehrer = DeveloperNotificationException.ifMapGetIsNull(this._lehrer_by_id, aIdLehrer);
            int cmpLehrer = _compLehrer.compare(aLehrer, bLehrer = DeveloperNotificationException.ifMapGetIsNull(this._lehrer_by_id, bIdLehrer));
            if (cmpLehrer == 0) continue;
            return cmpLehrer;
        }
        return 0;
    }

    @NotNull
    public StundenplanLehrer lehrerGetByIdOrException(long idLehrer) {
        return DeveloperNotificationException.ifMapGetIsNull(this._lehrer_by_id, idLehrer);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanLehrer> lehrerGetMengeAsList() {
        return this._lehrermenge_sortiert;
    }

    public void lehrerPatchAttributes(@NotNull StundenplanLehrer lehrer) {
        this.lehrerCheckAttributes(lehrer);
        DeveloperNotificationException.ifMapRemoveFailes(this._lehrer_by_id, lehrer.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._lehrer_by_id, lehrer.id, lehrer);
        this.update_all();
    }

    private void lehrerRemoveOhneUpdateById(long idLehrer) {
        for (StundenplanKurs kurs : MapUtils.getOrCreateArrayList(this._kursmenge_by_idLehrer, idLehrer)) {
            kurs.lehrer.remove(idLehrer);
        }
        for (StundenplanKlassenunterricht ku : MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idLehrer, idLehrer)) {
            ku.lehrer.remove(idLehrer);
        }
        for (StundenplanUnterricht u : MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idLehrer, idLehrer)) {
            u.lehrer.remove(idLehrer);
        }
        for (StundenplanPausenaufsicht pa : MapUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idLehrer, idLehrer)) {
            this.pausenaufsichtRemoveOhneUpdateById(pa.id);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._lehrer_by_id, idLehrer);
    }

    public void lehrerRemoveById(long idLehrer) {
        this.lehrerRemoveOhneUpdateById(idLehrer);
        this.update_all();
    }

    public void lehrerRemoveAll(@NotNull @NotNull List<@NotNull StundenplanLehrer> listLehrer) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanLehrer lehrer : listLehrer) {
            if (!this._lehrer_by_id.containsKey(lehrer.id)) {
                throw new DeveloperNotificationException("lehrerRemoveAll: Lehrer-ID existiert nicht!");
            }
            if (setOfIDs.add(lehrer.id)) continue;
            throw new DeveloperNotificationException("lehrerRemoveAll: Doppelte Lehrer-ID in der Liste!");
        }
        for (StundenplanLehrer lehrer : listLehrer) {
            this.lehrerRemoveOhneUpdateById(lehrer.id);
        }
        this.update_all();
    }

    private void pausenaufsichtAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanPausenaufsicht> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanPausenaufsicht pausenaufsicht : list) {
            this.pausenaufsichtCheckAttributes(pausenaufsicht);
            DeveloperNotificationException.ifTrue("pausenaufsichtAddAllOhneUpdate: ID=" + pausenaufsicht.id + " existiert bereits!", this._pausenaufsicht_by_id.containsKey(pausenaufsicht.id));
            DeveloperNotificationException.ifTrue("pausenaufsichtAddAllOhneUpdate: ID=" + pausenaufsicht.id + " doppelt in der Liste!", !setOfIDs.add(pausenaufsicht.id));
        }
        for (StundenplanPausenaufsicht pausenaufsicht : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._pausenaufsicht_by_id, pausenaufsicht.id, pausenaufsicht);
        }
    }

    public void pausenaufsichtAdd(@NotNull StundenplanPausenaufsicht pausenaufsicht) {
        this.pausenaufsichtAddAll(ListUtils.create1(pausenaufsicht));
    }

    public void pausenaufsichtAddAll(@NotNull @NotNull List<@NotNull StundenplanPausenaufsicht> listPausenaufsicht) {
        this.pausenaufsichtAddAllOhneUpdate(listPausenaufsicht);
        this.update_all();
    }

    private void pausenaufsichtCheckAttributes(@NotNull StundenplanPausenaufsicht pausenaufsicht) {
        DeveloperNotificationException.ifInvalidID("pausenaufsicht.id", pausenaufsicht.id);
        DeveloperNotificationException.ifMapNotContains("_map_idLehrer_zu_lehrer", this._lehrer_by_id, pausenaufsicht.idLehrer);
        DeveloperNotificationException.ifMapNotContains("_map_idPausenzeit_zu_pausenzeit", this._pausenzeit_by_id, pausenaufsicht.idPausenzeit);
        DeveloperNotificationException.ifTrue("(pa.wochentyp > 0) && (pa.wochentyp > stundenplanWochenTypModell)", pausenaufsicht.wochentyp > 0 && pausenaufsicht.wochentyp > this._stundenplanWochenTypModell);
        for (Long idAufsichtsbereich : pausenaufsicht.bereiche) {
            DeveloperNotificationException.ifMapNotContains("_aufsichtsbereich_by_id", this._aufsichtsbereich_by_id, idAufsichtsbereich);
        }
    }

    @NotNull
    public StundenplanPausenaufsicht pausenaufsichtGetByIdOrException(long idPausenaufsicht) {
        return DeveloperNotificationException.ifMapGetIsNull(this._pausenaufsicht_by_id, idPausenaufsicht);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenaufsicht> pausenaufsichtGetMengeAsList() {
        return this._pausenaufsichtmenge;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenaufsicht> pausenaufsichtGetMengeByWochentagOrEmptyList(int wochentag) {
        return MapUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_wochentag, wochentag);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenaufsicht> pausenaufsichtGetMengeByPausenzeitId(long idPausenzeit) {
        return MapUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idPausenzeit, idPausenzeit);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenaufsicht> pausenaufsichtGetMengeByKlasseIdAndPausenzeitIdAndWochentypAndInklusive(long idKlasse, long idPausenzeit, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanPausenaufsicht> list = new ArrayList<StundenplanPausenaufsicht>();
        for (StundenplanPausenaufsicht a : Map2DUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idKlasse_and_idPausenzeit, idKlasse, idPausenzeit)) {
            if (a.wochentyp != wochentyp && (a.wochentyp != 0 || !inklWoche0)) continue;
            list.add(a);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenaufsicht> pausenaufsichtGetMengeByLehrerIdAndPausenzeitIdAndWochentypAndInklusive(long idLehrer, long idPausenzeit, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanPausenaufsicht> list = new ArrayList<StundenplanPausenaufsicht>();
        for (StundenplanPausenaufsicht a : Map2DUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idLehrer_and_idPausenzeit, idLehrer, idPausenzeit)) {
            if (a.wochentyp != wochentyp && (a.wochentyp != 0 || !inklWoche0)) continue;
            list.add(a);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenaufsicht> pausenaufsichtGetMengeBySchuelerIdAndPausenzeitIdAndWochentypAndInklusive(long idSchueler, long idPausenzeit, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanPausenaufsicht> list = new ArrayList<StundenplanPausenaufsicht>();
        for (StundenplanPausenaufsicht a : Map2DUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idSchueler_and_idPausenzeit, idSchueler, idPausenzeit)) {
            if (a.wochentyp != wochentyp && (a.wochentyp != 0 || !inklWoche0)) continue;
            list.add(a);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenaufsicht> pausenaufsichtGetMengeByJahrgangIdAndPausenzeitIdAndWochentypAndInklusive(long idJahrgang, long idPausenzeit, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanPausenaufsicht> list = new ArrayList<StundenplanPausenaufsicht>();
        for (StundenplanPausenaufsicht a : Map2DUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idJahrgang_and_idPausenzeit, idJahrgang, idPausenzeit)) {
            if (a.wochentyp != wochentyp && (a.wochentyp != 0 || !inklWoche0)) continue;
            list.add(a);
        }
        return list;
    }

    public void pausenaufsichtPatchAttributes(@NotNull StundenplanPausenaufsicht pausenaufsicht) {
        this.pausenaufsichtCheckAttributes(pausenaufsicht);
        DeveloperNotificationException.ifMapRemoveFailes(this._pausenaufsicht_by_id, pausenaufsicht.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._pausenaufsicht_by_id, pausenaufsicht.id, pausenaufsicht);
        this.update_all();
    }

    private void pausenaufsichtRemoveOhneUpdateById(long idPausenaufsicht) {
        DeveloperNotificationException.ifMapRemoveFailes(this._pausenaufsicht_by_id, idPausenaufsicht);
    }

    public void pausenaufsichtRemoveById(long idPausenaufsicht) {
        this.pausenaufsichtRemoveOhneUpdateById(idPausenaufsicht);
        this.update_all();
    }

    private void pausenzeitAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanPausenzeit> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanPausenzeit pausenzeit : list) {
            StundenplanManager.pausenzeitCheckAttributes(pausenzeit);
            DeveloperNotificationException.ifTrue("pausenzeitAddAllOhneUpdate: ID=" + pausenzeit.id + " existiert bereits!", this._pausenzeit_by_id.containsKey(pausenzeit.id));
            DeveloperNotificationException.ifTrue("pausenzeitAddAllOhneUpdate: ID=" + pausenzeit.id + " doppelt in der Liste!", !setOfIDs.add(pausenzeit.id));
        }
        for (StundenplanPausenzeit pausenzeit : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._pausenzeit_by_id, pausenzeit.id, pausenzeit);
        }
    }

    public void pausenzeitAdd(@NotNull StundenplanPausenzeit pausenzeit) {
        this.pausenzeitAddAll(ListUtils.create1(pausenzeit));
        this.update_all();
    }

    public void pausenzeitAddAll(@NotNull @NotNull List<@NotNull StundenplanPausenzeit> listPausenzeit) {
        this.pausenzeitAddAllOhneUpdate(listPausenzeit);
        this.update_all();
    }

    private static void pausenzeitCheckAttributes(@NotNull StundenplanPausenzeit pausenzeit) {
        DeveloperNotificationException.ifInvalidID("pause.id", pausenzeit.id);
        Wochentag.fromIDorException(pausenzeit.wochentag);
        if (pausenzeit.beginn != null && pausenzeit.ende != null) {
            DeveloperNotificationException.ifTrue("pausenzeit.beginn >= pausenzeit.ende", pausenzeit.beginn >= pausenzeit.ende);
        }
    }

    @NotNull
    public StundenplanPausenzeit pausenzeitGetByIdOrException(long idPausenzeit) {
        return DeveloperNotificationException.ifMapGetIsNull(this._pausenzeit_by_id, idPausenzeit);
    }

    @NotNull
    public String pausenzeitGetByIdStringOfUhrzeitBeginn(long idPausenzeit) {
        @NotNull StundenplanPausenzeit pausenzeit = DeveloperNotificationException.ifMapGetIsNull(this._pausenzeit_by_id, idPausenzeit);
        return pausenzeit.beginn == null ? "" : DateUtils.getStringOfUhrzeitFromMinuten(pausenzeit.beginn);
    }

    @NotNull
    public String pausenzeitGetByIdStringOfUhrzeitEnde(long idPausenzeit) {
        @NotNull StundenplanPausenzeit pausenzeit = DeveloperNotificationException.ifMapGetIsNull(this._pausenzeit_by_id, idPausenzeit);
        return pausenzeit.ende == null ? "" : DateUtils.getStringOfUhrzeitFromMinuten(pausenzeit.ende);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeAsList() {
        return this._pausenzeitmenge;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeByKlasseIdAsList(long idKlasse) {
        return MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idKlasse, idKlasse);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeByLehrerIdAsList(long idLehrer) {
        return MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idLehrer, idLehrer);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeBySchuelerIdAsList(long idSchueler) {
        return MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idSchueler, idSchueler);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeByJahrgangIdAsList(long idJahrgang) {
        return MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idJahrgang, idJahrgang);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeByWochentagOrEmptyList(int wochentag) {
        return MapUtils.getOrCreateArrayList(this._pausenzeitmenge_by_wochentag, wochentag);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeByKlasseIdAndWochentagAsList(long idKlasse, int wochentag) {
        return Map2DUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idKlasse_and_wochentag, idKlasse, wochentag);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeByLehrerIdAndWochentagAsList(long idLehrer, int wochentag) {
        return Map2DUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idLehrer_and_wochentag, idLehrer, wochentag);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeBySchuelerIdAndWochentagAsList(long idSchueler, int wochentag) {
        return Map2DUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idSchueler_and_wochentag, idSchueler, wochentag);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeByJahrgangIdAndWochentagAsList(long idJahrgang, int wochentag) {
        return Map2DUtils.getOrCreateArrayList(this._pausenzeitmenge_by_idJahrgang_and_wochentag, idJahrgang, wochentag);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeitGetMengeNichtLeereAsList() {
        return this._pausenzeitmengeOhneLeere_sortiert;
    }

    public int pausenzeitGetMinutenMin() {
        return this._pausenzeitMinutenMin == null ? 480 : this._pausenzeitMinutenMin;
    }

    public int pausenzeitGetMinutenMax() {
        return this._pausenzeitMinutenMax == null ? 480 : this._pausenzeitMinutenMax;
    }

    public int pausenzeitUndZeitrasterGetMinutenMin() {
        Integer min = BlockungsUtils.minII(this._pausenzeitMinutenMin, this._zeitrasterMinutenMin);
        return min == null ? 480 : min;
    }

    public int pausenzeitUndZeitrasterGetMinutenMinOhneLeere() {
        Integer min = BlockungsUtils.minII(this._pausenzeitMinutenMinOhneLeere, this._zeitrasterMinutenMinOhneLeere);
        return min == null ? 480 : min;
    }

    public int pausenzeitUndZeitrasterGetMinutenMax() {
        Integer max = BlockungsUtils.maxII(this._pausenzeitMinutenMax, this._zeitrasterMinutenMax);
        return max == null ? 480 : max;
    }

    public int pausenzeitUndZeitrasterGetMinutenMaxOhneLeere() {
        Integer max = BlockungsUtils.maxII(this._pausenzeitMinutenMaxOhneLeere, this._zeitrasterMinutenMaxOhneLeere);
        return max == null ? 480 : max;
    }

    public void pausenzeitPatchAttributes(@NotNull StundenplanPausenzeit pausenzeit) {
        StundenplanManager.pausenzeitCheckAttributes(pausenzeit);
        DeveloperNotificationException.ifMapRemoveFailes(this._pausenzeit_by_id, pausenzeit.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._pausenzeit_by_id, pausenzeit.id, pausenzeit);
        this.update_all();
    }

    private void pausenzeitRemoveOhneUpdateById(long idPausenzeit) {
        for (StundenplanPausenaufsicht a : MapUtils.getOrCreateArrayList(this._pausenaufsichtmenge_by_idPausenzeit, idPausenzeit)) {
            this.pausenaufsichtRemoveOhneUpdateById(a.id);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._pausenzeit_by_id, idPausenzeit);
    }

    public void pausenzeitRemoveById(long idPausenzeit) {
        this.pausenzeitRemoveOhneUpdateById(idPausenzeit);
        this.update_all();
    }

    public void pausenzeitRemoveAll(@NotNull @NotNull List<@NotNull StundenplanPausenzeit> listPausenzeit) {
        for (StundenplanPausenzeit pausenzeit : listPausenzeit) {
            this.pausenzeitRemoveOhneUpdateById(pausenzeit.id);
        }
        this.update_all();
    }

    private void raumAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanRaum> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanRaum raum : list) {
            StundenplanManager.raumCheckAttributes(raum);
            DeveloperNotificationException.ifTrue("raumAddAllOhneUpdate: ID=" + raum.id + " existiert bereits!", this._raum_by_id.containsKey(raum.id));
            DeveloperNotificationException.ifTrue("raumAddAllOhneUpdate: ID=" + raum.id + " doppelt in der Liste!", !setOfIDs.add(raum.id));
        }
        for (StundenplanRaum raum : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._raum_by_id, raum.id, raum);
        }
    }

    public void raumAdd(@NotNull StundenplanRaum raum) {
        this.raumAddAll(ListUtils.create1(raum));
        this.update_all();
    }

    public void raumAddAll(@NotNull @NotNull List<@NotNull StundenplanRaum> listRaum) {
        this.raumAddAllOhneUpdate(listRaum);
        this.update_all();
    }

    private static void raumCheckAttributes(@NotNull StundenplanRaum raum) {
        DeveloperNotificationException.ifInvalidID("raum.id", raum.id);
        DeveloperNotificationException.ifStringIsBlank("raum.kuerzel", raum.kuerzel);
        DeveloperNotificationException.ifTrue("raum.groesse < 0", raum.groesse < 0);
    }

    @NotNull
    public StundenplanRaum raumGetByIdOrException(long idRaum) {
        return DeveloperNotificationException.ifMapGetIsNull(this._raum_by_id, idRaum);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanRaum> raumGetMengeAsList() {
        return this._raummenge_sortiert;
    }

    public void raumPatchAttributes(@NotNull StundenplanRaum raum) {
        StundenplanManager.raumCheckAttributes(raum);
        DeveloperNotificationException.ifMapRemoveFailes(this._raum_by_id, raum.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._raum_by_id, raum.id, raum);
        this.update_all();
    }

    private void raumRemoveOhneUpdateById(long idRaum) {
        for (StundenplanUnterricht u : MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idRaum, idRaum)) {
            u.raeume.remove(idRaum);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._raum_by_id, idRaum);
    }

    public void raumRemoveById(long idRaum) {
        this.raumRemoveOhneUpdateById(idRaum);
        this.update_all();
    }

    public void raumRemoveAll(@NotNull @NotNull List<@NotNull StundenplanRaum> listRaum) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanRaum raum : listRaum) {
            if (!this._raum_by_id.containsKey(raum.id)) {
                throw new DeveloperNotificationException("raumRemoveAll: Raum-ID existiert nicht!");
            }
            if (setOfIDs.add(raum.id)) continue;
            throw new DeveloperNotificationException("raumRemoveAll: Doppelte Raum-ID in der Liste!");
        }
        for (StundenplanRaum raum : listRaum) {
            this.raumRemoveOhneUpdateById(raum.id);
        }
        this.update_all();
    }

    private void schieneAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanSchiene> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanSchiene schiene : list) {
            this.schieneCheckAttributes(schiene);
            DeveloperNotificationException.ifTrue("schieneAddAllOhneUpdate: ID=" + schiene.id + " existiert bereits!", this._schiene_by_id.containsKey(schiene.id));
            DeveloperNotificationException.ifTrue("schieneAddAllOhneUpdate: ID=" + schiene.id + " doppelt in der Liste!", !setOfIDs.add(schiene.id));
        }
        for (StundenplanSchiene schiene : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._schiene_by_id, schiene.id, schiene);
        }
    }

    public void schieneAdd(@NotNull StundenplanSchiene schiene) {
        this.schieneAddAll(ListUtils.create1(schiene));
    }

    public void schieneAddAll(@NotNull @NotNull List<@NotNull StundenplanSchiene> listSchiene) {
        this.schieneAddAllOhneUpdate(listSchiene);
        this.update_all();
    }

    private void schieneCheckAttributes(@NotNull StundenplanSchiene schiene) {
        DeveloperNotificationException.ifInvalidID("schiene.id", schiene.id);
        DeveloperNotificationException.ifTrue("schiene.nummer <= 0", schiene.nummer <= 0);
        DeveloperNotificationException.ifStringIsBlank("schiene.bezeichnung", schiene.bezeichnung);
        DeveloperNotificationException.ifMapNotContains("_jahrgang_by_id", this._jahrgang_by_id, schiene.idJahrgang);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchiene> schieneGetMengeAsList() {
        return this._schienenmenge;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchiene> schieneGetMengeByKlasseIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(long idKlasse, int wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanSchiene> list = new ArrayList<StundenplanSchiene>();
        for (StundenplanUnterricht u : this.unterrichtGetMengeByKlasseIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(idKlasse, wochentag, stunde, wochentyp, inklWoche0)) {
            ListUtils.addAllIfNotExists(list, MapUtils.getOrCreateArrayList(this._schienenmenge_by_idUnterricht, u.id));
        }
        list.sort(_compSchiene);
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchiene> schieneGetMengeByKlasseId(long idKlasse) {
        return MapUtils.getOrCreateArrayList(this._schienenmenge_by_idKlasse, idKlasse);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchiene> schieneGetMengeByLehrerIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(long idLehrer, int wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanSchiene> list = new ArrayList<StundenplanSchiene>();
        for (StundenplanUnterricht u : this.unterrichtGetMengeByLehrerIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(idLehrer, wochentag, stunde, wochentyp, inklWoche0)) {
            ListUtils.addAllIfNotExists(list, MapUtils.getOrCreateArrayList(this._schienenmenge_by_idUnterricht, u.id));
        }
        list.sort(_compSchiene);
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchiene> schieneGetMengeBySchuelerIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(long idSchueler, int wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanSchiene> list = new ArrayList<StundenplanSchiene>();
        for (StundenplanUnterricht u : this.unterrichtGetMengeBySchuelerIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(idSchueler, wochentag, stunde, wochentyp, inklWoche0)) {
            ListUtils.addAllIfNotExists(list, MapUtils.getOrCreateArrayList(this._schienenmenge_by_idUnterricht, u.id));
        }
        list.sort(_compSchiene);
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchiene> schieneGetMengeByJahrgangIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(long idJahrgang, int wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanSchiene> list = new ArrayList<StundenplanSchiene>();
        for (StundenplanUnterricht u : this.unterrichtGetMengeByJahrgangIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(idJahrgang, wochentag, stunde, wochentyp, inklWoche0)) {
            ListUtils.addAllIfNotExists(list, MapUtils.getOrCreateArrayList(this._schienenmenge_by_idUnterricht, u.id));
        }
        list.sort(_compSchiene);
        return list;
    }

    private void schieneRemoveOhneUpdateById(long idSchiene) {
        for (StundenplanKurs kurs : MapUtils.getOrCreateArrayList(this._kursmenge_by_idSchiene, idSchiene)) {
            kurs.schienen.remove(idSchiene);
        }
        for (StundenplanKlassenunterricht ku : MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idSchiene, idSchiene)) {
            ku.schienen.remove(idSchiene);
        }
        for (StundenplanUnterricht u : MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idSchiene, idSchiene)) {
            u.schienen.remove(idSchiene);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._schiene_by_id, idSchiene);
    }

    private void schuelerAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanSchueler> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanSchueler schueler : list) {
            StundenplanManager.schuelerCheckAttributes(schueler);
            DeveloperNotificationException.ifTrue("schuelerAddAllOhneUpdate: ID=" + schueler.id + " existiert bereits!", this._schueler_by_id.containsKey(schueler.id));
            DeveloperNotificationException.ifTrue("schuelerAddAllOhneUpdate: ID=" + schueler.id + " doppelt in der Liste!", !setOfIDs.add(schueler.id));
        }
        for (StundenplanSchueler schueler : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._schueler_by_id, schueler.id, schueler);
        }
    }

    public void schuelerAdd(@NotNull StundenplanSchueler schueler) {
        this.schuelerAddAll(ListUtils.create1(schueler));
    }

    public void schuelerAddAll(@NotNull @NotNull List<@NotNull StundenplanSchueler> listSchueler) {
        this.schuelerAddAllOhneUpdate(listSchueler);
        this.update_all();
    }

    private static void schuelerCheckAttributes(@NotNull StundenplanSchueler schueler) {
        DeveloperNotificationException.ifInvalidID("schueler.id", schueler.id);
        DeveloperNotificationException.ifStringIsBlank("schueler.nachname", schueler.nachname);
        DeveloperNotificationException.ifStringIsBlank("schueler.vorname", schueler.vorname);
    }

    @NotNull
    public StundenplanSchueler schuelerGetByIdOrException(long idSchueler) {
        return DeveloperNotificationException.ifMapGetIsNull(this._schueler_by_id, idSchueler);
    }

    public long schuelerGetIDorException() {
        int size = this._schuelermenge.size();
        DeveloperNotificationException.ifTrue("getSchuelerID() geht nicht bei " + size + " Sch\u00fclern!", size != 1);
        return this._schuelermenge.get((int)0).id;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchueler> schuelerGetMengeAsList() {
        return this._schuelermenge;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchueler> schuelerGetMengeByKlasseIdAsListOrException(long idKlasse) throws DeveloperNotificationException {
        @NotNull StundenplanKlasse klasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, idKlasse);
        return MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKlasse, klasse.id);
    }

    public int schuelerGetAnzahlByKlasseIdOrException(long idKlasse) throws DeveloperNotificationException {
        @NotNull StundenplanKlasse klasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, idKlasse);
        return MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKlasse, klasse.id).size();
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanSchueler> schuelerGetMengeByKursIdAsListOrException(long idKurs) throws DeveloperNotificationException {
        return MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKurs, idKurs);
    }

    public int schuelerGetAnzahlByKursIdAsListOrException(long idKurs) throws DeveloperNotificationException {
        return MapUtils.getOrCreateArrayList(this._schuelermenge_by_idKurs, idKurs).size();
    }

    private void schuelerRemoveOhneUpdateById(long idSchueler) {
        for (StundenplanKlasse klasse : MapUtils.getOrCreateArrayList(this._klassenmenge_by_idSchueler, idSchueler)) {
            klasse.schueler.remove(idSchueler);
        }
        for (StundenplanKurs kurs : MapUtils.getOrCreateArrayList(this._kursmenge_by_idSchueler, idSchueler)) {
            kurs.schueler.remove(idSchueler);
        }
        for (StundenplanKlassenunterricht ku : MapUtils.getOrCreateArrayList(this._klassenunterrichtmenge_by_idSchueler, idSchueler)) {
            ku.schueler.remove(idSchueler);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._schiene_by_id, idSchueler);
    }

    public void schuelerRemoveById(long idSchueler) {
        this.schuelerRemoveOhneUpdateById(idSchueler);
        this.update_all();
    }

    public long getIDSchuljahresabschnitt() {
        return this._stundenplanSchuljahresAbschnittID;
    }

    @NotNull
    public String getGueltigAb() {
        return this._stundenplanGueltigAb;
    }

    @NotNull
    public String getGueltigBis() {
        return this._stundenplanGueltigBis;
    }

    @NotNull
    public String getBezeichnungStundenplan() {
        return this._stundenplanBezeichnung;
    }

    public int getWochenTypModell() {
        return this._stundenplanWochenTypModell;
    }

    public int stundenplanGetWochenTypModell() {
        return this._stundenplanWochenTypModell;
    }

    @NotNull
    public String stundenplanGetWochenTypAsString(int wochenTyp) {
        if (wochenTyp <= 0) {
            return "Alle Wochen";
        }
        int zahl = wochenTyp - 1;
        int z2 = zahl / 26;
        int z1 = zahl - z2 * 26;
        return StringUtils.numberToLetterIndex1(z2) + StringUtils.numberToLetterIndex0(z1) + "-Woche";
    }

    public long stundenplanGetID() {
        return this._stundenplanID;
    }

    private void unterrichtAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanUnterricht> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        for (StundenplanUnterricht u : list) {
            this.unterrichtCheckAttributes(u);
            DeveloperNotificationException.ifTrue("unterrichtAddAllOhneUpdate: ID=" + u.id + " existiert bereits!", this._unterricht_by_id.containsKey(u.id));
            DeveloperNotificationException.ifTrue("unterrichtAddAllOhneUpdate: ID=" + u.id + " doppelt in der Liste!", !setOfIDs.add(u.id));
        }
        for (StundenplanUnterricht u : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._unterricht_by_id, u.id, u);
        }
    }

    public void unterrichtAdd(@NotNull StundenplanUnterricht unterricht) {
        this.unterrichtAddAll(ListUtils.create1(unterricht));
    }

    public void unterrichtAddAll(@NotNull @NotNull List<@NotNull StundenplanUnterricht> listUnterricht) {
        this.unterrichtAddAllOhneUpdate(listUnterricht);
        this.update_all();
    }

    private void unterrichtCheckAttributes(@NotNull StundenplanUnterricht u) {
        DeveloperNotificationException.ifInvalidID("u.id", u.id);
        DeveloperNotificationException.ifMapNotContains("_zeitraster_by_id", this._zeitraster_by_id, u.idZeitraster);
        DeveloperNotificationException.ifTrue("u.wochentyp > stundenplanWochenTypModell", u.wochentyp > this._stundenplanWochenTypModell);
        DeveloperNotificationException.ifTrue("u.wochentyp < 0", u.wochentyp < 0);
        DeveloperNotificationException.ifTrue("(u.idKurs == null) && (u.klassen.size() != 1)", u.idKurs == null && u.klassen.size() != 1);
        DeveloperNotificationException.ifMapNotContains("_fach_by_id", this._fach_by_id, u.idFach);
        for (Long idLehrkraftDesUnterrichts : u.lehrer) {
            DeveloperNotificationException.ifMapNotContains("_lehrer_by_id", this._lehrer_by_id, idLehrkraftDesUnterrichts);
        }
        for (Long idKlasseDesUnterrichts : u.klassen) {
            DeveloperNotificationException.ifMapNotContains("_klasse_by_id", this._klasse_by_id, idKlasseDesUnterrichts);
        }
        for (Long idRaumDesUnterrichts : u.raeume) {
            DeveloperNotificationException.ifMapNotContains("_raum_by_id", this._raum_by_id, idRaumDesUnterrichts);
        }
        for (Long idSchieneDesUnterrichts : u.schienen) {
            DeveloperNotificationException.ifMapNotContains("_schiene_by_id", this._schiene_by_id, idSchieneDesUnterrichts);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull StundenplanUnterricht> unterrichtCreateComparator() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            StundenplanFach bFach;
            StundenplanJahrgang aJahrgang = this.jahrgangGetMinimumByKlassenIDs(a.klassen);
            StundenplanJahrgang bJahrgang = this.jahrgangGetMinimumByKlassenIDs(b.klassen);
            if (aJahrgang != null || bJahrgang != null) {
                if (aJahrgang == null) {
                    return -1;
                }
                if (bJahrgang == null) {
                    return 1;
                }
                int cmpJahrgang = _compJahrgang.compare(aJahrgang, bJahrgang);
                if (cmpJahrgang != 0) {
                    return cmpJahrgang;
                }
            }
            if (a.idKurs != null && b.idKurs == null) {
                return -1;
            }
            if (a.idKurs == null && b.idKurs != null) {
                return 1;
            }
            int cmpKlasse = this.klasseCompareByKlassenIDs(a.klassen, b.klassen);
            if (cmpKlasse != 0) {
                return cmpKlasse;
            }
            @NotNull StundenplanFach aFach = DeveloperNotificationException.ifMapGetIsNull(this._fach_by_id, a.idFach);
            int cmpFach = _compFach.compare(aFach, bFach = DeveloperNotificationException.ifMapGetIsNull(this._fach_by_id, b.idFach));
            if (cmpFach != 0) {
                return cmpFach;
            }
            int cmpLehrer = this.lehrerCompareByLehrerIDs(a.lehrer, b.lehrer);
            if (cmpLehrer != 0) {
                return cmpLehrer;
            }
            if (a.wochentyp < b.wochentyp) {
                return -1;
            }
            if (a.wochentyp > b.wochentyp) {
                return 1;
            }
            return Long.compare(a.id, b.id);
        };
        return comp;
    }

    @NotNull
    public StundenplanUnterricht unterrichtGetByIdOrException(long idUnterricht) {
        return DeveloperNotificationException.ifMapGetIsNull(this._unterricht_by_id, idUnterricht);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKlasseIdAndWochentyp(long idKlasse, int wochentyp) {
        DeveloperNotificationException.ifTrue("wochentyp > stundenplanWochenTypModell", wochentyp > this._stundenplanWochenTypModell);
        @NotNull List<@NotNull StundenplanUnterricht> listU = MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idKlasse, idKlasse);
        return CollectionUtils.toFilteredArrayList(listU, u -> u.wochentyp == 0 || u.wochentyp == wochentyp);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKlasseIdAndJahrAndKW(long idKlasse, int jahr, int kalenderwoche) {
        int wochentyp = this.kalenderwochenzuordnungGetWochentypOrDefault(jahr, kalenderwoche);
        return this.unterrichtGetMengeByKlasseIdAndWochentyp(idKlasse, wochentyp);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKlasseIdAndFachIdAndWochentyp(long idKlasse, long idFach, int wochentyp) {
        DeveloperNotificationException.ifTrue("wochentyp > stundenplanWochenTypModell", wochentyp > this._stundenplanWochenTypModell);
        @NotNull List<@NotNull StundenplanUnterricht> listU = DeveloperNotificationException.ifMap2DGetIsNull(this._unterrichtmenge_by_idKlasse_and_idFach, idKlasse, idFach);
        return CollectionUtils.toFilteredArrayList(listU, u -> u.wochentyp == 0 || u.wochentyp == wochentyp);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKlasseIdAndFachIdAndJahrAndKW(long idKlasse, long idFach, int jahr, int kalenderwoche) {
        int wochentyp = this.kalenderwochenzuordnungGetWochentypOrDefault(jahr, kalenderwoche);
        return this.unterrichtGetMengeByKlasseIdAndFachIdAndWochentyp(idKlasse, idFach, wochentyp);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKursIdAndWochentyp(long idkurs, int wochentyp) {
        DeveloperNotificationException.ifTrue("wochentyp > stundenplanWochenTypModell", wochentyp > this._stundenplanWochenTypModell);
        @NotNull List<@NotNull StundenplanUnterricht> listU = MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idKurs, idkurs);
        return CollectionUtils.toFilteredArrayList(listU, u -> u.wochentyp == 0 || u.wochentyp == wochentyp);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKursIdsAndWochentyp(@NotNull long[] idsKurs, int wochentyp) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> result = new ArrayList<StundenplanUnterricht>();
        for (long idKurs : idsKurs) {
            result.addAll(this.unterrichtGetMengeByKursIdAndWochentyp(idKurs, wochentyp));
        }
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKursIdAndJahrAndKW(long idKurs, int jahr, int kalenderwoche) {
        int wochentyp = this.kalenderwochenzuordnungGetWochentypOrDefault(jahr, kalenderwoche);
        return this.unterrichtGetMengeByKursIdAndWochentyp(idKurs, wochentyp);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKursIdsAndJahrAndKW(@NotNull long[] idsKurs, int jahr, int kalenderwoche) {
        int wochentyp = this.kalenderwochenzuordnungGetWochentypOrDefault(jahr, kalenderwoche);
        return this.unterrichtGetMengeByKursIdsAndWochentyp(idsKurs, wochentyp);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByZeitrasterIdAndWochentypOrEmptyList(long idZeitraster, int wochentyp) {
        return Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idZeitraster_and_wochentyp, idZeitraster, wochentyp);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByZeitrasterIdAndWochentypAndInklusiveOrEmptyList(long idZeitraster, int wochentyp, boolean inklWoche0) {
        if (wochentyp == 0 || !inklWoche0) {
            return this.unterrichtGetMengeByZeitrasterIdAndWochentypOrEmptyList(idZeitraster, wochentyp);
        }
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        list.addAll(this.unterrichtGetMengeByZeitrasterIdAndWochentypOrEmptyList(idZeitraster, wochentyp));
        list.addAll(this.unterrichtGetMengeByZeitrasterIdAndWochentypOrEmptyList(idZeitraster, 0));
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByWochentagAndStundeAndWochentypOrEmptyList(@NotNull Wochentag wochentag, int stunde, int wochentyp) {
        StundenplanZeitraster zeitraster = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag.id, stunde);
        if (zeitraster != null) {
            return Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idZeitraster_and_wochentyp, zeitraster.id, wochentyp);
        }
        return new ArrayList<StundenplanUnterricht>();
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(@NotNull Wochentag wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        long idZeitraster = this.zeitrasterGetByWochentagAndStundeOrException((int)wochentag.id, (int)stunde).id;
        return this.unterrichtGetMengeByZeitrasterIdAndWochentypAndInklusiveOrEmptyList(idZeitraster, wochentyp, inklWoche0);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKlasseIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(long idKlasse, int wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idKlasse_and_idZeitraster, idKlasse, z.id)) {
                if (u.wochentyp != wochentyp && (u.wochentyp != 0 || !inklWoche0)) continue;
                list.add(u);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByKlasseIdAndWochentagAndStundeAndWochentypAndSchieneAndInklusiveOrEmptyList(long idKlasse, int wochentag, int stunde, int wochentyp, long idSchiene, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        for (StundenplanUnterricht u : this.unterrichtGetMengeByKlasseIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(idKlasse, wochentag, stunde, wochentyp, inklWoche0)) {
            if (!this.unterrichtHatSchiene(u, idSchiene)) continue;
            list.add(u);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByLehrerIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(long idLehrer, int wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idLehrer_and_idZeitraster, idLehrer, z.id)) {
                if (u.wochentyp != wochentyp && (u.wochentyp != 0 || !inklWoche0)) continue;
                list.add(u);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByLehrerIdAndWochentagAndStundeAndWochentypAndSchieneAndInklusiveOrEmptyList(long idLehrer, int wochentag, int stunde, int wochentyp, long idSchiene, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        for (StundenplanUnterricht u : this.unterrichtGetMengeByLehrerIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(idLehrer, wochentag, stunde, wochentyp, inklWoche0)) {
            if (!this.unterrichtHatSchiene(u, idSchiene)) continue;
            list.add(u);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeBySchuelerIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(long idSchueler, int wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idSchueler_and_idZeitraster, idSchueler, z.id)) {
                if (u.wochentyp != wochentyp && (u.wochentyp != 0 || !inklWoche0)) continue;
                list.add(u);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeBySchuelerIdAndWochentagAndStundeAndWochentypAndSchieneAndInklusiveOrEmptyList(long idSchueler, int wochentag, int stunde, int wochentyp, long idSchiene, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        for (StundenplanUnterricht u : this.unterrichtGetMengeBySchuelerIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(idSchueler, wochentag, stunde, wochentyp, inklWoche0)) {
            if (!this.unterrichtHatSchiene(u, idSchiene)) continue;
            list.add(u);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByJahrgangIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(long idJahrgang, int wochentag, int stunde, int wochentyp, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idJahrgang_and_idZeitraster, idJahrgang, z.id)) {
                if (u.wochentyp != wochentyp && (u.wochentyp != 0 || !inklWoche0)) continue;
                list.add(u);
            }
        }
        list.sort(this._compUnterricht);
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanUnterricht> unterrichtGetMengeByJahrgangIdAndWochentagAndStundeAndWochentypAndSchieneAndInklusiveOrEmptyList(long idJahrgang, int wochentag, int stunde, int wochentyp, long idSchiene, boolean inklWoche0) {
        @NotNull ArrayList<@NotNull StundenplanUnterricht> list = new ArrayList<StundenplanUnterricht>();
        for (StundenplanUnterricht u : this.unterrichtGetMengeByJahrgangIdAndWochentagAndStundeAndWochentypAndInklusiveOrEmptyList(idJahrgang, wochentag, stunde, wochentyp, inklWoche0)) {
            if (!this.unterrichtHatSchiene(u, idSchiene)) continue;
            list.add(u);
        }
        return list;
    }

    @NotNull
    public String unterrichtGetByIDStringOfFachOderKursKuerzel(long idUnterricht) {
        @NotNull StundenplanUnterricht unterricht = DeveloperNotificationException.ifMapGetIsNull(this._unterricht_by_id, idUnterricht);
        if (unterricht.idKurs == null) {
            @NotNull StundenplanFach fach = DeveloperNotificationException.ifMapGetIsNull(this._fach_by_id, unterricht.idFach);
            return fach.kuerzel;
        }
        @NotNull StundenplanKurs kurs = DeveloperNotificationException.ifMapGetIsNull(this._kurs_by_id, unterricht.idKurs);
        return kurs.bezeichnung;
    }

    @NotNull
    public String unterrichtGetByIDStringOfKlassen(long idUnterricht) {
        @NotNull StundenplanUnterricht unterricht = DeveloperNotificationException.ifMapGetIsNull(this._unterricht_by_id, idUnterricht);
        @NotNull AVLSet<@NotNull String> kuerzel = new AVLSet<String>();
        for (Long idKlasse : unterricht.klassen) {
            @NotNull StundenplanKlasse klasse = DeveloperNotificationException.ifMapGetIsNull(this._klasse_by_id, idKlasse);
            kuerzel.add(klasse.kuerzel);
        }
        return StringUtils.collectionToCommaSeparatedString(kuerzel);
    }

    @NotNull
    public String unterrichtGetByIDStringOfRaeume(long idUnterricht) {
        @NotNull StundenplanUnterricht unterricht = DeveloperNotificationException.ifMapGetIsNull(this._unterricht_by_id, idUnterricht);
        @NotNull AVLSet<@NotNull String> kuerzel = new AVLSet<String>();
        for (Long idRaum : unterricht.raeume) {
            @NotNull StundenplanRaum raum = DeveloperNotificationException.ifMapGetIsNull(this._raum_by_id, idRaum);
            kuerzel.add(raum.kuerzel);
        }
        return StringUtils.collectionToCommaSeparatedString(kuerzel);
    }

    @NotNull
    public String unterrichtGetByIDStringOfSchienen(long idUnterricht) {
        @NotNull StundenplanUnterricht unterricht = DeveloperNotificationException.ifMapGetIsNull(this._unterricht_by_id, idUnterricht);
        @NotNull AVLSet<@NotNull String> kuerzel = new AVLSet<String>();
        for (Long idSchiene : unterricht.schienen) {
            @NotNull StundenplanSchiene schiene = DeveloperNotificationException.ifMapGetIsNull(this._schiene_by_id, idSchiene);
            kuerzel.add(schiene.bezeichnung);
        }
        return StringUtils.collectionToCommaSeparatedString(kuerzel);
    }

    @NotNull
    public String unterrichtGetByIDStringOfAll(long idUnterricht) {
        Object sLe = this.unterrichtGetByIDLehrerFirstAsStringOrEmpty(idUnterricht);
        Object sFa = this.unterrichtGetByIDStringOfFachOderKursKuerzel(idUnterricht);
        Object sKl = this.unterrichtGetByIDStringOfKlassen(idUnterricht);
        Object sRa = this.unterrichtGetByIDStringOfRaeume(idUnterricht);
        Object sSc = this.unterrichtGetByIDStringOfSchienen(idUnterricht);
        sLe = ((String)sLe).isEmpty() ? "" : ", " + (String)sLe;
        sFa = ((String)sFa).isEmpty() ? "" : ", " + (String)sFa;
        sKl = ((String)sKl).isEmpty() ? "" : ", " + (String)sKl;
        sRa = ((String)sRa).isEmpty() ? "" : ", " + (String)sRa;
        sSc = ((String)sSc).isEmpty() ? "" : ", " + (String)sSc;
        return idUnterricht + (String)sLe + (String)sFa + (String)sKl + (String)sRa + (String)sSc;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanLehrer> unterrichtGetByIDLehrerMenge(long idUnterricht) {
        return MapUtils.getOrCreateArrayList(this._lehrermenge_by_idUnterricht, idUnterricht);
    }

    @NotNull
    public String unterrichtGetByIDLehrerMengeAsString(long idUnterricht) {
        @NotNull List<@NotNull StundenplanLehrer> lehrkraefteDesUnterrichts = MapUtils.getOrCreateArrayList(this._lehrermenge_by_idUnterricht, idUnterricht);
        @NotNull ArrayList<@NotNull String> listeDerKuerzel = new ArrayList<String>();
        for (StundenplanLehrer lehkraft : lehrkraefteDesUnterrichts) {
            listeDerKuerzel.add(lehkraft.kuerzel);
        }
        return StringUtils.collectionToCommaSeparatedString(listeDerKuerzel);
    }

    public StundenplanLehrer unterrichtGetByIDLehrerFirstOrNull(long idUnterricht) {
        @NotNull List<@NotNull StundenplanLehrer> lehrerDesUnterrichts = MapUtils.getOrCreateArrayList(this._lehrermenge_by_idUnterricht, idUnterricht);
        return lehrerDesUnterrichts.isEmpty() ? null : DeveloperNotificationException.ifListGetFirstFailes("lehrerDesUnterrichts.first", lehrerDesUnterrichts);
    }

    @NotNull
    public String unterrichtGetByIDLehrerFirstAsStringOrEmpty(long idUnterricht) {
        StundenplanLehrer lehrkraft = this.unterrichtGetByIDLehrerFirstOrNull(idUnterricht);
        return lehrkraft == null ? "" : lehrkraft.kuerzel;
    }

    public boolean unterrichtHatMultiWochen() {
        return this._unterrichtHatMultiWochen;
    }

    public boolean unterrichtHatSchiene(@NotNull StundenplanUnterricht u, long idSchiene) {
        @NotNull List<@NotNull StundenplanSchiene> schienen = MapUtils.getOrCreateArrayList(this._schienenmenge_by_idUnterricht, u.id);
        if (idSchiene < 0L) {
            return schienen.isEmpty();
        }
        for (StundenplanSchiene schiene : schienen) {
            if (schiene.id != idSchiene) continue;
            return true;
        }
        return false;
    }

    public boolean unterrichtIstVerschiebenErlaubt(@NotNull StundenplanUnterricht u, @NotNull StundenplanZeitraster z) {
        for (StundenplanUnterricht partner : DeveloperNotificationException.ifMapGetIsNull(this._unterrichtmenge_by_idUnterricht, u.id)) {
            if (partner.idZeitraster != z.id || u.wochentyp != 0 && u.wochentyp != partner.wochentyp) continue;
            return false;
        }
        return true;
    }

    public void unterrichtPatchAttributes(@NotNull StundenplanUnterricht u) {
        this.unterrichtCheckAttributes(u);
        DeveloperNotificationException.ifMapRemoveFailes(this._unterricht_by_id, u.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._unterricht_by_id, u.id, u);
        this.update_all();
    }

    public void unterrichtPatchAttributesAll(@NotNull @NotNull List<@NotNull StundenplanUnterricht> list) {
        for (StundenplanUnterricht u : list) {
            this.unterrichtCheckAttributes(u);
        }
        for (StundenplanUnterricht u : list) {
            DeveloperNotificationException.ifMapRemoveFailes(this._unterricht_by_id, u.id);
            DeveloperNotificationException.ifMapPutOverwrites(this._unterricht_by_id, u.id, u);
        }
        this.update_all();
    }

    private void unterrichtRemoveByIdOhneUpdate(long idUnterricht) {
        DeveloperNotificationException.ifMapRemoveFailes(this._unterricht_by_id, idUnterricht);
    }

    public void unterrichtRemoveById(long idUnterricht) {
        this.unterrichtRemoveByIdOhneUpdate(idUnterricht);
        this.update_all();
    }

    public void unterrichtRemoveAll(@NotNull @NotNull List<@NotNull StundenplanUnterricht> listUnterricht) {
        for (StundenplanUnterricht unterricht : listUnterricht) {
            this.unterrichtRemoveByIdOhneUpdate(unterricht.id);
        }
        this.update_all();
    }

    @NotNull
    public @NotNull List<@NotNull String> unterrichtsstundeGetUhrzeitenAsStrings(int stunde) {
        String sUhrzeit;
        @NotNull ArrayList<@NotNull String> listUhrzeit = new ArrayList<String>();
        @NotNull ArrayList<@NotNull String> listWochentagVon = new ArrayList<String>();
        @NotNull ArrayList<@NotNull String> listWochentagBis = new ArrayList<String>();
        for (int wochentag = this._zeitrasterWochentagMin; wochentag <= this._zeitrasterWochentagMax; ++wochentag) {
            sUhrzeit = this.unterrichtsstundeGetUhrzeitAsString(wochentag, stunde);
            @NotNull String sWochentag = Wochentag.fromIDorException((int)wochentag).kuerzel;
            if (listUhrzeit.isEmpty()) {
                listUhrzeit.add(sUhrzeit);
                listWochentagVon.add(sWochentag);
                listWochentagBis.add(sWochentag);
                continue;
            }
            @NotNull String sUhrzeitDavor = DeveloperNotificationException.ifListGetLastFailes("listUhrzeit", listUhrzeit);
            if (sUhrzeitDavor.equals(sUhrzeit)) {
                listWochentagBis.set(listWochentagBis.size() - 1, sWochentag);
                continue;
            }
            listUhrzeit.add(sUhrzeit);
            listWochentagVon.add(sWochentag);
            listWochentagBis.add(sWochentag);
        }
        if (listUhrzeit.size() <= 1) {
            return listUhrzeit;
        }
        for (int i = 0; i < listUhrzeit.size(); ++i) {
            String sWochentagBis;
            sUhrzeit = (String)listUhrzeit.get(i);
            @NotNull String sWochentagVon = (String)listWochentagVon.get(i);
            if (sWochentagVon.equals(sWochentagBis = (String)listWochentagBis.get(i))) {
                listUhrzeit.set(i, sWochentagVon + " " + sUhrzeit);
                continue;
            }
            listUhrzeit.set(i, sWochentagVon + "\u2013" + sWochentagBis + " " + sUhrzeit);
        }
        return listUhrzeit;
    }

    @NotNull
    private String unterrichtsstundeGetUhrzeitAsString(int wochentag, int stunde) {
        StundenplanZeitraster zeitraster = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (zeitraster == null) {
            return "???";
        }
        @NotNull String sBeginn = zeitraster.stundenbeginn == null ? "??:??" : DateUtils.getStringOfUhrzeitFromMinuten(zeitraster.stundenbeginn);
        @NotNull String sEnde = zeitraster.stundenende == null ? "??:??" : DateUtils.getStringOfUhrzeitFromMinuten(zeitraster.stundenende);
        return sBeginn + "\u2013" + sEnde + " Uhr";
    }

    private void zeitrasterAddAllOhneUpdate(@NotNull @NotNull List<@NotNull StundenplanZeitraster> list) {
        @NotNull HashSet<@NotNull Long> setOfIDs = new HashSet<Long>();
        @NotNull HashSet<@NotNull CallSite> setOfWochentagStunde = new HashSet<CallSite>();
        for (StundenplanZeitraster z : list) {
            StundenplanManager.zeitrasterCheck(z);
            DeveloperNotificationException.ifTrue("zeitrasterAddAllOhneUpdate: ID=" + z.id + " existiert bereits!", this._zeitraster_by_id.containsKey(z.id));
            DeveloperNotificationException.ifTrue("zeitrasterAddAllOhneUpdate: WOCHENTAG=" + z.wochentag + ", STUNDE=" + z.unterrichtstunde + " existiert bereits!", this._zeitraster_by_wochentag_and_stunde.contains(z.wochentag, z.unterrichtstunde));
            DeveloperNotificationException.ifTrue("zeitrasterAddAllOhneUpdate: ID=" + z.id + " doppelt in der Liste!", !setOfIDs.add(z.id));
            DeveloperNotificationException.ifTrue("zeitrasterAddAllOhneUpdate: WOCHENTAG=" + z.wochentag + ", STUNDE= doppelt in der Liste!", !setOfWochentagStunde.add((CallSite)((Object)(z.wochentag + ";" + z.unterrichtstunde))));
        }
        for (StundenplanZeitraster z : list) {
            DeveloperNotificationException.ifMapPutOverwrites(this._zeitraster_by_id, z.id, z);
        }
    }

    public void zeitrasterAdd(@NotNull StundenplanZeitraster zeitraster) {
        this.zeitrasterAddAll(ListUtils.create1(zeitraster));
    }

    public void zeitrasterAddAll(@NotNull @NotNull List<@NotNull StundenplanZeitraster> listZeitraster) {
        this.zeitrasterAddAllOhneUpdate(listZeitraster);
        this.update_all();
    }

    private static void zeitrasterCheck(@NotNull StundenplanZeitraster zeitraster) {
        DeveloperNotificationException.ifInvalidID("zeitraster.id", zeitraster.id);
        Wochentag.fromIDorException(zeitraster.wochentag);
        DeveloperNotificationException.ifTrue("(zeit.unterrichtstunde < 0) || (zeit.unterrichtstunde > 29)", zeitraster.unterrichtstunde < 0 || zeitraster.unterrichtstunde > 29);
        if (zeitraster.stundenbeginn != null && zeitraster.stundenende != null) {
            int ende;
            int beginn = zeitraster.stundenbeginn;
            DeveloperNotificationException.ifTrue("beginn >= ende", beginn >= (ende = zeitraster.stundenende.intValue()));
        }
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanZeitraster> getListZeitraster() {
        return this._zeitrastermenge;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanZeitraster> zeitrasterGetDummyListe(int tagVon, int tagBis, int stundeVon, int stundeBis) {
        @NotNull ArrayList<@NotNull StundenplanZeitraster> listDummies = new ArrayList<StundenplanZeitraster>();
        for (int wochentag = tagVon; wochentag <= tagBis; ++wochentag) {
            for (int stunde = stundeVon; stunde <= stundeBis; ++stunde) {
                if (this._zeitraster_by_wochentag_and_stunde.contains(wochentag, stunde)) continue;
                @NotNull StundenplanZeitraster zeit = new StundenplanZeitraster();
                zeit.id = -1L;
                zeit.wochentag = wochentag;
                zeit.unterrichtstunde = stunde;
                zeit.stundenbeginn = this.zeitrasterGetDefaultStundenbeginnByStunde(stunde);
                zeit.stundenende = this.zeitrasterGetDefaultStundenendeByStunde(stunde);
                listDummies.add(zeit);
            }
        }
        return listDummies;
    }

    public int zeitrasterGetDefaultStundenbeginnByStunde(int stunde) {
        return 480 + (stunde - 1) * 50;
    }

    public int zeitrasterGetDefaultStundenendeByStunde(int stunde) {
        return this.zeitrasterGetDefaultStundenbeginnByStunde(stunde) + 45;
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanZeitraster> getListZeitrasterZuWochentag(@NotNull Wochentag wochentag) {
        return CollectionUtils.toFilteredArrayList(this._zeitrastermenge, z -> wochentag.id == z.wochentag);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanZeitraster> getListZeitrasterZuStunde(int unterrichtstunde) {
        return CollectionUtils.toFilteredArrayList(this._zeitrastermenge, z -> unterrichtstunde == z.unterrichtstunde);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanZeitraster> getZeitrasterByStartVerstrichen(@NotNull StundenplanZeitraster zeitrasterStart, int minutenVerstrichen) {
        Wochentag wochentag = Wochentag.fromIDorException(zeitrasterStart.wochentag);
        int startzeit = DeveloperNotificationException.ifNull("zeitrasterStart.stundenbeginn ist NULL", zeitrasterStart.stundenbeginn);
        return this.getZeitrasterByWochentagStartVerstrichen(wochentag, startzeit, minutenVerstrichen);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanZeitraster> getZeitrasterByWochentagStartVerstrichen(@NotNull Wochentag wochentag, int beginn, int minutenVerstrichen) {
        int ende = beginn + minutenVerstrichen;
        return CollectionUtils.toFilteredArrayList(this._zeitrastermenge, z -> wochentag.id == z.wochentag && this.zeitrasterGetSchneidenSich(beginn, ende, z.stundenbeginn, z.stundenende));
    }

    @NotNull
    public StundenplanZeitraster getZeitrasterNext(@NotNull StundenplanZeitraster zeitraster) {
        return this._zeitraster_by_wochentag_and_stunde.getNonNullOrException(zeitraster.wochentag, zeitraster.unterrichtstunde + 1);
    }

    public int zeitrasterGetMinutenMin() {
        return this._zeitrasterMinutenMin == null ? 480 : this._zeitrasterMinutenMin;
    }

    public int zeitrasterGetMinutenMinDerStunde(int stunde) {
        Integer min = this._zeitrasterMinutenMinByStunde.get(stunde);
        return min == null ? 480 : min;
    }

    public int zeitrasterGetMinutenMax() {
        return this._zeitrasterMinutenMax == null ? 480 : this._zeitrasterMinutenMax;
    }

    public int zeitrasterGetMinutenMaxDerStunde(int stunde) {
        Integer max = this._zeitrasterMinutenMaxByStunde.get(stunde);
        return max == null ? 480 : max;
    }

    public int zeitrasterGetStundeMin() {
        return this._zeitrasterStundeMin;
    }

    public int zeitrasterGetStundeMinOhneLeere() {
        return this._zeitrasterStundeMinOhneLeere;
    }

    public int zeitrasterGetStundeMax() {
        return this._zeitrasterStundeMax;
    }

    public int zeitrasterGetStundeMaxOhneLeere() {
        return this._zeitrasterStundeMaxOhneLeere;
    }

    public int zeitrasterGetWochentagMin() {
        return this._zeitrasterWochentagMin;
    }

    @NotNull
    public Wochentag zeitrasterGetWochentagMinEnum() {
        return Wochentag.fromIDorException(this._zeitrasterWochentagMin);
    }

    public int zeitrasterGetWochentagMax() {
        return this._zeitrasterWochentagMax;
    }

    @NotNull
    public Wochentag zeitrasterGetWochentagMaxEnum() {
        return Wochentag.fromIDorException(this._zeitrasterWochentagMax);
    }

    @NotNull
    public StundenplanZeitraster zeitrasterGetByIdOrException(long idZeitraster) {
        return DeveloperNotificationException.ifMapGetIsNull(this._zeitraster_by_id, idZeitraster);
    }

    @NotNull
    public String zeitrasterGetByIdStringOfUhrzeitBeginn(long idZeitraster) {
        @NotNull StundenplanZeitraster zeitraster = DeveloperNotificationException.ifMapGetIsNull(this._zeitraster_by_id, idZeitraster);
        return zeitraster.stundenbeginn == null ? "" : DateUtils.getStringOfUhrzeitFromMinuten(zeitraster.stundenbeginn);
    }

    @NotNull
    public String zeitrasterGetByIdStringOfUhrzeitEnde(long idZeitraster) {
        @NotNull StundenplanZeitraster zeitraster = DeveloperNotificationException.ifMapGetIsNull(this._zeitraster_by_id, idZeitraster);
        return zeitraster.stundenende == null ? "" : DateUtils.getStringOfUhrzeitFromMinuten(zeitraster.stundenende);
    }

    @NotNull
    public StundenplanZeitraster zeitrasterGetByWochentagAndStundeOrException(int wochentag, int stunde) {
        return this._zeitraster_by_wochentag_and_stunde.getNonNullOrException(wochentag, stunde);
    }

    public StundenplanZeitraster zeitrasterGetByWochentagAndStundeOrNull(int wochentag, int stunde) {
        return this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
    }

    public boolean zeitrasterGetSchneidenSich(int beginn1, int ende1, Integer iBeginn2, Integer iEnde2) {
        int beginn2 = DeveloperNotificationException.ifNull("zeitraster.stundenbeginn ist NULL!", iBeginn2);
        int ende2 = DeveloperNotificationException.ifNull("zeitraster.stundenende ist NULL!", iEnde2);
        DeveloperNotificationException.ifTrue("beginn1 < 0", beginn1 < 0);
        DeveloperNotificationException.ifTrue("beginn2 < 0", beginn2 < 0);
        DeveloperNotificationException.ifTrue("beginn1 > ende1", beginn1 > ende1);
        DeveloperNotificationException.ifTrue("beginn2 > ende2", beginn2 > ende2);
        return ende1 >= beginn2 && ende2 >= beginn1;
    }

    @NotNull
    public @NotNull int @NotNull [] zeitrasterGetStundenRange() {
        return this._zeitrasterStundenRange;
    }

    @NotNull
    public @NotNull int @NotNull [] zeitrasterGetStundenRangeOhneLeere() {
        return this._zeitrasterStundenRangeOhneLeere;
    }

    @NotNull
    public @NotNull Wochentag @NotNull [] zeitrasterGetWochentageAlsEnumRange() {
        return this._zeitrasterWochentageAlsEnumRange;
    }

    public boolean zeitrasterHatUnterrichtByWochentagAndStundeAndWochentyp(@NotNull Wochentag wochentag, int stunde, int wochentyp) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag.id, stunde);
        if (z != null) {
            return !Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idZeitraster_and_wochentyp, z.id, wochentyp).isEmpty();
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtByKlasseIdWochentagAndStundeAndWochentyp(long idKlasse, int wochentag, int stunde, int wochentyp) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idKlasse_and_idZeitraster, idKlasse, z.id)) {
                if (u.wochentyp != wochentyp) continue;
                return true;
            }
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtByLehrerIdWochentagAndStundeAndWochentyp(long idLehrer, int wochentag, int stunde, int wochentyp) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idLehrer_and_idZeitraster, idLehrer, z.id)) {
                if (u.wochentyp != wochentyp) continue;
                return true;
            }
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtBySchuelerIdWochentagAndStundeAndWochentyp(long idSchueler, int wochentag, int stunde, int wochentyp) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idSchueler_and_idZeitraster, idSchueler, z.id)) {
                if (u.wochentyp != wochentyp) continue;
                return true;
            }
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtByJahrgangIdWochentagAndStundeAndWochentyp(long idJahrgang, int wochentag, int stunde, int wochentyp) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idJahrgang_and_idZeitraster, idJahrgang, z.id)) {
                if (u.wochentyp != wochentyp) continue;
                return true;
            }
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp0(long idZeitraster) {
        return !Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idZeitraster_and_wochentyp, idZeitraster, 0).isEmpty();
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp0ByWochentagAndStunde(@NotNull Wochentag wochentag, int stunde) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag.id, stunde);
        return z != null && this.zeitrasterHatUnterrichtMitWochentyp0(z.id);
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp0ByKlasseIdWochentagAndStunde(long idKlasse, int wochentag, int stunde) {
        return this.zeitrasterHatUnterrichtByKlasseIdWochentagAndStundeAndWochentyp(idKlasse, wochentag, stunde, 0);
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp0ByLehrerIdWochentagAndStunde(long idLehrer, int wochentag, int stunde) {
        return this.zeitrasterHatUnterrichtByLehrerIdWochentagAndStundeAndWochentyp(idLehrer, wochentag, stunde, 0);
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp0BySchuelerIdWochentagAndStunde(long idSchueler, int wochentag, int stunde) {
        return this.zeitrasterHatUnterrichtBySchuelerIdWochentagAndStundeAndWochentyp(idSchueler, wochentag, stunde, 0);
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp0ByJahrgangIdWochentagAndStunde(long idJahrgang, int wochentag, int stunde) {
        return this.zeitrasterHatUnterrichtByJahrgangIdWochentagAndStundeAndWochentyp(idJahrgang, wochentag, stunde, 0);
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp1BisN(long idZeitraster) {
        for (int wochentyp = 1; wochentyp <= this._stundenplanWochenTypModell; ++wochentyp) {
            if (Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idZeitraster_and_wochentyp, idZeitraster, wochentyp).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp1BisNByWochentagAndStunde(@NotNull Wochentag wochentag, int stunde) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag.id, stunde);
        return z != null && this.zeitrasterHatUnterrichtMitWochentyp1BisN(z.id);
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp1BisNByKlasseIdWochentagAndStunde(long idKlasse, int wochentag, int stunde) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idKlasse_and_idZeitraster, idKlasse, z.id)) {
                if (u.wochentyp < 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp1BisNByLehrerIdWochentagAndStunde(long idLehrer, int wochentag, int stunde) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idLehrer_and_idZeitraster, idLehrer, z.id)) {
                if (u.wochentyp < 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp1BisNBySchuelerIdWochentagAndStunde(long idSchueler, int wochentag, int stunde) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idSchueler_and_idZeitraster, idSchueler, z.id)) {
                if (u.wochentyp < 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean zeitrasterHatUnterrichtMitWochentyp1BisNByJahrgangIdWochentagAndStunde(long idJahrgang, int wochentag, int stunde) {
        StundenplanZeitraster z = this._zeitraster_by_wochentag_and_stunde.getOrNull(wochentag, stunde);
        if (z != null) {
            for (StundenplanUnterricht u : Map2DUtils.getOrCreateArrayList(this._unterrichtmenge_by_idJahrgang_and_idZeitraster, idJahrgang, z.id)) {
                if (u.wochentyp < 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean zeitrasterExistsByWochentagAndStunde(int wochentag, int stunde) {
        return this._zeitraster_by_wochentag_and_stunde.contains(wochentag, stunde);
    }

    public boolean zeitrasterExistsByWochentag(int wochentag) {
        return !MapUtils.getOrCreateArrayList(this._zeitrastermenge_by_wochentag, wochentag).isEmpty();
    }

    public void zeitrasterPatchAttributes(@NotNull StundenplanZeitraster zeitraster) {
        this.zeitrasterPatchAttributesAll(ListUtils.create1(zeitraster));
    }

    public void zeitrasterPatchAttributesAll(@NotNull @NotNull List<@NotNull StundenplanZeitraster> zeitrasterList) {
        @NotNull HashMap2D<@NotNull K1, @NotNull K2, @NotNull V> mapWochentagStunde = new HashMap2D();
        for (StundenplanZeitraster z : zeitrasterList) {
            StundenplanManager.zeitrasterCheck(z);
            DeveloperNotificationException.ifMapNotContains("_zeitraster_by_id", this._zeitraster_by_id, z.id);
            DeveloperNotificationException.ifMap2DPutOverwrites(mapWochentagStunde, z.wochentag, z.unterrichtstunde, z);
        }
        for (StundenplanZeitraster z : zeitrasterList) {
            DeveloperNotificationException.ifMapRemoveFailes(this._zeitraster_by_id, z.id);
            DeveloperNotificationException.ifMapPutOverwrites(this._zeitraster_by_id, z.id, z);
        }
        this.update_all();
    }

    private void zeitrasterRemoveOhneUpdate(long idZeitraster) {
        for (StundenplanUnterricht u : MapUtils.getOrCreateArrayList(this._unterrichtmenge_by_idZeitraster, idZeitraster)) {
            this.unterrichtRemoveByIdOhneUpdate(u.id);
        }
        DeveloperNotificationException.ifMapRemoveFailes(this._zeitraster_by_id, idZeitraster);
    }

    public void zeitrasterRemoveById(long idZeitraster) {
        this.zeitrasterRemoveOhneUpdate(idZeitraster);
        this.update_all();
    }

    public void zeitrasterRemoveAll(@NotNull @NotNull List<@NotNull StundenplanZeitraster> listZeitraster) {
        for (StundenplanZeitraster zeitraster : listZeitraster) {
            this.zeitrasterRemoveOhneUpdate(zeitraster.id);
        }
        this.update_all();
    }

    public void zeitrasterRemoveAllByWochentag(int wochentagEnumID) {
        this.zeitrasterRemoveAll(MapUtils.getOrCreateArrayList(this._zeitrastermenge_by_wochentag, wochentagEnumID));
    }
}

