/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.stundenplanblockung;

import de.svws_nrw.core.utils.stundenplanblockung.StundenplanblockungManagerKlasse;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class StundenplanblockungManagerKlasseMenge {
    @NotNull
    private final @NotNull List<@NotNull StundenplanblockungManagerKlasse> _menge = new ArrayList<StundenplanblockungManagerKlasse>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull StundenplanblockungManagerKlasse> _map = new HashMap<Long, StundenplanblockungManagerKlasse>();

    public void addOrException(long pKlasseID, @NotNull String pKuerzel) throws NullPointerException {
        if (this._map.containsKey(pKlasseID)) {
            throw new NullPointerException("Die Klasse-ID " + pKlasseID + " existiert bereits!");
        }
        StundenplanblockungManagerKlasse kl = new StundenplanblockungManagerKlasse(pKlasseID, pKuerzel);
        this._map.put(pKlasseID, kl);
        this._menge.add(kl);
    }

    @NotNull
    public StundenplanblockungManagerKlasse getOrException(long pKlasseID) throws NullPointerException {
        StundenplanblockungManagerKlasse klasse = this._map.get(pKlasseID);
        if (klasse == null) {
            throw new NullPointerException("Klasse-ID " + pKlasseID + " unbekannt!");
        }
        return klasse;
    }

    @NotNull
    public StundenplanblockungManagerKlasse getRandomOrException(@NotNull Random pRandom) {
        int size = this._menge.size();
        if (size <= 0) {
            throw new NullPointerException("Es gibt keine Klassen!");
        }
        return this._menge.get(pRandom.nextInt(size));
    }

    public void removeOrException(long pKlasseID) throws NullPointerException {
        @NotNull StundenplanblockungManagerKlasse klasse = this.getOrException(pKlasseID);
        this._map.remove(pKlasseID);
        this._menge.remove(klasse);
    }

    public boolean exists(long pKlasseID) {
        return this._map.containsKey(pKlasseID);
    }

    public List<StundenplanblockungManagerKlasse> getMenge() {
        return this._menge;
    }

    public int size() {
        return this._menge.size();
    }
}

