/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.stundenplanblockung;

import de.svws_nrw.core.utils.stundenplanblockung.StundenplanblockungManagerKopplung;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class StundenplanblockungManagerKopplungMenge {
    @NotNull
    private final @NotNull List<@NotNull StundenplanblockungManagerKopplung> _menge = new ArrayList<StundenplanblockungManagerKopplung>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull StundenplanblockungManagerKopplung> _map = new HashMap<Long, StundenplanblockungManagerKopplung>();

    public void addOrException(long pKopplungID, @NotNull String pKuerzel) throws NullPointerException {
        if (this._map.containsKey(pKopplungID)) {
            throw new NullPointerException("Die Kopplung-ID " + pKopplungID + " existiert bereits!");
        }
        StundenplanblockungManagerKopplung ko = new StundenplanblockungManagerKopplung(pKopplungID, pKuerzel);
        this._map.put(pKopplungID, ko);
        this._menge.add(ko);
    }

    @NotNull
    public StundenplanblockungManagerKopplung getOrException(long pKopplungID) throws NullPointerException {
        StundenplanblockungManagerKopplung ko = this._map.get(pKopplungID);
        if (ko == null) {
            throw new NullPointerException("Kopplung-ID " + pKopplungID + " unbekannt!");
        }
        return ko;
    }

    @NotNull
    public StundenplanblockungManagerKopplung getRandomOrException(@NotNull Random pRandom) {
        int size = this._menge.size();
        if (size <= 0) {
            throw new NullPointerException("Es gibt keine Kopplungen!");
        }
        return this._menge.get(pRandom.nextInt(size));
    }

    public void removeOrException(long pKopplungID) throws NullPointerException {
        @NotNull StundenplanblockungManagerKopplung ko = this.getOrException(pKopplungID);
        this._map.remove(pKopplungID);
        this._menge.remove(ko);
    }

    public boolean exists(long pKopplungID) {
        return this._map.containsKey(pKopplungID);
    }

    public List<StundenplanblockungManagerKopplung> getMenge() {
        return this._menge;
    }

    public int size() {
        return this._menge.size();
    }
}

