/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.stundenplanblockung;

import de.svws_nrw.core.utils.stundenplanblockung.StundenplanblockungManagerLehrkraft;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class StundenplanblockungManagerLehrkraftMenge {
    @NotNull
    private final @NotNull List<@NotNull StundenplanblockungManagerLehrkraft> _menge = new ArrayList<StundenplanblockungManagerLehrkraft>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull StundenplanblockungManagerLehrkraft> _map = new HashMap<Long, StundenplanblockungManagerLehrkraft>();

    public void addOrException(long pLehrkraftID, @NotNull String pKuerzel) throws NullPointerException {
        if (this._map.containsKey(pLehrkraftID)) {
            throw new NullPointerException("Die Lehrkraft-ID " + pLehrkraftID + " existiert bereits!");
        }
        StundenplanblockungManagerLehrkraft le = new StundenplanblockungManagerLehrkraft(pLehrkraftID, pKuerzel);
        this._map.put(pLehrkraftID, le);
        this._menge.add(le);
    }

    @NotNull
    public StundenplanblockungManagerLehrkraft getOrException(long pLehrkraftID) throws NullPointerException {
        StundenplanblockungManagerLehrkraft lehrkraft = this._map.get(pLehrkraftID);
        if (lehrkraft == null) {
            throw new NullPointerException("Lehrkraft-ID " + pLehrkraftID + " unbekannt!");
        }
        return lehrkraft;
    }

    @NotNull
    public StundenplanblockungManagerLehrkraft getRandomOrException(@NotNull Random pRandom) {
        int size = this._menge.size();
        if (size <= 0) {
            throw new NullPointerException("Es gibt keine Lehrkr\u00e4fte!");
        }
        return this._menge.get(pRandom.nextInt(size));
    }

    public void removeOrException(long pLehrkraftID) throws NullPointerException {
        @NotNull StundenplanblockungManagerLehrkraft lehrkraft = this.getOrException(pLehrkraftID);
        this._map.remove(pLehrkraftID);
        this._menge.remove(lehrkraft);
    }

    public boolean exists(long pLehrkraftID) {
        return this._map.containsKey(pLehrkraftID);
    }

    public List<StundenplanblockungManagerLehrkraft> getMenge() {
        return this._menge;
    }

    public int size() {
        return this._menge.size();
    }
}

