/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.stundenplanblockung;

import de.svws_nrw.core.utils.stundenplanblockung.StundenplanblockungManagerLerngruppe;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class StundenplanblockungManagerLerngruppeMenge {
    @NotNull
    private final @NotNull List<@NotNull StundenplanblockungManagerLerngruppe> _menge = new ArrayList<StundenplanblockungManagerLerngruppe>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull StundenplanblockungManagerLerngruppe> _map = new HashMap<Long, StundenplanblockungManagerLerngruppe>();

    @NotNull
    public StundenplanblockungManagerLerngruppe createOrException(long pLerngruppeID) throws NullPointerException {
        if (this._map.containsKey(pLerngruppeID)) {
            throw new NullPointerException("Die Lerngruppe-ID " + pLerngruppeID + " existiert bereits!");
        }
        StundenplanblockungManagerLerngruppe gr = new StundenplanblockungManagerLerngruppe(pLerngruppeID);
        this._map.put(pLerngruppeID, gr);
        this._menge.add(gr);
        return gr;
    }

    @NotNull
    public StundenplanblockungManagerLerngruppe getOrException(long pLerngruppeID) throws NullPointerException {
        StundenplanblockungManagerLerngruppe gr = this._map.get(pLerngruppeID);
        if (gr == null) {
            throw new NullPointerException("Lerngruppe-ID " + pLerngruppeID + " unbekannt!");
        }
        return gr;
    }

    @NotNull
    public StundenplanblockungManagerLerngruppe getRandomOrException(@NotNull Random pRandom) {
        int size = this._menge.size();
        if (size <= 0) {
            throw new NullPointerException("Es gibt keine Lerngruppen!");
        }
        return this._menge.get(pRandom.nextInt(size));
    }

    public void removeOrException(long pLerngruppeID) throws NullPointerException {
        @NotNull StundenplanblockungManagerLerngruppe gr = this.getOrException(pLerngruppeID);
        this._map.remove(pLerngruppeID);
        this._menge.remove(gr);
    }

    public List<StundenplanblockungManagerLerngruppe> getMenge() {
        return this._menge;
    }

    public boolean exists(long pRaumID) {
        return this._map.containsKey(pRaumID);
    }

    public int size() {
        return this._menge.size();
    }
}

