/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.stundenplanblockung;

import de.svws_nrw.core.utils.stundenplanblockung.StundenplanblockungManagerRaum;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class StundenplanblockungManagerRaumMenge {
    @NotNull
    private final @NotNull List<@NotNull StundenplanblockungManagerRaum> _menge = new ArrayList<StundenplanblockungManagerRaum>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull StundenplanblockungManagerRaum> _map = new HashMap<Long, StundenplanblockungManagerRaum>();

    public void addOrException(long pRaumID, @NotNull String pKuerzel) throws NullPointerException {
        if (this._map.containsKey(pRaumID)) {
            throw new NullPointerException("Die Raum-ID " + pRaumID + " existiert bereits!");
        }
        @NotNull StundenplanblockungManagerRaum ra = new StundenplanblockungManagerRaum(pRaumID, pKuerzel);
        this._map.put(pRaumID, ra);
        this._menge.add(ra);
    }

    @NotNull
    public StundenplanblockungManagerRaum getOrException(long pRaumID) throws NullPointerException {
        StundenplanblockungManagerRaum ra = this._map.get(pRaumID);
        if (ra == null) {
            throw new NullPointerException("Raum-ID " + pRaumID + " unbekannt!");
        }
        return ra;
    }

    @NotNull
    public StundenplanblockungManagerRaum getRandomOrException(@NotNull Random pRandom) {
        int size = this._menge.size();
        if (size <= 0) {
            throw new NullPointerException("Es gibt keine R\u00e4ume!");
        }
        return this._menge.get(pRandom.nextInt(size));
    }

    public void removeOrException(long pRaumID) throws NullPointerException {
        @NotNull StundenplanblockungManagerRaum ra = this.getOrException(pRaumID);
        this._map.remove(pRaumID);
        this._menge.remove(ra);
    }

    public List<StundenplanblockungManagerRaum> getMenge() {
        return this._menge;
    }

    public boolean exists(long pRaumID) {
        return this._map.containsKey(pRaumID);
    }

    public int size() {
        return this._menge.size();
    }
}

