/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon;

import de.taimos.daemon.IDaemonLifecycleListener;
import de.taimos.daemon.LifecyclePhase;
import de.taimos.daemon.properties.ConfigServerPropertyProvider;
import de.taimos.daemon.properties.EmptyPropertyProvider;
import de.taimos.daemon.properties.FilePropertyProvider;
import de.taimos.daemon.properties.IPropertyProvider;
import de.taimos.daemon.properties.SimpleHTTPPropertyProvider;
import de.taimos.daemon.properties.UserDataPropertyProvider;
import java.util.Map;

public class DaemonLifecycleAdapter
implements IDaemonLifecycleListener {
    @Override
    public void doStart() throws Exception {
    }

    @Override
    public void doStop() throws Exception {
    }

    @Override
    public void started() {
    }

    @Override
    public void stopped() {
    }

    @Override
    public void stopping() {
    }

    @Override
    public void aborting() {
    }

    @Override
    public void signalUSR2() {
    }

    @Override
    public void exception(LifecyclePhase phase, Throwable exception) {
        System.err.println("Exception in phase: " + phase.name());
        exception.printStackTrace();
    }

    @Override
    public Map<String, String> loadProperties() {
        return this.getPropertyProvider().loadProperties();
    }

    public IPropertyProvider getPropertyProvider() {
        switch (System.getProperty("property.source", "")) {
            case "aws": {
                return new UserDataPropertyProvider();
            }
            case "file": {
                return new FilePropertyProvider(System.getProperty("property.location"));
            }
            case "cs": {
                return new ConfigServerPropertyProvider(System.getProperty("property.server"), System.getProperty("property.template"));
            }
            case "http": {
                return new SimpleHTTPPropertyProvider(System.getProperty("property.location"));
            }
        }
        return new EmptyPropertyProvider();
    }
}

