/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon.log4j;

import de.taimos.daemon.DaemonStarter;
import de.taimos.daemon.ILoggingConfigurer;
import de.taimos.daemon.log4j.JSONLayout;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;

public class Log4jLoggingConfigurer
implements ILoggingConfigurer {
    private static final String DEFAULT_PATTERN = "%d{HH:mm:ss,SSS} %-5p %c %x - %m%n";
    private static final String FALSE_STRING = "false";
    private final Logger rlog = Logger.getRootLogger();
    private SyslogAppender syslog;
    private DailyRollingFileAppender darofi;
    private ConsoleAppender console;

    @Override
    public void initializeLogging() throws Exception {
        this.rlog.removeAllAppenders();
        this.rlog.setLevel(Level.INFO);
        this.console = new ConsoleAppender();
        this.console.setName("CONSOLE");
        this.console.setLayout((Layout)new PatternLayout(DEFAULT_PATTERN));
        this.console.setTarget("System.out");
        this.console.activateOptions();
        this.rlog.addAppender((Appender)this.console);
        if (!DaemonStarter.isDevelopmentMode()) {
            this.darofi = new DailyRollingFileAppender();
            this.darofi.setName("DAROFI");
            this.darofi.setLayout((Layout)new PatternLayout(DEFAULT_PATTERN));
            this.darofi.setFile("log/" + DaemonStarter.getDaemonName() + ".log");
            this.darofi.setDatePattern("'.'yyyy-MM-dd");
            this.darofi.setAppend(true);
            this.darofi.setThreshold((Priority)Level.INFO);
            this.darofi.activateOptions();
            this.rlog.addAppender((Appender)this.darofi);
            this.syslog = new SyslogAppender();
            this.syslog.setName("SYSLOG");
            this.syslog.setLayout((Layout)new PatternLayout(DaemonStarter.getDaemonName() + ": %-5p %c %x - %m%n"));
            this.syslog.setSyslogHost("localhost");
            this.syslog.setFacility("LOCAL0");
            this.syslog.setFacilityPrinting(false);
            this.syslog.setThreshold((Priority)Level.INFO);
            this.syslog.activateOptions();
            this.rlog.addAppender((Appender)this.syslog);
        }
    }

    @Override
    public void reconfigureLogging() throws Exception {
        Level logLevel = Level.toLevel((String)DaemonStarter.getDaemonProperties().getProperty("logger.level"), (Level)Level.INFO);
        this.rlog.setLevel(logLevel);
        this.rlog.info((Object)String.format("Changed the the log level to %s", logLevel));
        this.console.setLayout(this.getLayout());
        this.console.setThreshold((Priority)logLevel);
        this.console.activateOptions();
        if (!DaemonStarter.isDevelopmentMode()) {
            String fileEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.file", FALSE_STRING);
            String syslogEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.syslog", FALSE_STRING);
            if (fileEnabled == null || fileEnabled.equals(FALSE_STRING)) {
                this.rlog.removeAppender((Appender)this.darofi);
                this.darofi = null;
                this.rlog.info((Object)"Deactivated the FILE Appender");
            } else {
                this.darofi.setThreshold((Priority)logLevel);
                this.darofi.setLayout(this.getLayout());
                this.darofi.activateOptions();
            }
            if (syslogEnabled == null || syslogEnabled.equals(FALSE_STRING)) {
                this.rlog.removeAppender((Appender)this.syslog);
                this.syslog = null;
                this.rlog.info((Object)"Deactivated the SYSLOG Appender");
            } else {
                String host = DaemonStarter.getDaemonProperties().getProperty("syslog.host", "localhost");
                String facility = DaemonStarter.getDaemonProperties().getProperty("syslog.facility", "LOCAL0");
                Level syslogLevel = Level.toLevel((String)DaemonStarter.getDaemonProperties().getProperty("syslog.level"), (Level)Level.INFO);
                this.syslog.setSyslogHost(host);
                this.syslog.setFacility(facility);
                this.syslog.setThreshold((Priority)syslogLevel);
                this.syslog.activateOptions();
                this.rlog.info((Object)String.format("Changed the SYSLOG Appender to host %s and facility %s", host, facility));
            }
        }
    }

    private Layout getLayout() {
        String logLayout;
        switch (logLayout = System.getProperty("logger.layout", "pattern")) {
            case "json": {
                return new JSONLayout();
            }
        }
        String logPattern = System.getProperty("logger.pattern", DEFAULT_PATTERN);
        return new PatternLayout(logPattern);
    }

    @Override
    public void simpleLogging() throws Exception {
        this.rlog.removeAllAppenders();
        Level logLevel = Level.toLevel((String)System.getProperty("logger.level"), (Level)Level.INFO);
        this.rlog.setLevel(logLevel);
        this.console = new ConsoleAppender();
        this.console.setName("CONSOLE");
        this.console.setLayout((Layout)new PatternLayout(DEFAULT_PATTERN));
        this.console.setTarget("System.out");
        this.console.activateOptions();
        this.rlog.addAppender((Appender)this.console);
    }

    public static void setup() {
        System.setProperty("loggerConfigurer", Log4jLoggingConfigurer.class.getCanonicalName());
    }
}

