/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public abstract class SpringTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AbstractXmlApplicationContext context;

    public AbstractXmlApplicationContext getContext() {
        return this.context;
    }

    public void start() {
        try {
            this.doBeforeSpringStart();
        }
        catch (Exception e) {
            this.logger.error("Before spring failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.context = this.createSpringContext();
            String[] profiles = System.getProperty("profiles", "test").split(",");
            this.context.getEnvironment().setActiveProfiles(profiles);
            PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
            configurer.setProperties(this.loadProperties());
            this.context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            this.context.setConfigLocation(this.getSpringResource());
            this.context.refresh();
        }
        catch (Exception e) {
            this.logger.error("Spring context failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.doAfterSpringStart();
        }
        catch (Exception e) {
            this.logger.error("After spring failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void doAfterSpringStart() {
    }

    protected void doBeforeSpringStart() {
    }

    protected void doAfterSpringStop() {
    }

    protected void doBeforeSpringStop() {
    }

    protected AbstractXmlApplicationContext createSpringContext() {
        return new ClassPathXmlApplicationContext();
    }

    protected String getSpringResource() {
        return "spring-test/beans.xml";
    }

    public void stop() {
        try {
            this.doBeforeSpringStop();
        }
        catch (Exception e) {
            this.logger.error("Before spring stop failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.context.stop();
            this.context.close();
        }
        catch (Exception e) {
            this.logger.error("spring stop failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.doAfterSpringStop();
        }
        catch (Exception e) {
            this.logger.error("After spring stop failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Properties loadProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("serviceName", this.getServiceName());
        this.fillProperties(props);
        if (!props.containsKey("servicePackage")) {
            props.put("servicePackage", this.getClass().getPackage().getName());
        }
        Properties properties = new Properties();
        for (Map.Entry entry : props.entrySet()) {
            this.logger.info("Setting property: '{}' with value '{}'", entry.getKey(), entry.getValue());
            properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return properties;
    }

    protected abstract String getServiceName();

    protected abstract void fillProperties(Map<String, String> var1);
}

