/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.daemon;

import de.taimos.daemon.DaemonStarter;
import de.taimos.daemon.log4j.Log4jLoggingConfigurer;
import de.taimos.daemon.properties.BestEffortPropertyProviderChain;
import de.taimos.daemon.properties.CloudConductorPropertyProvider;
import de.taimos.daemon.properties.EnvPropertyProvider;
import de.taimos.daemon.properties.FilePropertyProvider;
import de.taimos.daemon.properties.IPropertyProvider;
import de.taimos.daemon.properties.SimpleHTTPPropertyProvider;
import de.taimos.daemon.properties.UserDataPropertyProvider;
import de.taimos.daemon.spring.SpringDaemonAdapter;
import de.taimos.dvalin.daemon.ISpringLifecycleListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public abstract class DvalinLifecycleAdapter
extends SpringDaemonAdapter {
    public static void start(String serviceName, DvalinLifecycleAdapter lifecycleAdapter) {
        lifecycleAdapter.setupLogging();
        DaemonStarter.startDaemon(serviceName, lifecycleAdapter);
    }

    @Override
    protected void loadBasicProperties(Map<String, String> map) {
        super.loadBasicProperties(map);
        map.put("dns.ttl", "60");
    }

    @Override
    public IPropertyProvider getPropertyProvider() {
        BestEffortPropertyProviderChain chain = new BestEffortPropertyProviderChain();
        switch (System.getProperty("property.source", "")) {
            case "aws": {
                chain.withProvider(new UserDataPropertyProvider());
                break;
            }
            case "file": {
                chain.withProvider(new FilePropertyProvider(System.getProperty("property.location")));
                break;
            }
            case "c2": {
                chain.withProvider(new CloudConductorPropertyProvider(System.getProperty("property.server"), System.getProperty("property.template")));
                break;
            }
            case "http": {
                chain.withProvider(new SimpleHTTPPropertyProvider(System.getProperty("property.location")));
                break;
            }
        }
        if (new File("dvalin.properties").exists()) {
            chain.withProvider(new FilePropertyProvider("dvalin.properties"));
        }
        chain.withProvider("de.taimos.dvalin.cloud.aws.ParameterStorePropertyProvider");
        if (EnvPropertyProvider.isConfigured()) {
            chain.withProvider(new EnvPropertyProvider());
        }
        return chain;
    }

    @Override
    protected String getSpringResource() {
        return "spring/dvalin.xml";
    }

    @Override
    protected void doAfterSpringStart() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.afterContextStart();
        }
        super.doAfterSpringStart();
    }

    @Override
    protected void doBeforeSpringStop() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.beforeContextStop();
        }
        super.doBeforeSpringStop();
    }

    @Override
    public void started() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.started();
        }
        super.started();
    }

    @Override
    public void stopping() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.stopping();
        }
        super.stopping();
    }

    @Override
    public void aborting() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.aborting();
        }
        super.aborting();
    }

    @Override
    public void signalUSR2() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.signalUSR2();
        }
        super.signalUSR2();
    }

    protected void setupLogging() {
        Log4jLoggingConfigurer.setup();
    }

    private Collection<ISpringLifecycleListener> getLifecycleListeners() {
        Map map;
        ApplicationContext context = this.getContext();
        if (context != null && (map = context.getBeansOfType(ISpringLifecycleListener.class)) != null) {
            return map.values();
        }
        return Collections.EMPTY_LIST;
    }
}

