/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.template.jasperreports;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    public JasperPrint createReport(String fileName, Map<String, Object> parameters, Collection data) {
        try {
            parameters.put("datetime", DateTime.now().toString("dd.MM.yyyy HH:mm"));
            JasperReport jr = JasperCompileManager.compileReport((InputStream)this.getClass().getResourceAsStream("/reports/" + fileName + ".jrxml"));
            return JasperFillManager.fillReport((JasperReport)jr, parameters, (JRDataSource)new JRBeanCollectionDataSource(data));
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
    }

    public void concatReport(JasperPrint master, JasperPrint extraReport) {
        extraReport.getPages().forEach(arg_0 -> ((JasperPrint)master).addPage(arg_0));
    }

    public void writeReport(JasperPrint print, OutputStream stream) {
        try {
            JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)stream);
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
    }
}

