/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.maven_redmine_plugin;

import de.taimos.httputils.HTTPRequest;
import de.taimos.httputils.WS;
import de.taimos.maven_redmine_plugin.model.Ticket;
import de.taimos.maven_redmine_plugin.model.Version;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpResponse;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class Redmine {
    private final ObjectMapper mapper;
    private final String redmineUrl;
    private final String redmineKey;

    public Redmine(String redmineUrl, String redmineKey) {
        this.redmineUrl = redmineUrl;
        this.redmineKey = redmineKey;
        this.mapper = new ObjectMapper();
        this.mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public List<Ticket> getClosedTickets(String project, Integer version) {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        int offset = 0;
        int count = Integer.MAX_VALUE;
        while (tickets.size() < count && offset < count) {
            String url = "/issues.json?project_id=" + project + "&fixed_version_id=" + version + "&status_id=closed&offset=" + offset;
            HashMap<String, Object> map = this.getResponseAsMap(url);
            List issues = (List)map.get("issues");
            count = (Integer)map.get("total_count");
            offset += 25;
            for (HashMap hashMap : issues) {
                tickets.add((Ticket)this.mapper.convertValue((Object)hashMap, Ticket.class));
            }
        }
        return tickets;
    }

    public Version getVersion(String project, String version) {
        List<Version> object = this.getVersions(project);
        if (object != null) {
            for (Version v : object) {
                if (!v.getName().equals(version)) continue;
                return v;
            }
        }
        return null;
    }

    public List<Version> getVersions(String project) {
        HashMap<String, Object> map = this.getResponseAsMap("/projects/" + project + "/versions.json");
        List object = (List)map.get("versions");
        Version[] versions = (Version[])this.mapper.convertValue((Object)object, Version[].class);
        if (versions != null && versions.length != 0) {
            return Arrays.asList(versions);
        }
        return new ArrayList<Version>();
    }

    private HashMap<String, Object> getResponseAsMap(String url) {
        try {
            HttpResponse response = this.createRequest(url).get();
            String responseAsString = WS.getResponseAsString((HttpResponse)response);
            return (HashMap)this.mapper.readValue(responseAsString, HashMap.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, Object>();
        }
    }

    private HTTPRequest createRequest(String url) {
        return WS.url((String)(this.redmineUrl + url)).header("X-Redmine-API-Key", this.redmineKey);
    }

    public void closeVersion(Version version) {
        try {
            String due = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            String bodyString = "{\"version\":{\"name\":\"%s\",\"status\":\"closed\",\"due_date\":\"%s\"}}";
            String body = String.format("{\"version\":{\"name\":\"%s\",\"status\":\"closed\",\"due_date\":\"%s\"}}", version.getName(), due);
            HTTPRequest req = this.createRequest("/versions/" + version.getId() + ".json");
            req.header("Content-Type", "application/json");
            HttpResponse put = req.body(body).put();
            if (!WS.isStatusOK((HttpResponse)put)) {
                System.out.println(WS.getResponseAsString((HttpResponse)put));
                throw new RuntimeException("Status change failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Status change failed");
        }
    }

    public void createVersion(String project, String name) {
        try {
            String body = String.format("{\"version\":{\"name\":\"%s\",\"status\":\"open\"}}", name);
            HTTPRequest req = this.createRequest("/projects/" + project + "/versions.json");
            req.header("Content-Type", "application/json");
            HttpResponse put = req.body(body).post();
            if (!WS.isStatusOK((HttpResponse)put)) {
                System.out.println(WS.getResponseAsString((HttpResponse)put));
                throw new RuntimeException("Status change failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Status change failed");
        }
    }
}

