/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.collection.ceres;

import de.team33.patterns.building.elara.LateBuilder;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Collecting {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private Collecting() {
    }

    public static <E, C extends Collection<E>> C add(C subject, E element) {
        subject.add(element);
        return subject;
    }

    @SafeVarargs
    public static <E, C extends Collection<E>> C add(C subject, E element0, E element1, E ... more) {
        return Collecting.addAll(subject, Stream.concat(Stream.of(element0, element1), Stream.of(more)));
    }

    public static <E, C extends Collection<E>> C addAll(C subject, Collection<? extends E> elements) {
        subject.addAll(elements);
        return subject;
    }

    public static <E, C extends Collection<E>> C addAll(C subject, Stream<? extends E> elements) {
        elements.forEach(subject::add);
        return subject;
    }

    public static <E, C extends Collection<E>> C addAll(C subject, Iterable<? extends E> elements) {
        return elements instanceof Collection ? Collecting.addAll(subject, (Collection)elements) : Collecting.addAll(subject, elements.iterator());
    }

    public static <E, C extends Collection<E>> C addAll(C subject, Iterator<? extends E> elements) {
        while (elements.hasNext()) {
            subject.add(elements.next());
        }
        return subject;
    }

    public static <E, C extends Collection<E>> C addAll(C subject, E[] elements) {
        return Collecting.addAll(subject, Arrays.asList(elements));
    }

    public static <C extends Collection<?>> C clear(C subject) {
        subject.clear();
        return subject;
    }

    public static <C extends Collection<?>> C remove(C subject, Object element) {
        block2: {
            try {
                subject.removeAll(Collections.singleton(element));
            }
            catch (ClassCastException | NullPointerException caught) {
                if (null != subject) break block2;
                throw caught;
            }
        }
        return subject;
    }

    public static <C extends Collection<?>> C remove(C subject, Object element0, Object element1, Object ... more) {
        return Collecting.removeAll(subject, Stream.concat(Stream.of(element0, element1), Stream.of(more)));
    }

    public static <C extends Collection<?>> C removeAll(C subject, Collection<?> elements) {
        try {
            subject.removeAll(elements);
        }
        catch (ClassCastException | NullPointerException caught) {
            if (null == subject || null == elements) {
                throw caught;
            }
            Collecting.removeAll(subject, Collecting.retainAll(new HashSet(elements), subject));
        }
        return subject;
    }

    public static <C extends Collection<?>> C removeAll(C subject, Stream<?> elements) {
        return Collecting.removeAll(subject, Collecting.addAll(new HashSet(), elements.filter(subject::contains)));
    }

    public static <C extends Collection<?>> C removeAll(C subject, Iterable<?> elements) {
        return elements instanceof Collection ? Collecting.removeAll(subject, (Collection)elements) : Collecting.removeAll(subject, elements.iterator());
    }

    public static <C extends Collection<?>> C removeAll(C subject, Iterator<?> elements) {
        return Collecting.removeAll(subject, Collecting.addAll(new HashSet(), elements));
    }

    public static <C extends Collection<?>> C removeAll(C subject, Object[] elements) {
        return Collecting.removeAll(subject, Arrays.asList(elements));
    }

    public static <E, C extends Collection<E>> C removeIf(C subject, Predicate<? super E> filter) {
        subject.removeIf(filter);
        return subject;
    }

    public static <C extends Collection<?>> C retainAll(C subject, Collection<?> elements) {
        try {
            subject.retainAll(elements);
        }
        catch (ClassCastException | NullPointerException caught) {
            if (null == subject || null == elements) {
                throw caught;
            }
            Collecting.retainAll(subject, Collecting.retainAll(new HashSet(elements), subject));
        }
        return subject;
    }

    public static <C extends Collection<?>> C retainAll(C subject, Stream<?> elements) {
        return Collecting.retainAll(subject, Collecting.addAll(new HashSet(), elements));
    }

    public static <C extends Collection<?>> C retainAll(C subject, Iterable<?> elements) {
        return elements instanceof Collection ? Collecting.retainAll(subject, (Collection)elements) : Collecting.retainAll(subject, elements.iterator());
    }

    public static <C extends Collection<?>> C retainAll(C subject, Iterator<?> elements) {
        return Collecting.retainAll(subject, Collecting.addAll(new HashSet(), elements));
    }

    public static <C extends Collection<?>> C retainAll(C subject, Object[] elements) {
        return Collecting.retainAll(subject, Arrays.asList(elements));
    }

    public static boolean contains(Collection<?> subject, Object element) {
        try {
            return subject.contains(element);
        }
        catch (ClassCastException | NullPointerException caught) {
            if (null == subject) {
                throw caught;
            }
            return false;
        }
    }

    public static boolean contains(Collection<?> subject, Object element0, Object element1, Object ... more) {
        return Collecting.containsAll(subject, Stream.concat(Stream.of(element0, element1), Stream.of(more)));
    }

    public static boolean containsAll(Collection<?> subject, Collection<?> elements) {
        try {
            return subject.containsAll(elements);
        }
        catch (ClassCastException | NullPointerException caught) {
            if (null == subject || null == elements) {
                throw caught;
            }
            return false;
        }
    }

    public static boolean containsAll(Collection<?> subject, Stream<?> elements) {
        return Collecting.containsAll(subject, Collecting.addAll(new HashSet(), elements));
    }

    public static boolean containsAll(Collection<?> subject, Iterable<?> elements) {
        return elements instanceof Collection ? Collecting.containsAll(subject, (Collection)elements) : Collecting.containsAll(subject, elements.iterator());
    }

    public static boolean containsAll(Collection<?> subject, Iterator<?> elements) {
        return Collecting.containsAll(subject, Collecting.addAll(new HashSet(), elements));
    }

    public static boolean containsAll(Collection<?> subject, Object[] elements) {
        return Collecting.containsAll(subject, Arrays.asList(elements));
    }

    public static <E> Collection<E> proxy(final Collection<E> subject) {
        return new AbstractCollection<E>(){

            @Override
            public Iterator<E> iterator() {
                return subject.iterator();
            }

            @Override
            public int size() {
                return subject.size();
            }
        };
    }

    public static <E> List<E> proxy(final List<E> subject) {
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return subject.get(index);
            }

            @Override
            public int size() {
                return subject.size();
            }
        };
    }

    public static <E> Set<E> proxy(final Set<E> subject) {
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                return subject.iterator();
            }

            @Override
            public int size() {
                return subject.size();
            }
        };
    }

    private static <E> Collection<E> nullAsEmpty(Collection<E> nullable) {
        return null == nullable ? Collections.emptySet() : nullable;
    }

    private static <E> Stream<E> nullAsEmpty(Stream<E> nullable) {
        return null == nullable ? Stream.empty() : nullable;
    }

    private static <E> Iterable<E> nullAsEmpty(Iterable<E> nullable) {
        return null == nullable ? Collections.emptySet() : nullable;
    }

    private static <E> Iterator<E> nullAsEmpty(Iterator<E> nullable) {
        return null == nullable ? Collections.emptyIterator() : nullable;
    }

    private static <E> E[] nullAsEmpty(E[] nullable) {
        return null == nullable ? EMPTY_ARRAY : nullable;
    }

    public static <E, C extends Collection<E>> Builder<E, C> builder(Supplier<C> newTarget) {
        return new Builder(newTarget, Builder.class);
    }

    public static <E, C extends Collection<E>> Charger<E, C> charger(C target) {
        return new Charger(target, Charger.class, null);
    }

    public static class Charger<E, C extends Collection<E>>
    extends de.team33.patterns.building.elara.Charger<C, Charger<E, C>>
    implements Setup<E, C, Charger<E, C>> {
        private Charger(C target, Class builderClass) {
            super(target, builderClass);
        }

        /* synthetic */ Charger(Collection x0, Class x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class Builder<E, C extends Collection<E>>
    extends LateBuilder<C, Builder<E, C>>
    implements Setup<E, C, Builder<E, C>> {
        private Builder(Supplier<C> newResult, Class builderClass) {
            super(newResult, builderClass);
        }
    }

    @FunctionalInterface
    public static interface Setup<E, C extends Collection<E>, S extends Setup<E, C, S>>
    extends de.team33.patterns.building.elara.Setup<C, S> {
        default public S add(E element) {
            return (S)((Setup)this.setup(target -> Collecting.add(target, element)));
        }

        default public S add(E element0, E element1, E ... more) {
            return (S)((Setup)this.setup(target -> Collecting.add(target, element0, element1, Collecting.nullAsEmpty(more))));
        }

        default public S addAll(Collection<? extends E> elements) {
            return (S)((Setup)this.setup(target -> Collecting.addAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S addAll(Stream<? extends E> elements) {
            return (S)((Setup)this.setup(target -> Collecting.addAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S addAll(Iterable<? extends E> elements) {
            return (S)((Setup)this.setup(target -> Collecting.addAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S addAll(Iterator<? extends E> elements) {
            return (S)((Setup)this.setup(target -> Collecting.addAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S addAll(E[] elements) {
            return (S)((Setup)this.setup(target -> Collecting.addAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S remove(Object element) {
            return (S)((Setup)this.setup(target -> Collecting.remove(target, element)));
        }

        default public S remove(Object element0, Object element1, Object ... more) {
            return (S)((Setup)this.setup(target -> Collecting.remove(target, element0, element1, Collecting.nullAsEmpty(more))));
        }

        default public S removeAll(Collection<?> elements) {
            return (S)((Setup)this.setup(target -> Collecting.removeAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S removeAll(Stream<?> elements) {
            return (S)((Setup)this.setup(target -> Collecting.removeAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S removeAll(Iterable<?> elements) {
            return (S)((Setup)this.setup(target -> Collecting.removeAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S removeAll(Iterator<?> elements) {
            return (S)((Setup)this.setup(target -> Collecting.removeAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S removeAll(Object[] elements) {
            return (S)((Setup)this.setup(target -> Collecting.removeAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S removeIf(Predicate<? super E> filter) {
            return (S)((Setup)this.setup(target -> Collecting.removeIf(target, filter)));
        }

        default public S retainAll(Collection<?> elements) {
            return (S)((Setup)this.setup(target -> Collecting.retainAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S retainAll(Stream<?> elements) {
            return (S)((Setup)this.setup(target -> Collecting.retainAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S retainAll(Iterable<?> elements) {
            return (S)((Setup)this.setup(target -> Collecting.retainAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S retainAll(Iterator<?> elements) {
            return (S)((Setup)this.setup(target -> Collecting.retainAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S retainAll(Object[] elements) {
            return (S)((Setup)this.setup(target -> Collecting.retainAll(target, Collecting.nullAsEmpty(elements))));
        }

        default public S clear() {
            return (S)((Setup)this.setup(Collecting::clear));
        }
    }
}

