/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.collection.ceres;

import de.team33.patterns.building.elara.LateBuilder;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class Mapping {
    private Mapping() {
    }

    public static <K, V, M extends Map<K, V>> M put(M subject, K key, V value) {
        subject.put(key, value);
        return subject;
    }

    public static <K, V, M extends Map<? super K, ? super V>> M putAll(M subject, Map<? extends K, ? extends V> origin) {
        subject.putAll(origin);
        return subject;
    }

    public static <M extends Map<?, ?>> M clear(M subject) {
        subject.clear();
        return subject;
    }

    public static <M extends Map<?, ?>> M remove(M subject, Object key) {
        block2: {
            try {
                subject.remove(key);
            }
            catch (ClassCastException | NullPointerException caught) {
                if (null != subject) break block2;
                throw caught;
            }
        }
        return subject;
    }

    public static boolean containsKey(Map<?, ?> subject, Object key) {
        try {
            return subject.containsKey(key);
        }
        catch (ClassCastException | NullPointerException caught) {
            if (null == subject) {
                throw caught;
            }
            return false;
        }
    }

    public static boolean containsValue(Map<?, ?> subject, Object value) {
        try {
            return subject.containsValue(value);
        }
        catch (ClassCastException | NullPointerException caught) {
            if (null == subject) {
                throw caught;
            }
            return false;
        }
    }

    public static <V> V get(Map<?, V> subject, Object key) {
        try {
            return subject.get(key);
        }
        catch (ClassCastException | NullPointerException caught) {
            if (null == subject) {
                throw caught;
            }
            return null;
        }
    }

    public static <K, V> Map<K, V> proxy(final Map<K, V> subject) {
        return new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return subject.entrySet();
            }
        };
    }

    public static <K, V, M extends Map<K, V>> Builder<K, V, M> builder(Supplier<M> newTarget) {
        return new Builder(newTarget, Builder.class);
    }

    public static <K, V, M extends Map<K, V>> Charger<K, V, M> charger(M target) {
        return new Charger(target, Charger.class, null);
    }

    public static class Charger<K, V, M extends Map<K, V>>
    extends de.team33.patterns.building.elara.Charger<M, Charger<K, V, M>>
    implements Setup<K, V, M, Charger<K, V, M>> {
        private Charger(M target, Class builderClass) {
            super(target, builderClass);
        }

        /* synthetic */ Charger(Map x0, Class x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class Builder<K, V, M extends Map<K, V>>
    extends LateBuilder<M, Builder<K, V, M>>
    implements Setup<K, V, M, Builder<K, V, M>> {
        private Builder(Supplier<M> newResult, Class builderClass) {
            super(newResult, builderClass);
        }
    }

    @FunctionalInterface
    public static interface Setup<K, V, M extends Map<K, V>, S extends Setup<K, V, M, S>>
    extends de.team33.patterns.building.elara.Setup<M, S> {
        default public S put(K key, V value) {
            return (S)((Setup)this.setup(target -> Mapping.put(target, key, value)));
        }

        default public S remove(Object key) {
            return (S)((Setup)this.setup(target -> Mapping.remove(target, key)));
        }

        default public S putAll(Map<? extends K, ? extends V> origin) {
            return (S)((Setup)this.setup(target -> Mapping.putAll(target, null == origin ? Collections.emptyMap() : origin)));
        }

        default public S clear() {
            return (S)((Setup)this.setup(Mapping::clear));
        }
    }
}

