/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.random.tarvos;

import de.team33.patterns.random.tarvos.Charger;
import de.team33.patterns.random.tarvos.Methods;
import de.team33.patterns.random.tarvos.Supplying;
import de.team33.patterns.random.tarvos.Types;
import de.team33.patterns.random.tarvos.UnfitConditionException;
import de.team33.patterns.random.tarvos.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Charging<S extends Charger, T>
extends Supplying<S> {
    private static final String METHOD_NOT_APPLICABLE = Util.load(Charging.class, "setterMethodNotApplicable.txt");
    private static final String NO_SUPPLIER = Util.load(Charging.class, "noSupplierMethodFound.txt");
    private static final Map<Class<?>, List<Method>> SETTERS = new ConcurrentHashMap(0);
    private final T target;
    private final Class<?> targetType;

    Charging(S source, T target, Collection<String> ignore) {
        super(source, ignore);
        this.target = target;
        this.targetType = target.getClass();
    }

    private static List<Method> newSettersOf(Class<?> targetType) {
        return Methods.publicSetters(targetType).collect(Collectors.toList());
    }

    private Stream<Method> desiredSetters() {
        return SETTERS.computeIfAbsent(this.targetType, Charging::newSettersOf).stream().filter(this.desired);
    }

    private Consumer<Object> setter(Method setter) {
        return value -> {
            try {
                setter.invoke(this.target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new LocalException(String.format(METHOD_NOT_APPLICABLE, this.targetType, setter.toGenericString(), setter.getName()), e);
            }
        };
    }

    final T result() {
        this.desiredSetters().forEach(setter -> {
            Type valueType = setter.getGenericParameterTypes()[0];
            Supplier<?> supplier = this.desiredSupplier(valueType, Charging.preference(setter));
            if (null == supplier) {
                throw new LocalException(this, (Method)setter, valueType);
            }
            this.setter((Method)setter).accept(supplier.get());
        });
        return this.target;
    }

    private static BinaryOperator<Method> preference(Method setter) {
        String setterName = Methods.normalName(setter);
        return (left, right) -> {
            String leftName = Methods.normalName(left);
            String rightName = Methods.normalName(right);
            if (leftName.equals(setterName)) {
                return left;
            }
            if (rightName.equals(setterName)) {
                return right;
            }
            return left;
        };
    }

    private static final class LocalException
    extends UnfitConditionException {
        LocalException(String message, Throwable cause) {
            super(message, cause);
        }

        LocalException(Charging<?, ?> charging, Method setter, Type valueType) {
            super(LocalException.missingMessage(charging, setter, valueType), null);
        }

        private static String missingMessage(Charging<?, ?> charging, Method setter, Type valueType) {
            Types.Naming naming = Types.naming(valueType);
            String name1 = naming.parameterizedName(valueType);
            String name2 = Methods.normalName(setter);
            return String.format(NO_SUPPLIER, charging.sourceType, ((Charging)charging).targetType, setter.toGenericString(), setter.getName(), name1, name2);
        }
    }
}

