/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.random.tarvos;

import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@FunctionalInterface
public interface Generator {
    public static Generator simple() {
        return Generator.simple(new Random());
    }

    public static Generator simple(Random random) {
        return numBits -> new BigInteger(numBits, random);
    }

    public BigInteger nextBits(int var1);

    default public boolean nextBoolean() {
        return this.nextBits(1).equals(BigInteger.ONE);
    }

    default public byte nextByte() {
        return this.nextBits(8).byteValue();
    }

    default public short nextShort() {
        return this.nextBits(16).shortValue();
    }

    default public int nextInt() {
        return this.nextBits(32).intValue();
    }

    default public int nextInt(int bound) {
        return this.nextBigInteger(BigInteger.valueOf(bound)).intValue();
    }

    default public int nextInt(int min, int bound) {
        return this.nextBigInteger(BigInteger.valueOf(min), BigInteger.valueOf(bound)).intValue();
    }

    default public long nextLong() {
        return this.nextBits(64).longValue();
    }

    default public long nextLong(long bound) {
        return this.nextBigInteger(BigInteger.valueOf(bound)).longValue();
    }

    default public long nextLong(long min, long bound) {
        return this.nextBigInteger(BigInteger.valueOf(min), BigInteger.valueOf(bound)).longValue();
    }

    default public float nextFloat() {
        float numerator = this.nextBits(24).floatValue();
        float denominator = BigInteger.ONE.shiftLeft(24).floatValue();
        return numerator / denominator;
    }

    default public double nextDouble() {
        double numerator = this.nextBits(53).doubleValue();
        double denominator = BigInteger.ONE.shiftLeft(53).doubleValue();
        return numerator / denominator;
    }

    default public char nextChar(String characters) {
        return characters.charAt(this.nextInt(characters.length()));
    }

    default public String nextString(int length, String characters) {
        if (0 <= length) {
            return IntStream.generate(() -> this.nextInt(characters.length())).limit(length).collect(StringBuilder::new, (sb, i) -> sb.append(characters.charAt(i)), StringBuilder::append).toString();
        }
        throw new IllegalArgumentException("<length> must be greater than or equal to zero but was " + length);
    }

    default public BigInteger nextBigInteger(BigInteger bound) {
        if (BigInteger.ZERO.compareTo(bound) < 0) {
            int bitLength = bound.bitLength();
            return Stream.generate(() -> this.nextBits(bitLength)).filter(result -> result.compareTo(bound) < 0).findAny().orElseThrow(NoSuchElementException::new);
        }
        throw new IllegalArgumentException("<bound> must be greater than ZERO but was " + bound);
    }

    default public BigInteger nextBigInteger(BigInteger min, BigInteger bound) {
        return this.nextBigInteger(bound.subtract(min)).add(min);
    }

    default public <T> T nextOf(T ... values) {
        return values[this.nextInt(values.length)];
    }

    default public <T extends Enum<T>> T nextOf(Class<T> enumClass) {
        return (T)((Enum)this.nextOf(enumClass.getEnumConstants()));
    }
}

