/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.random.tarvos;

import de.team33.patterns.random.tarvos.Initiator;
import de.team33.patterns.random.tarvos.Supplying;
import de.team33.patterns.random.tarvos.Types;
import de.team33.patterns.random.tarvos.UnfitConditionException;
import de.team33.patterns.random.tarvos.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class Initiating<S extends Initiator, T>
extends Supplying<S> {
    private static final String NO_SUPPLIER = Util.load(Initiating.class, "noSupplierMethodFound4Parameter.txt");
    private static final String UNFIT_CONSTRUCTOR = Util.load(Initiating.class, "constructorNotApplicable.txt");
    private final Class<T> targetType;
    private final Constructor<T> constructor;
    private final Parameter[] parameters;

    Initiating(S source, Class<T> targetType, Collection<String> ignore) {
        super(source, ignore);
        this.targetType = targetType;
        this.constructor = Initiating.constructor(targetType);
        this.parameters = this.constructor.getParameters();
    }

    private static <T> Constructor<T> constructor(Class<T> targetType) {
        try {
            Class[] types = Stream.of(targetType.getConstructors()).reduce(Initiating::largest).map(Constructor::getParameterTypes).orElseThrow(() -> new NoSuchMethodException("No public constructor found in " + targetType));
            return targetType.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            throw new LocalException(e.getMessage(), e);
        }
    }

    private static Constructor<?> largest(Constructor<?> left, Constructor<?> right) {
        return left.getParameterCount() < right.getParameterCount() ? right : left;
    }

    private Object[] arguments() {
        return Stream.of(this.parameters).map(parameter -> {
            Type parameterType = parameter.getParameterizedType();
            Supplier<?> supplier = this.desiredSupplier(parameterType, this.preference((Parameter)parameter));
            if (this.ignorable.contains(parameter.getName())) {
                return Types.defaultValue(parameterType);
            }
            if (null != supplier) {
                return supplier.get();
            }
            throw new LocalException(this, parameter.getName(), parameterType);
        }).toArray(Object[]::new);
    }

    private BinaryOperator<Method> preference(Parameter parameter) {
        return (left, right) -> left;
    }

    final T result() {
        try {
            return this.constructor.newInstance(this.arguments());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new LocalException(String.format(UNFIT_CONSTRUCTOR, this.targetType, this.constructor.toGenericString()), e);
        }
    }

    private static final class LocalException
    extends UnfitConditionException {
        LocalException(String message, Throwable cause) {
            super(message, cause);
        }

        LocalException(Initiating<?, ?> initiating, String parameterName, Type parameterType) {
            super(LocalException.missingMessage(initiating, parameterName, parameterType), null);
        }

        private static String missingMessage(Initiating<?, ?> initiating, String name, Type type) {
            Types.Naming naming = Types.naming(type);
            String name1 = naming.parameterizedName(type);
            String name2 = naming.simpleName(type);
            return String.format(NO_SUPPLIER, initiating.sourceType, ((Initiating)initiating).targetType, ((Initiating)initiating).constructor.toGenericString(), name, name1, name2);
        }
    }
}

