/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.random.tarvos;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;

final class Methods {
    private static final int SYNTHETIC = 4096;
    private static final int NON_INSTANCE = 4360;
    private static final Set<String> IGNORABLE = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("hashCode", "toString")));

    private Methods() {
    }

    static Stream<Method> publicGetters(Class<?> targetClass) {
        return Stream.of(targetClass.getMethods()).filter(Methods::isNotIgnorable).filter(Methods::isInstance).filter(Methods::isGetterParameters).filter(method -> Methods.isGetterResult(method, targetClass));
    }

    static Stream<Method> publicSetters(Class<?> targetClass) {
        return Stream.of(targetClass.getMethods()).filter(Methods::isInstance).filter(Methods::isSetterParameters).filter(method -> Methods.isSetterResult(method, targetClass));
    }

    private static boolean isGetterParameters(Method method) {
        return 0 == method.getParameterCount();
    }

    private static boolean isSetterParameters(Method method) {
        return 1 == method.getParameterCount();
    }

    private static boolean isGetterResult(Method method, Class<?> targetClass) {
        return !Methods.isSetterResult(method, targetClass);
    }

    private static boolean isSetterResult(Method method, Class<?> targetClass) {
        Class<?> returnType = method.getReturnType();
        return Void.TYPE.equals(returnType) || targetClass.equals(returnType) || method.getDeclaringClass().equals(returnType);
    }

    private static boolean isNotIgnorable(Method method) {
        return !IGNORABLE.contains(method.getName());
    }

    private static boolean isInstance(Method method) {
        return Methods.isInstance(method.getModifiers());
    }

    private static boolean isInstance(int modifiers) {
        return 0 == (modifiers & 0x1108);
    }

    static String normalName(Method method) {
        String name = method.getName();
        Prefix prefix = Stream.of(Prefix.values()).filter(pfx -> name.startsWith(pfx.value)).findAny().orElse(Prefix.NONE);
        int headIndex = prefix.value.length();
        int tailIndex = headIndex < name.length() ? headIndex + 1 : headIndex;
        String head = name.substring(headIndex, tailIndex).toUpperCase(Locale.ROOT);
        return head + name.substring(tailIndex);
    }

    private static enum Prefix {
        NEXT,
        ANY,
        GET,
        NEW,
        SET,
        IS,
        AS,
        TO,
        NONE("");

        final String value;

        private Prefix(String value) {
            this.value = value;
        }

        private Prefix() {
            this.value = this.name().toLowerCase(Locale.ROOT);
        }
    }
}

