/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.test.bddwebapp.interaction;

import de.telekom.test.bddwebapp.interaction.ScenarioInteraction;
import de.telekom.test.bddwebapp.interaction.StoryInteraction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InteractionParameterConverter {
    private static final Logger log = LoggerFactory.getLogger(InteractionParameterConverter.class);
    public static String KEY_LITERAL = "$";
    public static String CONCATENATED_LITERAL = "+";
    @Autowired
    private ScenarioInteraction scenarioInteraction;
    @Autowired
    private StoryInteraction storyInteraction;

    public <S> S getValueFromKeyOrValueOrConcatenated(String keyOrValueOrConcatenated) {
        if (this.isConcatenatedKey(keyOrValueOrConcatenated)) {
            return (S)this.concatenatedKey(keyOrValueOrConcatenated);
        }
        return this.mapToValue(keyOrValueOrConcatenated);
    }

    protected boolean isKey(String keyOrValueOrConcatenated) {
        return keyOrValueOrConcatenated.startsWith(KEY_LITERAL);
    }

    protected boolean isConcatenatedKey(String keyOrValueOrConcatenated) {
        return keyOrValueOrConcatenated.contains(KEY_LITERAL) && keyOrValueOrConcatenated.contains(CONCATENATED_LITERAL);
    }

    protected String concatenatedKey(String concatenatedKey) {
        return Stream.of(concatenatedKey.split("\\" + CONCATENATED_LITERAL)).map(keyOrValueOrConcatenated -> (String)this.mapToValue((String)keyOrValueOrConcatenated)).collect(Collectors.joining());
    }

    protected <S> S mapToValue(String keyOrValueOrConcatenated) {
        if (this.isKey(keyOrValueOrConcatenated)) {
            return this.getInteractionValue(keyOrValueOrConcatenated.substring(1));
        }
        return (S)keyOrValueOrConcatenated;
    }

    protected <S> S getInteractionValue(String key) {
        Object value = this.storyInteraction.recall(key);
        if (value == null) {
            value = this.scenarioInteraction.recallNotNull(key);
            log.info("Don't find key {} in story interaction but in scenario interaction with value {}", (Object)key, value);
        }
        if (value instanceof String && ((String)value).startsWith("[") && ((String)value).endsWith("]")) {
            value = ((String)value).substring(1, ((String)value).length() - 1);
        }
        return value;
    }
}

