/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.terrestris.shoguncore.converter.UserGroupIdResolver;
import de.terrestris.shoguncore.model.Person;
import de.terrestris.shoguncore.model.Role;
import de.terrestris.shoguncore.model.UserGroup;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table
@Cacheable
public class User
extends Person {
    private static final long serialVersionUID = 1L;
    @Column(unique=true)
    private String accountName;
    @Column
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    @Column
    private boolean active;
    @ManyToMany
    @Fetch(value=FetchMode.JOIN)
    @JoinTable(joinColumns={@JoinColumn(name="USER_ID")}, inverseJoinColumns={@JoinColumn(name="ROLE_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Set<Role> roles = new HashSet<Role>();
    @ManyToMany
    @Fetch(value=FetchMode.JOIN)
    @JoinTable(name="user_usergroup", joinColumns={@JoinColumn(name="USER_ID")}, inverseJoinColumns={@JoinColumn(name="USERGROUP_ID")})
    @OrderColumn(name="IDX")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", resolver=UserGroupIdResolver.class)
    @JsonIdentityReference(alwaysAsId=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Set<UserGroup> userGroups = new HashSet<UserGroup>();

    public User() {
    }

    public User(String firstName, String lastName, String accountName) {
        super(firstName, lastName);
        this.accountName = accountName;
    }

    public User(String firstName, String lastName, String accountName, String password) {
        super(firstName, lastName);
        this.accountName = accountName;
        this.password = password;
    }

    public User(String firstName, String lastName, String accountName, String password, boolean active) {
        super(firstName, lastName);
        this.accountName = accountName;
        this.password = password;
        this.active = active;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public Set<UserGroup> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(Set<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(23, 13).appendSuper(super.hashCode()).append((Object)this.getAccountName()).append((Object)this.getPassword()).append(this.isActive()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getAccountName(), (Object)other.getAccountName()).append((Object)this.getPassword(), (Object)other.getPassword()).append(this.isActive(), other.isActive()).isEquals();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("accountName", (Object)this.getAccountName()).append("isActive", this.isActive()).toString();
    }
}

