/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.layer.util;

import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.layer.util.Extent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Inheritance(strategy=InheritanceType.JOINED)
public class TileGrid
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private String type;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="x", column=@Column(name="TILEGRIDORIGIN_X")), @AttributeOverride(name="y", column=@Column(name="TILEGRIDORIGIN_Y"))})
    private Point2D.Double tileGridOrigin;
    @ManyToOne
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Extent tileGridExtent;
    private Integer tileSize;
    @ElementCollection
    @CollectionTable(name="TILEGRID_RESOLUTION", joinColumns={@JoinColumn(name="TILEGRID_ID")})
    @Column(name="RESOLUTION")
    @OrderColumn(name="IDX")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private List<Double> tileGridResolutions;

    public TileGrid() {
        this.tileSize = new Integer(256);
    }

    public TileGrid(Point2D.Double tileGridOrigin, Extent tileGridExtent, Integer tileSize) {
        this.tileGridOrigin = tileGridOrigin;
        this.tileGridExtent = tileGridExtent;
        this.tileSize = tileSize;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Point2D.Double getTileGridOrigin() {
        return this.tileGridOrigin;
    }

    public void setTileGridOrigin(Point2D.Double tileGridOrigin) {
        this.tileGridOrigin = tileGridOrigin;
    }

    public Extent getTileGridExtent() {
        return this.tileGridExtent;
    }

    public void setTileGridExtent(Extent tileGridExtent) {
        this.tileGridExtent = tileGridExtent;
    }

    public Integer getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Integer tileSize) {
        this.tileSize = tileSize;
    }

    public List<Double> getTileGridResolutions() {
        return this.tileGridResolutions;
    }

    public void setTileGridResolutions(List<Double> tileGridResolutions) {
        this.tileGridResolutions = tileGridResolutions;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(43, 13).appendSuper(super.hashCode()).append((Object)this.getType()).append((Object)this.getTileGridOrigin()).append((Object)this.getTileGridExtent()).append((Object)this.getTileSize()).append(this.getTileGridResolutions()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TileGrid)) {
            return false;
        }
        TileGrid other = (TileGrid)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getType(), (Object)other.getType()).append((Object)this.getTileGridOrigin(), (Object)other.getTileGridOrigin()).append((Object)this.getTileGridExtent(), (Object)other.getTileGridExtent()).append((Object)this.getTileSize(), (Object)other.getTileSize()).append(this.getTileGridResolutions(), other.getTileGridResolutions()).isEquals();
    }
}

