/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.rest;

import de.terrestris.shoguncore.dao.PluginDao;
import de.terrestris.shoguncore.model.Plugin;
import de.terrestris.shoguncore.rest.AbstractRestController;
import de.terrestris.shoguncore.service.PluginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugins"})
public class PluginRestController<E extends Plugin, D extends PluginDao<E>, S extends PluginService<E, D>>
extends AbstractRestController<E, D, S> {
    public PluginRestController() {
        this(Plugin.class);
    }

    protected PluginRestController(Class<E> entityClass) {
        super(entityClass);
    }

    @RequestMapping(value={"/{simpleClassName}.js"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getExternalPluginSource(@PathVariable String simpleClassName) {
        this.LOG.debug("Requested to return the sourcecode for plugin " + simpleClassName);
        ResponseEntity responseEntity = null;
        HttpHeaders responseHeaders = new HttpHeaders();
        try {
            responseHeaders.add("Content-Type", "text/javascript; charset=utf-8");
            String classCode = ((PluginService)this.service).getPluginSource(simpleClassName);
            responseEntity = new ResponseEntity((Object)classCode, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            responseHeaders.add("Content-Type", "text/*");
            String errMsg = "Error while returning the class code for external plugin: " + e.getMessage();
            this.LOG.error(errMsg);
            responseEntity = new ResponseEntity((Object)errMsg, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return responseEntity;
    }

    @Override
    @Autowired
    @Qualifier(value="pluginService")
    public void setService(S service) {
        this.service = service;
    }
}

