/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.security.access.entity;

import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.model.security.Permission;
import de.terrestris.shoguncore.model.security.PermissionCollection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersistentObjectPermissionEvaluator<E extends PersistentObject> {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private final Class<E> entityClass;

    public PersistentObjectPermissionEvaluator(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public boolean hasPermission(User user, E entity, Permission permission) {
        String simpleClassName = this.entityClass.getSimpleName();
        Map<User, PermissionCollection> userPermissionsMap = ((PersistentObject)entity).getUserPermissions();
        PermissionCollection userPermissionCol = this.extractUserPermissions(user, userPermissionsMap);
        Set<Permission> userPermissions = userPermissionCol.getPermissions();
        if (userPermissions.contains((Object)permission) || userPermissions.contains((Object)Permission.ADMIN)) {
            this.LOG.trace("Granting " + (Object)((Object)permission) + " access by user permissions");
            return true;
        }
        Map<UserGroup, PermissionCollection> groupPermissionsMap = ((PersistentObject)entity).getGroupPermissions();
        PermissionCollection groupPermissionsCol = this.extractGroupPermissions(user, groupPermissionsMap);
        Set<Permission> groupPermissions = groupPermissionsCol.getPermissions();
        if (groupPermissions.contains((Object)permission) || groupPermissions.contains((Object)Permission.ADMIN)) {
            this.LOG.trace("Granting " + (Object)((Object)permission) + " access by group permissions");
            return true;
        }
        this.LOG.trace("Restricting " + (Object)((Object)permission) + " access on secured object '" + simpleClassName + "' with ID " + ((PersistentObject)entity).getId());
        return false;
    }

    protected PermissionCollection extractUserPermissions(User user, Map<User, PermissionCollection> userPermissionsMap) {
        PermissionCollection permissionCollection = userPermissionsMap.get(user);
        if (permissionCollection == null) {
            permissionCollection = new PermissionCollection();
        }
        return permissionCollection;
    }

    protected PermissionCollection extractGroupPermissions(User user, Map<UserGroup, PermissionCollection> groupPermissionsMap) {
        HashSet<Permission> aggregatedGroupPermissions = new HashSet<Permission>();
        Set<UserGroup> userGroupsWithPermissions = groupPermissionsMap.keySet();
        for (UserGroup userGroup : userGroupsWithPermissions) {
            if (!userGroup.getMembers().contains(user)) continue;
            Set<Permission> groupPermissions = groupPermissionsMap.get(userGroup).getPermissions();
            aggregatedGroupPermissions.addAll(groupPermissions);
        }
        return new PermissionCollection(aggregatedGroupPermissions);
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }
}

