/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="modelDescriptionService")
public class ModelDescriptionService {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    @Resource
    @Qualifier(value="describeModelSearchPackages")
    private List<String> describeModelSearchPackages;
    @Autowired
    protected ObjectMapper objectMapper;

    public JsonSchema getJsonSchema(String className) throws IOException {
        Class<?> foundClass = null;
        for (String searchPackage : this.describeModelSearchPackages) {
            this.LOG.debug(String.format("Search className %s in package %s.", className, searchPackage));
            try {
                boolean wasNull = foundClass == null;
                foundClass = Class.forName(searchPackage + "." + className);
                if (wasNull) continue;
                this.LOG.error(String.format("Modelname %s exists in multiple packages! Last one will win.", className));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (foundClass == null) {
            this.LOG.warn(String.format("No class found for describing modelname %s", className));
            return null;
        }
        JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(this.objectMapper);
        JsonSchema schema = schemaGen.generateSchema(foundClass);
        return schema;
    }
}

