/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.RegistrationTokenDao;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.token.RegistrationToken;
import de.terrestris.shoguncore.service.AbstractUserTokenService;
import de.terrestris.shoguncore.util.application.ShogunCoreContextUtil;
import de.terrestris.shoguncore.util.mail.MailPublisher;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service(value="registrationTokenService")
public class RegistrationTokenService<E extends RegistrationToken, D extends RegistrationTokenDao<E>>
extends AbstractUserTokenService<E, D> {
    @Value(value="${login.accountActivationPath}")
    private String accountActivationPath;
    @Value(value="${login.registrationTokenExpirationTime}")
    private int registrationTokenExpirationTime;
    @Autowired
    private MailPublisher mailPublisher;
    @Autowired
    @Qualifier(value="registrationMailMessageTemplate")
    private SimpleMailMessage registrationMailMessageTemplate;

    public RegistrationTokenService() {
        this(RegistrationToken.class);
    }

    protected RegistrationTokenService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="registrationTokenDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    @Override
    protected E buildConcreteInstance(User user, Integer expirationTimeInMinutes) {
        if (expirationTimeInMinutes == null) {
            return (E)new RegistrationToken(user);
        }
        return (E)new RegistrationToken(user, expirationTimeInMinutes);
    }

    public void sendRegistrationActivationMail(HttpServletRequest request, User user) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, URISyntaxException, UnsupportedEncodingException {
        URI resetPasswordURI = this.createRegistrationActivationURI(request, user);
        SimpleMailMessage registrationActivationMsg = new SimpleMailMessage(this.registrationMailMessageTemplate);
        String email = user.getEmail();
        registrationActivationMsg.setTo(email);
        registrationActivationMsg.setText(String.format(registrationActivationMsg.getText(), UriUtils.decode((String)resetPasswordURI.toString(), (String)"UTF-8")));
        this.mailPublisher.sendMail(registrationActivationMsg);
    }

    public URI createRegistrationActivationURI(HttpServletRequest request, User user) throws URISyntaxException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RegistrationToken registrationToken = (RegistrationToken)this.getValidTokenForUser(user, this.registrationTokenExpirationTime);
        URI appURI = ShogunCoreContextUtil.getApplicationURIFromRequest(request);
        URI tokenURI = new URIBuilder(appURI).setPath(appURI.getPath() + this.accountActivationPath).setParameter("token", registrationToken.getToken()).build();
        this.LOG.trace("Created the following URI for account activation: " + tokenURI);
        return tokenURI;
    }

    public void deleteTokenAfterActivation(RegistrationToken token) {
        ((RegistrationTokenDao)this.dao).delete(token);
        this.LOG.trace("The registration token has been deleted.");
    }

    public String getAccountActivationPath() {
        return this.accountActivationPath;
    }

    public void setAccountActivationPath(String accountActivationPath) {
        this.accountActivationPath = accountActivationPath;
    }

    public int getRegistrationTokenExpirationTime() {
        return this.registrationTokenExpirationTime;
    }

    public void setRegistrationTokenExpirationTime(int registrationTokenExpirationTime) {
        this.registrationTokenExpirationTime = registrationTokenExpirationTime;
    }

    public MailPublisher getMailPublisher() {
        return this.mailPublisher;
    }

    public void setMailPublisher(MailPublisher mailPublisher) {
        this.mailPublisher = mailPublisher;
    }

    public SimpleMailMessage getRegistrationMailMessageTemplate() {
        return this.registrationMailMessageTemplate;
    }

    public void setRegistrationMailMessageTemplate(SimpleMailMessage registrationMailMessageTemplate) {
        this.registrationMailMessageTemplate = registrationMailMessageTemplate;
    }
}

