/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.WpsPluginDao;
import de.terrestris.shoguncore.dao.WpsProcessExecuteDao;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.wps.WpsPlugin;
import de.terrestris.shoguncore.model.wps.WpsProcessExecute;
import de.terrestris.shoguncore.service.WpsPluginService;
import de.terrestris.shoguncore.service.WpsReferenceService;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wpsProcessExecuteService")
public class WpsProcessExecuteService<E extends WpsProcessExecute, D extends WpsProcessExecuteDao<E>>
extends WpsReferenceService<E, D> {
    @Autowired
    @Qualifier(value="wpsPluginService")
    private WpsPluginService<WpsPlugin, WpsPluginDao<WpsPlugin>> wpsPluginService;

    public WpsProcessExecuteService() {
        this(WpsProcessExecute.class);
    }

    protected WpsProcessExecuteService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#plugin, 'DELETE')")
    public void delete(E wpsProcessExecute) {
        if (this.wpsPluginService == null) {
            this.LOG.error("WPSProcessExecute cannot be deleted, failed to autowire WpsPluginService");
            return;
        }
        WpsPluginDao wpsPluginDao = (WpsPluginDao)this.wpsPluginService.getDao();
        SimpleExpression eqProcess = Restrictions.eq((String)"process", wpsProcessExecute);
        List wpsPlugins = wpsPluginDao.findByCriteria(new Criterion[]{eqProcess});
        Integer processId = ((PersistentObject)wpsProcessExecute).getId();
        for (WpsPlugin wpsPlugin : wpsPlugins) {
            WpsProcessExecute process = wpsPlugin.getProcess();
            if (process == null) continue;
            String msg = String.format("Remove WpsProcessExecute (id=%s) from WpsPlugin (id=%s)", processId, wpsPlugin.getId());
            this.LOG.debug(msg);
            wpsPlugin.setProcess(null);
            this.wpsPluginService.saveOrUpdate(wpsPlugin);
        }
        this.LOG.debug(String.format("Delete plugin (id=%s)", processId));
        super.delete(wpsProcessExecute);
    }

    @Override
    @Autowired
    @Qualifier(value="wpsProcessExecuteDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#wpsId, 'de.terrestris.shoguncore.model.wps.WpsProcessExecute', 'DELETE')")
    @Transactional(readOnly=true)
    public List<String> preCheckDelete(Integer wpsId) {
        ArrayList<String> result = new ArrayList<String>();
        WpsProcessExecute wpsProcessExecute = (WpsProcessExecute)((WpsProcessExecuteDao)this.dao).findById(wpsId);
        if (wpsProcessExecute != null) {
            List pluginsWithWps = this.wpsPluginService.findAllWhereFieldEquals("process", wpsProcessExecute);
            for (WpsPlugin plugin : pluginsWithWps) {
                result.add(plugin.getName());
            }
        }
        return result;
    }

    public WpsPluginService<WpsPlugin, WpsPluginDao<WpsPlugin>> getWpsPluginService() {
        return this.wpsPluginService;
    }
}

