/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.http;

import de.terrestris.shoguncore.util.model.Response;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class HttpUtil {
    private static final Logger LOG = LogManager.getLogger(HttpUtil.class);
    private static int httpTimeout;
    private static int defaultHttpTimeout;
    private static String AUTHORIZATION_HEADER;

    public static Response get(String url) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(url), null, null);
    }

    public static Response get(String url, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(url), null, requestHeaders);
    }

    public static Response get(String url, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(url), credentials, null);
    }

    public static Response get(String url, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(url), credentials, requestHeaders);
    }

    public static Response get(String url, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(url), (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response get(String url, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(url), (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response get(URI uri) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(uri), null, null);
    }

    public static Response get(URI uri, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(uri), null, requestHeaders);
    }

    public static Response get(URI uri, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(uri), (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response get(URI uri, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(uri), (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response get(URI uri, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(uri), credentials, null);
    }

    public static Response get(URI uri, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpGet(uri), credentials, requestHeaders);
    }

    public static Response forwardGet(URI uri, HttpServletRequest request, boolean forwardHeaders) throws URISyntaxException, HttpException {
        Header[] headersToForward = null;
        if (request != null && forwardHeaders) {
            headersToForward = HttpUtil.getHeadersFromRequest(request);
        }
        return HttpUtil.send((HttpRequestBase)new HttpGet(uri), null, headersToForward);
    }

    public static Response post(String url) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), new ArrayList<NameValuePair>(), null, null);
    }

    public static Response post(String url, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), new ArrayList<NameValuePair>(), null, requestHeaders);
    }

    public static Response post(String url, String password, String username) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), new ArrayList<NameValuePair>(), (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response post(String url, String password, String username, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), new ArrayList<NameValuePair>(), (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response post(String url, Credentials credentials) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), new ArrayList<NameValuePair>(), credentials, null);
    }

    public static Response post(String url, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), new ArrayList<NameValuePair>(), credentials, requestHeaders);
    }

    public static Response post(URI uri) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), new ArrayList<NameValuePair>(), null, null);
    }

    public static Response post(URI uri, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), new ArrayList<NameValuePair>(), null, requestHeaders);
    }

    public static Response post(URI uri, String username, String password) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), new ArrayList<NameValuePair>(), (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response post(URI uri, String username, String password, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), new ArrayList<NameValuePair>(), (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response post(URI uri, Credentials credentials) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), new ArrayList<NameValuePair>(), credentials, null);
    }

    public static Response post(URI uri, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), new ArrayList<NameValuePair>(), credentials, requestHeaders);
    }

    public static Response post(String url, List<NameValuePair> queryParams) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), queryParams, null, null);
    }

    public static Response post(String url, List<NameValuePair> queryParams, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), queryParams, null, requestHeaders);
    }

    public static Response post(String url, List<NameValuePair> queryParams, String username, String password) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), queryParams, (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response post(String url, List<NameValuePair> queryParams, String username, String password, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), queryParams, (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response post(String url, List<NameValuePair> queryParams, Credentials credentials) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), queryParams, credentials, null);
    }

    public static Response post(String url, List<NameValuePair> queryParams, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(url), queryParams, credentials, requestHeaders);
    }

    public static Response post(URI uri, List<NameValuePair> queryParams) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), queryParams, null, null);
    }

    public static Response post(URI uri, List<NameValuePair> queryParams, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), queryParams, null, requestHeaders);
    }

    public static Response post(URI uri, List<NameValuePair> queryParams, String username, String password) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), queryParams, (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response post(URI uri, List<NameValuePair> queryParams, String username, String password, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), queryParams, (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response post(URI uri, List<NameValuePair> queryParams, Credentials credentials) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), queryParams, credentials, null);
    }

    public static Response post(URI uri, List<NameValuePair> queryParams, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        return HttpUtil.postParams(new HttpPost(uri), queryParams, credentials, requestHeaders);
    }

    public static Response post(String url, String body, ContentType contentType) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(url), body, contentType, null, null);
    }

    public static Response post(String url, String body, ContentType contentType, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(url), body, contentType, null, requestHeaders);
    }

    public static Response post(String url, String body, ContentType contentType, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(url), body, contentType, (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response post(String url, String body, ContentType contentType, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(url), body, contentType, (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response post(String url, String body, ContentType contentType, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(url), body, contentType, credentials, null);
    }

    public static Response post(String url, String body, ContentType contentType, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(url), body, contentType, credentials, requestHeaders);
    }

    public static Response post(URI uri, String body, ContentType contentType) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(uri), body, contentType, null, null);
    }

    public static Response post(URI uri, String body, ContentType contentType, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(uri), body, contentType, null, requestHeaders);
    }

    public static Response post(URI uri, String body, ContentType contentType, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(uri), body, contentType, (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response post(URI uri, String body, ContentType contentType, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(uri), body, contentType, (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response post(URI uri, String body, ContentType contentType, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(uri), body, contentType, credentials, null);
    }

    public static Response post(URI uri, String body, ContentType contentType, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postBody(new HttpPost(uri), body, contentType, credentials, requestHeaders);
    }

    public static Response post(String url, File file) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(url), new FileBody(file), null, null);
    }

    public static Response post(String url, File file, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(url), new FileBody(file), null, requestHeaders);
    }

    public static Response post(String url, File file, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(url), new FileBody(file), (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response post(String url, File file, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(url), new FileBody(file), (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response post(String url, File file, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(url), new FileBody(file), credentials, null);
    }

    public static Response post(String url, File file, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(url), new FileBody(file), credentials, requestHeaders);
    }

    public static Response post(URI uri, File file) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(uri), new FileBody(file), null, null);
    }

    public static Response post(URI uri, File file, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(uri), new FileBody(file), null, requestHeaders);
    }

    public static Response post(URI uri, File file, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(uri), new FileBody(file), (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response post(URI uri, File file, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(uri), new FileBody(file), (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response post(URI uri, File file, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(uri), new FileBody(file), credentials, null);
    }

    public static Response post(URI uri, File file, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.postMultiPart(new HttpPost(uri), new FileBody(file), credentials, requestHeaders);
    }

    public static Response forwardFormMultipartPost(URI uri, HttpServletRequest request, boolean forwardHeaders) throws URISyntaxException, HttpException, IllegalStateException, IOException, ServletException {
        Header[] headersToForward = null;
        if (request != null && forwardHeaders) {
            headersToForward = HttpUtil.getHeadersFromRequest(request);
        }
        headersToForward = HttpUtil.removeHeaders(headersToForward, new String[]{"content-length", "content-type"});
        Collection parts = request.getParts();
        return HttpUtil.postMultiPart(uri, parts, headersToForward);
    }

    private static Response postMultiPart(URI uri, Collection<Part> parts, Header[] headersToForward) throws IOException, URISyntaxException, HttpException {
        HttpPost httpPost = new HttpPost(uri);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (Part part : parts) {
            String name = part.getName();
            String fileName = part.getSubmittedFileName();
            byte[] data = IOUtils.toByteArray((InputStream)part.getInputStream());
            ContentType contentType = ContentType.create((String)part.getContentType());
            ByteArrayBody byteArrayBody = new ByteArrayBody(data, contentType, fileName);
            builder.addPart(name, (ContentBody)byteArrayBody);
            LOG.debug("Add a form/multipart part with name '" + name + "', content type '" + contentType.getMimeType() + "' and size " + part.getSize());
        }
        HttpEntity multiPartEntity = builder.build();
        httpPost.setEntity(multiPartEntity);
        return HttpUtil.send((HttpRequestBase)httpPost, null, headersToForward);
    }

    private static Response postMultiPart(HttpPost httpRequest, FileBody file, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)file).build();
        httpRequest.setEntity(multiPartEntity);
        return HttpUtil.send((HttpRequestBase)httpRequest, credentials, requestHeaders);
    }

    private static Response postBody(HttpPost httpRequest, String body, ContentType contentType, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        StringEntity stringEntity = new StringEntity(body, contentType);
        stringEntity.setChunked(true);
        httpRequest.setEntity((HttpEntity)stringEntity);
        return HttpUtil.send((HttpRequestBase)httpRequest, credentials, requestHeaders);
    }

    private static Response postParams(HttpPost httpRequest, List<NameValuePair> queryParams, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, UnsupportedEncodingException, HttpException {
        if (!queryParams.isEmpty()) {
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(queryParams, "UTF-8");
            httpRequest.setEntity((HttpEntity)httpEntity);
        }
        return HttpUtil.send((HttpRequestBase)httpRequest, credentials, requestHeaders);
    }

    public static Response forwardPost(URI uri, HttpServletRequest request, boolean forwardHeaders) throws URISyntaxException, HttpException {
        Header[] headersToForward = null;
        if (request != null && forwardHeaders) {
            headersToForward = HttpUtil.getHeadersFromRequest(request);
        }
        String ctString = request.getContentType();
        ContentType ct = ContentType.parse((String)ctString);
        String body = HttpUtil.getRequestBody(request);
        return HttpUtil.postBody(new HttpPost(uri), body, ct, null, headersToForward);
    }

    public static Response put(URI uri) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), null, null, null, null);
    }

    public static Response put(URI uri, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), null, null, null, requestHeaders);
    }

    public static Response put(String uriString) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), null, null, null, null);
    }

    public static Response put(String uriString, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), null, null, null, requestHeaders);
    }

    public static Response put(URI uri, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), null, null, (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response put(URI uri, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), null, null, (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response put(URI uri, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), null, null, credentials, null);
    }

    public static Response put(URI uri, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), null, null, credentials, requestHeaders);
    }

    public static Response put(String uriString, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), null, null, (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response put(String uriString, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), null, null, (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response put(String uriString, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), null, null, credentials, null);
    }

    public static Response put(String uriString, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), null, null, credentials, requestHeaders);
    }

    public static Response put(String uriString, String body, ContentType contentType) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), body, contentType, null, null);
    }

    public static Response put(String uriString, String body, ContentType contentType, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), body, contentType, null, requestHeaders);
    }

    public static Response put(String uriString, String body, ContentType contentType, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), body, contentType, (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response put(String uriString, String body, ContentType contentType, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), body, contentType, (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response put(String uriString, String body, ContentType contentType, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), body, contentType, credentials, null);
    }

    public static Response put(String uriString, String body, ContentType contentType, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uriString), body, contentType, credentials, requestHeaders);
    }

    public static Response put(URI uri, String body, ContentType contentType) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), body, contentType, null, null);
    }

    public static Response put(URI uri, String body, ContentType contentType, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), body, contentType, null, requestHeaders);
    }

    public static Response put(URI uri, String body, ContentType contentType, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), body, contentType, (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response put(URI uri, String body, ContentType contentType, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), body, contentType, (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response put(URI uri, String body, ContentType contentType, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), body, contentType, credentials, null);
    }

    public static Response put(URI uri, String body, ContentType contentType, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.putBody(new HttpPut(uri), body, contentType, credentials, requestHeaders);
    }

    public static Response delete(String url) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(url), null, null);
    }

    public static Response delete(String url, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(url), null, requestHeaders);
    }

    public static Response delete(String url, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(url), (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response delete(String url, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(url), (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response delete(String url, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(url), credentials, null);
    }

    public static Response delete(String url, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(url), credentials, requestHeaders);
    }

    public static Response delete(URI uri) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(uri), null, null);
    }

    public static Response delete(URI uri, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(uri), null, requestHeaders);
    }

    public static Response delete(URI uri, String username, String password) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(uri), (Credentials)new UsernamePasswordCredentials(username, password), null);
    }

    public static Response delete(URI uri, String username, String password, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(uri), (Credentials)new UsernamePasswordCredentials(username, password), requestHeaders);
    }

    public static Response delete(URI uri, Credentials credentials) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(uri), credentials, null);
    }

    public static Response delete(URI uri, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        return HttpUtil.send((HttpRequestBase)new HttpDelete(uri), credentials, requestHeaders);
    }

    private static Response putBody(HttpPut httpRequest, String body, ContentType contentType, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        if (contentType != null && !StringUtils.isEmpty((CharSequence)body)) {
            StringEntity stringEntity = new StringEntity(body, contentType);
            stringEntity.setChunked(true);
            httpRequest.setEntity((HttpEntity)stringEntity);
        }
        return HttpUtil.send((HttpRequestBase)httpRequest, credentials, requestHeaders);
    }

    private static Response send(HttpRequestBase httpRequest, Credentials credentials, Header[] requestHeaders) throws URISyntaxException, HttpException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        Response response = new Response();
        HttpClientContext httpContext = HttpClientContext.create();
        URI uri = httpRequest.getURI();
        HttpHost systemProxy = null;
        AuthScope proxyAuthScope = null;
        UsernamePasswordCredentials proxyCredentials = null;
        try {
            String uriScheme = uri.getScheme();
            String httpsProxyUser = System.getProperty("https.proxyUser");
            String httpsProxyPassword = System.getProperty("https.proxyPassword");
            String httpProxyUser = System.getProperty("http.proxyUser");
            String httpProxyPassword = System.getProperty("http.proxyPassword");
            systemProxy = HttpUtil.getSystemProxy(uri);
            if (systemProxy != null) {
                String proxyHostName = systemProxy.getHostName();
                int proxyPort = systemProxy.getPort();
                LOG.debug("Using proxy hostname from system proxy: " + proxyHostName);
                LOG.debug("Using proxy port from system proxy: " + proxyPort);
                proxyAuthScope = new AuthScope(systemProxy.getHostName(), systemProxy.getPort());
                if (StringUtils.equalsIgnoreCase((CharSequence)uriScheme, (CharSequence)"http")) {
                    LOG.debug("Using http proxy");
                    if (!StringUtils.isEmpty((CharSequence)httpProxyUser) && !StringUtils.isEmpty((CharSequence)httpProxyPassword)) {
                        LOG.debug("Using proxy user and password for the http proxy " + proxyHostName);
                        proxyCredentials = new UsernamePasswordCredentials(httpProxyUser, httpProxyPassword);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)uriScheme, (CharSequence)"https")) {
                    LOG.debug("Using https proxy");
                    if (!StringUtils.isEmpty((CharSequence)httpsProxyUser) && !StringUtils.isEmpty((CharSequence)httpsProxyPassword)) {
                        LOG.debug("Using proxy user and password for the https proxy " + proxyHostName);
                        proxyCredentials = new UsernamePasswordCredentials(httpsProxyUser, httpsProxyPassword);
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            LOG.error("Error while detecting system wide proxy: " + e.getMessage());
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(httpTimeout).setConnectTimeout(httpTimeout).setSocketTimeout(httpTimeout).setProxy(systemProxy).build();
        if (credentials != null || proxyAuthScope != null && proxyCredentials != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (proxyAuthScope != null && proxyCredentials != null) {
                credentialsProvider.setCredentials(proxyAuthScope, proxyCredentials);
            }
            if (credentials != null) {
                credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), credentials);
            }
            HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
            httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            httpContext.setAuthCache((AuthCache)authCache);
            httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        } else {
            httpClient = HttpClients.createDefault();
        }
        try {
            HttpHeaders headersMap = new HttpHeaders();
            httpRequest.setConfig(requestConfig);
            if (requestHeaders != null) {
                httpRequest.setHeaders(requestHeaders);
            }
            httpResponse = httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
            HttpStatus httpStatus = HttpStatus.valueOf((int)httpResponse.getStatusLine().getStatusCode());
            Header[] headers = httpResponse.getAllHeaders();
            HttpEntity httpResponseEntity = httpResponse.getEntity();
            response.setStatusCode(httpStatus);
            for (Header header : headers) {
                if (header.getName().equalsIgnoreCase("Transfer-Encoding") && header.getValue().equalsIgnoreCase("chunked")) {
                    LOG.trace("Removed the header 'Transfer-Encoding:chunked' from a response, as its handled by the http-client");
                    continue;
                }
                headersMap.set(header.getName(), header.getValue());
            }
            response.setHeaders(headersMap);
            if (httpResponseEntity != null) {
                response.setBody(EntityUtils.toByteArray((HttpEntity)httpResponseEntity));
            }
        }
        catch (IOException e) {
            try {
                throw new HttpException("Error while getting a response from " + uri + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                httpRequest.reset();
                IOUtils.closeQuietly(httpResponse);
                IOUtils.closeQuietly((Closeable)httpClient);
                throw throwable;
            }
        }
        httpRequest.reset();
        IOUtils.closeQuietly((Closeable)httpResponse);
        IOUtils.closeQuietly((Closeable)httpClient);
        return response;
    }

    public static boolean isSaneRequest(HttpServletRequest request) {
        return request != null && request.getMethod() != null;
    }

    public static boolean isHttpGetRequest(HttpServletRequest request) {
        boolean isSane = HttpUtil.isSaneRequest(request);
        boolean isGet = isSane && request.getMethod().equals(HttpMethod.GET.toString());
        return isSane && isGet;
    }

    public static boolean isHttpPostRequest(HttpServletRequest request) {
        boolean isSane = HttpUtil.isSaneRequest(request);
        boolean isPost = isSane && request.getMethod().equals(HttpMethod.POST.toString());
        return isSane && isPost;
    }

    public static boolean isFormMultipartPost(HttpServletRequest request) {
        if (!HttpUtil.isHttpPostRequest(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/form-data");
    }

    public static Header[] getHeadersFromRequest(HttpServletRequest request) {
        ArrayList<BasicHeader> returnHeaderList = new ArrayList<BasicHeader>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                if (headerName.toLowerCase().equals("cookie")) {
                    String[] cookies = headerValue.split(";");
                    ArrayList<String> newCookieList = new ArrayList<String>();
                    for (int i = 0; i < cookies.length; ++i) {
                        String cookieFromArray = cookies[i];
                        newCookieList.add(cookieFromArray);
                    }
                    headerValue = StringUtils.join(newCookieList, (String)";");
                }
                if (headerValue.isEmpty()) {
                    LOG.debug("Skipping request header '" + headerName + "' as it's value is empty (possibly an unsupported cookie value has been removed)");
                    continue;
                }
                LOG.debug("Adding request header: " + headerName + "=" + headerValue);
                returnHeaderList.add(new BasicHeader(headerName, headerValue));
            }
        }
        Header[] headersArray = new Header[returnHeaderList.size()];
        headersArray = returnHeaderList.toArray(headersArray);
        return headersArray;
    }

    private static Header[] removeHeaders(Header[] headersToClean, String[] headersToRemove) {
        ArrayList<Header> headers = new ArrayList<Header>();
        if (headersToClean == null) {
            return null;
        }
        for (Header header : headersToClean) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)header.getName(), (CharSequence[])headersToRemove)) continue;
            headers.add(header);
        }
        LOG.debug("Removed the content-length and content-type headers as the HTTP Client lib will care about them as soon as the entity is set on the POST object.");
        Header[] headersArray = new Header[headers.size()];
        headersArray = headers.toArray(headersArray);
        return headersArray;
    }

    private static String getRequestBody(HttpServletRequest request) {
        String body = null;
        try (BufferedReader requestReader = request.getReader();){
            String bodyLine;
            StringBuffer bodyLines = new StringBuffer();
            while ((bodyLine = requestReader.readLine()) != null) {
                bodyLines.append(bodyLine);
            }
            body = bodyLines.toString();
        }
        catch (IOException e) {
            LOG.info("Failed to obtain a Reader for a potential body of this POST, assuming KVP");
        }
        return body;
    }

    private static HttpHost getSystemProxy(URI uri) throws UnknownHostException {
        HttpHost systemProxy = null;
        List<Proxy> proxyList = ProxySelector.getDefault().select(uri);
        for (Proxy proxy : proxyList) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            if (address == null) continue;
            LOG.debug("Detected a system wide proxy:   * Host: " + address.getHostName() + "  * Port: " + address.getPort());
            systemProxy = new HttpHost(InetAddress.getByName(address.getHostName()), address.getPort(), "http");
            break;
        }
        return systemProxy;
    }

    @Value(value="${http.timeout}")
    public void setDefaultHttpTimeout(int httpTimeout) {
        defaultHttpTimeout = httpTimeout;
        HttpUtil.httpTimeout = httpTimeout;
    }

    public static int getHttpTimeout() {
        return httpTimeout;
    }

    public static void setHttpTimeout(int httpTimeout) {
        HttpUtil.httpTimeout = httpTimeout;
    }

    public static void resetHttpTimeout() {
        httpTimeout = defaultHttpTimeout;
    }

    static {
        AUTHORIZATION_HEADER = "authorization";
    }
}

