/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor;

import de.terrestris.shoguncore.util.interceptor.InterceptorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StreamUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OgcXmlUtil {
    private static final Logger LOG = LogManager.getLogger(OgcXmlUtil.class);
    private static final String DEFAULT_CHARSET = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRequestBody(HttpServletRequest request) {
        ServletInputStream in = null;
        String body = null;
        try {
            in = request.getInputStream();
            String encoding = request.getCharacterEncoding();
            Charset charset = !StringUtils.isEmpty((CharSequence)encoding) ? Charset.forName(encoding) : Charset.forName(DEFAULT_CHARSET);
            body = StreamUtils.copyToString((InputStream)in, (Charset)charset);
        }
        catch (IOException e) {
            LOG.error("Could not read the InputStream as String: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return body;
    }

    public static Document getDocumentFromString(String xml) throws IOException {
        Document document = null;
        try {
            InputSource source = new InputSource(new StringReader(xml));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(source);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IOException("Could not parse input body as XML: " + e.getMessage());
        }
        return document;
    }

    public static String getPathInDocument(Document document, String path) throws InterceptorException {
        String result;
        if (document == null) {
            throw new InterceptorException("Document may not be null");
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new InterceptorException("Missing parameter path");
        }
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile(path);
            result = expr.evaluate(document, XPathConstants.STRING).toString();
        }
        catch (XPathExpressionException e) {
            throw new InterceptorException("Error while selecting document element with XPath: " + e.getMessage());
        }
        return result;
    }

    public static NodeList getPathInDocumentAsNodeList(Document document, String path) throws InterceptorException {
        NodeList result;
        if (document == null) {
            throw new InterceptorException("Document may not be null");
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new InterceptorException("Missing parameter path");
        }
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile(path);
            result = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new InterceptorException("Error while selecting document element with XPath: " + e.getMessage());
        }
        return result;
    }

    public static Element getDocumentElement(Document doc) {
        Element docElement = null;
        if (doc != null && (docElement = doc.getDocumentElement()) != null) {
            docElement.normalize();
        }
        return docElement;
    }
}

