/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.dao;

import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.model.security.PermissionCollection;
import de.terrestris.shoguncore.paging.PagingResult;
import de.terrestris.shoguncore.util.entity.EntityUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyProjection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transform.Transformers;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="genericDao")
public class GenericHibernateDao<E extends PersistentObject, ID extends Serializable> {
    protected static final Logger logger = LogManager.getLogger(GenericHibernateDao.class);
    private final Class<E> entityClass;
    @Value(value="${hibernate.cache.use_query_cache}")
    private Boolean useQueryCache;
    @Autowired
    private SessionFactory sessionFactory;

    public GenericHibernateDao() {
        this(PersistentObject.class);
    }

    protected GenericHibernateDao(Class<E> clazz) {
        this.entityClass = clazz;
    }

    private Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public E findById(ID id) {
        logger.trace("Finding " + this.entityClass.getSimpleName() + " with ID " + id);
        return (E)((PersistentObject)this.getSession().get(this.entityClass, id));
    }

    public List<E> findAllWhereFieldEquals(String fieldName, Object fieldEntity, Criterion ... criterion) {
        boolean isField;
        Class<?> fieldEntityType = null;
        if (fieldEntity != null) {
            fieldEntityType = fieldEntity.getClass();
        }
        if (!(isField = EntityUtil.isField(this.entityClass, fieldName, fieldEntityType, true))) {
            String errorMsg = String.format("There is no field '%s' in the type '%s' that accepts instances of '%s'", fieldName, this.entityClass.getName(), fieldEntityType.getName());
            throw new IllegalArgumentException(errorMsg);
        }
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        if (fieldEntity == null) {
            criteria.add(Restrictions.isNull((String)fieldName));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)fieldName, (Object)fieldEntity));
        }
        criteria.setCacheable(this.useQueryCache.booleanValue());
        return criteria.list();
    }

    public List<E> findAllWithCollectionContaining(String fieldName, PersistentObject subElement, Criterion ... criterion) {
        Class<?> subElementType = subElement.getClass();
        boolean isCollectionField = EntityUtil.isCollectionField(this.entityClass, fieldName, subElementType, true);
        if (!isCollectionField) {
            String errorMsg = String.format("There is no collection field '%s' with element type '%s' in the type '%s'", fieldName, subElementType.getName(), this.entityClass.getName());
            throw new IllegalArgumentException(errorMsg);
        }
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        criteria.createAlias(fieldName, "sub");
        criteria.add((Criterion)Restrictions.eq((String)"sub.id", (Object)subElement.getId()));
        return criteria.list();
    }

    public E loadById(ID id) {
        logger.trace("Loading " + this.entityClass.getSimpleName() + " with ID " + id);
        return (E)((PersistentObject)this.getSession().load(this.entityClass, id));
    }

    public List<E> findAll() throws HibernateException {
        logger.trace("Finding all instances of " + this.entityClass.getSimpleName());
        return this.findByCriteria(new Criterion[0]);
    }

    public void saveOrUpdate(E e) {
        Integer id = ((PersistentObject)e).getId();
        boolean hasId = id != null;
        String createOrUpdatePrefix = hasId ? "Updating" : "Creating a new";
        String idSuffix = hasId ? " with ID " + id : "";
        logger.trace(createOrUpdatePrefix + " instance of " + this.entityClass.getSimpleName() + idSuffix);
        ((PersistentObject)e).setModified((ReadableDateTime)DateTime.now());
        this.getSession().saveOrUpdate(e);
    }

    public void delete(E e) {
        logger.trace("Deleting " + this.entityClass.getSimpleName() + " with ID " + ((PersistentObject)e).getId());
        this.getSession().delete(e);
    }

    public E unproxy(E e) {
        if (e == null) {
            throw new NullPointerException("Entity passed for initialization is null");
        }
        Hibernate.initialize(e);
        if (e instanceof HibernateProxy) {
            e = (PersistentObject)((HibernateProxy)e).getHibernateLazyInitializer().getImplementation();
        }
        return e;
    }

    public void evict(E e) {
        logger.trace("Detaching " + this.entityClass.getSimpleName() + " with ID " + ((PersistentObject)e).getId() + " from hibernate session");
        this.getSession().evict(e);
    }

    public List<E> findByCriteria(Criterion ... criterion) throws HibernateException {
        logger.trace("Finding instances of " + this.entityClass.getSimpleName() + " based on " + criterion.length + " criteria");
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        return criteria.list();
    }

    public List<E> findByCriteriaRestricted(List<String> restrictFieldNames, Criterion ... criterion) throws HibernateException {
        logger.trace("Finding instances of " + this.entityClass.getSimpleName() + " based on " + criterion.length + " criteria");
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        if (restrictFieldNames != null) {
            ProjectionList projectionList = Projections.projectionList();
            for (String restrictFieldName : restrictFieldNames) {
                PropertyProjection pp = Projections.property((String)restrictFieldName);
                projectionList.add((Projection)pp, restrictFieldName);
            }
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(this.entityClass));
        }
        return criteria.list();
    }

    public E findByUniqueCriteria(Criterion ... criterion) throws HibernateException {
        logger.trace("Finding one unique " + this.entityClass.getSimpleName() + " based on " + criterion.length + " criteria");
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        return (E)((PersistentObject)criteria.uniqueResult());
    }

    public PagingResult<E> findByCriteriaWithSortingAndPaging(Integer firstResult, Integer maxResults, List<Order> sorters, Criterion ... criterion) throws HibernateException {
        int nrOfSorters = sorters == null ? 0 : sorters.size();
        logger.trace("Finding instances of " + this.entityClass.getSimpleName() + " based on " + criterion.length + " criteria with " + nrOfSorters + " sorters");
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        if (maxResults != null) {
            logger.trace("Limiting result set size to " + maxResults);
            criteria.setMaxResults(maxResults.intValue());
        }
        if (firstResult != null) {
            logger.trace("Setting the first result to be retrieved to " + firstResult);
            criteria.setFirstResult(firstResult.intValue());
        }
        if (sorters != null) {
            for (Order sortInfo : sorters) {
                criteria.addOrder(sortInfo);
            }
        }
        return new PagingResult(criteria.list(), this.getTotalCount(criterion));
    }

    public Map<PersistentObject, PermissionCollection> findAllUserPermissionsOfUser(User user) {
        Criteria criteria = this.getSession().createCriteria(PersistentObject.class);
        criteria.createAlias("userPermissions", "up");
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List entitiesWithPermissions = criteria.list();
        HashMap<PersistentObject, PermissionCollection> userPermissions = new HashMap<PersistentObject, PermissionCollection>();
        for (PersistentObject entity : entitiesWithPermissions) {
            Map<User, PermissionCollection> entityUserPermissions = entity.getUserPermissions();
            if (!entityUserPermissions.containsKey(user)) continue;
            userPermissions.put(entity, entityUserPermissions.get(user));
        }
        return userPermissions;
    }

    public Map<PersistentObject, PermissionCollection> findAllUserGroupPermissionsOfUserGroup(UserGroup userGroup) {
        Criteria criteria = this.getSession().createCriteria(PersistentObject.class);
        criteria.createAlias("groupPermissions", "gp");
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List entitiesWithPermissions = criteria.list();
        HashMap<PersistentObject, PermissionCollection> userGroupPermissions = new HashMap<PersistentObject, PermissionCollection>();
        for (PersistentObject entity : entitiesWithPermissions) {
            Map<UserGroup, PermissionCollection> entityUserGroupPermissions = entity.getGroupPermissions();
            if (!entityUserGroupPermissions.containsKey(userGroup)) continue;
            userGroupPermissions.put(entity, entityUserGroupPermissions.get(userGroup));
        }
        return userGroupPermissions;
    }

    protected Criteria createDistinctRootEntityCriteria(Criterion ... criterion) {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        this.addCriterionsToCriteria(criteria, criterion);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.setCacheable(this.useQueryCache.booleanValue());
        return criteria;
    }

    public Number getTotalCount(Criterion ... criterion) throws HibernateException {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        this.addCriterionsToCriteria(criteria, criterion);
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }

    private void addCriterionsToCriteria(Criteria criteria, Criterion ... criterion) {
        if (criteria != null) {
            for (Criterion c : criterion) {
                if (c == null) continue;
                criteria.add(c);
            }
        }
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }
}

