/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.layer.source;

import de.terrestris.shoguncore.model.layer.source.ImageWmsLayerDataSource;
import de.terrestris.shoguncore.model.layer.util.TileGrid;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Table
@Entity
@Cacheable
public class TileWmsLayerDataSource
extends ImageWmsLayerDataSource {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private TileGrid tileGrid;
    @Column(name="REQUEST_WITH_TILED")
    private Boolean requestWithTiled = Boolean.TRUE;

    public TileWmsLayerDataSource() {
    }

    public TileWmsLayerDataSource(String name, String type, String url, String format, int width, int height, String version, String layerNames, String layerStyles, TileGrid tileGrid) {
        super(name, type, url, format, width, height, version, layerNames, layerStyles);
        this.tileGrid = tileGrid;
    }

    public TileGrid getTileGrid() {
        return this.tileGrid;
    }

    public void setTileGrid(TileGrid tileGrid) {
        this.tileGrid = tileGrid;
    }

    public Boolean getRequestWithTiled() {
        return this.requestWithTiled;
    }

    public void setRequestWithTiled(Boolean requestWithTiled) {
        this.requestWithTiled = requestWithTiled;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(47, 13).appendSuper(super.hashCode()).append((Object)this.getTileGrid()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TileWmsLayerDataSource)) {
            return false;
        }
        TileWmsLayerDataSource other = (TileWmsLayerDataSource)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getTileGrid(), (Object)other.getTileGrid()).isEquals();
    }
}

