/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.rest;

import de.terrestris.shoguncore.dao.UserDao;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.rest.AbstractRestController;
import de.terrestris.shoguncore.service.UserService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/users"})
public class UserRestController<E extends User, D extends UserDao<E>, S extends UserService<E, D>>
extends AbstractRestController<E, D, S> {
    public UserRestController() {
        this(User.class);
    }

    protected UserRestController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="userService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"/{userId}/userGroups"}, method={RequestMethod.GET})
    public ResponseEntity<Set<UserGroup>> findGroupsOfUser(@PathVariable Integer userId) {
        try {
            Set<UserGroup> userGroupsSet = ((UserService)this.service).getGroupsOfUser(userId);
            return new ResponseEntity(userGroupsSet, HttpStatus.OK);
        }
        catch (Exception e) {
            logger.error("Error finding user with id " + userId + ": " + e.getMessage());
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}

