/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.security.access;

import de.terrestris.shoguncore.dao.GenericHibernateDao;
import de.terrestris.shoguncore.dao.UserDao;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.security.Permission;
import de.terrestris.shoguncore.security.access.entity.PersistentObjectPermissionEvaluator;
import de.terrestris.shoguncore.security.access.factory.EntityPermissionEvaluatorFactory;
import java.io.Serializable;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;

public class ShogunCorePermissionEvaluator
implements PermissionEvaluator {
    private static final Logger logger = LogManager.getLogger(ShogunCorePermissionEvaluator.class);
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    @Qualifier(value="userDao")
    private UserDao<User> userDao;
    private Boolean usePlainPrincipal = false;
    private EntityPermissionEvaluatorFactory permissionEvaluatorFactory;

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permissionObject) {
        boolean hasPermission = false;
        if (authentication != null && targetDomainObject != null && targetDomainObject instanceof PersistentObject && permissionObject instanceof String) {
            User user = null;
            Object principalObject = authentication.getPrincipal();
            if (principalObject instanceof User) {
                User principal = (User)principalObject;
                user = this.usePlainPrincipal != false ? principal : (User)this.userDao.findById(principal.getId());
            }
            PersistentObject persistentObject = (PersistentObject)targetDomainObject;
            Integer objectId = persistentObject.getId();
            String simpleClassName = targetDomainObject.getClass().getSimpleName();
            Permission permission = Permission.fromString((String)permissionObject);
            String accountName = user == null ? "ANONYMOUS" : user.getAccountName();
            logger.trace("Evaluating whether user '" + accountName + "' has permission '" + (Object)((Object)permission) + "' on '" + simpleClassName + "' with ID " + objectId);
            PersistentObjectPermissionEvaluator<?> entityPermissionEvaluator = this.permissionEvaluatorFactory.getEntityPermissionEvaluator(persistentObject.getClass());
            hasPermission = entityPermissionEvaluator.hasPermission(user, persistentObject, permission);
        } else {
            logger.error("Permission evaluation has been aborted.");
        }
        return hasPermission;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        Class<?> entityClass;
        try {
            entityClass = Class.forName(targetType);
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not create class for type: " + targetType + "(" + e.getMessage() + ")");
            return false;
        }
        Collection allDaos = this.appContext.getBeansOfType(GenericHibernateDao.class).values();
        GenericHibernateDao daoToUse = null;
        for (GenericHibernateDao dao : allDaos) {
            if (!dao.getEntityClass().equals(entityClass)) continue;
            daoToUse = dao;
            logger.debug("Found an exactly matching DAO for type " + entityClass);
            break;
        }
        if (daoToUse == null) {
            for (GenericHibernateDao dao : allDaos) {
                if (!dao.getEntityClass().isAssignableFrom(entityClass)) continue;
                daoToUse = dao;
                logger.debug("Found a matching DAO from the hierarchy of type " + entityClass);
                break;
            }
        }
        if (daoToUse == null) {
            logger.warn("Could not find a DAO for type:" + entityClass);
            return false;
        }
        Object entity = daoToUse.findById(targetId);
        return this.hasPermission(authentication, entity, permission);
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public UserDao<User> getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDao<User> userDao) {
        this.userDao = userDao;
    }

    public Boolean getUsePlainPrincipal() {
        return this.usePlainPrincipal;
    }

    public void setUsePlainPrincipal(Boolean usePlainPrincipal) {
        this.usePlainPrincipal = usePlainPrincipal;
    }

    public EntityPermissionEvaluatorFactory getPermissionEvaluatorFactory() {
        return this.permissionEvaluatorFactory;
    }

    public void setPermissionEvaluatorFactory(EntityPermissionEvaluatorFactory permissionEvaluatorFactory) {
        this.permissionEvaluatorFactory = permissionEvaluatorFactory;
    }
}

