/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.terrestris.shoguncore.dao.InterceptorRuleDao;
import de.terrestris.shoguncore.model.interceptor.InterceptorRule;
import de.terrestris.shoguncore.service.PermissionAwareCrudService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="interceptorRuleService")
public class InterceptorRuleService<E extends InterceptorRule, D extends InterceptorRuleDao<E>>
extends PermissionAwareCrudService<E, D> {
    HashMap<String, List<E>> cachedRules = new HashMap();

    public InterceptorRuleService() {
        this(InterceptorRule.class);
    }

    protected InterceptorRuleService(Class<E> entityClass) {
        super(entityClass);
    }

    @Transactional(readOnly=true)
    public List<E> findAllRulesForServiceAndEvent(String service, String event) {
        if (this.cachedRules.containsKey(service + "," + event)) {
            return this.cachedRules.get(service + "," + event);
        }
        List rules = ((InterceptorRuleDao)this.dao).findAllRulesForServiceAndEvent(service, event);
        this.cachedRules.put(service + "," + event, rules);
        return rules;
    }

    @Override
    public void saveOrUpdate(E e) {
        this.cachedRules.clear();
        super.saveOrUpdate(e);
    }

    @Override
    public E updatePartialWithJsonNode(E entity, JsonNode jsonObject, ObjectMapper objectMapper) throws IOException {
        this.cachedRules.clear();
        return (E)((InterceptorRule)super.updatePartialWithJsonNode(entity, jsonObject, objectMapper));
    }

    @Override
    public void delete(E e) {
        this.cachedRules.clear();
        super.delete(e);
    }

    @Override
    @Autowired
    @Qualifier(value="interceptorRuleDao")
    public void setDao(D dao) {
        this.dao = dao;
    }
}

