/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

@Service
public class LdapService {
    private static final Logger LOGGER = LogManager.getLogger(LdapService.class);
    private LdapTemplate ldapTemplate;

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public void authenticate(String username, String password) {
        this.ldapTemplate.authenticate((LdapQuery)LdapQueryBuilder.query().where("objectClass").is("simpleSecurityObject").and("cn").is(username), password);
        LOGGER.info("Successfully authenticated " + username);
    }

    public List<String> getGroups(String username, String property) {
        ArrayList<String> result = new ArrayList<String>();
        this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().where("cn").is(username), attrs -> {
            NamingEnumeration<?> ous = attrs.get(property).getAll();
            while (ous.hasMore()) {
                result.add((String)ous.next());
            }
            return "";
        });
        return result;
    }
}

